/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Hashtable;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.internal.Monitor;

final class ResultSetCacheManager {
    private static final Hashtable<String, ResultSetCache> cacheTable = new Hashtable(10);
    private static final Monitor CACHE_TABLE_MONITOR = Monitor.newInstance();

    ResultSetCacheManager() {
    }

    static ResultSetCache getResultSetCache(String databaseUniqueName, long cacheMaxSize, int cacheLag) {
        try (Monitor.CloseableLock lock = CACHE_TABLE_MONITOR.acquireCloseableLock();){
            String key = databaseUniqueName;
            ResultSetCache cache2 = cacheTable.get(key);
            if (cache2 == null) {
                cache2 = new ResultSetCache(cacheMaxSize, cacheLag);
                cacheTable.put(key, cache2);
            } else if (cache2.getState() == ResultSetCache.ResultSetCacheState.CLOSED) {
                cacheTable.remove(key);
                cache2 = new ResultSetCache(cacheMaxSize, cacheLag);
                cacheTable.put(key, cache2);
            }
            ResultSetCache resultSetCache = cache2;
            return resultSetCache;
        }
    }
}

