/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;
import oracle.jdbc.internal.OracleStatement;

class RawAccessor
extends RawCommonAccessor {
    private static final String CLASS_NAME = RawAccessor.class.getName();

    RawAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(stmt, stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK ? Math.max(stmt.connection.maxRawBytesPlsql, max_len) : stmt.connection.maxRawLength, isStoredInBindData);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "RawAccessor", "representationMaxLength: {0}", (String)null, (Throwable)null, (Object)this.representationMaxLength);
        this.init(stmt, 23, 15, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    RawAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK ? stmt.connection.maxRawBytesPlsql : stmt.connection.maxRawLength, false);
        this.init(stmt, 23, 15, form, false);
        this.initForDescribe(23, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        super.initForDataAccess(external_type, max_len, typeName);
        this.byteLength += 2;
    }
}

