/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.Representation;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;

class PlsqlIndexTableAccessor
extends Accessor {
    static final int MAXLENGTH = -1;
    PlsqlIbtBindInfo ibtBindInfo;

    PlsqlIndexTableAccessor(OracleStatement stmt, PlsqlIbtBindInfo ibtBindInfo_, short form) throws SQLException {
        super(Representation.PLSQL_INDEX_TABLE, stmt, -1, true);
        this.init(stmt, 998, 998, form, true);
        this.ibtBindInfo = ibtBindInfo_;
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        this.unimpl("initForDataAccess");
    }

    @Override
    PlsqlIbtBindInfo plsqlIndexTableBindInfo() throws SQLException {
        return this.ibtBindInfo;
    }

    Object[] getPlsqlIndexTable(int currentRow) throws SQLException {
        Object[] result2;
        int actualElements = 0;
        if (!this.isNull(currentRow)) {
            this.rowData.setPosition(this.getOffset(currentRow));
            actualElements = this.rowData.getInt();
        }
        switch (this.ibtBindInfo.element_internal_type) {
            case 9: {
                result2 = new String[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    int len = this.rowData.getShort();
                    result2[i] = len == 0 ? null : this.rowData.getString(len, this.statement.connection.conversion.getCharacterSet((short)1));
                }
                break;
            }
            case 6: {
                result2 = new BigDecimal[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    int len = this.rowData.getShort();
                    result2[i] = len == 0 ? null : oracle.sql.NUMBER.toBigDecimal(this.rowData.getBytes(len));
                }
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
            }
        }
        assert (this.rowData.getPosition() == this.getOffset(currentRow) + (long)this.getLength(currentRow)) : "rowData.position(): " + this.rowData.getPosition() + " getOffset(" + currentRow + "): " + this.getOffset(currentRow) + " getLength(" + currentRow + "): " + this.getLength(currentRow);
        return result2;
    }

    @Override
    Datum[] getOraclePlsqlIndexTable(int currentRow) throws SQLException {
        Datum[] result2 = null;
        int actualElements = 0;
        if (!this.isNull(currentRow)) {
            this.rowData.setPosition(this.getOffset(currentRow));
            actualElements = this.rowData.getInt();
        }
        switch (this.ibtBindInfo.element_internal_type) {
            case 9: {
                result2 = new CHAR[actualElements];
                CharacterSet charset = this.statement.connection.conversion.getDriverCharSetObj();
                for (int i = 0; i < actualElements; ++i) {
                    int len = this.rowData.getShort();
                    result2[i] = len == 0 ? null : new CHAR(this.rowData.getBytes(len), charset);
                }
                break;
            }
            case 6: {
                result2 = new NUMBER[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    int len = this.rowData.getShort();
                    result2[i] = len == 0 ? null : new NUMBER(this.rowData.getBytes(len));
                }
                break;
            }
            case 12: {
                result2 = new DATE[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    int len = this.rowData.getShort();
                    result2[i] = len == 0 ? null : new DATE(this.rowData.getBytes(len));
                }
                break;
            }
            case 180: {
                result2 = new TIMESTAMP[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    int len = this.rowData.getShort();
                    result2[i] = len == 0 ? null : new TIMESTAMP(this.rowData.getBytes(len));
                }
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
            }
        }
        if (!this.isNull(currentRow)) assert (this.rowData.getPosition() == this.getOffset(currentRow) + (long)this.getLength(currentRow)) : "rowData.position(): " + this.rowData.getPosition() + " getOffset(" + currentRow + "): " + this.getOffset(currentRow) + " getLength(" + currentRow + "): " + this.getLength(currentRow);
        return result2;
    }
}

