/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.logging.Level;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoplbgn;
import oracle.jdbc.driver.T4CTTIoplend;
import oracle.net.ns.Communication;
import oracle.net.nt.NTAdapter;

final class Pipeline
implements Diagnosable {
    private static final String CLASS_NAME = Pipeline.class.getName();
    private final Deque<IoTask> sendQueue = new ArrayDeque<IoTask>();
    private final Deque<IoTask> receiveQueue = new ArrayDeque<IoTask>();
    private final LockExecutor lockExecutor;
    private HalfDuplexAbortCause halfDuplexAbortCause = HalfDuplexAbortCause.NONE;
    private final Communication communication;
    private final Diagnosable diagnosable;
    private final Supplier<T4CTTIoplbgn> oplbgnSupplier;
    private final Supplier<T4CTTIoplend> oplendSupplier;
    private boolean isWriteInterestRegistered = false;
    private boolean isReadInterestRegistered = false;
    private boolean isAfterPipelineBegin = false;
    private boolean isYielding = false;
    private int tokenNumber = 1;
    private final CommunicationMode communicationMode;
    private final Deque<Queue<Runnable>> taskBuffers = new ArrayDeque<Queue<Runnable>>();
    private int bufferSuspendCount = 0;
    private Thread ioThread;

    static Pipeline createHalfDuplex(T4CConnection connection) throws IOException {
        return Pipeline.create(connection, CommunicationMode.HALF_DUPLEX);
    }

    static Pipeline create(T4CConnection connection) throws IOException {
        return Pipeline.create(connection, Pipeline.getCommunicationMode(connection));
    }

    private static Pipeline create(T4CConnection connection, CommunicationMode communicationMode) throws IOException {
        Communication communication = connection.net();
        Diagnosable diagnosable = connection.getDiagnosable();
        LockExecutor lockExecutor = new LockExecutor(connection.getMonitorLock(), connection.getAsyncExecutor(), diagnosable);
        switch (communicationMode) {
            case FULL_DUPLEX: {
                return new Pipeline(communication, lockExecutor, diagnosable, () -> new T4CTTIoplbgn(connection), () -> new T4CTTIoplend(connection));
            }
        }
        return new Pipeline(communication, lockExecutor, diagnosable);
    }

    private static CommunicationMode getCommunicationMode(T4CConnection connection) throws IOException {
        if (connection.getTTCVersion() < 18) {
            return CommunicationMode.HALF_DUPLEX;
        }
        if (!connection.hasServerCompileTimeCapability(44, 4)) {
            return CommunicationMode.HALF_DUPLEX;
        }
        Communication net = connection.net();
        if (net.getSessionAttributes().getNTAdapter().getNetworkAdapterType() == NTAdapter.NetworkAdapterType.BEQ) {
            return CommunicationMode.HALF_DUPLEX;
        }
        if ("2".equals(connection.sessionProperties.getProperty("AUTH_SERVER_TYPE"))) {
            return CommunicationMode.HALF_DUPLEX;
        }
        String isPipelineDisabled = System.getProperty("oracle.jdbc.disablePipeline");
        if ("true".equalsIgnoreCase(isPipelineDisabled)) {
            return CommunicationMode.HALF_DUPLEX;
        }
        if ("false".equalsIgnoreCase(isPipelineDisabled)) {
            return CommunicationMode.FULL_DUPLEX;
        }
        return net.isOutOfBandDataEnabled() ? CommunicationMode.FULL_DUPLEX : CommunicationMode.HALF_DUPLEX;
    }

    private Pipeline(Communication communication, LockExecutor lockExecutor, Diagnosable diagnosable) {
        this.communicationMode = CommunicationMode.HALF_DUPLEX;
        this.communication = communication;
        this.lockExecutor = lockExecutor;
        this.diagnosable = diagnosable;
        this.oplbgnSupplier = null;
        this.oplendSupplier = null;
    }

    private Pipeline(Communication communication, LockExecutor lockExecutor, Diagnosable diagnosable, Supplier<T4CTTIoplbgn> oplbgnSupplier, Supplier<T4CTTIoplend> oplendSupplier) {
        this.communicationMode = CommunicationMode.FULL_DUPLEX;
        this.communication = communication;
        this.lockExecutor = lockExecutor;
        this.diagnosable = diagnosable;
        this.oplbgnSupplier = oplbgnSupplier;
        this.oplendSupplier = oplendSupplier;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    public String toString() {
        return "[pending-sends = " + this.sendQueue.size() + ", pending-receives = " + this.receiveQueue.size() + ", communication-mode = " + String.valueOf((Object)this.communicationMode) + ", executor = " + String.valueOf(this.lockExecutor) + "]";
    }

    boolean isPipelinable(short functionCode) {
        switch (functionCode) {
            case 5: 
            case 14: 
            case 15: 
            case 94: 
            case 96: 
            case 103: 
            case 104: 
            case 127: 
            case 199: 
            case 200: {
                return true;
            }
        }
        return false;
    }

    void resume() {
        this.runOrBuffer(this::endPipeline);
    }

    void execute(IoTask ioTask) {
        assert (Pipeline.isSupportedErrorSet(ioTask.continueOnErrorSet())) : "ErrorSet is not supported: " + String.valueOf(ioTask.continueOnErrorSet());
        this.runOrBuffer(() -> this.beginTask(ioTask));
    }

    private void beginTask(IoTask ioTask) {
        if (this.isPipelinable(ioTask.functionCode())) {
            this.beginPipeline();
        } else {
            this.endPipeline();
        }
        this.enqueueSend(ioTask);
    }

    void await() throws SQLException {
        this.join();
        this.endPipeline();
        this.join();
        this.halfDuplexAbortCause = HalfDuplexAbortCause.NONE;
        try {
            this.communication.restoreBlockingMode();
        }
        catch (IOException ioException) {
            throw DatabaseError.createSqlException(null, ioException);
        }
    }

    void join() {
        if (Thread.currentThread() == this.ioThread) {
            throw new IllegalStateException("A thread that is executing an IO task has attempted to await the completion of itself. This is a deadlock.");
        }
        while (this.isExecuting()) {
            this.await(1L, TimeUnit.SECONDS);
        }
    }

    boolean await(long timeout, TimeUnit timeUnit) {
        try {
            return this.lockExecutor.awaitNext(timeout, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            this.fatalAbort(interruptedException);
            return false;
        }
    }

    boolean cancel() throws IOException {
        if (!this.isExecuting()) {
            return false;
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "cancel", "Pipeline is cancelling. pipeline={0}", (String)null, (Throwable)null, (Object)this);
        if (!this.communication.isOutOfBandDataEnabled()) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cancel", "Out-of-band breaks are not enabled. Cancellation may fail! pipeline={1}", (String)null, (Throwable)null, (Object)this);
        }
        if (!this.lockExecutor.tryLockedRun(this::sendCancel)) {
            this.lockExecutor.execute(this::sendCancel);
        }
        return true;
    }

    private void sendCancel() {
        try {
            this.communication.sendBreak();
            this.endPipeline();
        }
        catch (IOException ioException) {
            this.abort(new IOException("Failed to send break", ioException));
        }
    }

    void yield() {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "yield", "Pipeline is yielding. pipeline={0}", (String)null, (Throwable)null, (Object)this);
        this.isYielding = true;
    }

    void go() {
        if (!this.isYielding) {
            return;
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "go", "Pipeline is no longer yielding. pipeline={0}", (String)null, (Throwable)null, (Object)this);
        this.isYielding = false;
        this.registerWriteInterest();
    }

    int getNextToken() {
        int n;
        if (this.communicationMode == CommunicationMode.HALF_DUPLEX) {
            n = 0;
        } else {
            int n2 = this.tokenNumber;
            n = n2;
            this.tokenNumber = n2 + 1;
        }
        return n;
    }

    OracleTimeout createTimeout() {
        return new OracleTimeoutThreadPerVM(this.toString()){

            @Override
            void cancelTimeout() throws SQLException {
                super.cancelTimeout();
                this.close();
            }
        };
    }

    boolean isExecuting() {
        if (!this.sendQueue.isEmpty()) {
            return true;
        }
        if (!this.receiveQueue.isEmpty()) {
            return true;
        }
        for (Queue<Runnable> taskBuffer : this.taskBuffers) {
            if (taskBuffer.isEmpty()) continue;
            return true;
        }
        return false;
    }

    boolean isStarted() {
        return this.isAfterPipelineBegin;
    }

    CommunicationMode communicationMode() {
        return this.communicationMode;
    }

    void beginBuffer() {
        this.taskBuffers.addLast(new ArrayDeque());
    }

    void endBuffer() {
        assert (!this.taskBuffers.isEmpty()) : "More calls to endBuffer than beginBuffer";
        Queue<Runnable> taskBuffer = this.taskBuffers.removeFirst();
        for (Runnable task : taskBuffer) {
            task.run();
        }
    }

    void beginBufferSuspend() {
        ++this.bufferSuspendCount;
    }

    void endBufferSuspend() {
        assert (this.bufferSuspendCount > 0) : "More calls to endBufferSuspend than beginBufferSuspend";
        --this.bufferSuspendCount;
    }

    private void runOrBuffer(Runnable task) {
        Queue<Runnable> taskBuffer = this.taskBuffers.peekLast();
        if (taskBuffer != null && this.bufferSuspendCount == 0) {
            taskBuffer.add(task);
        } else {
            task.run();
        }
    }

    private void beginPipeline() {
        if (this.isAfterPipelineBegin) {
            return;
        }
        this.isAfterPipelineBegin = true;
        if (this.communicationMode != CommunicationMode.HALF_DUPLEX) {
            this.execute(new OplbgnIoTask());
        }
    }

    private void endPipeline() {
        if (!this.isAfterPipelineBegin) {
            return;
        }
        if (this.communicationMode != CommunicationMode.HALF_DUPLEX) {
            this.oplendSupplier.get().doOPLENDAsync(null, error -> {
                if (error != null) {
                    this.fatalAbort((Throwable)error);
                }
            });
        } else {
            this.execute(HalfDuplexResumeTask.INSTANCE);
        }
        this.isAfterPipelineBegin = false;
    }

    private void enqueueSend(IoTask ioTask) {
        this.sendQueue.add(ioTask);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "enqueueSend", "Enqueued ioTask={0} pipeline={1}", (String)null, (Throwable)null, (Object)ioTask, (Object)this);
        this.registerWriteInterest();
    }

    private void registerWriteInterest() {
        if (this.isWriteInterestRegistered) {
            return;
        }
        if (this.isYielding) {
            return;
        }
        IoTask nextSendTask = this.sendQueue.peek();
        if (nextSendTask == null) {
            return;
        }
        IoTask nextReceiveTask = this.receiveQueue.peek();
        if (nextReceiveTask != null) {
            if (this.communicationMode != CommunicationMode.FULL_DUPLEX) {
                return;
            }
            if (!this.isPipelinable(nextSendTask.functionCode())) {
                return;
            }
            if (!this.isPipelinable(nextReceiveTask.functionCode())) {
                return;
            }
        }
        try {
            this.isWriteInterestRegistered = true;
            this.communication.onWriteReady(error -> {
                if (error != null) {
                    this.fatalAbort((Throwable)error);
                    return;
                }
                this.lockExecutor.execute(() -> {
                    this.ioThread = Thread.currentThread();
                    try {
                        this.isWriteInterestRegistered = false;
                        this.sendNext();
                    }
                    finally {
                        this.ioThread = null;
                    }
                });
            });
        }
        catch (Throwable throwable) {
            this.fatalAbort(throwable);
        }
    }

    private void sendNext() {
        Throwable sendError;
        IoStatus ioStatus;
        IoTask ioTask = this.sendQueue.peek();
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "sendNext", "Sending ioTask={0}", (String)null, (Throwable)null, (Object)ioTask);
        try {
            this.emulateHalfDuplexAbort(ioTask);
            ioStatus = ioTask.send();
            sendError = null;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "sendNext", "Sent ioTask={0} ioStatus={1}", (String)null, (Throwable)null, (Object)ioTask, (Object)ioStatus);
        }
        catch (Throwable error) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "sendNext", "Failed ioTask={0}", (String)null, error, (Object)ioTask);
            sendError = error;
            ioStatus = IoStatus.COMPLETE;
        }
        switch (ioStatus) {
            case PENDING_SEND: {
                break;
            }
            case PENDING_RECEIVE: {
                this.sendQueue.remove();
                this.enqueueReceive(ioTask);
                break;
            }
            case COMPLETE: {
                this.sendQueue.remove();
                this.completeTask(ioTask, sendError);
                break;
            }
            default: {
                throw new IllegalStateException("IoTask.send() returned an unrecognized status");
            }
        }
        this.registerWriteInterest();
    }

    private void emulateHalfDuplexAbort(IoTask ioTask) throws SQLException {
        if (ioTask instanceof HalfDuplexResumeTask) {
            this.halfDuplexAbortCause = HalfDuplexAbortCause.NONE;
            return;
        }
        switch (this.halfDuplexAbortCause) {
            case ABORT_ON_ERROR: {
                throw (SQLException)DatabaseError.createSqlException(null, 43610).fillInStackTrace();
            }
            case ABORT_ON_CANCEL: {
                throw (SQLException)DatabaseError.createSqlException(null, 1013).fillInStackTrace();
            }
        }
    }

    private void emulateHalfDuplexError(IoTask ioTask, Throwable error) {
        if (this.communicationMode != CommunicationMode.HALF_DUPLEX) {
            return;
        }
        if (!this.isPipelinable(ioTask.functionCode())) {
            return;
        }
        if (!(error instanceof SQLException)) {
            return;
        }
        SQLException sqlException = (SQLException)error;
        if (DatabaseError.isInternallyHandledWarning(sqlException)) {
            return;
        }
        int errorCode = sqlException.getErrorCode();
        if (errorCode == 1013) {
            this.halfDuplexAbortCause = HalfDuplexAbortCause.ABORT_ON_CANCEL;
        } else if (ioTask.continueOnErrorSet() != ErrorSet.ALL_ERRORS) {
            this.halfDuplexAbortCause = HalfDuplexAbortCause.ABORT_ON_ERROR;
        }
    }

    private void enqueueReceive(IoTask ioTask) {
        this.receiveQueue.add(ioTask);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "enqueueReceive", "Enqueued ioTask={0} pipeline={1}", (String)null, (Throwable)null, (Object)ioTask, (Object)this);
        this.registerReadInterest();
    }

    private void registerReadInterest() {
        if (this.isReadInterestRegistered) {
            return;
        }
        if (this.receiveQueue.isEmpty()) {
            return;
        }
        try {
            this.isReadInterestRegistered = true;
            this.communication.onReadReady(error -> {
                if (error != null) {
                    this.fatalAbort((Throwable)error);
                    return;
                }
                this.lockExecutor.execute(() -> {
                    this.ioThread = Thread.currentThread();
                    try {
                        this.isReadInterestRegistered = false;
                        this.receiveNext();
                    }
                    finally {
                        this.ioThread = null;
                    }
                });
            });
        }
        catch (Throwable throwable) {
            this.fatalAbort(throwable);
        }
    }

    private void receiveNext() {
        IoStatus ioStatus;
        IoTask ioTask = this.receiveQueue.peek();
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "receiveNext", "Receiving ioTask={0}", (String)null, (Throwable)null, (Object)ioTask);
        Throwable receiveError = null;
        try {
            ioStatus = ioTask.receive();
        }
        catch (Throwable error) {
            ioStatus = IoStatus.COMPLETE;
            receiveError = error;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "receiveNext", "Received ioTask={0} ioStatus={1} pipeline={2}", (String)null, receiveError, (Object)ioTask, (Object)ioStatus, (Object)this);
        switch (ioStatus) {
            case COMPLETE: {
                this.completeTask(ioTask, receiveError);
                this.receiveQueue.remove();
                this.emulateHalfDuplexError(ioTask, receiveError);
                this.registerWriteInterest();
                this.registerReadInterest();
                break;
            }
            case PENDING_RECEIVE: {
                this.registerReadInterest();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected status: " + String.valueOf((Object)ioStatus));
            }
        }
    }

    private void fatalAbort(Throwable error) {
        this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "fatalAbort", "A fatal error has occurred! pipeline={0}", (String)null, error, (Object)this);
        try {
            this.communication.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockExecutor.execute(() -> this.abort(error instanceof IOException ? error : new IOException(error)));
    }

    private void abort(Throwable error) {
        while (!this.receiveQueue.isEmpty()) {
            this.completeTask(this.receiveQueue.peek(), error);
            this.receiveQueue.remove();
        }
        while (!this.sendQueue.isEmpty()) {
            this.completeTask(this.sendQueue.peek(), error);
            this.sendQueue.remove();
        }
    }

    private void completeTask(IoTask ioTask, Throwable throwable) {
        try {
            ioTask.complete(throwable);
        }
        catch (Throwable completeError) {
            if (throwable != null) {
                completeError.addSuppressed(throwable);
            }
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "receiveNext", "IoTask.complete(Throwable) unexpectedly threw an exception! ioTask={0} pipeline={1}", (String)null, completeError, (Object)ioTask, (Object)this);
        }
    }

    static ErrorSet requireSupportedErrorSet(ErrorSet errorSet) {
        if (Pipeline.isSupportedErrorSet(errorSet)) {
            return errorSet;
        }
        if (errorSet == null) {
            throw new NullPointerException("ErrorSet is null");
        }
        throw new IllegalArgumentException("Unrecognized ErrorSet: " + String.valueOf(errorSet) + ". Only ErrorSet constants declared by oracle.jdbc.ErrorSet are supported");
    }

    static boolean isSupportedErrorSet(ErrorSet errorSet) {
        return errorSet == ErrorSet.ALL_ERRORS || errorSet == ErrorSet.NO_ERRORS;
    }

    static enum HalfDuplexAbortCause {
        NONE,
        ABORT_ON_ERROR,
        ABORT_ON_CANCEL;

    }

    static enum CommunicationMode {
        FULL_DUPLEX,
        HALF_DUPLEX;

    }

    private static final class HalfDuplexResumeTask
    implements IoTask {
        private static final HalfDuplexResumeTask INSTANCE = new HalfDuplexResumeTask();

        private HalfDuplexResumeTask() {
        }

        @Override
        public short functionCode() {
            return 200;
        }

        @Override
        public ErrorSet continueOnErrorSet() {
            return ErrorSet.ALL_ERRORS;
        }

        @Override
        public IoStatus send() throws IOException {
            return IoStatus.COMPLETE;
        }

        @Override
        public IoStatus receive() {
            return IoStatus.COMPLETE;
        }

        @Override
        public void complete(Throwable error) {
        }

        public String toString() {
            return "HALF-DUPLEX-RESUME";
        }
    }

    private final class OplbgnIoTask
    implements IoTask {
        private OplbgnIoTask() {
        }

        @Override
        public short functionCode() {
            return 199;
        }

        @Override
        public ErrorSet continueOnErrorSet() {
            return ErrorSet.ALL_ERRORS;
        }

        @Override
        public IoStatus send() throws IOException {
            Pipeline.this.tokenNumber = 1;
            Pipeline.this.communication.getConnectedSessionAttributes().dataChannel.startPipeline();
            Pipeline.this.oplbgnSupplier.get().doOPLBGN(0, (short)0, (short)1);
            return IoStatus.COMPLETE;
        }

        @Override
        public IoStatus receive() {
            return IoStatus.COMPLETE;
        }

        @Override
        public void complete(Throwable error) {
            if (error != null) {
                Pipeline.this.fatalAbort(error);
            }
        }

        public String toString() {
            return "OPLBGN";
        }
    }

    private static final class LockExecutor
    implements Executor,
    Diagnosable {
        private static final String CLASS_NAME = LockExecutor.class.getName();
        private static final AtomicReference<Executor> FALLBACK_EXECUTOR = new AtomicReference<Object>(null);
        private final Lock lock;
        private final Executor executor;
        private final Diagnosable diagnosable;
        private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
        private final AtomicBoolean isExecuting = new AtomicBoolean(false);

        private LockExecutor(Lock lock, Executor executor, Diagnosable diagnosable) {
            this.lock = lock;
            this.executor = executor;
            this.diagnosable = diagnosable;
        }

        @Override
        public Diagnosable getDiagnosable() {
            return this.diagnosable;
        }

        public String toString() {
            return "[pending tasks = " + this.taskQueue.size() + ", executor = " + String.valueOf(this.executor) + "]";
        }

        @Override
        public void execute(Runnable runnable) {
            this.taskQueue.add(runnable);
            if (this.isExecuting.compareAndSet(false, true)) {
                this.executeWithFallback(this::tryExecuteQueue);
            }
        }

        private void executeWithFallback(Runnable runnable) {
            try {
                this.executor.execute(runnable);
            }
            catch (Throwable throwable) {
                this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "executeWithFallback", "Executor.execute(Runnable) unexpectedly threw an exception!", null, throwable);
                LockExecutor.getFallbackExecutor().execute(runnable);
            }
        }

        private void tryExecuteQueue() {
            do {
                if (!this.tryLockedRun(this::runAll) && !this.taskQueue.isEmpty()) {
                    this.executeWithFallback(this::tryExecuteQueue);
                    return;
                }
                this.isExecuting.set(false);
            } while (!this.taskQueue.isEmpty() && this.isExecuting.compareAndSet(false, true));
        }

        private void runAll() {
            Runnable task;
            while ((task = (Runnable)this.taskQueue.poll()) != null) {
                task.run();
            }
        }

        boolean tryLockedRun(Runnable runnable) {
            if (this.lock.tryLock()) {
                try {
                    runnable.run();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean awaitNext(long timeout, TimeUnit timeUnit) throws InterruptedException {
            long start = System.nanoTime();
            if (!this.lock.tryLock(timeout, timeUnit)) {
                return false;
            }
            try {
                long remaining = Math.max(0L, timeout - (System.nanoTime() - start));
                Runnable task = this.taskQueue.poll(remaining, timeUnit);
                if (task == null) {
                    boolean bl = false;
                    return bl;
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "awaitNext", "Running task", null, null);
                task.run();
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private static Executor getFallbackExecutor() {
            return FALLBACK_EXECUTOR.updateAndGet(current -> {
                if (current != null) {
                    return current;
                }
                return Executors.newSingleThreadExecutor(runnable -> {
                    Thread thread2 = new Thread(runnable);
                    thread2.setDaemon(true);
                    thread2.setName(Pipeline.class.getName() + " Fallback Thread");
                    return thread2;
                });
            });
        }
    }

    protected static class IoTaskDecorator
    implements IoTask {
        private IoTask ioTask;

        protected IoTaskDecorator(IoTask ioTask) {
            this.ioTask = ioTask;
        }

        protected void delegateTo(IoTask ioTask) {
            this.ioTask = ioTask;
        }

        @Override
        public short functionCode() {
            return this.ioTask.functionCode();
        }

        @Override
        public ErrorSet continueOnErrorSet() {
            return this.ioTask.continueOnErrorSet();
        }

        @Override
        public IoStatus send() throws Exception {
            return this.ioTask.send();
        }

        @Override
        public IoStatus receive() throws Exception {
            return this.ioTask.receive();
        }

        @Override
        public void complete(Throwable error) {
            this.ioTask.complete(error);
        }

        public String toString() {
            return this.ioTask.toString();
        }
    }

    static enum IoStatus {
        PENDING_SEND,
        PENDING_RECEIVE,
        COMPLETE;

    }

    static interface IoTask {
        public short functionCode();

        public ErrorSet continueOnErrorSet();

        public IoStatus send() throws Exception;

        public IoStatus receive() throws Exception;

        public void complete(Throwable var1);
    }
}

