/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;

abstract class OracleInputStream
extends OracleBufferedStream {
    int columnIndex;
    Accessor accessor;
    OracleInputStream nextStream;
    boolean hasBeenOpen = false;

    protected OracleInputStream(OracleStatement stmt, int index, Accessor a) {
        super(stmt, stmt.connection.getDefaultStreamChunkSize());
        this.closed = true;
        this.statement = stmt;
        this.columnIndex = index;
        this.accessor = a;
        this.nextStream = null;
        OracleInputStream s2 = this.statement.streamList;
        if (s2 == null || this.columnIndex < s2.columnIndex) {
            this.nextStream = this.statement.streamList;
            this.statement.streamList = this;
        } else if (this.columnIndex == s2.columnIndex) {
            this.nextStream = s2.nextStream;
            s2.nextStream = null;
            this.statement.streamList = this;
        } else {
            while (s2.nextStream != null && this.columnIndex > s2.nextStream.columnIndex) {
                s2 = s2.nextStream;
            }
            if (s2.nextStream != null && this.columnIndex == s2.nextStream.columnIndex) {
                this.nextStream = s2.nextStream.nextStream;
                s2.nextStream.nextStream = null;
                s2.nextStream = this;
            } else {
                this.nextStream = s2.nextStream;
                s2.nextStream = this;
            }
        }
    }

    public String toString() {
        return "OIS@" + Integer.toHexString(this.hashCode()) + "{statement = " + String.valueOf(this.statement) + ", accessor = " + String.valueOf(this.accessor) + ", nextStream = " + String.valueOf(this.nextStream) + ", columnIndex = " + this.columnIndex + ", hasBeenOpen = " + this.hasBeenOpen + "}";
    }

    @Override
    public boolean needBytes(int howMany) throws IOException {
        try (Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();){
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            if (this.pos >= this.count) {
                if (howMany > this.currentBufferSize) {
                    this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                }
                byte[] buffer = this.getBuffer(this.currentBufferSize);
                try {
                    int readLength = this.getBytes(this.currentBufferSize, buffer);
                    this.pos = 0;
                    this.count = readLength;
                    if (this.count == -1) {
                        if (this.nextStream == null) {
                            this.statement.connection.releaseLine();
                        }
                        this.closed = true;
                        this.accessor.fetchNextColumns();
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (SQLException e) {
                    throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    protected int readInternal(byte[] buffer) throws IOException {
        return super.readInternal(buffer, 0, buffer.length);
    }

    @Override
    public boolean isNull() throws IOException {
        boolean result2 = false;
        try {
            result2 = this.accessor.isNull(0);
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
        return result2;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try (Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();){
            if (!this.closed && this.hasBeenOpen) {
                while (this.statement.nextStream != this) {
                    this.statement.nextStream.close();
                    this.statement.nextStream = this.statement.nextStream.nextStream;
                }
                if (!this.isNull()) {
                    while (this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize))) {
                        this.pos = this.count;
                    }
                }
                this.closed = true;
                this.currentBufferSize = 0;
            }
        }
        finally {
            super.close();
        }
    }

    public abstract int getBytes(int var1, byte[] var2) throws IOException, SQLException;
}

