/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.NTFConnection;
import oracle.sql.TIMESTAMP;

class NTFAQEvent
extends AQNotificationEvent {
    private static final long serialVersionUID = 4073258592022522641L;
    private String registrationString;
    private int namespace;
    private byte[] payload;
    private String queueName = null;
    private byte[] messageId = null;
    private String consumerName = null;
    private NTFConnection conn;
    private AQMessagePropertiesI msgProp;
    private AQNotificationEvent.EventType eventType = AQNotificationEvent.EventType.REGULAR;
    private AQNotificationEvent.AdditionalEventType additionalEventType = AQNotificationEvent.AdditionalEventType.NONE;
    private ByteBuffer dataBuffer;
    private boolean isReady = false;
    private short databaseVersion;

    NTFAQEvent(NTFConnection _conn, short _databaseVersion) throws IOException, InterruptedException {
        super(_conn);
        this.conn = _conn;
        int lengthDataHandle = this.conn.readInt();
        byte[] data = new byte[lengthDataHandle];
        this.conn.readBuffer(data, 0, lengthDataHandle);
        this.dataBuffer = ByteBuffer.wrap(data);
        this.databaseVersion = _databaseVersion;
    }

    private void initEvent() throws SQLException {
        byte registrationType = this.dataBuffer.get();
        int registrationLength = this.dataBuffer.getInt();
        byte[] registrationBuffer = new byte[registrationLength];
        this.dataBuffer.get(registrationBuffer, 0, registrationLength);
        this.registrationString = this.conn.charset.toString(registrationBuffer, 0, registrationLength);
        byte namespaceType = this.dataBuffer.get();
        int namespaceLength = this.dataBuffer.getInt();
        byte[] namespaceBuffer = new byte[namespaceLength];
        this.dataBuffer.get(namespaceBuffer, 0, namespaceLength);
        this.namespace = namespaceBuffer[0];
        byte notificationType = this.dataBuffer.get();
        int notificationLength = this.dataBuffer.getInt();
        if (notificationLength > 0) {
            this.payload = new byte[notificationLength];
            this.dataBuffer.get(this.payload, 0, notificationLength);
        } else {
            this.payload = null;
        }
        if (this.dataBuffer.hasRemaining()) {
            int deliveryMode = 0;
            if (this.databaseVersion >= 10200) {
                byte deliveryModeType = this.dataBuffer.get();
                int deliveryModeLength = this.dataBuffer.getInt();
                deliveryMode = this.dataBuffer.getInt();
            }
            byte queueNameType = this.dataBuffer.get();
            int queueNameLength = this.dataBuffer.getInt();
            byte[] queueNameBuffer = new byte[queueNameLength];
            this.dataBuffer.get(queueNameBuffer, 0, queueNameLength);
            this.queueName = this.conn.charset.toString(queueNameBuffer, 0, queueNameLength);
            byte messageIdType = this.dataBuffer.get();
            int messageIdLength = this.dataBuffer.getInt();
            this.messageId = new byte[messageIdLength];
            this.dataBuffer.get(this.messageId, 0, messageIdLength);
            byte consumerNameType = this.dataBuffer.get();
            int consumerNameLength = this.dataBuffer.getInt();
            byte[] consumerNameBuffer = new byte[consumerNameLength];
            this.dataBuffer.get(consumerNameBuffer, 0, consumerNameLength);
            this.consumerName = this.conn.charset.toString(consumerNameBuffer, 0, consumerNameLength);
            byte prioritySignType = this.dataBuffer.get();
            int prioritySignLength = this.dataBuffer.getInt();
            byte[] prioritySign = new byte[prioritySignLength];
            this.dataBuffer.get(prioritySign, 0, prioritySignLength);
            byte priorityType = this.dataBuffer.get();
            int priorityLength = this.dataBuffer.getInt();
            int priority_l = this.dataBuffer.getInt();
            if (prioritySign[0] == 1) {
                priority_l = -priority_l;
            }
            int priority = priority_l;
            byte delayType = this.dataBuffer.get();
            int delayLength = this.dataBuffer.getInt();
            int delay = this.dataBuffer.getInt();
            byte expirationSignType = this.dataBuffer.get();
            int expirationSignLength = this.dataBuffer.getInt();
            byte[] expirationSign = new byte[expirationSignLength];
            this.dataBuffer.get(expirationSign, 0, expirationSignLength);
            byte expirationType = this.dataBuffer.get();
            int expirationLength = this.dataBuffer.getInt();
            int expiration_l = this.dataBuffer.getInt();
            if (expirationSign[0] == 1) {
                expiration_l = -expiration_l;
            }
            int expiration = expiration_l;
            byte attemptsType = this.dataBuffer.get();
            int attemptsLength = this.dataBuffer.getInt();
            int attempts = this.dataBuffer.getInt();
            byte timestampType = this.dataBuffer.get();
            int timestampLength = this.dataBuffer.getInt();
            byte[] timestampBytes = new byte[timestampLength];
            this.dataBuffer.get(timestampBytes, 0, timestampLength);
            TIMESTAMP timestamp2 = new TIMESTAMP(timestampBytes);
            byte stateBType = this.dataBuffer.get();
            int stateBLength = this.dataBuffer.getInt();
            byte[] stateB = new byte[stateBLength];
            this.dataBuffer.get(stateB, 0, stateBLength);
            byte state = stateB[0];
            byte exceptionQueueType = this.dataBuffer.get();
            int exceptionQueueLength = this.dataBuffer.getInt();
            byte[] exceptionQueueBuffer = new byte[exceptionQueueLength];
            this.dataBuffer.get(exceptionQueueBuffer, 0, exceptionQueueLength);
            String exceptionQueue = this.conn.charset.toString(exceptionQueueBuffer, 0, exceptionQueueLength);
            byte correlationIdType = this.dataBuffer.get();
            int correlationIdLength = this.dataBuffer.getInt();
            byte[] correlationIdBuff = new byte[correlationIdLength];
            this.dataBuffer.get(correlationIdBuff, 0, correlationIdLength);
            String correlationId = this.conn.charset.toString(correlationIdBuff, 0, correlationIdLength);
            byte originalMessageIdType = this.dataBuffer.get();
            int originalMessageIdLength = this.dataBuffer.getInt();
            byte[] originalMessageId = null;
            if (originalMessageIdLength > 0) {
                originalMessageId = new byte[originalMessageIdLength];
                this.dataBuffer.get(originalMessageId, 0, originalMessageIdLength);
            }
            byte agentNameType = this.dataBuffer.get();
            int agentNameLength = this.dataBuffer.getInt();
            byte[] agentNameBuffer = new byte[agentNameLength];
            this.dataBuffer.get(agentNameBuffer, 0, agentNameLength);
            String agentName = this.conn.charset.toString(agentNameBuffer, 0, agentNameLength);
            byte agentAddressType = this.dataBuffer.get();
            int agentAddressLength = this.dataBuffer.getInt();
            byte[] agentAddressBuffer = new byte[agentAddressLength];
            this.dataBuffer.get(agentAddressBuffer, 0, agentAddressLength);
            String agentAddress = this.conn.charset.toString(agentAddressBuffer, 0, agentAddressLength);
            byte agentProtocolType = this.dataBuffer.get();
            int agentProtocolLength = this.dataBuffer.getInt();
            byte agentProtocol = this.dataBuffer.get();
            this.msgProp = new AQMessagePropertiesI();
            this.msgProp.setAttempts(attempts);
            this.msgProp.setCorrelation(correlationId);
            this.msgProp.setDelay(delay);
            this.msgProp.setEnqueueTime(timestamp2.timestampValue());
            this.msgProp.setMessageState(AQMessageProperties.MessageState.getMessageState(state));
            if (this.databaseVersion >= 10200) {
                this.msgProp.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(deliveryMode));
            }
            this.msgProp.setPreviousQueueMessageId(originalMessageId);
            AQAgentI senderAgent = new AQAgentI();
            senderAgent.setAddress(agentAddress);
            senderAgent.setName(agentName);
            senderAgent.setProtocol(agentProtocol);
            this.msgProp.setSender(senderAgent);
            this.msgProp.setPriority(priority);
            this.msgProp.setExpiration(expiration);
            this.msgProp.setExceptionQueue(exceptionQueue);
        }
        this.isReady = true;
    }

    @Override
    public AQMessageProperties getMessageProperties() throws SQLException {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.msgProp;
    }

    @Override
    public String getRegistration() throws SQLException {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.registrationString;
    }

    @Override
    public AQNotificationEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public AQNotificationEvent.AdditionalEventType getAdditionalEventType() {
        return this.additionalEventType;
    }

    void setEventType(AQNotificationEvent.EventType _type) throws IOException {
        this.eventType = _type;
    }

    void setAdditionalEventType(AQNotificationEvent.AdditionalEventType _adtype) {
        this.additionalEventType = _adtype;
    }

    @Override
    public byte[] getPayload() throws SQLException {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.payload;
    }

    @Override
    public String getQueueName() throws SQLException {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.queueName;
    }

    @Override
    public byte[] getMessageId() throws SQLException {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.messageId;
    }

    @Override
    public String getConsumerName() throws SQLException {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.consumerName;
    }

    @Override
    public String getConnectionInformation() {
        return this.conn.connectionDescription;
    }

    @Override
    public String toString() {
        if (!this.isReady) {
            try {
                this.initEvent();
            }
            catch (SQLException ex) {
                return ex.getMessage();
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Connection information  : " + this.conn.connectionDescription + "\n");
        sb.append("Event type              : " + String.valueOf((Object)this.eventType) + "\n");
        if (this.additionalEventType != AQNotificationEvent.AdditionalEventType.NONE) {
            sb.append("Additional event type   : " + String.valueOf((Object)this.additionalEventType) + "\n");
        }
        sb.append("Namespace               : " + this.namespace + "\n");
        sb.append("Registration            : " + this.registrationString + "\n");
        sb.append("Queue name              : " + this.queueName + "\n");
        sb.append("Consumer name           : " + this.consumerName + "\n");
        if (this.payload != null) {
            sb.append("Payload length          : " + this.payload.length + "\n");
            sb.append("Payload (first 50 bytes): " + NTFAQEvent.byteBufferToHexString(this.payload, 50) + "\n");
        } else {
            sb.append("Payload                 : null\n");
        }
        sb.append("Message ID              : " + NTFAQEvent.byteBufferToHexString(this.messageId, 50) + "\n");
        if (this.msgProp != null) {
            sb.append(this.msgProp.toString());
        }
        return sb.toString();
    }

    static final String byteBufferToHexString(byte[] buffer, int maxNbOfBytes) {
        if (buffer == null) {
            return null;
        }
        boolean isFirst = true;
        StringBuffer sb = new StringBuffer();
        for (int offset = 0; offset < buffer.length && offset < maxNbOfBytes; ++offset) {
            if (!isFirst) {
                sb.append(' ');
            } else {
                isFirst = false;
            }
            Object hexrep = Integer.toHexString(buffer[offset] & 0xFF);
            if (((String)hexrep).length() == 1) {
                hexrep = "0" + (String)hexrep;
            }
            sb.append((String)hexrep);
        }
        String ret = sb.toString();
        return ret;
    }
}

