/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleLargeObject;

abstract class LobCommonAccessor
extends Accessor {
    long[] prefetchedDataOffset;
    int[] prefetchedDataLength;
    long[] prefetchedLength;
    int[] prefetchedChunkSize;
    private OracleLargeObject[][] prefetchedLargeObjects;

    LobCommonAccessor(Representation _representation, OracleStatement _statement, int _representationMaxLength, boolean isStoredInBindData) {
        super(_representation, _statement, _representationMaxLength, isStoredInBindData);
    }

    @Override
    void setNull(int currentRow, boolean value) throws SQLException {
        super.setNull(currentRow, value);
        if (value && this.isPrefetched()) {
            this.prefetchedDataOffset[currentRow] = -1L;
            this.prefetchedDataLength[currentRow] = -1;
            this.prefetchedLength[currentRow] = -1L;
            this.prefetchedChunkSize[currentRow] = -1;
        }
    }

    @Override
    void setCapacity(int capacity) {
        super.setCapacity(capacity);
        if (this.isPrefetched() && this.prefetchedDataOffset == null) {
            this.prefetchedDataOffset = new long[capacity];
            this.prefetchedDataLength = new int[capacity];
            this.prefetchedLength = new long[capacity];
            this.prefetchedChunkSize = new int[capacity];
        } else if (this.isPrefetched() && capacity > this.prefetchedDataOffset.length) {
            Object tmp = new long[capacity];
            System.arraycopy(this.prefetchedDataOffset, 0, tmp, 0, this.prefetchedDataOffset.length);
            this.prefetchedDataOffset = tmp;
            tmp = new int[capacity];
            System.arraycopy(this.prefetchedDataLength, 0, tmp, 0, this.prefetchedDataLength.length);
            this.prefetchedDataLength = (int[])tmp;
            tmp = new long[capacity];
            System.arraycopy(this.prefetchedLength, 0, tmp, 0, this.prefetchedLength.length);
            this.prefetchedLength = tmp;
            tmp = new int[capacity];
            System.arraycopy(this.prefetchedChunkSize, 0, tmp, 0, this.prefetchedChunkSize.length);
            this.prefetchedChunkSize = (int[])tmp;
            if (this.prefetchedLargeObjects != null) {
                tmp = new OracleLargeObject[capacity][];
                System.arraycopy(this.prefetchedLargeObjects, 0, tmp, 0, this.prefetchedLargeObjects.length);
                this.prefetchedLargeObjects = (OracleLargeObject[][])tmp;
            }
        }
    }

    @Override
    void insertNull(int rowIndex) throws SQLException {
        if (this.isPrefetched()) {
            System.arraycopy(this.prefetchedDataOffset, rowIndex, this.prefetchedDataOffset, rowIndex + 1, this.prefetchedDataOffset.length - rowIndex - 1);
            System.arraycopy(this.prefetchedDataLength, rowIndex, this.prefetchedDataLength, rowIndex + 1, this.prefetchedDataLength.length - rowIndex - 1);
            System.arraycopy(this.prefetchedLength, rowIndex, this.prefetchedLength, rowIndex + 1, this.prefetchedLength.length - rowIndex - 1);
            System.arraycopy(this.prefetchedChunkSize, rowIndex, this.prefetchedChunkSize, rowIndex + 1, this.prefetchedChunkSize.length - rowIndex - 1);
            if (this.prefetchedLargeObjects != null) {
                System.arraycopy(this.prefetchedLargeObjects, rowIndex, this.prefetchedLargeObjects, rowIndex + 1, this.prefetchedLargeObjects.length - rowIndex - 1);
            }
        }
        super.insertNull(rowIndex);
    }

    @Override
    Accessor copyForDefine(OracleStatement dest) {
        LobCommonAccessor acc = (LobCommonAccessor)super.copyForDefine(dest);
        acc.prefetchedDataOffset = null;
        acc.prefetchedDataLength = null;
        acc.prefetchedLength = null;
        acc.prefetchedChunkSize = null;
        return acc;
    }

    @Override
    protected void copyFromInternal(Accessor srcAcc, int srcRow, int destRow) throws SQLException {
        super.copyFromInternal(srcAcc, srcRow, destRow);
        if (this.isPrefetched()) {
            long destOff;
            LobCommonAccessor srcLobAcc = (LobCommonAccessor)srcAcc;
            assert (srcLobAcc.isPrefetched()) : "srcLobAcc is not prefetched";
            int srcLen = srcLobAcc.getPrefetchedDataLength(srcRow);
            long l = destOff = srcLen <= this.getPrefetchedDataLength(destRow) ? this.getPrefetchedDataOffset(destRow) : this.statement.allocateRowDataSpace(srcLen);
            if (srcLen > 0) {
                this.rowData.put(destOff, srcLobAcc.rowData, srcLobAcc.getPrefetchedDataOffset(srcRow), srcLen);
            }
            this.setPrefetchedDataOffset(destRow, destOff);
            this.setPrefetchedDataLength(destRow, srcLen);
            this.setPrefetchedLength(destRow, srcLobAcc.getPrefetchedLength(srcRow));
            this.setPrefetchedChunkSize(destRow, srcLobAcc.getPrefetchedChunkSize(srcRow));
        }
    }

    @Override
    void deleteRow(int row) throws SQLException {
        super.deleteRow(row);
        if (this.isPrefetched()) {
            this.rowData.freeSpace(this.getPrefetchedDataOffset(row), this.getPrefetchedDataLength(row));
            this.delete(this.prefetchedDataOffset, row);
            this.delete(this.prefetchedDataLength, row);
            this.delete(this.prefetchedLength, row);
            this.delete(this.prefetchedChunkSize, row);
            if (this.prefetchedLargeObjects != null) {
                this.releasePrefetchedData(row);
                this.delete(this.prefetchedLargeObjects, row);
            }
        }
    }

    boolean isPrefetched() {
        return !this.isDMLReturnedParam && this.lobPrefetchSizeForThisColumn > -1;
    }

    @Override
    void setNoPrefetch() {
        this.lobPrefetchSizeForThisColumn = -1;
        this.prefetchedDataOffset = null;
        this.prefetchedDataLength = null;
        this.prefetchedLength = null;
        this.prefetchedChunkSize = null;
        this.releasePrefetchedData();
        this.prefetchedLargeObjects = null;
    }

    final int getPrefetchLength() {
        return this.lobPrefetchSizeForThisColumn;
    }

    @Override
    void setPrefetchLength(int length) {
        if (length == -1) {
            this.setNoPrefetch();
        } else {
            this.lobPrefetchSizeForThisColumn = length;
            if (this.rowNull != null) {
                this.setCapacity(this.rowNull.length);
            }
        }
    }

    final void setPrefetchedDataOffset(int currentRow) {
        assert (this.prefetchedDataOffset.length > currentRow) : "prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + currentRow;
        this.prefetchedDataOffset[currentRow] = this.rowData.getPosition();
    }

    final void setPrefetchedDataOffset(int currentRow, long offset) {
        assert (this.prefetchedDataOffset.length > currentRow) : "prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + currentRow;
        this.prefetchedDataOffset[currentRow] = offset;
    }

    final void setPrefetchedDataLength(int currentRow, int length) {
        assert (this.prefetchedDataLength.length > currentRow) : "prefetchedDataLength.length: " + this.prefetchedDataLength.length + " currentRow: " + currentRow;
        this.prefetchedDataLength[currentRow] = length;
    }

    final void setPrefetchedLength(int currentRow, long size) {
        assert (this.prefetchedLength.length > currentRow) : "prefetchedLength.length: " + this.prefetchedLength.length + " currentRow: " + currentRow;
        this.prefetchedLength[currentRow] = size;
    }

    final void setPrefetchedChunkSize(int currentRow, int chunkSize) {
        assert (this.prefetchedChunkSize.length > currentRow) : "prefetchedChunkSize.length: " + this.prefetchedChunkSize.length + " currentRow: " + currentRow;
        this.prefetchedChunkSize[currentRow] = chunkSize;
    }

    final long getPrefetchedDataOffset(int currentRow) {
        return this.prefetchedDataOffset[currentRow];
    }

    final int getPrefetchedDataLength(int currentRow) {
        return this.prefetchedDataLength[currentRow];
    }

    final long getPrefetchedLength(int currentRow) {
        return this.prefetchedLength[currentRow];
    }

    final int getPrefetchedChunkSize(int currentRow) {
        return this.prefetchedChunkSize[currentRow];
    }

    final byte[] getPrefetchedData(int currentRow) {
        if (this.getPrefetchLength() > -1) {
            if (this.getPrefetchedDataLength(currentRow) == 0) {
                return PhysicalConnection.EMPTY_BYTE_ARRAY;
            }
            return this.rowData.get(this.getPrefetchedDataOffset(currentRow), this.getPrefetchedDataLength(currentRow));
        }
        return null;
    }

    protected void addPrefetchedLargeObject(int row, OracleLargeObject largeObject) {
        if (this.prefetchedLargeObjects == null) {
            this.prefetchedLargeObjects = new OracleLargeObject[this.rowNull.length][];
        }
        if (this.prefetchedLargeObjects[row] == null) {
            this.prefetchedLargeObjects[row] = new OracleLargeObject[1];
        }
        if (this.prefetchedLargeObjects[row][0] == null) {
            this.prefetchedLargeObjects[row][0] = largeObject;
        } else {
            int index;
            for (index = 1; index < this.prefetchedLargeObjects[row].length && this.prefetchedLargeObjects[row][index] != null; ++index) {
            }
            if (index == this.prefetchedLargeObjects[row].length) {
                this.prefetchedLargeObjects[row] = Arrays.copyOf(this.prefetchedLargeObjects[row], index == 1 ? 2 : index + (index >> 1));
            }
            this.prefetchedLargeObjects[row][index] = largeObject;
        }
    }

    @Override
    protected void releaseRowData() {
        this.releasePrefetchedData();
    }

    private void releasePrefetchedData() {
        if (this.prefetchedLargeObjects == null) {
            return;
        }
        for (int row = 0; row < this.prefetchedLargeObjects.length; ++row) {
            this.releasePrefetchedData(row);
        }
    }

    private void releasePrefetchedData(int row) {
        OracleLargeObject[] largeObjects = this.prefetchedLargeObjects[row];
        if (largeObjects == null) {
            return;
        }
        for (int i = 0; i < largeObjects.length; ++i) {
            OracleLargeObject largeObject = largeObjects[i];
            if (largeObject == null) continue;
            if (!largeObject.isFree()) {
                if (this.statement.connection.isLobPrefetchDataRetained) {
                    LobCommonAccessor.setPrefetchDataCopy(largeObject);
                } else {
                    largeObject.setPrefetchData(null);
                }
            }
            largeObjects[i] = null;
        }
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getOracleObject(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        return this.getOracleObject(currentRow);
    }

    private static <T> void setPrefetchDataCopy(OracleLargeObject<T> largeObject) {
        OracleLargeObject.PrefetchData<T> prefetchData = largeObject.getPrefetchData();
        if (prefetchData == null) {
            return;
        }
        T copy = prefetchData.share();
        largeObject.setPrefetchData(OracleLargeObject.PrefetchData.wrapArray(copy, prefetchData.length()));
    }
}

