/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.NoSupportHAManager;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ServiceMember;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.FanManager;
import oracle.simplefan.FanSubscription;

public class HAManager
implements Diagnosable {
    private static final String CLASS_NAME = HAManager.class.getName();
    private ConcurrentHashMap<String, Map<String, ServiceMember>> services;
    private ConcurrentHashMap<String, Map<String, ServiceMember>> hosts;
    private Map<String, Integer> cardinalities = new HashMap<String, Integer>();
    private static final String FAN_SERVICE_NAME_PROPERTY = "serviceName";
    private FanManager fanMngr = null;
    private FanSubscription fanSubscription = null;
    static final ConcurrentHashMap<String, HAManager> allManagers = new ConcurrentHashMap();
    static final String FAN_CONFIG_PROPERTY = "oracle.jdbc.fanONSConfig";
    private int drainIntervals = 0;
    private final AtomicInteger remainingIntervals = new AtomicInteger();
    private int targetDrainCountTotal = 0;
    private int targetDrainCountPerInterval = 0;
    private final AtomicInteger currentDrainTarget = new AtomicInteger();
    private final AtomicInteger currentDrainCount = new AtomicInteger();
    private DrainingTask drainingTask = null;
    private DrainingTask delayedDrainingTask = null;
    private static AtomicBoolean dependentJarsChecked = new AtomicBoolean(false);
    private static boolean allDependentJarsPresent = true;

    HAManager() {
        this.services = new ConcurrentHashMap();
        this.hosts = new ConcurrentHashMap();
    }

    HAManager(String onsConfigStr) throws SQLException {
        this();
        this.configure(onsConfigStr);
    }

    static HAManager getInstance(String onsConfigStr) throws SQLException {
        return new HAManager(onsConfigStr);
    }

    private void configure(String onsConfigStr) throws SQLException {
        assert (onsConfigStr != null && !"".equals(onsConfigStr)) : "onsConfigStr: " + onsConfigStr;
        if (this.fanMngr == null) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "Creating FAN manager instance. ", null, null);
            this.fanMngr = FanManager.getInstance();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "Created FAN manager instance. ", null, null);
            if (onsConfigStr != null && !"".equals(onsConfigStr)) {
                Properties onsProps = new Properties();
                onsProps.setProperty("onsRemoteConfig", onsConfigStr);
                this.fanMngr.configure(onsProps);
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "FAN manager instance. ", null, null);
            }
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "FAN manager is not NULL, no-op. ", null, null);
        }
    }

    private static final Constructor<?> getListenerConstructor() {
        return CHolder.c;
    }

    private void addService(String currentServiceName) throws SQLException {
        assert (currentServiceName != null && !"".equals(currentServiceName)) : "currentServiceName: " + currentServiceName;
        if (this.fanMngr != null) {
            Properties subscriptionProps = new Properties();
            subscriptionProps.setProperty(FAN_SERVICE_NAME_PROPERTY, currentServiceName);
            this.fanSubscription = this.fanMngr.subscribe(subscriptionProps);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addService", "Created Fan subscription for service name={0}. ", (String)null, (Throwable)null, (Object)currentServiceName);
            FanEventListener fanListener = null;
            try {
                fanListener = (FanEventListener)HAManager.getListenerConstructor().newInstance(this);
            }
            catch (Throwable t) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addService", "FAN listener creation error.", null, t);
                throw new SQLException("Metadata error: error while creating FAN listener");
            }
            this.fanSubscription.addListener(fanListener);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addService", "Created FAN listener. ", null, null);
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addService", "FAN manager is NULL, no-op. ", null, null);
        }
    }

    void addConnection(OracleConnection oconn) throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addConnection", "HA configured, checking HA subscriptions. ", null, null);
        Properties props = oconn.getServerSessionInfo();
        String origSvc = props.getProperty("SERVICE_NAME");
        String svc = HAManager.toLowerCase(origSvc);
        String inst = HAManager.toLowerCase(props.getProperty("INSTANCE_NAME"));
        String db = HAManager.toLowerCase(props.getProperty("DATABASE_NAME"));
        String hst = HAManager.toLowerCase(props.getProperty("SERVER_HOST"));
        String memberKey = svc + "###" + inst + "###" + db + "###" + hst;
        ConcurrentHashMap<CallSite, ServiceMember> newMembers = new ConcurrentHashMap<CallSite, ServiceMember>();
        Map members = this.services.putIfAbsent(svc, newMembers);
        if (members == null) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addConnection", "NEW service={0}, and member instance={1}. Creating HA subscriptions for service={0}. ", (String)null, (Throwable)null, (Object)origSvc, (Object)inst);
            this.addService(origSvc);
            ServiceMember member = new ServiceMember(svc, inst, db, hst);
            member.up();
            member.addConnection(oconn);
            newMembers.put((CallSite)((Object)memberKey), member);
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addConnection", "Existing member instance={0}. ", (String)null, (Throwable)null, (Object)inst);
            ServiceMember member = (ServiceMember)members.get(memberKey);
            if (member != null) {
                member.up();
                member.addConnection(oconn);
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addConnection", "NEW member instance={0}. ", (String)null, (Throwable)null, (Object)inst);
                member = new ServiceMember(svc, inst, db, hst);
                member.up();
                member.addConnection(oconn);
                members.put(memberKey, member);
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addConnection", "Added new member instance to topology, new size={0}. ", (String)null, (Throwable)null, (Object)members.size());
            }
        }
        oconn.setHAManager(this);
    }

    public void dropConnection(OracleConnection oconn) throws SQLException {
        Properties props = oconn.getServerSessionInfo();
        String svc = HAManager.toLowerCase(props.getProperty("SERVICE_NAME"));
        String inst = HAManager.toLowerCase(props.getProperty("INSTANCE_NAME"));
        String db = HAManager.toLowerCase(props.getProperty("DATABASE_NAME"));
        String hst = HAManager.toLowerCase(props.getProperty("SERVER_HOST"));
        String memberKey = svc + "###" + inst + "###" + db + "###" + hst;
        Map<String, ServiceMember> members = this.services.get(svc);
        if (members == null) {
            throw new SQLException("Metadata error: no member instances for service");
        }
        ServiceMember member = members.get(memberKey);
        if (member == null) {
            throw new SQLException("Metadata error: no member instance for service");
        }
        member.dropConnection(oconn);
    }

    void plannedDown(String evtService, String evtInstance, String evtDatabase, String evtHost, int drainTimeout) {
        try {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "svc={0}, inst={1}, db={2}, hst={3}, drain_timeout={4}. ", (String)null, (Throwable)null, (Object)evtService, (Object)evtInstance, (Object)evtDatabase, (Object)evtHost, (Object)drainTimeout);
            Map<String, ServiceMember> members = this.services.get(evtService);
            if (members == null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "non-applicable FAN down-event for service={0}. ", (String)null, (Throwable)null, (Object)evtService);
                return;
            }
            if (evtInstance == null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "full-service down, database={0}. ", (String)null, (Throwable)null, (Object)evtDatabase);
                for (ServiceMember downMember : members.values()) {
                    if (downMember.getDatabase().equalsIgnoreCase(evtDatabase)) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "ONLY marking down member instance={0}. ", (String)null, (Throwable)null, (Object)downMember.getName());
                        downMember.down();
                        continue;
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "full-service down not-applicable. member={0}. ", (String)null, (Throwable)null, (Object)downMember.getName());
                }
            } else {
                String memberKey = evtService + "###" + evtInstance + "###" + evtDatabase + "###" + evtHost;
                ServiceMember member = members.get(memberKey);
                if (member != null) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "ONLY marking down member instance={0}. ", (String)null, (Throwable)null, (Object)member.getName());
                    member.down();
                    this.drainGracefully(member, members, drainTimeout);
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "non-applicable FAN down-event. service={0}, instance={1}. ", (String)null, (Throwable)null, (Object)evtService, (Object)evtInstance);
                }
            }
        }
        catch (Throwable t) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "plannedDown", "Planned-down error. ", null, t);
        }
    }

    private void drainGracefully(ServiceMember member, Map<String, ServiceMember> members, int drainTimeout) {
        if (drainTimeout > 0) {
            this.drainIntervals = (drainTimeout + 10 - 1) / 10;
            this.remainingIntervals.set(this.drainIntervals);
            this.targetDrainCountTotal = member.connCount;
            this.targetDrainCountPerInterval = (this.targetDrainCountTotal + this.drainIntervals - 1) / this.drainIntervals;
            this.currentDrainCount.set(0);
            this.currentDrainTarget.set(0);
            this.drainingTask = new DrainingTask();
            boolean noOtherInstanceUp = true;
            for (ServiceMember m : members.values()) {
                if (!m.isUp()) continue;
                noOtherInstanceUp = false;
                break;
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "drainGracefully", "Planned down, noOtherInstanceUp={0}. ", (String)null, (Throwable)null, (Object)noOtherInstanceUp);
            if (noOtherInstanceUp) {
                this.delayedDrainingTask = this.drainingTask;
            } else {
                this.scheduleDrainingTask(this.drainingTask, this.drainIntervals);
            }
        }
    }

    private void scheduleDrainingTask(DrainingTask task, int interval) {
        if (interval > 0) {
            task.scheduleRepeatedExecution(interval);
        } else {
            task.scheduleExecution();
        }
    }

    void unplannedDown(String evtService, String evtInstance, String evtDatabase, String evtHost) {
        try {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "svc={0}, inst={1}, db={2}, hst={3}. ", (String)null, (Throwable)null, (Object)evtService, (Object)evtInstance, (Object)evtDatabase, (Object)evtHost);
            Map<String, ServiceMember> members = this.services.get(evtService);
            if (members == null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "non-applicable FAN down-event for service={0}. ", (String)null, (Throwable)null, (Object)evtService);
                return;
            }
            if (evtInstance == null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "full-service down. database={0}. ", (String)null, (Throwable)null, (Object)evtDatabase);
                for (ServiceMember downMember : members.values()) {
                    if (downMember.getDatabase().equalsIgnoreCase(evtDatabase)) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "marking down member instance={0}. ", (String)null, (Throwable)null, (Object)downMember.getName());
                        downMember.down();
                        downMember.cleanupConnections();
                        continue;
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "full-service down not-applicable to {0}. ", (String)null, (Throwable)null, (Object)downMember.getName());
                }
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "member instance down", null, null);
                String memberKey = evtService + "###" + evtInstance + "###" + evtDatabase + "###" + evtHost;
                ServiceMember member = members.get(memberKey);
                if (member != null) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "marking down member instance={0}. ", (String)null, (Throwable)null, (Object)member.getName());
                    member.down();
                    member.cleanupConnections();
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", "non-applicable FAN down-event. service={0}, instance={1}. ", (String)null, (Throwable)null, (Object)evtService, (Object)evtInstance);
                }
            }
        }
        catch (Throwable t) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unplannedDown", null, null, t);
        }
    }

    void nodeDown(String evtHost) {
        try {
            Map<String, ServiceMember> members = this.hosts.get(evtHost);
            if (members == null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "nodeDown", "non-applicable FAN down-event. node={0}. ", (String)null, (Throwable)null, (Object)evtHost);
                return;
            }
            for (ServiceMember downMember : members.values()) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "nodeDown", "marking down member instance={0}. ", (String)null, (Throwable)null, (Object)downMember.getName());
                downMember.down();
                downMember.cleanupConnections();
            }
        }
        catch (Throwable t) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "nodeDown", null, null, t);
        }
    }

    void serviceUp(String evtService, String evtInstance, String evtDatabase, String evtHost, int cardinality) {
        try {
            String memberKey;
            if (!this.services.containsKey(evtService)) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "serviceUp", "non-applicable FAN up-event. service={0}. ", (String)null, (Throwable)null, (Object)evtService);
                return;
            }
            if (evtInstance == null) {
                this.cardinalities.put(evtService, cardinality);
                return;
            }
            Map<String, ServiceMember> members = this.services.get(evtService);
            ServiceMember member = members.get(memberKey = evtService + "###" + evtInstance + "###" + evtDatabase + "###" + evtHost);
            if (member != null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "serviceUp", "marking UP. member={0}. ", (String)null, (Throwable)null, (Object)member.getName());
                member.up();
                this.cardinalities.put(evtService, cardinality);
                if (this.delayedDrainingTask != null) {
                    this.scheduleDrainingTask(this.drainingTask, this.drainIntervals);
                }
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "serviceUp", "non-applicable FAN up-event. service={0}, instance={1}. ", (String)null, (Throwable)null, (Object)evtService, (Object)evtInstance);
            }
        }
        catch (Throwable t) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "serviceUp", null, null, t);
        }
    }

    public boolean isServiceMemberDown(OracleConnection oconn) throws SQLException {
        Properties props = oconn.getServerSessionInfo();
        String svc = HAManager.toLowerCase(props.getProperty("SERVICE_NAME"));
        String inst = HAManager.toLowerCase(props.getProperty("INSTANCE_NAME"));
        String db = HAManager.toLowerCase(props.getProperty("DATABASE_NAME"));
        String hst = HAManager.toLowerCase(props.getProperty("SERVER_HOST"));
        String memberKey = svc + "###" + inst + "###" + db + "###" + hst;
        Map<String, ServiceMember> members = this.services.get(svc);
        if (members != null) {
            ServiceMember member = members.get(memberKey);
            return member.isDown();
        }
        return false;
    }

    public boolean checkAndDrain(OracleConnection oconn) throws SQLException {
        boolean justDrain = false;
        if (this.drainIntervals > 0) {
            if (this.remainingIntervals.get() == 0) {
                if (this.drainingTask != null) {
                    this.drainingTask.cancel();
                    this.drainingTask = null;
                }
                if (this.delayedDrainingTask != null) {
                    this.delayedDrainingTask.cancel();
                    this.delayedDrainingTask = null;
                }
                this.drainIntervals = 0;
                justDrain = true;
            } else {
                justDrain = false;
            }
        } else {
            justDrain = true;
        }
        if (this.isServiceMemberDown(oconn) && (justDrain || this.currentDrainCount.get() < this.currentDrainTarget.get())) {
            ((PhysicalConnection)oconn).closeConnectionSafely();
            this.currentDrainCount.incrementAndGet();
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "checkAndDrain", "Cleaned up. conn={0}. ", null, null, () -> {
                try {
                    return new Object[]{oconn.getNetConnectionId()};
                }
                catch (SQLException e) {
                    return new Object[]{e.getMessage()};
                }
            });
            return true;
        }
        return false;
    }

    public static void enableHAIfNecessary(final String url2, final OracleConnection oconn) throws SQLException {
        try {
            OracleDriver.getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        HAManager.enableHAIfNecessaryAsync(url2, oconn);
                    }
                    catch (Throwable err) {
                        CommonDiagnosable.getInstance().debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessary", "connId={0}. async HA-enabling task failed: {1}", null, null, () -> {
                            try {
                                return new Object[]{oconn.getNetConnectionId(), err};
                            }
                            catch (SQLException e) {
                                return new Object[]{e.getMessage(), err};
                            }
                        });
                    }
                }
            });
        }
        catch (Throwable exc) {
            CommonDiagnosable.getInstance().debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessary", "connId={0}. HA-enabling task submission failed: {1}", null, null, () -> {
                try {
                    return new Object[]{oconn.getNetConnectionId(), exc};
                }
                catch (SQLException e) {
                    return new Object[]{e.getMessage(), exc};
                }
            });
        }
    }

    public static void enableHAIfNecessaryAsync(String url2, OracleConnection oconn) throws SQLException {
        boolean fanEnabled = true;
        if (dependentJarsChecked.compareAndSet(false, true)) {
            try {
                ClassLoader clsLoader = oconn.getClass().getClassLoader();
                Class.forName("oracle.simplefan.FanManager", false, clsLoader);
                Class.forName("oracle.ons.ONS", false, clsLoader);
                allDependentJarsPresent = true;
            }
            catch (Throwable err) {
                allDependentJarsPresent = false;
                fanEnabled = false;
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "simplefan.jar or ons.jar is not on the classpath, HA is disabled. {0}. ", (String)null, (Throwable)null, (Object)err);
            }
        }
        if (!allDependentJarsPresent) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "HA is explicitly disabled. ", null, null);
        } else {
            HAManager haManager = allManagers.get(url2);
            if (haManager == null) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "url={0}. Automatically determine whether to enable HA. ", (String)null, (Throwable)null, (Object)url2);
                String explicitONSConfig = System.getProperty(FAN_CONFIG_PROPERTY);
                short ver = oconn.getVersionNumber();
                String onsConfig = null;
                if (ver < 11100) {
                    fanEnabled = false;
                    CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "url={0}. Pre-11.x DB, HA is disabled. ", (String)null, (Throwable)null, (Object)url2);
                } else if (explicitONSConfig != null && !"".equals(explicitONSConfig)) {
                    fanEnabled = true;
                    onsConfig = explicitONSConfig;
                    CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "url={0}. explicit ONS config provided, HA is enabled. ", (String)null, (Throwable)null, (Object)url2);
                } else {
                    Properties connSig = oconn.getServerSessionInfo();
                    String autoONSConfig = connSig.getProperty("AUTH_ONS_CONFIG");
                    if (ver >= 12101) {
                        if (autoONSConfig == null) {
                            fanEnabled = false;
                            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "url={0}. Single-instance 12.x DB, HA is disabled. ", (String)null, (Throwable)null, (Object)url2);
                        } else {
                            fanEnabled = true;
                            onsConfig = autoONSConfig;
                            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "{0}. RAC/GDS 12.x, HA is enabled. ", (String)null, (Throwable)null, (Object)url2);
                        }
                    } else {
                        fanEnabled = false;
                        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "url={0}. DB 11.x with no ONS config provided, HA is disabled.", (String)null, (Throwable)null, (Object)url2);
                    }
                }
                if (fanEnabled) {
                    try {
                        haManager = HAManager.getInstance(onsConfig);
                    }
                    catch (Throwable err) {
                        fanEnabled = false;
                        haManager = NoSupportHAManager.getInstance();
                        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enableHAIfNecessaryAsync", "url={0}. ONS config failed, HA is disabled. ", (String)null, (Throwable)null, (Object)url2);
                    }
                } else {
                    haManager = NoSupportHAManager.getInstance();
                }
                allManagers.putIfAbsent(url2, haManager);
            }
            haManager.addConnection(oconn);
        }
    }

    public static void shutdownAll() {
        for (HAManager mngr : allManagers.values()) {
            if (mngr == null) continue;
            mngr.close();
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "shutdownAll", "Closed all FAN subscriptions in Oracle JDBC driver. ", null, null);
    }

    public void close() {
        if (this.fanSubscription != null) {
            this.fanSubscription.close();
        }
        if (this.drainingTask != null) {
            this.drainingTask.cancel();
        }
        if (this.delayedDrainingTask != null) {
            this.delayedDrainingTask.cancel();
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "close", "Closed FAN subscription on={0}. ", (String)null, (Throwable)null, (Object)this.hashCode());
    }

    static final String getStackTraceString(Throwable exc) {
        StringWriter stackTraceWriter = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(stackTraceWriter);
        exc.printStackTrace(pw);
        return ((Object)stackTraceWriter).toString();
    }

    private static String toLowerCase(String s2) {
        return null == s2 ? null : s2.toLowerCase();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    private final class DrainingTask {
        private TimerTask scheduledTimerTask = null;

        private DrainingTask() {
        }

        private void updateDrainTarget() {
            if (HAManager.this.remainingIntervals.get() > 0) {
                int left = HAManager.this.targetDrainCountTotal - HAManager.this.currentDrainCount.get();
                int delta = Math.min(HAManager.this.targetDrainCountPerInterval, left);
                HAManager.this.currentDrainTarget.addAndGet(delta);
                HAManager.this.remainingIntervals.decrementAndGet();
            }
        }

        boolean cancel() {
            if (this.scheduledTimerTask == null) {
                return false;
            }
            return this.scheduledTimerTask.cancel();
        }

        void scheduleExecution() {
            assert (this.scheduledTimerTask == null) : "Task is already scheduled";
            this.scheduledTimerTask = TimeoutInterruptHandler.scheduleTask(this::updateDrainTarget, 0L);
        }

        void scheduleRepeatedExecution(int intervalOfSeconds) {
            assert (this.scheduledTimerTask == null) : "Task is already scheduled";
            this.scheduledTimerTask = TimeoutInterruptHandler.scheduleFixedDelayRepeatingTask(this::updateDrainTarget, (long)intervalOfSeconds * 1000L);
        }
    }

    private static final class CHolder {
        private static final String CLASS_NAME = CHolder.class.getName();
        private static Class<?> cls;
        private static Constructor<?> c;

        private CHolder() {
        }

        static {
            try {
                cls = Class.forName("oracle.jdbc.driver.HAFanListener");
                c = cls.getDeclaredConstructor(HAManager.class);
            }
            catch (Throwable exc) {
                CommonDiagnosable.getInstance().debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "CHolder", "FAN listener constructor error.", null, exc);
                c = null;
                cls = null;
            }
        }
    }
}

