/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class DateCommonBinder
extends Binder {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int ORACLE_DATE_CENTURY = 0;
    static final int ORACLE_DATE_YEAR = 1;
    static final int ORACLE_DATE_MONTH = 2;
    static final int ORACLE_DATE_DAY = 3;
    static final int ORACLE_DATE_HOUR = 4;
    static final int ORACLE_DATE_MIN = 5;
    static final int ORACLE_DATE_SEC = 6;
    static final int ORACLE_DATE_NANO1 = 7;
    static final int ORACLE_DATE_NANO2 = 8;
    static final int ORACLE_DATE_NANO3 = 9;
    static final int ORACLE_DATE_NANO4 = 10;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int SECOND_MILLISECOND = 1000;

    DateCommonBinder() {
    }

    static final long floorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    static final int floorDivide(int numerator, int denominator) {
        return numerator >= 0 ? numerator / denominator : (numerator + 1) / denominator - 1;
    }

    static final int floorDivide(int numerator, int denominator, int[] remainder) {
        if (numerator >= 0) {
            remainder[0] = numerator % denominator;
            return numerator / denominator;
        }
        int quotient = (numerator + 1) / denominator - 1;
        remainder[0] = numerator - quotient * denominator;
        return quotient;
    }

    static final int floorDivide(long numerator, int denominator, int[] remainder) {
        if (numerator >= 0L) {
            remainder[0] = (int)(numerator % (long)denominator);
            return (int)(numerator / (long)denominator);
        }
        int quotient = (int)((numerator + 1L) / (long)denominator - 1L);
        remainder[0] = (int)(numerator - (long)(quotient * denominator));
        return quotient;
    }

    static void setOracleNanos(long nanos, byte[] oracleDate, int off) {
        oracleDate[10 + off] = (byte)(nanos & 0xFFL);
        oracleDate[9 + off] = (byte)(nanos >> 8 & 0xFFL);
        oracleDate[8 + off] = (byte)(nanos >> 16 & 0xFFL);
        oracleDate[7 + off] = (byte)(nanos >> 24 & 0xFFL);
    }

    static void setOracleHMS(int millis, byte[] oracleDate, int off) {
        if (millis < 0) {
            throw new RuntimeException("Assertion botch: negative time");
        }
        oracleDate[6 + off] = (byte)((millis /= 1000) % 60 + 1);
        oracleDate[5 + off] = (byte)((millis /= 60) % 60 + 1);
        oracleDate[4 + off] = (byte)((millis /= 60) + 1);
    }

    static final int setOracleCYMD(long time, byte[] oracleDate, int off, OraclePreparedStatement stmt) throws SQLException {
        int march1;
        int dayOfWeek;
        boolean isLeap;
        int year2;
        int dayOfYear;
        TimeZone zone = stmt.getDefaultTimeZone(true);
        Calendar cal2 = stmt.getDefaultCalendar();
        cal2.setTimeInMillis(time);
        int Offset_UTC = cal2.get(15);
        int Offset_DST = cal2.get(16);
        long localMillis = time + (long)Offset_UTC;
        if (localMillis >= -12219292800000L) {
            int n1;
            int n4;
            int n100;
            int n400;
            long gregorianEpochDay = 2440588L + DateCommonBinder.floorDivide(localMillis, 86400000L) - 1721426L;
            if (gregorianEpochDay > 0L) {
                n400 = (int)(gregorianEpochDay / 146097L);
                dayOfYear = (int)(gregorianEpochDay % 146097L);
                n100 = dayOfYear / 36524;
                n4 = (dayOfYear %= 36524) / 1461;
                n1 = (dayOfYear %= 1461) / 365;
                dayOfYear %= 365;
            } else {
                int[] rem = new int[1];
                n400 = DateCommonBinder.floorDivide(gregorianEpochDay, 146097, rem);
                n100 = DateCommonBinder.floorDivide(rem[0], 36524, rem);
                n4 = DateCommonBinder.floorDivide(rem[0], 1461, rem);
                n1 = DateCommonBinder.floorDivide(rem[0], 365, rem);
                dayOfYear = rem[0];
            }
            year2 = 400 * n400 + 100 * n100 + 4 * n4 + n1;
            if (n100 == 4 || n1 == 4) {
                dayOfYear = 365;
            } else {
                ++year2;
            }
            isLeap = (year2 & 3) == 0 && (year2 % 100 != 0 || year2 % 400 == 0);
            dayOfWeek = (int)((gregorianEpochDay + 1L) % 7L);
        } else {
            long julianEpochDay = 2440588L + DateCommonBinder.floorDivide(localMillis, 86400000L) - 1721424L;
            year2 = (int)DateCommonBinder.floorDivide(4L * julianEpochDay + 1464L, 1461L);
            long january1 = 365 * (year2 - 1) + DateCommonBinder.floorDivide(year2 - 1, 4);
            dayOfYear = (int)(julianEpochDay - january1);
            isLeap = (year2 & 3) == 0;
            dayOfWeek = (int)((julianEpochDay - 1L) % 7L);
        }
        int correction = 0;
        int n = march1 = isLeap ? 60 : 59;
        if (dayOfYear >= march1) {
            correction = isLeap ? 1 : 2;
        }
        int month2 = (12 * (dayOfYear + correction) + 6) / 367;
        int date = dayOfYear - (isLeap ? LEAP_NUM_DAYS[month2] : NUM_DAYS[month2]) + 1;
        dayOfWeek += dayOfWeek < 0 ? 8 : 1;
        long days = localMillis / 86400000L;
        int millisInDay = (int)(localMillis - days * 86400000L);
        if (millisInDay < 0) {
            millisInDay = (int)((long)millisInDay + 86400000L);
        }
        if ((long)(millisInDay += Offset_DST) >= 86400000L) {
            millisInDay = (int)((long)millisInDay - 86400000L);
            if (++date > (isLeap ? LEAP_MONTH_LENGTH[month2] : MONTH_LENGTH[month2])) {
                date = 1;
                if (++month2 == 12) {
                    month2 = 0;
                    ++year2;
                }
            }
        }
        if (year2 <= 0) {
            --year2;
        }
        if (year2 > 9999 || year2 < -4712) {
            throw (SQLException)DatabaseError.createSqlException(268).fillInStackTrace();
        }
        oracleDate[0 + off] = (byte)(year2 / 100 + 100);
        oracleDate[1 + off] = (byte)(year2 % 100 + 100);
        oracleDate[2 + off] = (byte)(month2 + 1);
        oracleDate[3 + off] = (byte)date;
        return millisInDay;
    }
}

