/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.DATE;
import oracle.sql.Datum;

class DateAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 7;

    DateAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.DATE, stmt, 7, isStoredInBindData);
        this.init(stmt, 12, 12, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    DateAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.DATE, stmt, 7, false);
        this.init(stmt, 12, 12, form, false);
        this.initForDescribe(12, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        Object result2 = null;
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        if (this.externalType == 0) {
            if (this.statement.connection.mapDateToTimestamp) {
                return DateAccessor.timestampToString(this.getTimestamp(currentRow));
            }
            return this.getDate(currentRow).toString();
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        int year2 = DateAccessor.oracleYear(this.tmpBytes);
        int hour2 = 0;
        hour2 = this.tmpBytes[4] - 1;
        return this.toText(year2, this.tmpBytes[2], this.tmpBytes[3], hour2, this.tmpBytes[5] - 1, this.tmpBytes[6] - 1, -1, hour2 < 12, null);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        if (this.externalType == 0) {
            if (this.statement.connection.mapDateToTimestamp) {
                return this.getTimestamp(currentRow);
            }
            return this.getDate(currentRow);
        }
        switch (this.externalType) {
            case 91: {
                return this.getDate(currentRow);
            }
            case 92: {
                return this.getTime(currentRow);
            }
            case 93: {
                return this.getTimestamp(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getDATE(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        return this.getObject(currentRow);
    }

    @Override
    LocalDate getLocalDate(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new DATE(this.getBytesInternal(currentRow)), LocalDate.class, this.statement.connection, null, null);
    }

    @Override
    LocalDateTime getLocalDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new DATE(this.getBytesInternal(currentRow)), LocalDateTime.class, this.statement.connection, null, null);
    }

    @Override
    LocalTime getLocalTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new DATE(this.getBytesInternal(currentRow)), LocalTime.class, this.statement.connection, null, null);
    }

    @Override
    OffsetDateTime getOffsetDateTime(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1716, null, null, "DATE").fillInStackTrace();
    }

    @Override
    OffsetTime getOffsetTime(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1716, null, null, "DATE").fillInStackTrace();
    }

    @Override
    ZonedDateTime getZonedDateTime(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1716, null, null, "DATE").fillInStackTrace();
    }

    static String timestampToString(Timestamp timestamp2) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timestamp2);
    }
}

