/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;
import oracle.sql.converter.CharacterSetMetaData;

class ClobAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    int[] prefetchedDataCharset;
    int[] prefetchedDataFormOfUse;
    private CharacterSet cachedCharSet = null;
    private CharacterSet ucs2CompatibleCharSet = null;

    ClobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(form == 2 ? Representation.NCLOB : Representation.CLOB, stmt, 4000, isStoredInBindData);
        this.init(stmt, 112, 112, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    ClobAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(form == 2 ? Representation.NCLOB : Representation.CLOB, stmt, 4000, false);
        this.init(stmt, 112, 112, form, false);
        this.initForDescribe(112, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    void setCapacity(int capacity) {
        super.setCapacity(capacity);
        if (this.prefetchedDataCharset == null) {
            this.prefetchedDataCharset = new int[capacity];
            this.prefetchedDataFormOfUse = new int[capacity];
        } else if (capacity > this.prefetchedDataCharset.length) {
            int[] tmp = new int[capacity];
            System.arraycopy(this.prefetchedDataCharset, 0, tmp, 0, this.prefetchedDataCharset.length);
            this.prefetchedDataCharset = tmp;
            tmp = new int[capacity];
            System.arraycopy(this.prefetchedDataFormOfUse, 0, tmp, 0, this.prefetchedDataFormOfUse.length);
            this.prefetchedDataFormOfUse = tmp;
        }
    }

    @Override
    void insertNull(int rowIndex) throws SQLException {
        System.arraycopy(this.prefetchedDataCharset, rowIndex, this.prefetchedDataCharset, rowIndex + 1, this.prefetchedDataCharset.length - rowIndex - 1);
        System.arraycopy(this.prefetchedDataFormOfUse, rowIndex, this.prefetchedDataFormOfUse, rowIndex + 1, this.prefetchedDataFormOfUse.length - rowIndex - 1);
        super.insertNull(rowIndex);
    }

    @Override
    Accessor copyForDefine(OracleStatement dest) {
        ClobAccessor acc = (ClobAccessor)super.copyForDefine(dest);
        acc.prefetchedDataCharset = null;
        acc.prefetchedDataFormOfUse = null;
        return acc;
    }

    @Override
    protected void copyFromInternal(Accessor srcAcc, int srcRow, int destRow) throws SQLException {
        super.copyFromInternal(srcAcc, srcRow, destRow);
        if (this.isPrefetched()) {
            ClobAccessor srcClobAcc = (ClobAccessor)srcAcc;
            this.setPrefetchedDataCharset(destRow, srcClobAcc.getPrefetchedDataCharset(srcRow));
            this.setPrefetchedDataFormOfUse(destRow, srcClobAcc.getPrefetchedDataFormOfUse(srcRow));
        }
    }

    @Override
    void deleteRow(int row) throws SQLException {
        super.deleteRow(row);
        if (this.isPrefetched()) {
            this.delete(this.prefetchedDataCharset, row);
            this.delete(this.prefetchedDataFormOfUse, row);
        }
    }

    final int getPrefetchedDataCharset(int currentRow) {
        return this.prefetchedDataCharset[currentRow];
    }

    final void setPrefetchedDataCharset(int currentRow, int charSet) {
        this.prefetchedDataCharset[currentRow] = charSet;
    }

    final int getPrefetchedDataFormOfUse(int currentRow) {
        return this.prefetchedDataFormOfUse[currentRow];
    }

    final void setPrefetchedDataFormOfUse(int currentRow, int formOfUse) {
        this.prefetchedDataFormOfUse[currentRow] = formOfUse;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getCLOB(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        return this.getCLOB(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getCLOB(currentRow);
    }

    protected void normalizeFormOfUse(byte[] locator) {
        short formOfUseFromLocator = oracle.sql.CLOB.getFormOfUseFromLocator(locator);
        if (formOfUseFromLocator != -1) {
            this.formOfUse = formOfUseFromLocator;
        }
    }

    private CLOB getCLOB_(int currentRow, byte[] locator) throws SQLException {
        CLOB result2 = this.formOfUse == 1 ? new CLOB((OracleConnection)this.statement.connection, locator, this.formOfUse) : new NCLOB(this.statement.connection, locator);
        if (this.isPrefetched()) {
            result2.setActivePrefetch(true);
            result2.setLength(this.getPrefetchedLength(currentRow));
            result2.setChunkSize(this.getPrefetchedChunkSize(currentRow));
            if (this.getPrefetchLength() > -1 && this.getPrefetchedDataLength(currentRow) != 0) {
                int characterWidth;
                boolean isFixedWidth;
                CharacterSet characterSet = this.getPrefetchedDataCharacterSet(currentRow);
                if (characterSet.getOracleId() == 2000 || characterSet.getOracleId() == 2002) {
                    isFixedWidth = true;
                    characterWidth = 2;
                } else {
                    isFixedWidth = CharacterSetMetaData.isFixedWidth(characterSet.getOracleId());
                    characterWidth = CharacterSetMetaData.getRatio(characterSet.getOracleId(), 1);
                }
                if (isFixedWidth || characterWidth == 1) {
                    result2.setPrefetchData(new PrefetchCharData(this.rowData, this.getPrefetchedDataOffset(currentRow), this.getPrefetchedDataLength(currentRow), characterSet, characterWidth));
                    this.addPrefetchedLargeObject(currentRow, result2);
                } else {
                    int[] lengthHolder = new int[1];
                    result2.setPrefetchData(OracleLargeObject.PrefetchData.wrapArray(this.getPrefetchedCharData(currentRow, lengthHolder), lengthHolder[0]));
                }
            } else {
                result2.setPrefetchData((OracleLargeObject.PrefetchData<char[]>)null);
            }
        }
        if (result2.isTemporary()) {
            this.statement.connection.addTemporaryLob(result2.getInternal());
        }
        return result2;
    }

    @Override
    CLOB getCLOB(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] locator = this.getBytesInternal(currentRow);
        this.normalizeFormOfUse(locator);
        CLOB result2 = this.getCLOB_(currentRow, locator);
        return result2;
    }

    @Override
    NCLOB getNCLOB(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] locator = this.getBytesInternal(currentRow);
        this.normalizeFormOfUse(locator);
        if (this.formOfUse != 2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
        }
        return (NCLOB)this.getCLOB_(currentRow, locator);
    }

    final char[] XgetPrefetchedCharData(int currentRow, int[] out_charLength) throws SQLException {
        if (this.getPrefetchLength() == -1) {
            return null;
        }
        int nbOfCharsFromConversion = -1;
        int nbOfBytesFromNetwork = this.getPrefetchedDataLength(currentRow);
        char[] charsData = new char[this.getPrefetchedDataLength(currentRow)];
        byte[] prefetchedData = this.rowData.get(this.getPrefetchedDataOffset(currentRow), this.getPrefetchedDataLength(currentRow));
        if (this.getPrefetchedDataCharset(currentRow) != 0) {
            nbOfCharsFromConversion = this.getPrefetchedDataCharset(currentRow) == 2000 ? CharacterSet.convertAL16UTF16BytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesFromNetwork, true) : CharacterSet.convertAL16UTF16LEBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesFromNetwork, true);
        } else {
            int[] nbOfBytesArr = new int[]{nbOfBytesFromNetwork};
            nbOfCharsFromConversion = this.formOfUse == 1 ? this.statement.connection.conversion.CHARBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesArr, charsData.length) : this.statement.connection.conversion.NCHARBytesToJavaChars(prefetchedData, 0, charsData, 0, nbOfBytesArr, charsData.length);
        }
        out_charLength[0] = nbOfCharsFromConversion;
        return charsData;
    }

    final CharacterSet getPrefetchedDataCharacterSet(int row) {
        int charSetId = this.getPrefetchedDataCharset(row);
        if (charSetId == 0) {
            return this.statement.connection.conversion.getCharacterSet((short)this.getPrefetchedDataFormOfUse(row));
        }
        if (this.cachedCharSet == null || this.cachedCharSet.getOracleId() != charSetId) {
            this.cachedCharSet = CharacterSet.make(charSetId);
        }
        return this.cachedCharSet;
    }

    final char[] getPrefetchedCharData(int currentRow, int[] out_charLength) throws SQLException {
        if (this.getPrefetchLength() == -1) {
            return null;
        }
        return this.rowData.getChars(this.getPrefetchedDataOffset(currentRow), this.getPrefetchedDataLength(currentRow), this.getPrefetchedDataCharacterSet(currentRow), out_charLength);
    }

    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        CLOB clob = this.getCLOB(currentRow);
        if (clob == null) {
            return null;
        }
        return clob.getAsciiStream(true);
    }

    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        CLOB clob = this.getCLOB(currentRow);
        if (clob == null) {
            return null;
        }
        return clob.getCharacterStream();
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        CLOB clob = this.getCLOB(currentRow);
        if (clob == null) {
            return null;
        }
        return clob.getAsciiStream();
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.isPrefetched() && this.getPrefetchedLength(currentRow) > Integer.MAX_VALUE) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        CLOB clob = this.getCLOB(currentRow);
        if (clob == null) {
            return null;
        }
        if (clob.isTemporary()) {
            this.statement.addToTempLobsToFree(clob);
        }
        if (this.isPrefetched()) {
            if (this.statement.definedColumnSize != null && this.statement.definedColumnSize.length > currentRow && this.getPrefetchedLength(currentRow) <= (long)this.statement.definedColumnSize[currentRow] && this.getPrefetchedDataCharset(currentRow) != 0) {
                if (this.ucs2CompatibleCharSet == null || this.ucs2CompatibleCharSet.getOracleId() != this.getPrefetchedDataCharset(currentRow)) {
                    this.ucs2CompatibleCharSet = this.getPrefetchedDataCharset(currentRow) == 2000 ? CharacterSet.make(2000) : CharacterSet.make(2002);
                }
                return this.rowData.getString(this.getPrefetchedDataOffset(currentRow), this.getPrefetchedDataLength(currentRow), this.ucs2CompatibleCharSet);
            }
            return clob.getSubString(1L, (int)this.getPrefetchedLength(currentRow));
        }
        return this.getStringNoPrefetch(currentRow);
    }

    String getStringNoPrefetch(int currentRow) throws SQLException {
        CLOB clob = this.getCLOB(currentRow);
        if (clob == null) {
            return null;
        }
        Reader r = clob.getCharacterStream();
        int size = clob.getBufferSize();
        int length = 0;
        StringWriter w = new StringWriter(size);
        char[] buffer = new char[size];
        try {
            while ((length = r.read(buffer)) != -1) {
                w.write(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
        catch (IndexOutOfBoundsException x) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        if (clob.isTemporary()) {
            this.statement.addToTempLobsToFree(clob);
        }
        return w.getBuffer().substring(0);
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getBytes").fillInStackTrace();
    }

    @Override
    long updateChecksum(long _checkSum, int currentRow) throws SQLException {
        this.unimpl("updateChecksum");
        return -1L;
    }

    private static final class PrefetchCharData
    implements OracleLargeObject.PrefetchData<char[]> {
        private final ByteArray byteArray;
        private final long offset;
        private final int length;
        private final CharacterSet characterSet;
        private final int characterWidth;

        private PrefetchCharData(ByteArray byteArray, long offset, int length, CharacterSet characterSet, int characterWidth) {
            this.byteArray = byteArray;
            this.offset = offset;
            this.length = length;
            this.characterSet = characterSet;
            this.characterWidth = characterWidth;
        }

        @Override
        public int copy(int srcOffset, char[] dst, int dstOffset, int length) {
            int copyLength = Math.min(length, this.length() - srcOffset);
            if (copyLength < 1) {
                return 0;
            }
            try {
                return this.byteArray.getChars(this.offset + (long)(srcOffset * this.characterWidth), copyLength * this.characterWidth, this.characterSet, dst, dstOffset);
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException(sqlException);
            }
        }

        @Override
        public int length() {
            return this.length / this.characterWidth;
        }

        @Override
        public char[] share() {
            try {
                return this.byteArray.getChars(this.offset, this.length, this.characterSet);
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException(sqlException);
            }
        }
    }
}

