/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NumberCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BOOLEAN;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.NUMBER;

class BooleanAccessor
extends NumberCommonAccessor {
    static final int MAXLENGTH = 4;

    BooleanAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(stmt, 4, isStoredInBindData);
        this.init(stmt, max_len, form, external_type, isOutBind);
    }

    BooleanAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, 4, false);
        this.init(stmt, max_len, form, 0, false);
        this.initForDescribe(252, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
    }

    @Override
    void init(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind) throws SQLException {
        this.init(stmt, 252, 252, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        int internalTypeMaxLength = this.representationMaxLength;
        if (max_len > 0 && max_len < internalTypeMaxLength) {
            internalTypeMaxLength = max_len;
        }
        this.byteLength = internalTypeMaxLength;
    }

    @Override
    boolean getBoolean(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return false;
        }
        return this.rowData.get(this.getOffset(currentRow)) != 0 || this.getLength(currentRow) >= 3 && this.rowData.get(this.getOffset(currentRow) + 4L - 1L) != 0;
    }

    @Override
    String getString(int currentRow) throws SQLException {
        return String.valueOf(this.getBoolean(currentRow));
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        return this.getBoolean(currentRow) ? 1 : 0;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return this.getBoolean(currentRow);
    }

    @Override
    CHAR getCHAR(int currentRow) throws SQLException {
        CharacterSet cs = this.statement.connection.conversion.getCharacterSet(this.formOfUse);
        return new CHAR(this.getString(currentRow), cs);
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
    }

    @Override
    BOOLEAN getBOOLEAN(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        boolean booleanValue = this.getBoolean(currentRow);
        return new BOOLEAN(booleanValue);
    }

    @Override
    BOOLEAN getOracleObject(int currentRow) throws SQLException {
        return this.getBOOLEAN(currentRow);
    }

    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        int intValue = this.getInt(currentRow);
        return new NUMBER(intValue);
    }
}

