/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.sql.BLOB;
import oracle.sql.Datum;

class BlobAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;

    BlobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.BLOB, stmt, 4000, isStoredInBindData);
        this.init(stmt, 113, 113, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    BlobAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.BLOB, stmt, 4000, false);
        this.init(stmt, 113, 113, form, false);
        this.initForDescribe(113, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getBLOB(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        return this.getBLOB(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getBLOB(currentRow);
    }

    @Override
    BLOB getBLOB(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        BLOB result2 = new BLOB(this.statement.connection, this.getBytesInternal(currentRow));
        if (this.isPrefetched()) {
            result2.setActivePrefetch(true);
            result2.setLength(this.getPrefetchedLength(currentRow));
            result2.setChunkSize(this.getPrefetchedChunkSize(currentRow));
            if (this.getPrefetchLength() > -1 && this.getPrefetchedDataLength(currentRow) != 0) {
                result2.setPrefetchData(new PrefetchByteData(this.rowData, this.getPrefetchedDataOffset(currentRow), this.getPrefetchedDataLength(currentRow)));
                this.addPrefetchedLargeObject(currentRow, result2);
            } else {
                result2.setPrefetchData((OracleLargeObject.PrefetchData<byte[]>)null);
            }
        }
        if (result2.isTemporary()) {
            this.statement.connection.addTemporaryLob(result2.getInternal());
        }
        return result2;
    }

    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        BLOB blob = this.getBLOB(currentRow);
        if (blob == null) {
            return null;
        }
        if (blob.isTemporary()) {
            this.statement.addToTempLobsToFree(blob);
        }
        return blob.asciiStreamValue();
    }

    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        BLOB blob = this.getBLOB(currentRow);
        if (blob == null) {
            return null;
        }
        if (blob.isTemporary()) {
            this.statement.addToTempLobsToFree(blob);
        }
        return blob.characterStreamValue(true);
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        BLOB blob = this.getBLOB(currentRow);
        if (blob == null) {
            return null;
        }
        if (blob.isTemporary()) {
            this.statement.addToTempLobsToFree(blob);
        }
        return blob.getBinaryStream(true);
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.isPrefetched() && this.getPrefetchedLength(currentRow) > Integer.MAX_VALUE) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        if (this.isPrefetched() && (long)this.getPrefetchedDataLength(currentRow) == this.getPrefetchedLength(currentRow)) {
            return this.getPrefetchedData(currentRow);
        }
        BLOB blob = this.getBLOB(currentRow);
        if (blob == null) {
            return null;
        }
        if (blob.isTemporary()) {
            this.statement.addToTempLobsToFree(blob);
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    @Override
    String getString(int currentRow) throws SQLException {
        this.unimpl("getString/getNString");
        return null;
    }

    @Override
    String getNString(int currentRow) throws SQLException {
        this.unimpl("getNString");
        return null;
    }

    @Override
    long updateChecksum(long _checkSum, int currentRow) throws SQLException {
        this.unimpl("updateChecksum");
        return -1L;
    }

    private static final class PrefetchByteData
    implements OracleLargeObject.PrefetchData<byte[]> {
        private final ByteArray byteArray;
        private final long offset;
        private final int length;

        private PrefetchByteData(ByteArray byteArray, long offset, int length) {
            this.byteArray = byteArray;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int copy(int srcOffset, byte[] dst, int dstOffset, int length) {
            int copyLength = Math.min(length, this.length - srcOffset);
            if (copyLength < 1) {
                return 0;
            }
            this.byteArray.get(this.offset + (long)srcOffset, dst, dstOffset, copyLength);
            return copyLength;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public byte[] share() {
            byte[] dst = new byte[this.length()];
            this.copy(0, dst, 0, dst.length);
            return dst;
        }
    }
}

