/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class BinaryFloatAccessor
extends Accessor {
    static final int MAXLENGTH = 4;
    private final byte[] tmpBytes;

    BinaryFloatAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.BINARY_FLOAT, stmt, 4, isStoredInBindData);
        this.tmpBytes = new byte[this.representationMaxLength];
        this.init(stmt, 100, 100, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    BinaryFloatAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.BINARY_FLOAT, stmt, 4, false);
        this.tmpBytes = new byte[this.representationMaxLength];
        this.init(stmt, 100, 100, form, false);
        this.initForDescribe(100, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    static int floatToIntBits(float value) {
        int bits = Float.floatToRawIntBits(value);
        bits = (bits & Integer.MIN_VALUE) == 0 ? (bits |= Integer.MIN_VALUE) : (bits ^= 0xFFFFFFFF);
        return bits;
    }

    static float intBitsToFloat(int bits) {
        bits = (bits & Integer.MIN_VALUE) != 0 ? (bits &= Integer.MAX_VALUE) : (bits ^= 0xFFFFFFFF);
        return Float.intBitsToFloat(bits);
    }

    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, short form, int external_type) throws SQLException {
        this.init(stmt, internal_type, database_type, form, false);
        this.initForDataAccess(external_type, max_len, null);
    }

    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        this.init(stmt, internal_type, database_type, form, false);
        this.initForDescribe(internal_type, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return 0.0f;
        }
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, this.representationMaxLength);
        return BinaryFloatAccessor.decodeFloat(this.tmpBytes);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return BinaryFloatAccessor.floatToString(this.getFloat(currentRow));
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new Float(this.getFloat(currentRow));
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new Float(this.getFloat(currentRow));
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getBINARY_FLOAT(currentRow);
    }

    @Override
    BINARY_FLOAT getBINARY_FLOAT(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new BINARY_FLOAT(this.rowData.get(this.getOffset(currentRow), this.getLength(currentRow)));
    }

    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new NUMBER(this.getFloat(currentRow));
    }

    @Override
    BigInteger getBigInteger(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return this.getBigDecimal(currentRow).toBigInteger();
    }

    @Override
    BigDecimal getBigDecimal(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return BinaryFloatAccessor.floatToBigDecimal(this.getFloat(currentRow));
    }

    @Override
    byte getByte(int currentRow) throws SQLException {
        return BinaryFloatAccessor.floatToByte(this.getFloat(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    short getShort(int currentRow) throws SQLException {
        return BinaryFloatAccessor.floatToShort(this.getFloat(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        return BinaryFloatAccessor.floatToInt(this.getFloat(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    long getLong(int currentRow) throws SQLException {
        return BinaryFloatAccessor.floatToLong(this.getFloat(currentRow));
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        return BinaryFloatAccessor.floatToDouble(this.getFloat(currentRow));
    }

    @Override
    boolean getBoolean(int currentRow) throws SQLException {
        return BinaryFloatAccessor.floatToBoolean(this.getFloat(currentRow));
    }

    static float decodeFloat(byte[] encodedFloat) {
        int b0 = encodedFloat[0];
        int b1 = encodedFloat[1];
        int b2 = encodedFloat[2];
        int b3 = encodedFloat[3];
        if ((b0 & 0x80) != 0) {
            b0 &= 0x7F;
            b1 &= 0xFF;
            b2 &= 0xFF;
            b3 &= 0xFF;
        } else {
            b0 = ~b0 & 0xFF;
            b1 = ~b1 & 0xFF;
            b2 = ~b2 & 0xFF;
            b3 = ~b3 & 0xFF;
        }
        int intBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        return Float.intBitsToFloat(intBits);
    }

    static byte floatToByte(float floatValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        if (floatValue >= -128.0f && floatValue <= 127.0f) {
            return (byte)floatValue;
        }
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 26).fillInStackTrace();
    }

    static short floatToShort(float floatValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        if (floatValue >= -32768.0f && floatValue <= 32767.0f) {
            return (short)floatValue;
        }
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 26).fillInStackTrace();
    }

    static int floatToInt(float floatValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        if (floatValue >= -2.1474836E9f && floatValue <= 2.1474836E9f) {
            return (int)floatValue;
        }
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 26).fillInStackTrace();
    }

    static double floatToDouble(float floatValue) {
        return floatValue;
    }

    static long floatToLong(float floatValue) {
        return (long)floatValue;
    }

    static String floatToString(float floatValue) {
        return Float.toString(floatValue);
    }

    static BigDecimal floatToBigDecimal(float floatValue) {
        return new BigDecimal(BinaryFloatAccessor.floatToString(floatValue));
    }

    static boolean floatToBoolean(float floatValue) {
        return floatValue != 0.0f;
    }
}

