/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.VarnumBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class BigDecimalBinder
extends VarnumBinder {
    BigDecimal paramVal;

    BigDecimalBinder(BigDecimal x) {
        this.paramVal = x;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] b = null;
        int offset = 0;
        BigDecimal val = this.paramVal;
        long dbaPos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = dbaPos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = dbaPos;
            b = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b = bindBytes;
            offset = byteoffset + 1;
        }
        int rlen = this.getDatumBytes(stmt, val, b, offset);
        if (bindUseDBA) {
            bindData.put(b, 0, rlen);
            bindIndicators[indoffset] = 0;
            bindDataLengths[bindDataIndex] = rlen;
            stmt.lastBoundDataLengths[bindPosition] = rlen;
        } else {
            b[byteoffset] = (byte)rlen;
            bindIndicators[indoffset] = 0;
        }
        bindIndicators[lenoffset] = (short)(rlen + 1);
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = CRC64.updateChecksum(localCheckSum, val.toString());
        }
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, BigDecimal val, byte[] b, int offset) throws SQLException {
        char c;
        int signed;
        int rlen = 0;
        String sval = val.toString();
        int eIndex = sval.indexOf("E");
        if (eIndex != -1) {
            StringBuffer s2 = new StringBuffer(sval.length() + 5);
            int digits = 0;
            BigDecimal val2 = null;
            boolean isValueNegative = sval.charAt(0) == '-';
            String eValue = sval.substring(eIndex + 1);
            String intVal = sval.substring(isValueNegative ? 1 : 0, eIndex);
            val2 = new BigDecimal(intVal);
            boolean isExponentNegative = eValue.charAt(0) == '-';
            eValue = eValue.substring(1);
            digits = Integer.parseInt(eValue);
            Object sval2 = val2.toString();
            int dotIndex = ((String)sval2).indexOf(".");
            int sval2Length = ((String)sval2).length();
            int suggestedDotIndex = sval2Length--;
            if (dotIndex != -1) {
                sval2 = ((String)sval2).substring(0, dotIndex) + ((String)sval2).substring(dotIndex + 1);
                if (isExponentNegative) {
                    digits -= dotIndex;
                } else {
                    suggestedDotIndex = ++digits;
                }
            } else if (isExponentNegative) {
                digits -= sval2Length;
            } else {
                suggestedDotIndex = ++digits;
            }
            if (isValueNegative) {
                s2.append("-");
            }
            if (isExponentNegative) {
                s2.append("0.");
                for (int index = 0; index < digits; ++index) {
                    s2.append("0");
                }
                s2.append((String)sval2);
            } else {
                int maxLen = digits > sval2Length ? digits : sval2Length;
                for (int index = 0; index < maxLen; ++index) {
                    if (suggestedDotIndex == index) {
                        s2.append(".");
                    }
                    s2.append(sval2Length > index ? ((String)sval2).charAt(index) : (char)'0');
                }
            }
            sval = s2.toString();
        }
        int len = sval.length();
        int ppos = sval.indexOf(46);
        int nzpos = signed = sval.charAt(0) == '-' ? 1 : 0;
        int nlen = 2;
        int lim1 = len;
        if (ppos == -1) {
            ppos = len;
        } else if ((len - ppos & 1) != 0) {
            lim1 = len + 1;
        }
        while (nzpos < len && ((c = sval.charAt(nzpos)) < '1' || c > '9')) {
            ++nzpos;
        }
        if (nzpos >= len) {
            b[offset] = -128;
            rlen = 1;
        } else {
            int dig;
            int pos;
            int diglen = nzpos < ppos ? 2 - (ppos - nzpos & 1) : 1 + (nzpos - ppos & 1);
            int exp = (ppos - nzpos - 1) / 2;
            if (exp > 62) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + String.valueOf(val)).fillInStackTrace();
            }
            if (exp < -65) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + String.valueOf(val)).fillInStackTrace();
            }
            int lim2 = nzpos + diglen + 38;
            if (lim2 > len) {
                lim2 = len;
            }
            for (pos = nzpos + diglen; pos < lim2; pos += 2) {
                if (pos == ppos) {
                    --pos;
                    if (lim2 >= len) continue;
                    ++lim2;
                    continue;
                }
                if (sval.charAt(pos) == '0' && (pos + 1 >= len || sval.charAt(pos + 1) == '0')) continue;
                nlen = (pos - nzpos - diglen) / 2 + 3;
            }
            int i = offset + 2;
            pos = nzpos + diglen;
            if (signed == 0) {
                b[offset] = (byte)(192 + exp + 1);
                dig = sval.charAt(nzpos) - 48;
                if (diglen == 2) {
                    dig = dig * 10 + (nzpos + 1 < len ? sval.charAt(nzpos + 1) - 48 : 0);
                }
                b[offset + 1] = (byte)(dig + 1);
                while (i < offset + nlen) {
                    if (pos == ppos) {
                        ++pos;
                    }
                    dig = (sval.charAt(pos) - 48) * 10;
                    if (pos + 1 < len) {
                        dig += sval.charAt(pos + 1) - 48;
                    }
                    b[i++] = (byte)(dig + 1);
                    pos += 2;
                }
            } else {
                b[offset] = (byte)(62 - exp);
                dig = sval.charAt(nzpos) - 48;
                if (diglen == 2) {
                    dig = dig * 10 + (nzpos + 1 < len ? sval.charAt(nzpos + 1) - 48 : 0);
                }
                b[offset + 1] = (byte)(101 - dig);
                while (i < offset + nlen) {
                    if (pos == ppos) {
                        ++pos;
                    }
                    dig = (sval.charAt(pos) - 48) * 10;
                    if (pos + 1 < len) {
                        dig += sval.charAt(pos + 1) - 48;
                    }
                    b[i++] = (byte)(101 - dig);
                    pos += 2;
                }
                if (nlen < 21) {
                    b[offset + nlen++] = 102;
                }
            }
            rlen = nlen;
        }
        return rlen;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

