/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

class ArrayLocatorResultSet
extends ForwardOnlyResultSet {
    static int COUNT_UNLIMITED = -1;
    Map<String, Class<?>> map;
    long beginIndex;
    int count;
    long currentIndex;

    static ArrayLocatorResultSet create(PhysicalConnection conn, ArrayDescriptor descriptor2, byte[] locator, Map<String, Class<?>> map2) throws SQLException {
        return ArrayLocatorResultSet.create(conn, descriptor2, locator, 0L, COUNT_UNLIMITED, map2);
    }

    static ArrayLocatorResultSet create(PhysicalConnection connection, ArrayDescriptor descriptor2, byte[] locator, long beginIndex, int count2, Map<String, Class<?>> map2) throws SQLException {
        ARRAY tmpObj = new ARRAY(descriptor2, connection, (Object)null);
        tmpObj.setLocator(locator);
        String elementsQuery = descriptor2.getBaseType() == 2002 || descriptor2.getBaseType() == 2008 ? "SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS " + descriptor2.getName() + ") )" : "SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS " + descriptor2.getName() + ") )";
        OraclePreparedStatement preparedStatement = connection.prepareStatementInternal(elementsQuery, OracleResultSet.ResultSetType.FORWARD_READ_ONLY);
        preparedStatement.setArray(1, tmpObj);
        preparedStatement.executeQuery();
        return new ArrayLocatorResultSet(connection, preparedStatement, beginIndex, count2, map2);
    }

    private ArrayLocatorResultSet(OracleConnection conn, OracleStatement stmt, long beginIndex, int count2, Map<String, Class<?>> map2) throws SQLException {
        super((PhysicalConnection)conn, stmt);
        if (conn == null || stmt == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid arguments").fillInStackTrace();
        }
        stmt.closeOnCompletion();
        this.count = count2;
        this.currentIndex = 0L;
        this.beginIndex = beginIndex;
        this.map = map2;
    }

    @Override
    public boolean next() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.currentIndex < this.beginIndex) {
                while (this.currentIndex < this.beginIndex) {
                    ++this.currentIndex;
                    if (super.next()) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if (this.count == COUNT_UNLIMITED) {
                boolean bl = super.next();
                return bl;
            }
            if (this.currentIndex < this.beginIndex + (long)this.count - 1L) {
                ++this.currentIndex;
                boolean bl = super.next();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Object object = this.getObject(columnIndex, this.map);
            return object;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (columnName.equalsIgnoreCase("index")) {
                int n = 1;
                return n;
            }
            if (columnName.equalsIgnoreCase("value")) {
                int n = 2;
                return n;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index").fillInStackTrace();
        }
    }
}

