/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.AbstractTrueCacheConnection;
import oracle.jdbc.driver.AbstractTrueCacheStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.TrueCacheDriverExtension;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

@ProxyFor(value={OracleResultSet.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractTrueCacheResultSet {
    boolean closed;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract ResultSet getDelegate();

    @SetDelegate
    protected abstract void setDelegate(ResultSet var1);

    public Statement getStatement() throws SQLException {
        AbstractTrueCacheStatement applicationStatement = (AbstractTrueCacheStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            this.ensureOpen("getStatement");
            Statement statement = (Statement)((Object)applicationStatement);
            return statement;
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={})})
    protected void preUnsupportedResultSetMethods(Method m, Object receiver, Object ... args2) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public ResultSet getCursor(int columnIndex) throws SQLException {
        ResultSet result2 = null;
        AbstractTrueCacheStatement applicationStatement = (AbstractTrueCacheStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet resultSet = (OracleResultSet)this.getDelegate();
            result2 = resultSet.getCursor(columnIndex);
            if (result2 != null) {
                result2 = this.createResultSetProxy(result2);
            }
        }
        return result2;
    }

    public ResultSet getCursor(String columnName) throws SQLException {
        ResultSet result2 = null;
        AbstractTrueCacheStatement applicationStatement = (AbstractTrueCacheStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet resultSet = (OracleResultSet)this.getDelegate();
            result2 = resultSet.getCursor(columnName);
            if (result2 != null) {
                result2 = this.createResultSetProxy(result2);
            }
        }
        return result2;
    }

    public void close() throws SQLException {
        AbstractTrueCacheStatement applicationStatement = (AbstractTrueCacheStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                return;
            }
            OracleResultSet resultSet = (OracleResultSet)this.getDelegate();
            OracleConnection connection = (OracleConnection)resultSet.getStatement().getConnection();
            resultSet.close();
            applicationStatement.currentResultSet = null;
            this.closed = true;
            applicationStatement.closeByDependent(connection);
        }
    }

    boolean isComplete() throws SQLException {
        return this.closed;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    void ensureOpen(String where) throws SQLException {
        AbstractTrueCacheStatement applicationStatement = (AbstractTrueCacheStatement)this.getCreator();
        if (this.closed) {
            if (applicationStatement.getConnection().isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, where).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, where).fillInStackTrace();
        }
        if (applicationStatement.closed) {
            throw (SQLException)DatabaseError.createSqlException(9, where).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        AbstractTrueCacheStatement applicationStatement = (AbstractTrueCacheStatement)this.getCreator();
        return applicationStatement.getConnectionDuringExceptionHandling();
    }

    protected ResultSet createResultSetProxy(ResultSet rs) throws SQLException {
        AbstractTrueCacheStatement applicationStatement = (AbstractTrueCacheStatement)this.getCreator();
        return TrueCacheDriverExtension.PROXY_FACTORY.proxyForCreate(rs, applicationStatement);
    }
}

