/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingLob;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ShardingDriverExtension;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.REF;
import oracle.sql.STRUCT;

@ProxyFor(value={OracleResultSet.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingResultSet {
    boolean closed;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract ResultSet getDelegate();

    @SetDelegate
    protected abstract void setDelegate(ResultSet var1);

    public Blob getBlob(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Blob obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBlob(columnIndex);
            Blob blob = obj = (Blob)this.createLobProxy(obj);
            return blob;
        }
    }

    public Blob getBlob(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Blob obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBlob(columnName);
            Blob blob = obj = (Blob)this.createLobProxy(obj);
            return blob;
        }
    }

    public Clob getClob(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Clob obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getClob(columnIndex);
            Clob clob = obj = (Clob)this.createLobProxy(obj);
            return clob;
        }
    }

    public Clob getClob(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Clob obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getClob(columnName);
            Clob clob = obj = (Clob)this.createLobProxy(obj);
            return clob;
        }
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        NClob obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getNClob(columnIndex);
            NClob nClob = obj = (NClob)this.createLobProxy(obj);
            return nClob;
        }
    }

    public NClob getNClob(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        NClob obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getNClob(columnName);
            NClob nClob = obj = (NClob)this.createLobProxy(obj);
            return nClob;
        }
    }

    public Ref getRef(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Ref obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getRef(columnIndex);
            Ref ref = obj = (Ref)this.createLobProxy(obj);
            return ref;
        }
    }

    public Ref getRef(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Ref obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getRef(columnName);
            Ref ref = obj = (Ref)this.createLobProxy(obj);
            return ref;
        }
    }

    public Array getArray(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Array obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getArray(columnIndex);
            Array array = obj = (Array)this.createLobProxy(obj);
            return array;
        }
    }

    public Array getArray(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        Array obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getArray(columnName);
            Array array = obj = (Array)this.createLobProxy(obj);
            return array;
        }
    }

    public BLOB getBLOB(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        BLOB obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBLOB(columnIndex);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            BLOB bLOB = obj;
            return bLOB;
        }
    }

    public BLOB getBLOB(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        BLOB obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBLOB(columnName);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            BLOB bLOB = obj;
            return bLOB;
        }
    }

    public CLOB getCLOB(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        CLOB obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getCLOB(columnIndex);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            CLOB cLOB = obj;
            return cLOB;
        }
    }

    public CLOB getCLOB(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        CLOB obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getCLOB(columnName);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            CLOB cLOB = obj;
            return cLOB;
        }
    }

    public BFILE getBFILE(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        BFILE obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBFILE(columnIndex);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            BFILE bFILE = obj;
            return bFILE;
        }
    }

    public BFILE getBFILE(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        BFILE obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBFILE(columnName);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            BFILE bFILE = obj;
            return bFILE;
        }
    }

    public BFILE getBfile(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        BFILE obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBfile(columnIndex);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            BFILE bFILE = obj;
            return bFILE;
        }
    }

    public BFILE getBfile(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        BFILE obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getBfile(columnName);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            BFILE bFILE = obj;
            return bFILE;
        }
    }

    public REF getREF(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        REF obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getREF(columnIndex);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            REF rEF = obj;
            return rEF;
        }
    }

    public REF getREF(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        REF obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getREF(columnName);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            REF rEF = obj;
            return rEF;
        }
    }

    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        STRUCT obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getSTRUCT(columnIndex);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            STRUCT sTRUCT = obj;
            return sTRUCT;
        }
    }

    public STRUCT getSTRUCT(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        STRUCT obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getSTRUCT(columnName);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            STRUCT sTRUCT = obj;
            return sTRUCT;
        }
    }

    public ARRAY getARRAY(int columnIndex) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        ARRAY obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getARRAY(columnIndex);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            ARRAY aRRAY = obj;
            return aRRAY;
        }
    }

    public ARRAY getARRAY(String columnName) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        ARRAY obj = null;
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            obj = databaseResultSet.getARRAY(columnName);
            obj.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
            ARRAY aRRAY = obj;
            return aRRAY;
        }
    }

    public Statement getStatement() throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            this.ensureOpen("getStatement");
            Statement statement = (Statement)((Object)applicationStatement);
            return statement;
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={})})
    protected void preUnsupportedResultSetMethods(Method m, Object receiver, Object ... args2) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public ResultSet getCursor(int columnIndex) throws SQLException {
        ResultSet result2 = null;
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            result2 = databaseResultSet.getCursor(columnIndex);
            if (result2 != null) {
                result2 = this.createResultSetProxy(result2);
            }
        }
        return result2;
    }

    public ResultSet getCursor(String columnName) throws SQLException {
        ResultSet result2 = null;
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            result2 = databaseResultSet.getCursor(columnName);
            if (result2 != null) {
                result2 = this.createResultSetProxy(result2);
            }
        }
        return result2;
    }

    public void close() throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        try (Monitor.CloseableLock lock = ((AbstractShardingConnection)applicationStatement.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                return;
            }
            OracleResultSet databaseResultSet = (OracleResultSet)this.getDelegate();
            OracleConnection databaseConnection = (OracleConnection)databaseResultSet.getStatement().getConnection();
            databaseResultSet.close();
            applicationStatement.currentResultSet = null;
            this.closed = true;
            applicationStatement.closeByDependent(databaseConnection);
        }
    }

    boolean isComplete() throws SQLException {
        return this.closed;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    void ensureOpen(String where) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        if (this.closed) {
            if (applicationStatement.getConnection().isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, where).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, where).fillInStackTrace();
        }
        if (applicationStatement.closed) {
            throw (SQLException)DatabaseError.createSqlException(9, where).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        return applicationStatement.getConnectionDuringExceptionHandling();
    }

    protected ResultSet createResultSetProxy(ResultSet rs) throws SQLException {
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)this.getCreator();
        return ShardingDriverExtension.PROXY_FACTORY.proxyForCreate(rs, applicationStatement);
    }

    protected Object createLobProxy(Object obj) throws SQLException {
        return ShardingDriverExtension.PROXY_FACTORY.proxyForCreate(obj, this);
    }
}

