/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingResultSet;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleNClob;
import oracle.jdbc.internal.OracleRef;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.sql.DatumWithConnection;

@ProxyFor(value={OracleBlob.class, OracleClob.class, OracleNClob.class, OracleBfile.class, OracleStruct.class, OracleRef.class, OracleArray.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingLob {
    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    public void closeLob() throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        Object delegate2 = this.getDelegate();
        if (delegate2 instanceof OracleBlob) {
            ((OracleBlob)delegate2).closeLob();
            databaseConnection = ((OracleBlob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleClob) {
            ((OracleClob)delegate2).closeLob();
            databaseConnection = ((OracleClob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleNClob) {
            ((OracleNClob)delegate2).closeLob();
            databaseConnection = ((OracleNClob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleBfile) {
            ((OracleBfile)delegate2).closeLob();
            databaseConnection = ((OracleBfile)delegate2).getInternalConnection();
        }
        if (this.isCreatedByConnectionObject()) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    public void free() throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        Object delegate2 = this.getDelegate();
        if (delegate2 instanceof OracleBlob) {
            ((OracleBlob)delegate2).free();
            databaseConnection = ((OracleBlob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleClob) {
            ((OracleClob)delegate2).free();
            databaseConnection = ((OracleClob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleNClob) {
            ((OracleNClob)delegate2).free();
            databaseConnection = ((OracleNClob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleArray) {
            ((OracleArray)delegate2).free();
            databaseConnection = ((OracleArray)delegate2).getInternalConnection();
        }
        if (this.isCreatedByConnectionObject()) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    public void freeTemporary() throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        Object delegate2 = this.getDelegate();
        if (delegate2 instanceof OracleBlob) {
            ((OracleBlob)delegate2).freeTemporary();
            databaseConnection = ((OracleBlob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleClob) {
            ((OracleClob)delegate2).freeTemporary();
            databaseConnection = ((OracleClob)delegate2).getInternalConnection();
        } else if (delegate2 instanceof OracleNClob) {
            ((OracleNClob)delegate2).freeTemporary();
            databaseConnection = ((OracleNClob)delegate2).getInternalConnection();
        }
        if (this.isCreatedByConnectionObject()) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() {
        Object creator = this.getCreator();
        if (creator instanceof AbstractShardingConnection) {
            return (oracle.jdbc.internal.OracleConnection)creator;
        }
        AbstractShardingResultSet applicationResultSet = (AbstractShardingResultSet)this.getCreator();
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)applicationResultSet.getCreator();
        return (oracle.jdbc.internal.OracleConnection)applicationStatement.getCreator();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getInternalConnection();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.getOracleConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public void setPhysicalConnectionOf(Connection conn) {
        DatumWithConnection delegate2 = (DatumWithConnection)this.getDelegate();
        delegate2.setPhysicalConnectionOf(conn);
    }

    @Pre
    @Methods(signatures={@Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={})})
    protected void preUnsupportedResultSetMethods(Method m, Object receiver, Object ... args2) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    boolean isCreatedByConnectionObject() {
        Object creator = this.getCreator();
        return creator instanceof AbstractShardingConnection;
    }
}

