/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.Serializable;
import java.util.Iterator;
import oracle.jdbc.TraceKey;
import oracle.jdbc.diagnostics.ImmutableTraceAttributes;

public abstract class TraceAttributes
implements Iterable<Entry>,
Serializable {
    protected final String[] values = new String[TraceKey.maxIndex()];

    protected TraceAttributes() {
    }

    protected TraceAttributes(String[] values2) {
        this();
        if (values2 != null) {
            assert (values2.length == this.values.length);
            System.arraycopy(values2, 0, this.values, 0, values2.length);
        }
    }

    public abstract ImmutableTraceAttributes toReadOnly();

    public String get(Object key) {
        return this.values[((TraceKey)key).index()];
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iterator<Entry>(){
            private Iterator<TraceKey> i = TraceKey.iterator();

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Entry next() {
                TraceKey k = this.i.next();
                return new Entry(k, TraceAttributes.this.values[k.index()]);
            }
        };
    }

    public static final class Entry {
        public final TraceKey key;
        public final String value;

        private Entry(TraceKey key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

