/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.babelfish.TranslatedErrorInfo;
import oracle.jdbc.babelfish.TranslationCache;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class Translator {
    private final File localErrorTranslationFile;
    private final String translationProfile;
    private Connection conn;
    private CallableStatement queryTranslationStatement;
    private CallableStatement errorTranslationStatement;
    private final Map<String, String> queryCache;
    private final Map<Integer, TranslatedErrorInfo> errorCache;
    private final Map<Integer, TranslatedErrorInfo> localErrorCache;

    Translator(String translationProfile, File localErrorTranslationFile, TranslationCache translationCache) throws SQLException {
        this.translationProfile = translationProfile;
        this.localErrorTranslationFile = localErrorTranslationFile;
        this.queryCache = translationCache.getQueryCache();
        this.errorCache = translationCache.getErrorCache();
        this.localErrorCache = translationCache.getLocalErrorCache();
    }

    public SQLException translateError(SQLException ex) throws SQLException {
        if (this.conn == null) {
            return this.translateErrorLocal(ex);
        }
        TranslatedErrorInfo translatedErrorInfo = this.errorCache.get(ex.getErrorCode());
        if (translatedErrorInfo != null) {
            SQLException newex = new SQLException("[Translated Error Codes] " + ex.getMessage(), translatedErrorInfo.getSqlState(), translatedErrorInfo.getErrorCode(), ex);
            newex.setStackTrace(ex.getStackTrace());
            return newex;
        }
        try {
            String tmpSqlState;
            this.errorTranslationStatement.clearParameters();
            this.errorTranslationStatement.setInt(1, ex.getErrorCode());
            this.errorTranslationStatement.registerOutParameter(2, 4);
            this.errorTranslationStatement.registerOutParameter(3, 12);
            this.errorTranslationStatement.execute();
            int tmpErrorCode = this.errorTranslationStatement.getInt(2);
            if (this.errorTranslationStatement.wasNull()) {
                tmpErrorCode = ex.getErrorCode();
            }
            if ((tmpSqlState = this.errorTranslationStatement.getString(3)) == null) {
                tmpSqlState = ex.getSQLState();
            }
            translatedErrorInfo = new TranslatedErrorInfo(tmpErrorCode, tmpSqlState);
        }
        catch (SQLException e) {
            throw (SQLException)DatabaseError.createSqlException(null, 280, null, (Throwable)e).fillInStackTrace();
        }
        this.errorCache.put(ex.getErrorCode(), translatedErrorInfo);
        SQLException newex = new SQLException("[Translated Error Codes] " + ex.getMessage(), translatedErrorInfo.getSqlState(), translatedErrorInfo.getErrorCode(), ex);
        newex.setStackTrace(ex.getStackTrace());
        return newex;
    }

    SQLException translateErrorLocal(SQLException ex) throws SQLException {
        if (this.localErrorCache == null) {
            return ex;
        }
        TranslatedErrorInfo translatedErrorInfo = this.localErrorCache.get(ex.getErrorCode());
        if (translatedErrorInfo != null) {
            String message = "[Translated Error Codes] " + ex.getMessage();
            SQLException exep = new SQLException(message, translatedErrorInfo.getSqlState(), translatedErrorInfo.getErrorCode(), ex);
            exep.setStackTrace(ex.getStackTrace());
            return exep;
        }
        SQLException newex = new SQLException("[Error Translation Not Available] " + ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), ex);
        newex.setStackTrace(ex.getStackTrace());
        return newex;
    }

    String translateQuery(String sql2) throws SQLException {
        if (this.conn != null) {
            String translatedSql = this.queryCache.get(sql2);
            if (translatedSql != null) {
                return translatedSql;
            }
            String jdbcMarkerConvertedSql = this.convertParameterMarkersToOracleStyle(sql2);
            try {
                this.queryTranslationStatement.clearParameters();
                this.queryTranslationStatement.setString(1, jdbcMarkerConvertedSql);
                this.queryTranslationStatement.registerOutParameter(2, 12);
                this.queryTranslationStatement.execute();
                translatedSql = this.queryTranslationStatement.getString(2);
            }
            catch (SQLException ex) {
                throw (SQLException)DatabaseError.createSqlException(null, 280, null, (Throwable)ex).fillInStackTrace();
            }
            if (translatedSql == null) {
                translatedSql = jdbcMarkerConvertedSql;
            }
            this.queryCache.put(sql2, translatedSql);
            return translatedSql;
        }
        throw (SQLException)DatabaseError.createSqlException(279).fillInStackTrace();
    }

    public void activateServerTranslation(Connection babelfishConnection) throws SQLException {
        CallableStatement sessionstmt = babelfishConnection.prepareCall("begin execute immediate 'alter session set sql_translation_profile = ' || sys.dbms_assert.qualified_sql_name(?); end;");
        sessionstmt.setString(1, this.translationProfile);
        sessionstmt.execute();
        this.queryTranslationStatement = babelfishConnection.prepareCall("begin sys.dbms_sql_translator.translate_sql(?, ? ); end;");
        this.errorTranslationStatement = babelfishConnection.prepareCall("begin sys.dbms_sql_translator.translate_error(?, ?, ? ); end;");
        this.conn = babelfishConnection;
    }

    void deactivateServerTranslation() throws SQLException {
        this.queryTranslationStatement.close();
        this.errorTranslationStatement.close();
        this.conn = null;
    }

    String convertParameterMarkersToOracleStyle(String sql2) {
        StringBuilder retStr = new StringBuilder();
        boolean inQuotesFlag = false;
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        int parameterCount = 1;
        block8: for (int i = 0; i < sql2.length(); ++i) {
            char c = sql2.charAt(i);
            if (inSingleLineComment) {
                retStr.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    retStr.append(c);
                    if (i >= sql2.length() - 1) continue block8;
                    retStr.append(sql2.charAt(++i));
                    continue block8;
                }
                case '?': {
                    if (!inQuotesFlag && !inMultiLineComment) {
                        retStr.append(":").append(parameterCount++);
                        continue block8;
                    }
                    retStr.append(c);
                    continue block8;
                }
                case '\'': {
                    if (!inMultiLineComment) {
                        inQuotesFlag = !inQuotesFlag;
                    }
                    retStr.append(c);
                    continue block8;
                }
                case '-': {
                    retStr.append(c);
                    if (i >= sql2.length() - 1 || sql2.charAt(i + 1) != '-') continue block8;
                    retStr.append(sql2.charAt(++i));
                    inSingleLineComment = true;
                    continue block8;
                }
                case '/': {
                    retStr.append(c);
                    if (inQuotesFlag || i >= sql2.length() - 1 || sql2.charAt(i + 1) != '*') continue block8;
                    retStr.append(sql2.charAt(++i));
                    inMultiLineComment = true;
                    continue block8;
                }
                case '*': {
                    retStr.append(c);
                    if (inQuotesFlag || !inMultiLineComment || i >= sql2.length() - 1 || sql2.charAt(i + 1) != '/') continue block8;
                    retStr.append(sql2.charAt(++i));
                    inMultiLineComment = false;
                    continue block8;
                }
                default: {
                    retStr.append(c);
                }
            }
        }
        return retStr.toString();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

