/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.babelfish.BabelfishGenericProxy;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.GetProxy;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.ProxyFor;

@ProxyFor(value={OracleStatement.class, Statement.class})
public abstract class BabelfishStatement
extends BabelfishGenericProxy {
    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @GetProxy
    protected abstract Object proxify(Object var1, Object var2);

    @Override
    @OnError(value=SQLException.class)
    protected Object translateError(Method m, SQLException ex) throws SQLException {
        throw this.translator.translateError(ex);
    }

    @Override
    @Post
    protected Object post_Methods(Method m, Object result2) {
        if (result2 instanceof BabelfishGenericProxy) {
            ((BabelfishGenericProxy)result2).setTranslator(this.translator);
        }
        return result2;
    }

    public void addBatch(String sql2) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            ((Statement)this.getDelegate()).addBatch(translatedSql);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql2) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).execute(translatedSql);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql2, int autoGeneratedKeys) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).execute(translatedSql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql2, int[] columnIndexes) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).execute(translatedSql, columnIndexes);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql2, String[] columnNames) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).execute(translatedSql, columnNames);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public ResultSet executeQuery(String sql2) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            ResultSet rs = (ResultSet)this.proxify(((Statement)this.getDelegate()).executeQuery(translatedSql), this);
            ((BabelfishGenericProxy)((Object)rs)).setTranslator(this.translator);
            return rs;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql2) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql2, int autoGeneratedKeys) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql2, int[] columnIndexes) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql, columnIndexes);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql2, String[] columnNames) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql2);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql, columnNames);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }
}

