/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.sql.SQLException;
import java.util.regex.Pattern;
import oracle.jdbc.OracleCommonStatement;
import oracle.jdbc.dcn.DatabaseChangeRegistration;

public interface OracleStatement
extends OracleCommonStatement {
    public static final int NEW = 0;
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;

    public void clearDefines() throws SQLException;

    public void defineColumnType(int var1, int var2) throws SQLException;

    public void defineColumnType(int var1, int var2, int var3) throws SQLException;

    public void defineColumnType(int var1, int var2, int var3, short var4) throws SQLException;

    public void defineColumnTypeBytes(int var1, int var2, int var3) throws SQLException;

    public void defineColumnTypeChars(int var1, int var2, int var3) throws SQLException;

    public void defineColumnType(int var1, int var2, String var3) throws SQLException;

    public int getRowPrefetch();

    public void setRowPrefetch(int var1) throws SQLException;

    public int getLobPrefetchSize() throws SQLException;

    public void setLobPrefetchSize(int var1) throws SQLException;

    public void closeWithKey(String var1) throws SQLException;

    public int creationState();

    public boolean isNCHAR(int var1) throws SQLException;

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration var1) throws SQLException;

    public String[] getRegisteredTableNames() throws SQLException;

    public long getRegisteredQueryId() throws SQLException;

    public String getSqlId() throws SQLException;

    @Override
    public void closeOnCompletion() throws SQLException;

    @Override
    default public String enquoteLiteral(String val) throws SQLException {
        return "'" + val.replace("'", "''") + "'";
    }

    @Override
    default public String enquoteNCharLiteral(String val) throws SQLException {
        return "'" + val.replace("'", "''") + "'";
    }

    @Override
    default public boolean isSimpleIdentifier(String identifier) throws SQLException {
        boolean result2 = false;
        int len = identifier.length();
        if (len >= 1 && len <= 128 && Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]+").matcher(identifier).matches()) {
            result2 = true;
        }
        return result2;
    }

    @Override
    default public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        int len = identifier.length();
        if (len < 1 || len > 128) {
            throw new SQLException("Invalid name");
        }
        if (Pattern.compile("^[\\p{Alpha}][\\p{Alnum}_]+$").matcher(identifier).matches()) {
            return alwaysQuote ? "\"" + identifier + "\"" : identifier;
        }
        if (identifier.matches("^\".+\"$")) {
            identifier = identifier.substring(1, len - 1);
        }
        if (Pattern.compile("[^\u0000\"]+").matcher(identifier).matches()) {
            return "\"" + identifier + "\"";
        }
        throw new SQLException("Invalid name");
    }

    @Override
    public void setEscapeProcessing(boolean var1) throws SQLException;
}

