/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.refs;

import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;

public class GenericRef {
    private RefFormat format;
    private RefType type;
    private String ref;
    private String originalRef;
    private String simpleRef;
    private static boolean relativeRefWithAnyDot = true;

    public static void relativeRefWithAnyDot() {
        relativeRefWithAnyDot = true;
    }

    public static void internalRefWithAnyDot() {
        relativeRefWithAnyDot = false;
    }

    public static boolean isRelativeRefWithAnyDot() {
        return relativeRefWithAnyDot;
    }

    public GenericRef() {
    }

    public GenericRef(RefType type, String ref) {
        this(type, ref, null);
    }

    public GenericRef(RefType type, String ref, RefFormat format) {
        this.originalRef = ref;
        this.format = format == null ? GenericRef.computeRefFormat(ref) : format;
        this.type = type;
        this.ref = this.format == RefFormat.INTERNAL && !ref.startsWith("#/") ? type.getInternalPrefix() + ref : ref;
        this.simpleRef = GenericRef.computeSimpleRef(this.ref, this.format, type);
    }

    public RefFormat getFormat() {
        return this.format;
    }

    public RefType getType() {
        return this.type;
    }

    public String getRef() {
        return this.ref;
    }

    public String getSimpleRef() {
        return this.simpleRef;
    }

    public String getOriginalRef() {
        return this.originalRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericRef)) {
            return false;
        }
        GenericRef that = (GenericRef)o;
        if (this.format != that.format) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        if (this.originalRef != null ? !this.originalRef.equals(that.originalRef) : that.originalRef != null) {
            return false;
        }
        return this.simpleRef != null ? this.simpleRef.equals(that.simpleRef) : that.simpleRef == null;
    }

    public int hashCode() {
        int result2 = this.format != null ? this.format.hashCode() : 0;
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        result2 = 31 * result2 + (this.ref != null ? this.ref.hashCode() : 0);
        result2 = 31 * result2 + (this.originalRef != null ? this.originalRef.hashCode() : 0);
        result2 = 31 * result2 + (this.simpleRef != null ? this.simpleRef.hashCode() : 0);
        return result2;
    }

    private static String computeSimpleRef(String ref, RefFormat format, RefType type) {
        String result2 = ref;
        if (format == RefFormat.INTERNAL) {
            String prefix = type.getInternalPrefix();
            result2 = ref.substring(ref.lastIndexOf("/") + 1);
        }
        return result2;
    }

    private static RefFormat computeRefFormat(String ref) {
        RefFormat result2 = RefFormat.INTERNAL;
        if (ref.startsWith("http:") || ref.startsWith("https:")) {
            result2 = RefFormat.URL;
        } else if (ref.startsWith("#/")) {
            result2 = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/")) {
            result2 = RefFormat.RELATIVE;
        } else if (relativeRefWithAnyDot && !ref.contains(":") && !ref.startsWith("#") && !ref.startsWith("/") && ref.indexOf(".") > -1) {
            result2 = RefFormat.RELATIVE;
        }
        return result2;
    }
}

