/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.parameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.models.parameters.AbstractParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"name", "in", "description", "required", "type", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "multipleOf"})
public abstract class AbstractSerializableParameter<T extends AbstractSerializableParameter<T>>
extends AbstractParameter
implements SerializableParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerializableParameter.class);
    protected String type;
    protected String format;
    protected String collectionFormat;
    protected Property items;
    protected Boolean exclusiveMaximum;
    protected BigDecimal maximum;
    protected Boolean exclusiveMinimum;
    protected BigDecimal minimum;
    protected String example;
    private Integer maxItems;
    private Integer minItems;
    protected Boolean allowEmptyValue;
    @JsonIgnore
    protected List<String> _enum;
    public Integer maxLength;
    public Integer minLength;
    public String pattern;
    public Boolean uniqueItems;
    public Number multipleOf;
    @JsonIgnore
    protected String defaultValue;

    public T property(Property property) {
        this.setProperty(property);
        return this.castThis();
    }

    public T type(String type) {
        this.setType(type);
        return this.castThis();
    }

    public T format(String format) {
        this.setFormat(format);
        return this.castThis();
    }

    public T description(String description) {
        this.setDescription(description);
        return this.castThis();
    }

    public T name(String name) {
        this.setName(name);
        return this.castThis();
    }

    public T required(boolean required) {
        this.setRequired(required);
        return this.castThis();
    }

    public T collectionFormat(String collectionFormat) {
        this.setCollectionFormat(collectionFormat);
        return this.castThis();
    }

    public T example(String example) {
        this.setExample(example);
        return this.castThis();
    }

    public T allowEmptyValue(Boolean allowEmpty) {
        this.setAllowEmptyValue(allowEmpty);
        return this.castThis();
    }

    public T readOnly(Boolean readOnly) {
        this.setReadOnly(readOnly);
        return this.castThis();
    }

    @JsonIgnore
    protected String getDefaultCollectionFormat() {
        return "csv";
    }

    public T items(Property items) {
        this.items = items;
        return this.castThis();
    }

    public T _enum(List<String> value) {
        this._enum = value;
        return this.castThis();
    }

    @Override
    @JsonIgnore
    public List<String> getEnum() {
        return this._enum;
    }

    @Override
    public void setEnum(List<String> _enum) {
        this._enum = _enum;
    }

    @Override
    @JsonProperty(value="enum")
    public List<Object> getEnumValue() {
        if (this._enum == null) {
            return null;
        }
        if (this._enum.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> oList = new ArrayList<Object>(this._enum.size());
        if ("integer".equals(this.type) || "number".equals(this.type)) {
            for (String s2 : this._enum) {
                try {
                    if ("int32".equals(this.format)) {
                        oList.add(Integer.valueOf(s2));
                        continue;
                    }
                    if ("int64".equals(this.format)) {
                        oList.add(Long.valueOf(s2));
                        continue;
                    }
                    if ("double".equals(this.format)) {
                        oList.add(Double.valueOf(s2));
                        continue;
                    }
                    if ("float".equals(this.format)) {
                        oList.add(Float.valueOf(s2));
                        continue;
                    }
                    if ("integer".equals(this.type)) {
                        oList.add(Integer.valueOf(s2));
                        continue;
                    }
                    if (!"number".equals(this.type)) continue;
                    oList.add(Double.valueOf(s2));
                }
                catch (NumberFormatException e) {
                    LOGGER.warn(String.format("Illegal enum value %s for parameter type %s", s2, this.type), e);
                    oList.add(s2);
                }
            }
        } else if ((this.type == null || "array".equals(this.type)) && this.items != null) {
            for (String s3 : this._enum) {
                try {
                    if (this.items instanceof StringProperty) {
                        oList.add(s3);
                        continue;
                    }
                    if (this.items instanceof IntegerProperty) {
                        oList.add(Integer.valueOf(s3));
                        continue;
                    }
                    if (this.items instanceof LongProperty) {
                        oList.add(Long.valueOf(s3));
                        continue;
                    }
                    if (this.items instanceof FloatProperty) {
                        oList.add(Float.valueOf(s3));
                        continue;
                    }
                    if (this.items instanceof DoubleProperty) {
                        oList.add(Double.valueOf(s3));
                        continue;
                    }
                    if (this.items instanceof BaseIntegerProperty) {
                        oList.add(Integer.valueOf(s3));
                        continue;
                    }
                    if (this.items instanceof DecimalProperty) {
                        oList.add(Double.valueOf(s3));
                        continue;
                    }
                    oList.add(s3);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn(String.format("Illegal enum value %s for parameter type %s", s3, this.type), e);
                    oList.add(s3);
                }
            }
        } else {
            for (String s4 : this._enum) {
                oList.add(s4);
            }
        }
        return oList;
    }

    @Override
    public void setEnumValue(List<?> enumValue) {
        if (enumValue == null) {
            this._enum = null;
            return;
        }
        if (enumValue.isEmpty()) {
            this._enum = Collections.emptyList();
            return;
        }
        ArrayList<String> sList = new ArrayList<String>(enumValue.size());
        for (Object item : enumValue) {
            sList.add(item.toString());
        }
        this._enum = sList;
    }

    @Override
    public Property getItems() {
        return this.items;
    }

    @Override
    public void setItems(Property items) {
        this.items = items;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
        if (ArrayProperty.isType(type)) {
            if (this.getCollectionFormat() == null) {
                this.setCollectionFormat(this.getDefaultCollectionFormat());
            }
        } else {
            this.setCollectionFormat(null);
        }
    }

    @Override
    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    @Override
    public void setCollectionFormat(String collectionFormat) {
        this.collectionFormat = collectionFormat;
    }

    public void setProperty(Property property) {
        this.setType(property.getType());
        this.format = property.getFormat();
        if (property instanceof StringProperty) {
            StringProperty string = (StringProperty)property;
            this.setEnum(string.getEnum());
        } else if (property instanceof IntegerProperty) {
            this.setEnumValue(((IntegerProperty)property).getEnum());
        } else if (property instanceof LongProperty) {
            this.setEnumValue(((LongProperty)property).getEnum());
        } else if (property instanceof FloatProperty) {
            this.setEnumValue(((FloatProperty)property).getEnum());
        } else if (property instanceof DoubleProperty) {
            this.setEnumValue(((DoubleProperty)property).getEnum());
        } else if (property instanceof ArrayProperty) {
            ArrayProperty array = (ArrayProperty)property;
            this.setItems(array.getItems());
        }
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return new Integer(this.defaultValue);
            }
            if ("number".equals(this.type)) {
                return new BigDecimal(this.defaultValue);
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefault() {
        if (this.defaultValue == null || this.defaultValue.isEmpty()) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return Long.valueOf(this.defaultValue);
            }
            if ("number".equals(this.type)) {
                return Double.valueOf(this.defaultValue);
            }
            if ("boolean".equals(this.type) && ("true".equalsIgnoreCase(this.defaultValue) || "false".equalsIgnoreCase(this.defaultValue))) {
                return Boolean.valueOf(this.defaultValue);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("Illegal DefaultValue %s for parameter type %s", this.defaultValue, this.type), e);
        }
        return this.defaultValue;
    }

    public void setDefault(Object defaultValue) {
        this.defaultValue = defaultValue == null ? null : defaultValue.toString();
    }

    @Override
    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    @Override
    public BigDecimal getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    @Override
    public Boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @Override
    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    @Override
    public BigDecimal getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    @Override
    public Integer getMaxItems() {
        return this.maxItems;
    }

    @Override
    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    @Override
    public Integer getMinItems() {
        return this.minItems;
    }

    @Override
    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    @Override
    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    @Override
    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    @JsonProperty(value="x-example")
    public Object getExample() {
        if (this.example == null || this.example.isEmpty()) {
            return this.example;
        }
        try {
            if ("integer".equals(this.type)) {
                return Long.valueOf(this.example);
            }
            if ("number".equals(this.type)) {
                return Double.valueOf(this.example);
            }
            if ("boolean".equals(this.type) && ("true".equalsIgnoreCase(this.example) || "false".equalsIgnoreCase(this.defaultValue))) {
                return Boolean.valueOf(this.example);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("Illegal DefaultValue %s for parameter type %s", this.defaultValue, this.type), e);
        }
        return this.example;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public Integer getMinLength() {
        return this.minLength;
    }

    @Override
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Boolean isUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @Override
    public Number getMultipleOf() {
        return this.multipleOf;
    }

    @Override
    public void setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
    }

    @Override
    public Boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExample(String example) {
        this.example = example;
    }

    @JsonIgnore
    private T castThis() {
        AbstractSerializableParameter result2 = this;
        return (T)result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSerializableParameter other = (AbstractSerializableParameter)obj;
        if (this._enum == null ? other._enum != null : !this._enum.equals(other._enum)) {
            return false;
        }
        if (this.collectionFormat == null ? other.collectionFormat != null : !this.collectionFormat.equals(other.collectionFormat)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.example == null ? other.example != null : !this.example.equals(other.example)) {
            return false;
        }
        if (this.exclusiveMaximum == null ? other.exclusiveMaximum != null : !this.exclusiveMaximum.equals(other.exclusiveMaximum)) {
            return false;
        }
        if (this.exclusiveMinimum == null ? other.exclusiveMinimum != null : !this.exclusiveMinimum.equals(other.exclusiveMinimum)) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        if (this.maxItems == null ? other.maxItems != null : !this.maxItems.equals(other.maxItems)) {
            return false;
        }
        if (this.maxLength == null ? other.maxLength != null : !this.maxLength.equals(other.maxLength)) {
            return false;
        }
        if (this.maximum == null ? other.maximum != null : !this.maximum.equals(other.maximum)) {
            return false;
        }
        if (this.minItems == null ? other.minItems != null : !this.minItems.equals(other.minItems)) {
            return false;
        }
        if (this.minLength == null ? other.minLength != null : !this.minLength.equals(other.minLength)) {
            return false;
        }
        if (this.minimum == null ? other.minimum != null : !this.minimum.equals(other.minimum)) {
            return false;
        }
        if (this.multipleOf == null ? other.multipleOf != null : !this.multipleOf.equals(other.multipleOf)) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.uniqueItems == null ? other.uniqueItems != null : !this.uniqueItems.equals(other.uniqueItems)) {
            return false;
        }
        return !(this.allowEmptyValue != null ? !this.allowEmptyValue.equals(other.allowEmptyValue) : other.allowEmptyValue != null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this._enum == null ? 0 : this._enum.hashCode());
        result2 = 31 * result2 + (this.collectionFormat == null ? 0 : this.collectionFormat.hashCode());
        result2 = 31 * result2 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result2 = 31 * result2 + (this.example == null ? 0 : this.example.hashCode());
        result2 = 31 * result2 + (this.exclusiveMaximum == null ? 0 : this.exclusiveMaximum.hashCode());
        result2 = 31 * result2 + (this.exclusiveMinimum == null ? 0 : this.exclusiveMinimum.hashCode());
        result2 = 31 * result2 + (this.format == null ? 0 : this.format.hashCode());
        result2 = 31 * result2 + (this.items == null ? 0 : this.items.hashCode());
        result2 = 31 * result2 + (this.maxItems == null ? 0 : this.maxItems.hashCode());
        result2 = 31 * result2 + (this.maxLength == null ? 0 : this.maxLength.hashCode());
        result2 = 31 * result2 + (this.maximum == null ? 0 : this.maximum.hashCode());
        result2 = 31 * result2 + (this.minItems == null ? 0 : this.minItems.hashCode());
        result2 = 31 * result2 + (this.minLength == null ? 0 : this.minLength.hashCode());
        result2 = 31 * result2 + (this.minimum == null ? 0 : this.minimum.hashCode());
        result2 = 31 * result2 + (this.multipleOf == null ? 0 : this.multipleOf.hashCode());
        result2 = 31 * result2 + (this.pattern == null ? 0 : this.pattern.hashCode());
        result2 = 31 * result2 + (this.type == null ? 0 : this.type.hashCode());
        result2 = 31 * result2 + (this.uniqueItems == null ? 0 : this.uniqueItems.hashCode());
        result2 = 31 * result2 + (this.allowEmptyValue != null ? this.allowEmptyValue.hashCode() : 0);
        return result2;
    }
}

