/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class ActionsAuthRecord {
    @SerializedName(value="destination")
    private DestinationEnum destination = null;
    @SerializedName(value="action")
    private ActionEnum action = null;
    @SerializedName(value="category")
    private String category = null;
    @SerializedName(value="authLevel")
    private String authLevel = null;
    @SerializedName(value="actionType")
    private String actionType = null;
    @SerializedName(value="additionalInfo")
    private String additionalInfo = null;
    @SerializedName(value="category2")
    private String category2 = null;
    @SerializedName(value="policy")
    private PolicyEnum policy = null;
    @SerializedName(value="authAttr")
    private String authAttr = null;

    public ActionsAuthRecord destination(DestinationEnum destination) {
        this.destination = destination;
        return this;
    }

    @ApiModelProperty(value="component in which the action sent - Possible Values - EM, CTM_Server, CTM_Agent, CTM_CM")
    public DestinationEnum getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationEnum destination) {
        this.destination = destination;
    }

    public ActionsAuthRecord action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(value="action name unique list of actions' names as appear in the actions_auth em db table, along with the destination makes a unique action auth entry")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ActionsAuthRecord category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="Privilege (Can be empty) Possible Values for categories fields  - OPER, DATABASE, CONFIG, CTMSEC, CPMAN, RAMAN, AGMAN, CMMAN, CCP, UNKNOWN")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ActionsAuthRecord authLevel(String authLevel) {
        this.authLevel = authLevel;
        return this;
    }

    @ApiModelProperty(value="required minimum authorization level - BROWSE, UPDATE, FULL")
    public String getAuthLevel() {
        return this.authLevel;
    }

    public void setAuthLevel(String authLevel) {
        this.authLevel = authLevel;
    }

    public ActionsAuthRecord actionType(String actionType) {
        this.actionType = actionType;
        return this;
    }

    @ApiModelProperty(value="R - request always pass, authorization is done on the response; C - Connection Profile name will remain empty and will be ignored; E - Not related to authorization")
    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public ActionsAuthRecord additionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    @ApiModelProperty(value="currently not in use regarding authorization")
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public ActionsAuthRecord category2(String category2) {
        this.category2 = category2;
        return this;
    }

    @ApiModelProperty(value="")
    public String getCategory2() {
        return this.category2;
    }

    public void setCategory2(String category2) {
        this.category2 = category2;
    }

    public ActionsAuthRecord policy(PolicyEnum policy) {
        this.policy = policy;
        return this;
    }

    @ApiModelProperty(value="relation between Category and category2 - 1. Only category, 2. Only Category2, 3. Category AND Category2, 4. Category OR Category2")
    public PolicyEnum getPolicy() {
        return this.policy;
    }

    public void setPolicy(PolicyEnum policy) {
        this.policy = policy;
    }

    public ActionsAuthRecord authAttr(String authAttr) {
        this.authAttr = authAttr;
        return this;
    }

    @ApiModelProperty(value="In case that not all information for authorization exist in the header request, it contain path in the body for the missing field\\fields.")
    public String getAuthAttr() {
        return this.authAttr;
    }

    public void setAuthAttr(String authAttr) {
        this.authAttr = authAttr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionsAuthRecord actionsAuthRecord = (ActionsAuthRecord)o;
        return Objects.equals((Object)this.destination, (Object)actionsAuthRecord.destination) && Objects.equals((Object)this.action, (Object)actionsAuthRecord.action) && Objects.equals(this.category, actionsAuthRecord.category) && Objects.equals(this.authLevel, actionsAuthRecord.authLevel) && Objects.equals(this.actionType, actionsAuthRecord.actionType) && Objects.equals(this.additionalInfo, actionsAuthRecord.additionalInfo) && Objects.equals(this.category2, actionsAuthRecord.category2) && Objects.equals((Object)this.policy, (Object)actionsAuthRecord.policy) && Objects.equals(this.authAttr, actionsAuthRecord.authAttr);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destination, this.action, this.category, this.authLevel, this.actionType, this.additionalInfo, this.category2, this.policy, this.authAttr});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionsAuthRecord {\n");
        sb.append("    destination: ").append(this.toIndentedString((Object)this.destination)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    authLevel: ").append(this.toIndentedString(this.authLevel)).append("\n");
        sb.append("    actionType: ").append(this.toIndentedString(this.actionType)).append("\n");
        sb.append("    additionalInfo: ").append(this.toIndentedString(this.additionalInfo)).append("\n");
        sb.append("    category2: ").append(this.toIndentedString(this.category2)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString((Object)this.policy)).append("\n");
        sb.append("    authAttr: ").append(this.toIndentedString(this.authAttr)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DestinationEnum {
        EM("EM"),
        CTM_SERVER("CTM_Server"),
        CTM_AGENT("CTM_Agent"),
        CTM_CM("CTM_CM");

        private String value;

        private DestinationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DestinationEnum fromValue(String text) {
            for (DestinationEnum b : DestinationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DestinationEnum> {
            @Override
            public void write(JsonWriter jsonWriter, DestinationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public DestinationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DestinationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionEnum {
        COLLECT_MEASUREMENTS_AND_REPORTS_REQUEST("Collect_measurements_and_reports_request"),
        SET_AGENT_DEBUG_INFO_REQUEST("Set_agent_debug_info_request"),
        GET_AGENT_DEBUG_INFO_REQUEST("Get_agent_debug_info_request"),
        SET_AGENT_CONFIG_PARAMS_REQUEST("Set_agent_config_params_request"),
        GET_AGENT_CONFIG_PARAMS_REQUEST("Get_agent_config_params_request"),
        CTMAG_SET_CERT_REQUEST("Ctmag_set_cert_request"),
        CTMAG_GET_CSR_REQUEST("Ctmag_get_csr_request"),
        CTMAG_GET_CERT_EXPIRE_DATE_REQUEST("Ctmag_get_cert_expire_date_request"),
        CTMAG_GET_CONFIG_REQUEST("Ctmag_get_config_request"),
        CTMAGENT_RECYCLE_REQUEST("Ctmagent_recycle_request"),
        CTMAG_GET_LOCALE_LIST_REQUEST("Ctmag_get_locale_list_request"),
        CTMAG_UPDATE_CONFIG_REQUEST("Ctmag_update_config_request"),
        AUTHORIZE_REMOTE_HOST_REQUEST("Authorize_remote_host_request"),
        CTMSAP_UPDATE_EW_CONFIG_REQUEST("Ctmsap_update_ew_config_request"),
        CTMSAP_GET_EW_CONFIG_REQUEST("Ctmsap_get_ew_config_request"),
        CTMCM_UPDATE_EXTRACT_RULE_TABLE_REQUEST("Ctmcm_update_extract_rule_table_request"),
        CTMCM_GET_EXTRACT_RULE_TABLE_REQUEST("Ctmcm_get_extract_rule_table_request"),
        CTMCM_GET_TEMPLATES_REQUEST("Ctmcm_get_templates_request"),
        CTMCM_GET_ACCOUNTS_REQUEST("Ctmcm_get_accounts_request"),
        CTMCM_ADD_ACCOUNT_REQUEST("Ctmcm_add_account_request"),
        CTMCM_UPDATE_ACCOUNT_REQUEST("Ctmcm_update_account_request"),
        CTMCM_DELETE_ACCOUNT_REQUEST("Ctmcm_delete_account_request"),
        CTMCM_VALIDATE_ACCOUNT_REQUEST("Ctmcm_validate_account_request"),
        CTMCM_GET_INFO_REQUEST("Ctmcm_get_info_request"),
        CTMCM_MASS_UPDATE_REQUEST("Ctmcm_mass_update_request"),
        CTMCM_GET_CONFIG_REQUEST("Ctmcm_get_config_request"),
        CTMCM_UPDATE_CONFIG_REQUEST("Ctmcm_update_config_request"),
        CTMSAP_GET_ACCOUNTS_NAMES_REQUEST("Ctmsap_get_accounts_names_request"),
        CTMSAP_GET_SAP_INTERCEPTION_CRITERIA_REQUEST("Ctmsap_get_sap_interception_criteria_request"),
        CTMSAP_UPDATE_SAP_INTERCEPTION_CRITERIA_REQUEST("Ctmsap_update_sap_interception_criteria_request"),
        CTMSAP_GET_CTM_INTERCEPTION_RULES_REQUEST("Ctmsap_get_ctm_interception_rules_request"),
        CTMSAP_UPDATE_CTM_INTERCEPTION_RULES_REQUEST("Ctmsap_update_ctm_interception_rules_request"),
        CTMSAP_GET_EXTRACT_RULES_REQUEST("Ctmsap_get_extract_rules_request"),
        CTMSAP_UPDATE_EXTRACT_RULES_REQUEST("Ctmsap_update_extract_rules_request"),
        CTMSAP_GET_USER_EXIT_FILES_REQUEST("Ctmsap_get_user_exit_files_request"),
        CTMSAP_GET_XTRACTOR_CONFIG_REQUEST("Ctmsap_get_xtractor_config_request"),
        CTMSAP_UPDATE_XTRACTOR_CONFIG_REQUEST("Ctmsap_update_xtractor_config_request"),
        CTMSAP_CHECK_XBP2_ENABLE_REQUEST("Ctmsap_check_XBP2_enable_request"),
        CTMSAP_GET_SAP_CALENDARS_REQUEST("Ctmsap_get_sap_calendars_request"),
        CTMSAP_IMPORT_SAP_CALENDAR_REQUEST("Ctmsap_import_sap_calendar_request"),
        CTMSAP_GET_EW_EVENTS_NAMES_REQUEST("Ctmsap_get_ew_events_names_request"),
        CTMSAP_CREATE_PROFILE_REQUEST("Ctmsap_create_profile_request"),
        CTMSAP_SET_PROFILE_REQUEST("Ctmsap_set_profile_request"),
        CTMSAP_DELETE_PROFILE_REQUEST("Ctmsap_delete_profile_request"),
        CTMSAP_GET_PROFILES_REQUEST("Ctmsap_get_profiles_request"),
        CTMSAP_GET_PROFILE_CRITERIA_REQUEST("Ctmsap_get_profile_criteria_request"),
        CTMSAP_ACTIVATE_PROFILE_REQUEST("Ctmsap_activate_profile_request"),
        CTMAG_SET_EXTRACT_SERVICE_STATUS_REQUEST("Ctmag_set_extract_service_status_request"),
        CTMAG_UPDATE_EXTRACT_SERVICE_PROP_REQUEST("Ctmag_update_extract_service_prop_request"),
        CTMAG_GET_EXTRACT_SERVICE_PROP_REQUEST("Ctmag_get_extract_service_prop_request"),
        CTMCM_JNDI_BROWSE_REQUEST("Ctmcm_jndi_browse_request"),
        CTMCM_LOAD_EJB_REQUEST("Ctmcm_load_ejb_request"),
        CTMCM_GET_ENCRYPTION_TYPE_REQUEST("Ctmcm_get_encryption_type_request"),
        CTMCM_GET_KNOWN_HOSTS_REQUEST("Ctmcm_get_known_hosts_request"),
        CTMCM_UPDATE_AFT_SERVER_CONFIGURATION_REQUEST("Ctmcm_update_aft_server_configuration_request"),
        CTMCM_GET_AFT_SERVER_CONFIGURATION_REQUEST("Ctmcm_get_aft_server_configuration_request"),
        CTMCM_VERIFY_LOCAL_PATH_REQUEST("Ctmcm_verify_local_path_request"),
        CTMCM_MFT_B2B_REST_PATCH_REQUEST("Ctmcm_mft_b2b_rest_patch_request"),
        CTMCM_GET_AS2_ENCRYPTION_ALGORITHMS_REQUEST("Ctmcm_get_as2_encryption_algorithms_request"),
        CTMCM_GET_AS2_SIGNATURE_ALGORITHMS_REQUEST("Ctmcm_get_as2_signature_algorithms_request"),
        CTMCM_GET_S3_REGIONS_REQUEST("Ctmcm_get_s3_regions_request"),
        CTMCM_GET_ORACLE_REGIONS_REQUEST("Ctmcm_get_oracle_regions_request"),
        CTMCM_GET_ORACLE_COMPARTMENTS_REQUEST("Ctmcm_get_oracle_compartments_request"),
        CTMCM_GET_SSH_KEYS_CONTENT_REQUEST("Ctmcm_get_ssh_keys_content_request"),
        CTMDB_REMOVE_DBVENDOR_REQUEST("Ctmdb_remove_dbvendor_request"),
        CTMDB_UPDATE_DBVENDOR_REQUEST("Ctmdb_update_dbvendor_request"),
        CTMDB_ADD_DBVENDOR_REQUEST("Ctmdb_add_dbvendor_request"),
        CTMCM_MFT_GET_B2B_MODE_REQUEST("Ctmcm_mft_get_b2b_mode_request"),
        CTMCM_MFT_B2B_REST_DELETE_REQUEST("Ctmcm_mft_b2b_rest_delete_request"),
        CTMCM_MFT_B2B_REST_READ_REQUEST("Ctmcm_mft_b2b_rest_read_request"),
        CTMCM_MFT_B2B_REST_UPDATE_REQUEST("Ctmcm_mft_b2b_rest_update_request"),
        CTMCM_MFT_B2B_REST_CREATE_REQUEST("Ctmcm_mft_b2b_rest_create_request"),
        CTMCM_MFT_B2B_GENERAL_COMMAND_REQUEST("Ctmcm_mft_b2b_general_command_request"),
        CTMPSFT_RECYCLE_REQUEST("Ctmpsft_recycle_request"),
        CTMCM_GET_MVS_TEMPLATES_REQUEST("Ctmcm_get_Mvs_templates_request"),
        CTMCM_DELETE_MVS_TEMPLATE_REQUEST("Ctmcm_delete_Mvs_template_request"),
        CTMCM_ADD_MVS_TEMPLATE_REQUEST("Ctmcm_add_Mvs_template_request"),
        CTMCM_UPDATE_MVS_TEMPLATE_REQUEST("Ctmcm_update_Mvs_template_request"),
        CTMSAP_UPDATE_SAP_INTERCEPTION_PROFILE_REQUEST("Ctmsap_update_sap_interception_profile_request"),
        CTMSAP_GET_SAP_INTERCEPTION_PROFILES_REQUEST("Ctmsap_get_sap_interception_profiles_request"),
        CTMCM_GET_PGP_TEMPLATES_REQUEST("Ctmcm_get_pgp_templates_request"),
        CTMCM_DELETE_PGP_TEMPLATE_REQUEST("Ctmcm_delete_pgp_template_request"),
        CTMCM_ADD_PGP_TEMPLATE_REQUEST("Ctmcm_add_pgp_template_request"),
        CTMCM_UPDATE_PGP_TEMPLATE_REQUEST("Ctmcm_update_pgp_template_request"),
        CTMCM_MASS_UPDATE_DETAILS_REQUEST("Ctmcm_mass_update_details_request"),
        CTMCM_CREATE_SSH_KEY_REQUEST("Ctmcm_create_ssh_key_request"),
        CTMCM_AUTHORIZE_REMOTE_HOST_REQUEST("Ctmcm_authorize_remote_host_request"),
        CTMCM_GET_HOME_DIRECTORY_REQUEST("Ctmcm_get_home_directory_request"),
        CTMOEBS_ACTIVATE_EW_REQUEST("Ctmoebs_activate_ew_request"),
        CTMOEBS_GET_ALERTS_LIST_REQUEST("Ctmoebs_get_alerts_list_request"),
        CTMOEBS_GET_APPLICATIONS_LIST_REQUEST("Ctmoebs_get_applications_list_request"),
        CTMOEBS_UPDATE_EW_RULES_REQUEST("Ctmoebs_update_ew_rules_request"),
        CTMOEBS_GET_EW_RULES_REQUEST("Ctmoebs_get_ew_rules_request"),
        CTMOEBS_UPDATE_EW_CONFIG_REQUEST("Ctmoebs_update_ew_config_request"),
        CTMOEBS_GET_EW_CONFIG_REQUEST("Ctmoebs_get_ew_config_request"),
        CTMOEBS_GET_SERVICE_NAMES_REQUEST("Ctmoebs_get_service_names_request"),
        CTMCM_BROWSE_FILE_REQUEST("Ctmcm_browse_file_request"),
        CTMSAP_CLEAR_EVENTS_REQUEST("Ctmsap_clear_events_request"),
        CTMSAP_UPDATE_EW_RULES_REQUEST("Ctmsap_update_ew_rules_request"),
        CTMSAP_GET_EW_RULES_REQUEST("Ctmsap_get_ew_rules_request"),
        ZOS_GET_SYS_PARMS_REQUEST("Zos_get_sys_parms_request"),
        UPDATE_DEPLOYMENT_TARGET_REQUEST("Update_deployment_target_request"),
        UPDATE_DEPLOYMENT_PARAMETERS_REQUEST("Update_deployment_parameters_request"),
        GET_DEPLOYMENT_OUTPUT_REQUEST("Get_deployment_output_request"),
        RETRY_DEPLOYMENT_REQUEST("Retry_deployment_request"),
        CANCEL_DEPLOYMENT_REQUEST("Cancel_deployment_request"),
        DELETE_DEPLOYMENT_REQUEST("Delete_deployment_request"),
        ADD_UNINSTALL_DEPLOYMENT_REQUEST("Add_uninstall_deployment_request"),
        CTMSEC_GET_USERS_GROUPS_REQUEST("Ctmsec_get_users_groups_request"),
        CTMSEC_DELETE_USER_REQUEST("Ctmsec_delete_user_request"),
        CTMSEC_DELETE_GROUP_REQUEST("Ctmsec_delete_group_request"),
        CTMSEC_UPDATE_USER_REQUEST("Ctmsec_update_user_request"),
        CTMSEC_UPDATE_GROUP_REQUEST("Ctmsec_update_group_request"),
        CTMSEC_NEW_USER_REQUEST("Ctmsec_new_user_request"),
        CTMSEC_NEW_GROUP_REQUEST("Ctmsec_new_group_request"),
        CTMSEC_GET_SECURITY_ATTRIBUTES_REQUEST("Ctmsec_get_security_attributes_request"),
        CTMSEC_UPDATE_SECURITY_ATTRIBUTES_REQUEST("Ctmsec_update_security_attributes_request"),
        CTMAGENT_ADD_REQUEST("Ctmagent_add_request"),
        CTMAGENT_DELETE_REQUEST("Ctmagent_delete_request"),
        CTMAGENT_PING_REQUEST("Ctmagent_ping_request"),
        CTMAGENT_GET_PARAMETERS_REQUEST("Ctmagent_get_parameters_request"),
        CTMAGENT_SET_PARAMETERS_REQUEST("Ctmagent_set_parameters_request"),
        CTMAGENT_ENABLE_REQUEST("Ctmagent_enable_request"),
        CTMAGENT_DISABLE_REQUEST("Ctmagent_disable_request"),
        GET_CTMS_DEBUG_INFO_REQUEST("Get_ctms_debug_info_request"),
        SET_CTMS_DEBUG_INFO_REQUEST("Set_ctms_debug_info_request"),
        CTMRJX_GET_HOST_DETAILS_REQUEST("Ctmrjx_get_host_details_request"),
        CTMRJX_ADD_HOST_REQUEST("Ctmrjx_add_host_request"),
        CTMRJX_UPDATE_HOST_REQUEST("Ctmrjx_update_host_request"),
        CTMRJX_DELETE_HOST_REQUEST("Ctmrjx_delete_host_request"),
        CTMRJX_TEST_HOST_REQUEST("Ctmrjx_test_host_request"),
        CTMRJX_ENABLE_HOST_REQUEST("Ctmrjx_enable_host_request"),
        CTMRJX_DISABLE_HOST_REQUEST("Ctmrjx_disable_host_request"),
        CTMRJX_PING_HOST_REQUEST("Ctmrjx_ping_host_request"),
        CTMRJX_GET_OWNERS_REQUEST("Ctmrjx_get_owners_request"),
        CTMRJX_GET_OWNER_DETAILS_REQUEST("Ctmrjx_get_owner_details_request"),
        CTMRJX_ADD_OWNER_REQUEST("Ctmrjx_add_owner_request"),
        CTMRJX_UPDATE_OWNER_REQUEST("Ctmrjx_update_owner_request"),
        CTMRJX_DELETE_OWNER_REQUEST("Ctmrjx_delete_owner_request"),
        CTMRJX_GET_KEYNAMES_LIST_REQUEST("Ctmrjx_get_keynames_list_request"),
        CTMRJX_TEST_USER_REQUEST("Ctmrjx_test_user_request"),
        CTM_GET_NODE_GROUPS_REQUEST("Ctm_get_node_groups_request"),
        CTM_UPDATE_NODE_GROUP_REQUEST("Ctm_update_node_group_request"),
        CTM_ADD_NODE_GROUP_REQUEST("Ctm_add_node_group_request"),
        CTM_DELETE_NODE_GROUP_REQUEST("Ctm_delete_node_group_request"),
        ZOS_CTL_REQUEST("Zos_ctl_request"),
        ZOS_NEW_SYS_PARM_REQUEST("Zos_new_sys_parm_request"),
        ZOS_UPDATE_SYS_PARM_REQUEST("Zos_update_sys_parm_request"),
        ZOS_DELETE_SYS_PARM_REQUEST("Zos_delete_sys_parm_request"),
        ZOS_REFRESH_SYS_PARMS_REQUEST("Zos_refresh_sys_parms_request"),
        CTMNODEID_TEST_USER_REQUEST("Ctmnodeid_test_user_request"),
        CTM_SERVER_GET_SYS_PARMS_REQUEST("Ctm_server_get_sys_parms_request"),
        CTM_SERVER_UPDATE_SYS_PARM_REQUEST("Ctm_server_update_sys_parm_request"),
        CTM_SERVER_REFRESH_SYS_PARMS_REQUEST("Ctm_server_refresh_sys_parms_request"),
        SET_PAUSE_REQUEST("Set_pause_request"),
        ZOS_GET_SYS_PARMS_ENHANCED_REQUEST("Zos_get_sys_parms_enhanced_request"),
        CTMSERVER_GET_SSH_KEYS_LIST_REQUEST("Ctmserver_get_ssh_keys_list_request"),
        CTMSERVER_CREATE_SSH_KEY_REQUEST("Ctmserver_create_ssh_key_request"),
        CTMSERVER_UPDATE_SSH_KEY_REQUEST("Ctmserver_update_ssh_key_request"),
        CTMSERVER_DELETE_SSH_KEY_REQUEST("Ctmserver_delete_ssh_key_request"),
        CTMSERVER_GET_PUBLIC_KEY_REQUEST("Ctmserver_get_public_key_request"),
        GET_SUPPORTED_SHOUT_DESTINATION_ADDRESSES_REQUEST("Get_supported_shout_destination_addresses_request"),
        GET_SHOUT_DESTINATION_TABLES_REQUEST("Get_shout_destination_tables_request"),
        DELETE_SHOUT_DESTINATION_TABLE_REQUEST("Delete_shout_destination_table_request"),
        SET_ACTIVE_SHOUT_DESTINATION_TABLE_REQUEST("Set_active_shout_destination_table_request"),
        UPDATE_SHOUT_DESTINATION_REQUEST("Update_shout_destination_request"),
        CREATE_SHOUT_DESTINATION_REQUEST("Create_shout_destination_request"),
        DELETE_SHOUT_DESTINATION_REQUEST("Delete_shout_destination_request"),
        CTM_GET_ALL_NODE_RESTRICTIONS_REQUEST("Ctm_get_all_node_restrictions_request"),
        CTM_ADD_NODE_RESTRICTION_REQUEST("Ctm_add_node_restriction_request"),
        CTM_UPDATE_NODE_RESTRICTION_REQUEST("Ctm_update_node_restriction_request"),
        CTM_DELETE_NODE_RESTRICTIONS_REQUEST("Ctm_delete_node_restrictions_request"),
        CTMSRV_GET_CM_ACCOUNTS_STATUS_REQUEST("Ctmsrv_get_cm_accounts_status_request"),
        CTMSRV_UPDATE_CM_ACCOUNT_STATUS_REQUEST("Ctmsrv_update_cm_account_status_request"),
        SET_CTM_PRIMARY_REQUEST("Set_ctm_primary_request"),
        SET_CTM_FAILOVER_MODE_REQUEST("Set_ctm_failover_mode_request"),
        REPLICATION_MODE_REQUEST("Replication_mode_request"),
        CTMAGENT_TROUBLESHOOTING_REQUEST("Ctmagent_troubleshooting_request"),
        SET_DB_HOST_PORT_REQUEST("Set_db_host_port_request"),
        GET_DB_HOST_PORT_REQUEST("Get_db_host_port_request"),
        XALERT_UNHANDLE_REQUEST("Xalert_unhandle_request"),
        CREATE_EM_COMPONENT_REQUEST("Create_em_component_request"),
        GET_COMPONENT_REQUEST("Get_component_request"),
        REFRESH_CTMS_AG_DEPLOY_REQUEST("Refresh_ctms_ag_deploy_request"),
        REFRESH_CTMS_REQUEST("Refresh_ctms_request"),
        GET_AGENTS_REQUEST("Get_agents_request"),
        XALERT_HANDLE_REQUEST("Xalert_handle_request"),
        GET_ALL_NODE_GROUPS_REQUEST("Get_all_node_groups_request"),
        GET_COMPONENTS_REQUEST("Get_components_request"),
        VIEW_AGENTS_LOG_REQUEST("View_agents_log_request"),
        GET_XALERTS_REQUEST("Get_xalerts_request"),
        DELETE_SYS_PARMS_REQUEST("Delete_sys_parms_request"),
        UPDATE_SYS_PARMS_REQUEST("Update_sys_parms_request"),
        NEW_SYS_PARMS_REQUEST("New_sys_parms_request"),
        GET_SYS_PARMS_REQUEST("Get_sys_parms_request"),
        GET_CMS_DETAILS_REQUEST("Get_cms_details_request"),
        GET_CTMS_CODES_REQUEST("Get_ctms_codes_request"),
        DELETE_CTMS_REQUEST("Delete_ctms_request"),
        CCP_ADD_OR_UPDATE_REQUEST("Ccp_add_or_update_request"),
        CCP_GET_SUMMARY_REQUEST("Ccp_get_summary_request"),
        CCP_GET_FULL_REQUEST("Ccp_get_full_request"),
        CCP_DELETE_REQUEST("Ccp_delete_request"),
        CCP_GET_SYNC_STATUS_REQUEST("Ccp_get_sync_status_request"),
        GET_WEBSERVER_DEBUGLEVELINFO_REQUEST("Get_webserver_debuglevelinfo_request"),
        NEW_CTMS_REQUEST("New_ctms_request"),
        DISCOVER_REQUEST("Discover_request"),
        GET_CTMS_DETAILS_REQUEST("Get_ctms_details_request"),
        UN_MANAGE_CTMS_REQUEST("Un_manage_ctms_request"),
        MANAGE_CTMS_REQUEST("Manage_ctms_request"),
        DISABLE_CTMS_REQUEST("Disable_ctms_request"),
        GET_WEBSERVER_URLS_REQUEST("Get_WebServer_urls_request"),
        ENABLE_CTMS_REQUEST("Enable_ctms_request"),
        RENAME_CTMSERVER_DRY_RUN_REQUEST("Rename_CTMServer_dry_run_request"),
        GET_DB_DETAILS_REQUEST("Get_db_details_request"),
        GET_EM_DETAILS_REQUEST("Get_em_details_request"),
        MOVE_EM_CONTROL_REQUEST("Move_em_control_request"),
        SET_WEBSERVER_DEBUGLEVELINFO_REQUEST("Set_webserver_debuglevelinfo_request"),
        SET_EM_PRIMARY_REQUEST("Set_em_primary_request"),
        START_REPLICATION_REQUEST("Start_replication_request"),
        CREATE_XALERT_REQUEST("Create_xalert_request"),
        SET_EM_FAILOVER_MODE_REQUEST("Set_em_failover_mode_request"),
        PURGE_XALERTS_REQUEST("Purge_xalerts_request"),
        REMOVE_OLD_VERSIONS_REQUEST("Remove_old_versions_request"),
        MOVE_EM_CTM_CONTROL_REQUEST("Move_em_ctm_control_request"),
        SET_EM_CTM_PRIMARY_REQUEST("Set_em_ctm_primary_request"),
        GET_CAPACITY_EXCEED_ALERT_PARAMS_REQUEST("Get_capacity_exceed_alert_params_request"),
        SET_CAPACITY_EXCEED_ALERT_PARAMS_REQUEST("Set_capacity_exceed_alert_params_request"),
        TEST_ENVS_CONNECTIVITY_REQUEST("Test_envs_connectivity_request"),
        SET_ENABLE_CAPACITY_EXCEED_ALERT_REQUEST("Set_enable_capacity_exceed_alert_request"),
        GET_ENABLE_CAPACITY_EXCEED_ALERT_REQUEST("Get_enable_capacity_exceed_alert_request"),
        GET_LICENSE_SITE_INFO_REQUEST("Get_license_site_info_request"),
        GET_LICENSE_INFO_REQUEST("Get_license_info_request"),
        UPDATE_LICENSE_REQUEST("Update_license_request"),
        GET_WEB_SERVER_DETAILS_REQUEST("Get_web_server_details_request"),
        GET_AVAILABLE_CLIENT_UPDATES_REQUEST("Get_available_client_updates_request"),
        SET_REQUIRED_FP_OR_PATCH_REQUEST("Set_required_fp_or_patch_request"),
        IMPORT_CLIENT_CERTIFICATES_REQUEST("Import_client_certificates_request"),
        GET_ARCHIVE_SERVER_CONF_REQUEST("Get_archive_server_conf_request"),
        SET_ARCHIVE_SERVER_CONF_REQUEST("Set_archive_server_conf_request"),
        ARCHIVE_BROWSE_CCM("Archive_Browse_CCM"),
        ARCHIVE_UPDATE_CCM("Archive_Update_CCM"),
        SET_B2B_MODE_FOR_MFT_REQUEST("Set_B2B_mode_for_mft_request"),
        PROMOTE_AND_RENAME_CTMSERVER_REQUEST("Promote_and_rename_CTMServer_request"),
        GET_COMPATIBILITY_DETAILS_REQUEST("Get_compatibility_details_request"),
        SET_COMPATIBILITY_VERSION_REQUEST("Set_compatibility_version_request"),
        UPDATE_LOCAL_CTMSERVER_ATTRIBUTE_REQUEST("Update_local_CTMServer_attribute_request"),
        UPDATE_CTMS_REQUEST("Update_ctms_request"),
        IGNORE_REQUEST("Ignore_request"),
        RECYCLE_REQUEST("Recycle_request"),
        STOP_REQUEST("Stop_request"),
        START_REQUEST("Start_request"),
        GET_EM_COMPONENT_REQUEST("Get_em_component_request"),
        DELETE_EM_COMPONENT_REQUEST("Delete_em_component_request"),
        REMOVE_OLD_ALERTS_REQUEST("Remove_old_alerts_request"),
        UPDATE_EM_COMPONENT_REQUEST("Update_em_component_request"),
        LIST_EM_USER_NAMES_REQUEST("List_em_user_names_request"),
        GET_DIAG_OUTPUT_REQUEST("Get_diag_output_request"),
        ADD_DEPLOYMENT_REQUEST("Add_deployment_request"),
        GET_DEPLOYMENT_LIST_REQUEST("Get_deployment_list_request"),
        GET_MACHINE_DETAILS_REQUEST("Get_machine_details_request"),
        GET_PACKAGES_REQUEST("Get_packages_request"),
        UPDATE_ADD_ONS_REQUEST("Update_Add_Ons_request"),
        GET_ADD_ONS_REQUEST("Get_Add_Ons_request"),
        LDAP_GET_TYPES_REQUEST("LDAP_get_types_request"),
        WEB_LAUNCH_PREPARE_PACKAGE("Web_launch_prepare_package"),
        MANAGESSL_GENERATE_CERTIFICATE_REQUEST("ManageSSL_generate_certificate_request"),
        MANAGESSL_GET_COMPONENTS_REQUEST("ManageSSL_get_components_request"),
        MANAGESSL_CREATE_NEW_CA_REQUEST("ManageSSL_create_new_CA_request"),
        MANAGESSL_GET_CA_DETAILS_REQUEST("ManageSSL_get_CA_details_request"),
        IS_ANNOTATION_REQUIRED_REQUEST("Is_annotation_required_request"),
        ACTIONS_AUTH_REQUEST("Actions_auth_request"),
        LOGIN_ADMIN_DB_REQUEST("Login_admin_db_request"),
        DB_EXTEND_REQUEST("Db_extend_request"),
        GET_DB_FILE_LIST_REQUEST("Get_db_file_list_request"),
        DB_CHECK_SPACE_REQUEST("Db_check_space_request"),
        POLLING_REQUEST("Polling_request"),
        CTL_REQUEST("Ctl_request"),
        XALERT_UPDATE_NOTE_REQUEST("Xalert_update_note_request"),
        CTMCM_MFT_SET_B2B_MODE_REQUEST("Ctmcm_mft_set_b2b_mode_request"),
        GET_CTM_NODE_GROUPS_REQUEST("Get_ctm_node_groups_request"),
        GET_CTM_NODE_GROUP_REQUEST("Get_ctm_node_group_request"),
        ACTIVATE_SERVER_REQUEST("Activate_server_request"),
        DEACTIVATE_SERVER_REQUEST("Deactivate_server_request"),
        DELETE_SYS_PARMS_EXT_REQUEST("Delete_sys_parms_ext_request"),
        GET_SYS_PARMS_EXT_REQUEST("Get_sys_parms_ext_request"),
        NEW_SYS_PARMS_EXT_REQUEST("New_sys_parms_ext_request"),
        UPDATE_ADD_ONS_REQUEST_WITH_AUDIT("Update_Add_Ons_request_with_audit"),
        UPDATE_SYS_PARMS_EXT_REQUEST("Update_sys_parms_ext_request"),
        INTERNAL_NEW_CTMS_REQUEST("internal_New_ctms_request");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionEnum fromValue(String text) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ActionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ActionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PolicyEnum {
        CTG("CTG"),
        CTG2("CTG2"),
        CTG_AND_CTG2("CTG_AND_CTG2"),
        CTG_OR_CTG2("CTG_OR_CTG2");

        private String value;

        private PolicyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PolicyEnum fromValue(String text) {
            for (PolicyEnum b : PolicyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PolicyEnum> {
            @Override
            public void write(JsonWriter jsonWriter, PolicyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public PolicyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PolicyEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

