/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.AiDeployResponse;
import io.swagger.client.model.AiJobtypeList;
import io.swagger.client.model.ConnectionProfilesDeploymentStatusResult;
import io.swagger.client.model.ConnectionProfilesStatusResult;
import io.swagger.client.model.ConvertLcpToCcpResults;
import io.swagger.client.model.DeployJobtypeResponse;
import io.swagger.client.model.DeploymentFileResults;
import io.swagger.client.model.EmdefTaskResult;
import io.swagger.client.model.FieldValues;
import io.swagger.client.model.ItemInfoList;
import io.swagger.client.model.ListOfEmdefTaskStatus;
import io.swagger.client.model.PollID;
import io.swagger.client.model.SiteStandardDetailsList;
import io.swagger.client.model.SiteStandardPoliciesFileResults;
import io.swagger.client.model.SiteStandardPolicyDetailsList;
import io.swagger.client.model.SiteStandardsList;
import io.swagger.client.model.StringListResult;
import io.swagger.client.model.SuccessData;
import io.swagger.client.model.WorkspaceFolders;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DeployApi {
    private ApiClient apiClient;

    public DeployApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeployApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call convertToCentralizedConnectionProfileCall(String server, String agent, String type, Boolean dryRun, File definitionsFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/connectionprofile/local/convert/{server}/{agent}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{agent\\}", this.apiClient.escapeString(agent.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call convertToCentralizedConnectionProfileValidateBeforeCall(String server, String agent, String type, Boolean dryRun, File definitionsFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling convertToCentralizedConnectionProfile(Async)");
        }
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling convertToCentralizedConnectionProfile(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling convertToCentralizedConnectionProfile(Async)");
        }
        Call call = this.convertToCentralizedConnectionProfileCall(server, agent, type, dryRun, definitionsFile, progressListener, progressRequestListener);
        return call;
    }

    public ConvertLcpToCcpResults convertToCentralizedConnectionProfile(String server, String agent, String type, Boolean dryRun, File definitionsFile) throws ApiException {
        ApiResponse<ConvertLcpToCcpResults> resp = this.convertToCentralizedConnectionProfileWithHttpInfo(server, agent, type, dryRun, definitionsFile);
        return resp.getData();
    }

    public ApiResponse<ConvertLcpToCcpResults> convertToCentralizedConnectionProfileWithHttpInfo(String server, String agent, String type, Boolean dryRun, File definitionsFile) throws ApiException {
        Call call = this.convertToCentralizedConnectionProfileValidateBeforeCall(server, agent, type, dryRun, definitionsFile, null, null);
        Type localVarReturnType = new TypeToken<ConvertLcpToCcpResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call convertToCentralizedConnectionProfileAsync(String server, String agent, String type, Boolean dryRun, File definitionsFile, final ApiCallback<ConvertLcpToCcpResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertToCentralizedConnectionProfileValidateBeforeCall(server, agent, type, dryRun, definitionsFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ConvertLcpToCcpResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCalendarCall(String calendarName, String server, String type, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/calendar/{calendarName}".replaceAll("\\{calendarName\\}", this.apiClient.escapeString(calendarName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCalendarValidateBeforeCall(String calendarName, String server, String type, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (calendarName == null) {
            throw new ApiException("Missing the required parameter 'calendarName' when calling deleteCalendar(Async)");
        }
        Call call = this.deleteCalendarCall(calendarName, server, type, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteCalendar(String calendarName, String server, String type) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteCalendarWithHttpInfo(calendarName, server, type);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteCalendarWithHttpInfo(String calendarName, String server, String type) throws ApiException {
        Call call = this.deleteCalendarValidateBeforeCall(calendarName, server, type, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteCalendarAsync(String calendarName, String server, String type, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCalendarValidateBeforeCall(calendarName, server, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteConnectionProfileCall(String server, String agent, String type, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofile/{server}/{agent}/{type}/{name}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{agent\\}", this.apiClient.escapeString(agent.toString())).replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteConnectionProfileValidateBeforeCall(String server, String agent, String type, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling deleteConnectionProfile(Async)");
        }
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling deleteConnectionProfile(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling deleteConnectionProfile(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteConnectionProfile(Async)");
        }
        Call call = this.deleteConnectionProfileCall(server, agent, type, name, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteConnectionProfile(String server, String agent, String type, String name) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteConnectionProfileWithHttpInfo(server, agent, type, name);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteConnectionProfileWithHttpInfo(String server, String agent, String type, String name) throws ApiException {
        Call call = this.deleteConnectionProfileValidateBeforeCall(server, agent, type, name, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteConnectionProfileAsync(String server, String agent, String type, String name, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteConnectionProfileValidateBeforeCall(server, agent, type, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteFolderCall(String server, String folderName, String library, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/folder/{server}/{folderName}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{folderName\\}", this.apiClient.escapeString(folderName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (library != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("library", library));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFolderValidateBeforeCall(String server, String folderName, String library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling deleteFolder(Async)");
        }
        if (folderName == null) {
            throw new ApiException("Missing the required parameter 'folderName' when calling deleteFolder(Async)");
        }
        Call call = this.deleteFolderCall(server, folderName, library, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteFolder(String server, String folderName, String library) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteFolderWithHttpInfo(server, folderName, library);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteFolderWithHttpInfo(String server, String folderName, String library) throws ApiException {
        Call call = this.deleteFolderValidateBeforeCall(server, folderName, library, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteFolderAsync(String server, String folderName, String library, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFolderValidateBeforeCall(server, folderName, library, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteJobPathCall(String jobPath, String server, String library, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/job/{jobPath}".replaceAll("\\{jobPath\\}", this.apiClient.escapeString(jobPath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (library != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("library", library));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteJobPathValidateBeforeCall(String jobPath, String server, String library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobPath == null) {
            throw new ApiException("Missing the required parameter 'jobPath' when calling deleteJobPath(Async)");
        }
        Call call = this.deleteJobPathCall(jobPath, server, library, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteJobPath(String jobPath, String server, String library) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteJobPathWithHttpInfo(jobPath, server, library);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteJobPathWithHttpInfo(String jobPath, String server, String library) throws ApiException {
        Call call = this.deleteJobPathValidateBeforeCall(jobPath, server, library, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteJobPathAsync(String jobPath, String server, String library, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteJobPathValidateBeforeCall(jobPath, server, library, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteLocalConnectionProfileCall(String server, String agent, String type, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofile/local/{server}/{agent}/{type}/{name}".replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{agent\\}", this.apiClient.escapeString(agent.toString())).replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteLocalConnectionProfileValidateBeforeCall(String server, String agent, String type, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling deleteLocalConnectionProfile(Async)");
        }
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling deleteLocalConnectionProfile(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling deleteLocalConnectionProfile(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteLocalConnectionProfile(Async)");
        }
        Call call = this.deleteLocalConnectionProfileCall(server, agent, type, name, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteLocalConnectionProfile(String server, String agent, String type, String name) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteLocalConnectionProfileWithHttpInfo(server, agent, type, name);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteLocalConnectionProfileWithHttpInfo(String server, String agent, String type, String name) throws ApiException {
        Call call = this.deleteLocalConnectionProfileValidateBeforeCall(server, agent, type, name, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteLocalConnectionProfileAsync(String server, String agent, String type, String name, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteLocalConnectionProfileValidateBeforeCall(server, agent, type, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSharedConnectionProfileCall(String type, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofile/centralized/{type}/{name}".replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSharedConnectionProfileValidateBeforeCall(String type, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling deleteSharedConnectionProfile(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSharedConnectionProfile(Async)");
        }
        Call call = this.deleteSharedConnectionProfileCall(type, name, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteSharedConnectionProfile(String type, String name) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteSharedConnectionProfileWithHttpInfo(type, name);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteSharedConnectionProfileWithHttpInfo(String type, String name) throws ApiException {
        Call call = this.deleteSharedConnectionProfileValidateBeforeCall(type, name, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSharedConnectionProfileAsync(String type, String name, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSharedConnectionProfileValidateBeforeCall(type, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSiteStandardCall(String siteStandardName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandard/{siteStandardName}".replaceAll("\\{siteStandardName\\}", this.apiClient.escapeString(siteStandardName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSiteStandardValidateBeforeCall(String siteStandardName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (siteStandardName == null) {
            throw new ApiException("Missing the required parameter 'siteStandardName' when calling deleteSiteStandard(Async)");
        }
        Call call = this.deleteSiteStandardCall(siteStandardName, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteSiteStandard(String siteStandardName) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteSiteStandardWithHttpInfo(siteStandardName);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteSiteStandardWithHttpInfo(String siteStandardName) throws ApiException {
        Call call = this.deleteSiteStandardValidateBeforeCall(siteStandardName, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSiteStandardAsync(String siteStandardName, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSiteStandardValidateBeforeCall(siteStandardName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSiteStandardPolicyCall(String siteStandardPolicyName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandardpolicy/{siteStandardPolicyName}".replaceAll("\\{siteStandardPolicyName\\}", this.apiClient.escapeString(siteStandardPolicyName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSiteStandardPolicyValidateBeforeCall(String siteStandardPolicyName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (siteStandardPolicyName == null) {
            throw new ApiException("Missing the required parameter 'siteStandardPolicyName' when calling deleteSiteStandardPolicy(Async)");
        }
        Call call = this.deleteSiteStandardPolicyCall(siteStandardPolicyName, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteSiteStandardPolicy(String siteStandardPolicyName) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteSiteStandardPolicyWithHttpInfo(siteStandardPolicyName);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteSiteStandardPolicyWithHttpInfo(String siteStandardPolicyName) throws ApiException {
        Call call = this.deleteSiteStandardPolicyValidateBeforeCall(siteStandardPolicyName, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSiteStandardPolicyAsync(String siteStandardPolicyName, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSiteStandardPolicyValidateBeforeCall(siteStandardPolicyName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSubFolderCall(String subFolderPath, String server, String library, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/subfolder/{subFolderPath}".replaceAll("\\{subFolderPath\\}", this.apiClient.escapeString(subFolderPath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (library != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("library", library));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSubFolderValidateBeforeCall(String subFolderPath, String server, String library, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (subFolderPath == null) {
            throw new ApiException("Missing the required parameter 'subFolderPath' when calling deleteSubFolder(Async)");
        }
        Call call = this.deleteSubFolderCall(subFolderPath, server, library, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteSubFolder(String subFolderPath, String server, String library) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteSubFolderWithHttpInfo(subFolderPath, server, library);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteSubFolderWithHttpInfo(String subFolderPath, String server, String library) throws ApiException {
        Call call = this.deleteSubFolderValidateBeforeCall(subFolderPath, server, library, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSubFolderAsync(String subFolderPath, String server, String library, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSubFolderValidateBeforeCall(subFolderPath, server, library, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deployAiJobtypeCall(String ctm, String agent, String jobTypeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/ai/jobtype";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (agent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("agent", agent));
        }
        if (jobTypeId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobTypeId", jobTypeId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deployAiJobtypeValidateBeforeCall(String ctm, String agent, String jobTypeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ctm == null) {
            throw new ApiException("Missing the required parameter 'ctm' when calling deployAiJobtype(Async)");
        }
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling deployAiJobtype(Async)");
        }
        if (jobTypeId == null) {
            throw new ApiException("Missing the required parameter 'jobTypeId' when calling deployAiJobtype(Async)");
        }
        Call call = this.deployAiJobtypeCall(ctm, agent, jobTypeId, progressListener, progressRequestListener);
        return call;
    }

    public AiDeployResponse deployAiJobtype(String ctm, String agent, String jobTypeId) throws ApiException {
        ApiResponse<AiDeployResponse> resp = this.deployAiJobtypeWithHttpInfo(ctm, agent, jobTypeId);
        return resp.getData();
    }

    public ApiResponse<AiDeployResponse> deployAiJobtypeWithHttpInfo(String ctm, String agent, String jobTypeId) throws ApiException {
        Call call = this.deployAiJobtypeValidateBeforeCall(ctm, agent, jobTypeId, null, null);
        Type localVarReturnType = new TypeToken<AiDeployResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deployAiJobtypeAsync(String ctm, String agent, String jobTypeId, final ApiCallback<AiDeployResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deployAiJobtypeValidateBeforeCall(ctm, agent, jobTypeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AiDeployResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deployFileCall(File definitionsFile, File deployDescriptorFile, File additionalConfiguration, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if (deployDescriptorFile != null) {
            localVarFormParams.put("deployDescriptorFile", deployDescriptorFile);
        }
        if (additionalConfiguration != null) {
            localVarFormParams.put("additionalConfiguration", additionalConfiguration);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deployFileValidateBeforeCall(File definitionsFile, File deployDescriptorFile, File additionalConfiguration, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (definitionsFile == null) {
            throw new ApiException("Missing the required parameter 'definitionsFile' when calling deployFile(Async)");
        }
        Call call = this.deployFileCall(definitionsFile, deployDescriptorFile, additionalConfiguration, progressListener, progressRequestListener);
        return call;
    }

    public List<DeploymentFileResults> deployFile(File definitionsFile, File deployDescriptorFile, File additionalConfiguration) throws ApiException {
        ApiResponse<List<DeploymentFileResults>> resp = this.deployFileWithHttpInfo(definitionsFile, deployDescriptorFile, additionalConfiguration);
        return resp.getData();
    }

    public ApiResponse<List<DeploymentFileResults>> deployFileWithHttpInfo(File definitionsFile, File deployDescriptorFile, File additionalConfiguration) throws ApiException {
        Call call = this.deployFileValidateBeforeCall(definitionsFile, deployDescriptorFile, additionalConfiguration, null, null);
        Type localVarReturnType = new TypeToken<List<DeploymentFileResults>>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deployFileAsync(File definitionsFile, File deployDescriptorFile, File additionalConfiguration, final ApiCallback<List<DeploymentFileResults>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deployFileValidateBeforeCall(definitionsFile, deployDescriptorFile, additionalConfiguration, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DeploymentFileResults>>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deployJobtypeFileCall(File definitionsFile, String agent, String server, File payloadFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/jobtype";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (agent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("agent", agent));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if (payloadFile != null) {
            localVarFormParams.put("payloadFile", payloadFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deployJobtypeFileValidateBeforeCall(File definitionsFile, String agent, String server, File payloadFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (definitionsFile == null) {
            throw new ApiException("Missing the required parameter 'definitionsFile' when calling deployJobtypeFile(Async)");
        }
        Call call = this.deployJobtypeFileCall(definitionsFile, agent, server, payloadFile, progressListener, progressRequestListener);
        return call;
    }

    public DeployJobtypeResponse deployJobtypeFile(File definitionsFile, String agent, String server, File payloadFile) throws ApiException {
        ApiResponse<DeployJobtypeResponse> resp = this.deployJobtypeFileWithHttpInfo(definitionsFile, agent, server, payloadFile);
        return resp.getData();
    }

    public ApiResponse<DeployJobtypeResponse> deployJobtypeFileWithHttpInfo(File definitionsFile, String agent, String server, File payloadFile) throws ApiException {
        Call call = this.deployJobtypeFileValidateBeforeCall(definitionsFile, agent, server, payloadFile, null, null);
        Type localVarReturnType = new TypeToken<DeployJobtypeResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deployJobtypeFileAsync(File definitionsFile, String agent, String server, File payloadFile, final ApiCallback<DeployJobtypeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deployJobtypeFileValidateBeforeCall(definitionsFile, agent, server, payloadFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeployJobtypeResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deploySiteStandardPoliciesCall(File siteStandardPoliciesFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandardpolicies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (siteStandardPoliciesFile != null) {
            localVarFormParams.put("siteStandardPoliciesFile", siteStandardPoliciesFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deploySiteStandardPoliciesValidateBeforeCall(File siteStandardPoliciesFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (siteStandardPoliciesFile == null) {
            throw new ApiException("Missing the required parameter 'siteStandardPoliciesFile' when calling deploySiteStandardPolicies(Async)");
        }
        Call call = this.deploySiteStandardPoliciesCall(siteStandardPoliciesFile, progressListener, progressRequestListener);
        return call;
    }

    public SiteStandardPoliciesFileResults deploySiteStandardPolicies(File siteStandardPoliciesFile) throws ApiException {
        ApiResponse<SiteStandardPoliciesFileResults> resp = this.deploySiteStandardPoliciesWithHttpInfo(siteStandardPoliciesFile);
        return resp.getData();
    }

    public ApiResponse<SiteStandardPoliciesFileResults> deploySiteStandardPoliciesWithHttpInfo(File siteStandardPoliciesFile) throws ApiException {
        Call call = this.deploySiteStandardPoliciesValidateBeforeCall(siteStandardPoliciesFile, null, null);
        Type localVarReturnType = new TypeToken<SiteStandardPoliciesFileResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deploySiteStandardPoliciesAsync(File siteStandardPoliciesFile, final ApiCallback<SiteStandardPoliciesFileResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deploySiteStandardPoliciesValidateBeforeCall(siteStandardPoliciesFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SiteStandardPoliciesFileResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deploySiteStandardsInternalCall(SiteStandardsList siteStandards, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SiteStandardsList localVarPostBody = siteStandards;
        String localVarPath = "/deploy/internal/sitestandards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deploySiteStandardsInternalValidateBeforeCall(SiteStandardsList siteStandards, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (siteStandards == null) {
            throw new ApiException("Missing the required parameter 'siteStandards' when calling deploySiteStandardsInternal(Async)");
        }
        Call call = this.deploySiteStandardsInternalCall(siteStandards, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deploySiteStandardsInternal(SiteStandardsList siteStandards) throws ApiException {
        ApiResponse<SuccessData> resp = this.deploySiteStandardsInternalWithHttpInfo(siteStandards);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deploySiteStandardsInternalWithHttpInfo(SiteStandardsList siteStandards) throws ApiException {
        Call call = this.deploySiteStandardsInternalValidateBeforeCall(siteStandards, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deploySiteStandardsInternalAsync(SiteStandardsList siteStandards, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deploySiteStandardsInternalValidateBeforeCall(siteStandards, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call emdefDeployCall(String utilityName, File payLoadFile, File parameters, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/emdef";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (utilityName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("utilityName", utilityName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (payLoadFile != null) {
            localVarFormParams.put("payLoadFile", payLoadFile);
        }
        if (parameters != null) {
            localVarFormParams.put("parameters", parameters);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call emdefDeployValidateBeforeCall(String utilityName, File payLoadFile, File parameters, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.emdefDeployCall(utilityName, payLoadFile, parameters, progressListener, progressRequestListener);
        return call;
    }

    public PollID emdefDeploy(String utilityName, File payLoadFile, File parameters) throws ApiException {
        ApiResponse<PollID> resp = this.emdefDeployWithHttpInfo(utilityName, payLoadFile, parameters);
        return resp.getData();
    }

    public ApiResponse<PollID> emdefDeployWithHttpInfo(String utilityName, File payLoadFile, File parameters) throws ApiException {
        Call call = this.emdefDeployValidateBeforeCall(utilityName, payLoadFile, parameters, null, null);
        Type localVarReturnType = new TypeToken<PollID>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call emdefDeployAsync(String utilityName, File payLoadFile, File parameters, final ApiCallback<PollID> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.emdefDeployValidateBeforeCall(utilityName, payLoadFile, parameters, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PollID>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call emdefDeployResultCall(String pollID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/emdef/result";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pollID != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pollID", pollID));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call emdefDeployResultValidateBeforeCall(String pollID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (pollID == null) {
            throw new ApiException("Missing the required parameter 'pollID' when calling emdefDeployResult(Async)");
        }
        Call call = this.emdefDeployResultCall(pollID, progressListener, progressRequestListener);
        return call;
    }

    public EmdefTaskResult emdefDeployResult(String pollID) throws ApiException {
        ApiResponse<EmdefTaskResult> resp = this.emdefDeployResultWithHttpInfo(pollID);
        return resp.getData();
    }

    public ApiResponse<EmdefTaskResult> emdefDeployResultWithHttpInfo(String pollID) throws ApiException {
        Call call = this.emdefDeployResultValidateBeforeCall(pollID, null, null);
        Type localVarReturnType = new TypeToken<EmdefTaskResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call emdefDeployResultAsync(String pollID, final ApiCallback<EmdefTaskResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.emdefDeployResultValidateBeforeCall(pollID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EmdefTaskResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call emdefDeployStatusCall(String pollID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/emdef/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pollID != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pollID", pollID));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call emdefDeployStatusValidateBeforeCall(String pollID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.emdefDeployStatusCall(pollID, progressListener, progressRequestListener);
        return call;
    }

    public ListOfEmdefTaskStatus emdefDeployStatus(String pollID) throws ApiException {
        ApiResponse<ListOfEmdefTaskStatus> resp = this.emdefDeployStatusWithHttpInfo(pollID);
        return resp.getData();
    }

    public ApiResponse<ListOfEmdefTaskStatus> emdefDeployStatusWithHttpInfo(String pollID) throws ApiException {
        Call call = this.emdefDeployStatusValidateBeforeCall(pollID, null, null);
        Type localVarReturnType = new TypeToken<ListOfEmdefTaskStatus>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call emdefDeployStatusAsync(String pollID, final ApiCallback<ListOfEmdefTaskStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.emdefDeployStatusValidateBeforeCall(pollID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListOfEmdefTaskStatus>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call exportFromWorkspacePBToJsonCall(File workspacePBFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/workspace/export";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (workspacePBFile != null) {
            localVarFormParams.put("workspacePBFile", workspacePBFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call exportFromWorkspacePBToJsonValidateBeforeCall(File workspacePBFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.exportFromWorkspacePBToJsonCall(workspacePBFile, progressListener, progressRequestListener);
        return call;
    }

    public String exportFromWorkspacePBToJson(File workspacePBFile) throws ApiException {
        ApiResponse<String> resp = this.exportFromWorkspacePBToJsonWithHttpInfo(workspacePBFile);
        return resp.getData();
    }

    public ApiResponse<String> exportFromWorkspacePBToJsonWithHttpInfo(File workspacePBFile) throws ApiException {
        Call call = this.exportFromWorkspacePBToJsonValidateBeforeCall(workspacePBFile, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call exportFromWorkspacePBToJsonAsync(File workspacePBFile, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.exportFromWorkspacePBToJsonValidateBeforeCall(workspacePBFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getConnectionProfilesDeploymentStatusCall(String type, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofile/centralized/deploymentstatus/{type}/{name}".replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getConnectionProfilesDeploymentStatusValidateBeforeCall(String type, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getConnectionProfilesDeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getConnectionProfilesDeploymentStatus(Async)");
        }
        Call call = this.getConnectionProfilesDeploymentStatusCall(type, name, progressListener, progressRequestListener);
        return call;
    }

    public ConnectionProfilesDeploymentStatusResult getConnectionProfilesDeploymentStatus(String type, String name) throws ApiException {
        ApiResponse<ConnectionProfilesDeploymentStatusResult> resp = this.getConnectionProfilesDeploymentStatusWithHttpInfo(type, name);
        return resp.getData();
    }

    public ApiResponse<ConnectionProfilesDeploymentStatusResult> getConnectionProfilesDeploymentStatusWithHttpInfo(String type, String name) throws ApiException {
        Call call = this.getConnectionProfilesDeploymentStatusValidateBeforeCall(type, name, null, null);
        Type localVarReturnType = new TypeToken<ConnectionProfilesDeploymentStatusResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getConnectionProfilesDeploymentStatusAsync(String type, String name, final ApiCallback<ConnectionProfilesDeploymentStatusResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getConnectionProfilesDeploymentStatusValidateBeforeCall(type, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ConnectionProfilesDeploymentStatusResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCtmAiJobTypePluginCall(String jobTypeName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/jobtype";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (jobTypeName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobTypeName", jobTypeName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCtmAiJobTypePluginValidateBeforeCall(String jobTypeName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobTypeName == null) {
            throw new ApiException("Missing the required parameter 'jobTypeName' when calling getCtmAiJobTypePlugin(Async)");
        }
        Call call = this.getCtmAiJobTypePluginCall(jobTypeName, progressListener, progressRequestListener);
        return call;
    }

    public String getCtmAiJobTypePlugin(String jobTypeName) throws ApiException {
        ApiResponse<String> resp = this.getCtmAiJobTypePluginWithHttpInfo(jobTypeName);
        return resp.getData();
    }

    public ApiResponse<String> getCtmAiJobTypePluginWithHttpInfo(String jobTypeName) throws ApiException {
        Call call = this.getCtmAiJobTypePluginValidateBeforeCall(jobTypeName, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCtmAiJobTypePluginAsync(String jobTypeName, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCtmAiJobTypePluginValidateBeforeCall(jobTypeName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDefinitionItemsInfoInternalCall(String type, String filter2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/definitionitems/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (filter2 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter2));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDefinitionItemsInfoInternalValidateBeforeCall(String type, String filter2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getDefinitionItemsInfoInternal(Async)");
        }
        Call call = this.getDefinitionItemsInfoInternalCall(type, filter2, progressListener, progressRequestListener);
        return call;
    }

    public ItemInfoList getDefinitionItemsInfoInternal(String type, String filter2) throws ApiException {
        ApiResponse<ItemInfoList> resp = this.getDefinitionItemsInfoInternalWithHttpInfo(type, filter2);
        return resp.getData();
    }

    public ApiResponse<ItemInfoList> getDefinitionItemsInfoInternalWithHttpInfo(String type, String filter2) throws ApiException {
        Call call = this.getDefinitionItemsInfoInternalValidateBeforeCall(type, filter2, null, null);
        Type localVarReturnType = new TypeToken<ItemInfoList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDefinitionItemsInfoInternalAsync(String type, String filter2, final ApiCallback<ItemInfoList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDefinitionItemsInfoInternalValidateBeforeCall(type, filter2, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemInfoList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployDescriptorForPromotionRuleNameCall(String ruleName, Boolean failRule, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/promotionrules/rule/{ruleName}".replaceAll("\\{ruleName\\}", this.apiClient.escapeString(ruleName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (failRule != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("failRule", failRule));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployDescriptorForPromotionRuleNameValidateBeforeCall(String ruleName, Boolean failRule, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ruleName == null) {
            throw new ApiException("Missing the required parameter 'ruleName' when calling getDeployDescriptorForPromotionRuleName(Async)");
        }
        Call call = this.getDeployDescriptorForPromotionRuleNameCall(ruleName, failRule, progressListener, progressRequestListener);
        return call;
    }

    public String getDeployDescriptorForPromotionRuleName(String ruleName, Boolean failRule) throws ApiException {
        ApiResponse<String> resp = this.getDeployDescriptorForPromotionRuleNameWithHttpInfo(ruleName, failRule);
        return resp.getData();
    }

    public ApiResponse<String> getDeployDescriptorForPromotionRuleNameWithHttpInfo(String ruleName, Boolean failRule) throws ApiException {
        Call call = this.getDeployDescriptorForPromotionRuleNameValidateBeforeCall(ruleName, failRule, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployDescriptorForPromotionRuleNameAsync(String ruleName, Boolean failRule, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployDescriptorForPromotionRuleNameValidateBeforeCall(ruleName, failRule, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployedAiJobtypesCall(String jobTypeName, String jobTypeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/ai/jobtypes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (jobTypeName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobTypeName", jobTypeName));
        }
        if (jobTypeId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobTypeId", jobTypeId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployedAiJobtypesValidateBeforeCall(String jobTypeName, String jobTypeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDeployedAiJobtypesCall(jobTypeName, jobTypeId, progressListener, progressRequestListener);
        return call;
    }

    public AiJobtypeList getDeployedAiJobtypes(String jobTypeName, String jobTypeId) throws ApiException {
        ApiResponse<AiJobtypeList> resp = this.getDeployedAiJobtypesWithHttpInfo(jobTypeName, jobTypeId);
        return resp.getData();
    }

    public ApiResponse<AiJobtypeList> getDeployedAiJobtypesWithHttpInfo(String jobTypeName, String jobTypeId) throws ApiException {
        Call call = this.getDeployedAiJobtypesValidateBeforeCall(jobTypeName, jobTypeId, null, null);
        Type localVarReturnType = new TypeToken<AiJobtypeList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployedAiJobtypesAsync(String jobTypeName, String jobTypeId, final ApiCallback<AiJobtypeList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployedAiJobtypesValidateBeforeCall(jobTypeName, jobTypeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AiJobtypeList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployedCalendarsCall(String name, String server, String type, String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/calendars";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (alias != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("alias", alias));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployedCalendarsValidateBeforeCall(String name, String server, String type, String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDeployedCalendarsCall(name, server, type, alias, progressListener, progressRequestListener);
        return call;
    }

    public String getDeployedCalendars(String name, String server, String type, String alias) throws ApiException {
        ApiResponse<String> resp = this.getDeployedCalendarsWithHttpInfo(name, server, type, alias);
        return resp.getData();
    }

    public ApiResponse<String> getDeployedCalendarsWithHttpInfo(String name, String server, String type, String alias) throws ApiException {
        Call call = this.getDeployedCalendarsValidateBeforeCall(name, server, type, alias, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployedCalendarsAsync(String name, String server, String type, String alias, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployedCalendarsValidateBeforeCall(name, server, type, alias, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployedConnectionProfilesCall(String agent, String type, String ctm, String server, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofiles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (agent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("agent", agent));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployedConnectionProfilesValidateBeforeCall(String agent, String type, String ctm, String server, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling getDeployedConnectionProfiles(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getDeployedConnectionProfiles(Async)");
        }
        Call call = this.getDeployedConnectionProfilesCall(agent, type, ctm, server, progressListener, progressRequestListener);
        return call;
    }

    public String getDeployedConnectionProfiles(String agent, String type, String ctm, String server) throws ApiException {
        ApiResponse<String> resp = this.getDeployedConnectionProfilesWithHttpInfo(agent, type, ctm, server);
        return resp.getData();
    }

    public ApiResponse<String> getDeployedConnectionProfilesWithHttpInfo(String agent, String type, String ctm, String server) throws ApiException {
        Call call = this.getDeployedConnectionProfilesValidateBeforeCall(agent, type, ctm, server, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployedConnectionProfilesAsync(String agent, String type, String ctm, String server, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployedConnectionProfilesValidateBeforeCall(agent, type, ctm, server, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployedConnectionProfilesStatusCall(Long limit, String name, String type, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofiles/centralized/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployedConnectionProfilesStatusValidateBeforeCall(Long limit, String name, String type, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDeployedConnectionProfilesStatusCall(limit, name, type, progressListener, progressRequestListener);
        return call;
    }

    public ConnectionProfilesStatusResult getDeployedConnectionProfilesStatus(Long limit, String name, String type) throws ApiException {
        ApiResponse<ConnectionProfilesStatusResult> resp = this.getDeployedConnectionProfilesStatusWithHttpInfo(limit, name, type);
        return resp.getData();
    }

    public ApiResponse<ConnectionProfilesStatusResult> getDeployedConnectionProfilesStatusWithHttpInfo(Long limit, String name, String type) throws ApiException {
        Call call = this.getDeployedConnectionProfilesStatusValidateBeforeCall(limit, name, type, null, null);
        Type localVarReturnType = new TypeToken<ConnectionProfilesStatusResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployedConnectionProfilesStatusAsync(Long limit, String name, String type, final ApiCallback<ConnectionProfilesStatusResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployedConnectionProfilesStatusValidateBeforeCall(limit, name, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ConnectionProfilesStatusResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployedFoldersCall(String folder, String server, String library, String folderType, String siteStandard, String application, String subApplication, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/folders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (folder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder", folder));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (library != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("library", library));
        }
        if (folderType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folderType", folderType));
        }
        if (siteStandard != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("siteStandard", siteStandard));
        }
        if (application != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("application", application));
        }
        if (subApplication != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("subApplication", subApplication));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployedFoldersValidateBeforeCall(String folder, String server, String library, String folderType, String siteStandard, String application, String subApplication, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDeployedFoldersCall(folder, server, library, folderType, siteStandard, application, subApplication, progressListener, progressRequestListener);
        return call;
    }

    public Object getDeployedFolders(String folder, String server, String library, String folderType, String siteStandard, String application, String subApplication) throws ApiException {
        ApiResponse<Object> resp = this.getDeployedFoldersWithHttpInfo(folder, server, library, folderType, siteStandard, application, subApplication);
        return resp.getData();
    }

    public ApiResponse<Object> getDeployedFoldersWithHttpInfo(String folder, String server, String library, String folderType, String siteStandard, String application, String subApplication) throws ApiException {
        Call call = this.getDeployedFoldersValidateBeforeCall(folder, server, library, folderType, siteStandard, application, subApplication, null, null);
        Type localVarReturnType = new TypeToken<Object>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployedFoldersAsync(String folder, String server, String library, String folderType, String siteStandard, String application, String subApplication, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployedFoldersValidateBeforeCall(folder, server, library, folderType, siteStandard, application, subApplication, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployedFoldersNewCall(String format, String folder, String job, String ctm, String server, Boolean useArrayFormat, String library, Boolean flowData, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (format != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("format", format));
        }
        if (folder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder", folder));
        }
        if (job != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("job", job));
        }
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (useArrayFormat != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("useArrayFormat", useArrayFormat));
        }
        if (library != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("library", library));
        }
        if (flowData != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("flowData", flowData));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployedFoldersNewValidateBeforeCall(String format, String folder, String job, String ctm, String server, Boolean useArrayFormat, String library, Boolean flowData, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDeployedFoldersNewCall(format, folder, job, ctm, server, useArrayFormat, library, flowData, progressListener, progressRequestListener);
        return call;
    }

    public Object getDeployedFoldersNew(String format, String folder, String job, String ctm, String server, Boolean useArrayFormat, String library, Boolean flowData) throws ApiException {
        ApiResponse<Object> resp = this.getDeployedFoldersNewWithHttpInfo(format, folder, job, ctm, server, useArrayFormat, library, flowData);
        return resp.getData();
    }

    public ApiResponse<Object> getDeployedFoldersNewWithHttpInfo(String format, String folder, String job, String ctm, String server, Boolean useArrayFormat, String library, Boolean flowData) throws ApiException {
        Call call = this.getDeployedFoldersNewValidateBeforeCall(format, folder, job, ctm, server, useArrayFormat, library, flowData, null, null);
        Type localVarReturnType = new TypeToken<Object>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployedFoldersNewAsync(String format, String folder, String job, String ctm, String server, Boolean useArrayFormat, String library, Boolean flowData, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployedFoldersNewValidateBeforeCall(format, folder, job, ctm, server, useArrayFormat, library, flowData, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLocalConnectionProfilesCall(String agent, String type, String ctm, String server, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofiles/local";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (agent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("agent", agent));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLocalConnectionProfilesValidateBeforeCall(String agent, String type, String ctm, String server, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling getLocalConnectionProfiles(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getLocalConnectionProfiles(Async)");
        }
        Call call = this.getLocalConnectionProfilesCall(agent, type, ctm, server, progressListener, progressRequestListener);
        return call;
    }

    public String getLocalConnectionProfiles(String agent, String type, String ctm, String server) throws ApiException {
        ApiResponse<String> resp = this.getLocalConnectionProfilesWithHttpInfo(agent, type, ctm, server);
        return resp.getData();
    }

    public ApiResponse<String> getLocalConnectionProfilesWithHttpInfo(String agent, String type, String ctm, String server) throws ApiException {
        Call call = this.getLocalConnectionProfilesValidateBeforeCall(agent, type, ctm, server, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLocalConnectionProfilesAsync(String agent, String type, String ctm, String server, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLocalConnectionProfilesValidateBeforeCall(agent, type, ctm, server, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPromotionRulesNamesCall(String rulename, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/promotionrules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (rulename != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("rulename", rulename));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPromotionRulesNamesValidateBeforeCall(String rulename, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getPromotionRulesNamesCall(rulename, progressListener, progressRequestListener);
        return call;
    }

    public StringListResult getPromotionRulesNames(String rulename) throws ApiException {
        ApiResponse<StringListResult> resp = this.getPromotionRulesNamesWithHttpInfo(rulename);
        return resp.getData();
    }

    public ApiResponse<StringListResult> getPromotionRulesNamesWithHttpInfo(String rulename) throws ApiException {
        Call call = this.getPromotionRulesNamesValidateBeforeCall(rulename, null, null);
        Type localVarReturnType = new TypeToken<StringListResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPromotionRulesNamesAsync(String rulename, final ApiCallback<StringListResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPromotionRulesNamesValidateBeforeCall(rulename, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StringListResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSharedConnectionProfilesCall(String type, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofiles/centralized";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSharedConnectionProfilesValidateBeforeCall(String type, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getSharedConnectionProfiles(Async)");
        }
        Call call = this.getSharedConnectionProfilesCall(type, name, progressListener, progressRequestListener);
        return call;
    }

    public String getSharedConnectionProfiles(String type, String name) throws ApiException {
        ApiResponse<String> resp = this.getSharedConnectionProfilesWithHttpInfo(type, name);
        return resp.getData();
    }

    public ApiResponse<String> getSharedConnectionProfilesWithHttpInfo(String type, String name) throws ApiException {
        Call call = this.getSharedConnectionProfilesValidateBeforeCall(type, name, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSharedConnectionProfilesAsync(String type, String name, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSharedConnectionProfilesValidateBeforeCall(type, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSiteStandardFieldRestrictionsCall(String standardName, String fieldName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}".replaceAll("\\{standardName\\}", this.apiClient.escapeString(standardName.toString())).replaceAll("\\{fieldName\\}", this.apiClient.escapeString(fieldName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSiteStandardFieldRestrictionsValidateBeforeCall(String standardName, String fieldName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (standardName == null) {
            throw new ApiException("Missing the required parameter 'standardName' when calling getSiteStandardFieldRestrictions(Async)");
        }
        if (fieldName == null) {
            throw new ApiException("Missing the required parameter 'fieldName' when calling getSiteStandardFieldRestrictions(Async)");
        }
        Call call = this.getSiteStandardFieldRestrictionsCall(standardName, fieldName, progressListener, progressRequestListener);
        return call;
    }

    public String getSiteStandardFieldRestrictions(String standardName, String fieldName) throws ApiException {
        ApiResponse<String> resp = this.getSiteStandardFieldRestrictionsWithHttpInfo(standardName, fieldName);
        return resp.getData();
    }

    public ApiResponse<String> getSiteStandardFieldRestrictionsWithHttpInfo(String standardName, String fieldName) throws ApiException {
        Call call = this.getSiteStandardFieldRestrictionsValidateBeforeCall(standardName, fieldName, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSiteStandardFieldRestrictionsAsync(String standardName, String fieldName, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSiteStandardFieldRestrictionsValidateBeforeCall(standardName, fieldName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSiteStandardPoliciesCall(String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandardpolicies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSiteStandardPoliciesValidateBeforeCall(String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSiteStandardPoliciesCall(name, progressListener, progressRequestListener);
        return call;
    }

    public String getSiteStandardPolicies(String name) throws ApiException {
        ApiResponse<String> resp = this.getSiteStandardPoliciesWithHttpInfo(name);
        return resp.getData();
    }

    public ApiResponse<String> getSiteStandardPoliciesWithHttpInfo(String name) throws ApiException {
        Call call = this.getSiteStandardPoliciesValidateBeforeCall(name, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSiteStandardPoliciesAsync(String name, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSiteStandardPoliciesValidateBeforeCall(name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSiteStandardPoliciesDetailsCall(String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandardpolicies/details";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSiteStandardPoliciesDetailsValidateBeforeCall(String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSiteStandardPoliciesDetailsCall(name, progressListener, progressRequestListener);
        return call;
    }

    public SiteStandardPolicyDetailsList getSiteStandardPoliciesDetails(String name) throws ApiException {
        ApiResponse<SiteStandardPolicyDetailsList> resp = this.getSiteStandardPoliciesDetailsWithHttpInfo(name);
        return resp.getData();
    }

    public ApiResponse<SiteStandardPolicyDetailsList> getSiteStandardPoliciesDetailsWithHttpInfo(String name) throws ApiException {
        Call call = this.getSiteStandardPoliciesDetailsValidateBeforeCall(name, null, null);
        Type localVarReturnType = new TypeToken<SiteStandardPolicyDetailsList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSiteStandardPoliciesDetailsAsync(String name, final ApiCallback<SiteStandardPolicyDetailsList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSiteStandardPoliciesDetailsValidateBeforeCall(name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SiteStandardPolicyDetailsList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSiteStandardsCall(String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSiteStandardsValidateBeforeCall(String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSiteStandardsCall(name, progressListener, progressRequestListener);
        return call;
    }

    public String getSiteStandards(String name) throws ApiException {
        ApiResponse<String> resp = this.getSiteStandardsWithHttpInfo(name);
        return resp.getData();
    }

    public ApiResponse<String> getSiteStandardsWithHttpInfo(String name) throws ApiException {
        Call call = this.getSiteStandardsValidateBeforeCall(name, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSiteStandardsAsync(String name, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSiteStandardsValidateBeforeCall(name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSiteStandardsDetailsCall(String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandards/details";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSiteStandardsDetailsValidateBeforeCall(String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSiteStandardsDetailsCall(name, progressListener, progressRequestListener);
        return call;
    }

    public SiteStandardDetailsList getSiteStandardsDetails(String name) throws ApiException {
        ApiResponse<SiteStandardDetailsList> resp = this.getSiteStandardsDetailsWithHttpInfo(name);
        return resp.getData();
    }

    public ApiResponse<SiteStandardDetailsList> getSiteStandardsDetailsWithHttpInfo(String name) throws ApiException {
        Call call = this.getSiteStandardsDetailsValidateBeforeCall(name, null, null);
        Type localVarReturnType = new TypeToken<SiteStandardDetailsList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSiteStandardsDetailsAsync(String name, final ApiCallback<SiteStandardDetailsList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSiteStandardsDetailsValidateBeforeCall(name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SiteStandardDetailsList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSiteStandardsInternalCall(String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/sitestandards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSiteStandardsInternalValidateBeforeCall(String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSiteStandardsInternalCall(name, progressListener, progressRequestListener);
        return call;
    }

    public SiteStandardsList getSiteStandardsInternal(String name) throws ApiException {
        ApiResponse<SiteStandardsList> resp = this.getSiteStandardsInternalWithHttpInfo(name);
        return resp.getData();
    }

    public ApiResponse<SiteStandardsList> getSiteStandardsInternalWithHttpInfo(String name) throws ApiException {
        Call call = this.getSiteStandardsInternalValidateBeforeCall(name, null, null);
        Type localVarReturnType = new TypeToken<SiteStandardsList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSiteStandardsInternalAsync(String name, final ApiCallback<SiteStandardsList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSiteStandardsInternalValidateBeforeCall(name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SiteStandardsList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call importDataIntoWorkbenchCall(File definitionsFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/workbench/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importDataIntoWorkbenchValidateBeforeCall(File definitionsFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.importDataIntoWorkbenchCall(definitionsFile, progressListener, progressRequestListener);
        return call;
    }

    public List<DeploymentFileResults> importDataIntoWorkbench(File definitionsFile) throws ApiException {
        ApiResponse<List<DeploymentFileResults>> resp = this.importDataIntoWorkbenchWithHttpInfo(definitionsFile);
        return resp.getData();
    }

    public ApiResponse<List<DeploymentFileResults>> importDataIntoWorkbenchWithHttpInfo(File definitionsFile) throws ApiException {
        Call call = this.importDataIntoWorkbenchValidateBeforeCall(definitionsFile, null, null);
        Type localVarReturnType = new TypeToken<List<DeploymentFileResults>>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call importDataIntoWorkbenchAsync(File definitionsFile, final ApiCallback<List<DeploymentFileResults>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importDataIntoWorkbenchValidateBeforeCall(definitionsFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DeploymentFileResults>>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call importFromJsonToWorkspacePBCall(File definitionsFile, File deployDescriptorFile, Boolean skipValidation, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/workspace/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (skipValidation != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skipValidation", skipValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if (deployDescriptorFile != null) {
            localVarFormParams.put("deployDescriptorFile", deployDescriptorFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importFromJsonToWorkspacePBValidateBeforeCall(File definitionsFile, File deployDescriptorFile, Boolean skipValidation, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.importFromJsonToWorkspacePBCall(definitionsFile, deployDescriptorFile, skipValidation, progressListener, progressRequestListener);
        return call;
    }

    public WorkspaceFolders importFromJsonToWorkspacePB(File definitionsFile, File deployDescriptorFile, Boolean skipValidation) throws ApiException {
        ApiResponse<WorkspaceFolders> resp = this.importFromJsonToWorkspacePBWithHttpInfo(definitionsFile, deployDescriptorFile, skipValidation);
        return resp.getData();
    }

    public ApiResponse<WorkspaceFolders> importFromJsonToWorkspacePBWithHttpInfo(File definitionsFile, File deployDescriptorFile, Boolean skipValidation) throws ApiException {
        Call call = this.importFromJsonToWorkspacePBValidateBeforeCall(definitionsFile, deployDescriptorFile, skipValidation, null, null);
        Type localVarReturnType = new TypeToken<WorkspaceFolders>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call importFromJsonToWorkspacePBAsync(File definitionsFile, File deployDescriptorFile, Boolean skipValidation, final ApiCallback<WorkspaceFolders> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importFromJsonToWorkspacePBValidateBeforeCall(definitionsFile, deployDescriptorFile, skipValidation, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkspaceFolders>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call pollConvertResultCall(String pollId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/connectionprofile/local/status/convert/poll";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pollId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pollId", pollId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call pollConvertResultValidateBeforeCall(String pollId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (pollId == null) {
            throw new ApiException("Missing the required parameter 'pollId' when calling pollConvertResult(Async)");
        }
        Call call = this.pollConvertResultCall(pollId, progressListener, progressRequestListener);
        return call;
    }

    public ConvertLcpToCcpResults pollConvertResult(String pollId) throws ApiException {
        ApiResponse<ConvertLcpToCcpResults> resp = this.pollConvertResultWithHttpInfo(pollId);
        return resp.getData();
    }

    public ApiResponse<ConvertLcpToCcpResults> pollConvertResultWithHttpInfo(String pollId) throws ApiException {
        Call call = this.pollConvertResultValidateBeforeCall(pollId, null, null);
        Type localVarReturnType = new TypeToken<ConvertLcpToCcpResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call pollConvertResultAsync(String pollId, final ApiCallback<ConvertLcpToCcpResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.pollConvertResultValidateBeforeCall(pollId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ConvertLcpToCcpResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call pollDeployResultsCall(String pollId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/poll";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pollId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pollId", pollId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call pollDeployResultsValidateBeforeCall(String pollId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (pollId == null) {
            throw new ApiException("Missing the required parameter 'pollId' when calling pollDeployResults(Async)");
        }
        Call call = this.pollDeployResultsCall(pollId, progressListener, progressRequestListener);
        return call;
    }

    public DeploymentFileResults pollDeployResults(String pollId) throws ApiException {
        ApiResponse<DeploymentFileResults> resp = this.pollDeployResultsWithHttpInfo(pollId);
        return resp.getData();
    }

    public ApiResponse<DeploymentFileResults> pollDeployResultsWithHttpInfo(String pollId) throws ApiException {
        Call call = this.pollDeployResultsValidateBeforeCall(pollId, null, null);
        Type localVarReturnType = new TypeToken<DeploymentFileResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call pollDeployResultsAsync(String pollId, final ApiCallback<DeploymentFileResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.pollDeployResultsValidateBeforeCall(pollId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeploymentFileResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call renameSiteStandardCall(String siteStandardName, String siteStandardNewName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandard/{siteStandardName}".replaceAll("\\{siteStandardName\\}", this.apiClient.escapeString(siteStandardName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (siteStandardNewName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("siteStandardNewName", siteStandardNewName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call renameSiteStandardValidateBeforeCall(String siteStandardName, String siteStandardNewName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (siteStandardName == null) {
            throw new ApiException("Missing the required parameter 'siteStandardName' when calling renameSiteStandard(Async)");
        }
        if (siteStandardNewName == null) {
            throw new ApiException("Missing the required parameter 'siteStandardNewName' when calling renameSiteStandard(Async)");
        }
        Call call = this.renameSiteStandardCall(siteStandardName, siteStandardNewName, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData renameSiteStandard(String siteStandardName, String siteStandardNewName) throws ApiException {
        ApiResponse<SuccessData> resp = this.renameSiteStandardWithHttpInfo(siteStandardName, siteStandardNewName);
        return resp.getData();
    }

    public ApiResponse<SuccessData> renameSiteStandardWithHttpInfo(String siteStandardName, String siteStandardNewName) throws ApiException {
        Call call = this.renameSiteStandardValidateBeforeCall(siteStandardName, siteStandardNewName, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call renameSiteStandardAsync(String siteStandardName, String siteStandardNewName, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.renameSiteStandardValidateBeforeCall(siteStandardName, siteStandardNewName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call renameSiteStandardPolicyCall(String siteStandardPolicyName, String siteStandardPolicyNewName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/sitestandardpolicy/{siteStandardPolicyName}".replaceAll("\\{siteStandardPolicyName\\}", this.apiClient.escapeString(siteStandardPolicyName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (siteStandardPolicyNewName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("siteStandardPolicyNewName", siteStandardPolicyNewName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call renameSiteStandardPolicyValidateBeforeCall(String siteStandardPolicyName, String siteStandardPolicyNewName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (siteStandardPolicyName == null) {
            throw new ApiException("Missing the required parameter 'siteStandardPolicyName' when calling renameSiteStandardPolicy(Async)");
        }
        if (siteStandardPolicyNewName == null) {
            throw new ApiException("Missing the required parameter 'siteStandardPolicyNewName' when calling renameSiteStandardPolicy(Async)");
        }
        Call call = this.renameSiteStandardPolicyCall(siteStandardPolicyName, siteStandardPolicyNewName, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData renameSiteStandardPolicy(String siteStandardPolicyName, String siteStandardPolicyNewName) throws ApiException {
        ApiResponse<SuccessData> resp = this.renameSiteStandardPolicyWithHttpInfo(siteStandardPolicyName, siteStandardPolicyNewName);
        return resp.getData();
    }

    public ApiResponse<SuccessData> renameSiteStandardPolicyWithHttpInfo(String siteStandardPolicyName, String siteStandardPolicyNewName) throws ApiException {
        Call call = this.renameSiteStandardPolicyValidateBeforeCall(siteStandardPolicyName, siteStandardPolicyNewName, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call renameSiteStandardPolicyAsync(String siteStandardPolicyName, String siteStandardPolicyNewName, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.renameSiteStandardPolicyValidateBeforeCall(siteStandardPolicyName, siteStandardPolicyNewName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setHostNameInternalCall(String host, String url2, String message, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/internal/host";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (host != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("host", host));
        }
        if (url2 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("url", url2));
        }
        if (message != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("message", message));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setHostNameInternalValidateBeforeCall(String host, String url2, String message, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (host == null) {
            throw new ApiException("Missing the required parameter 'host' when calling setHostNameInternal(Async)");
        }
        Call call = this.setHostNameInternalCall(host, url2, message, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData setHostNameInternal(String host, String url2, String message) throws ApiException {
        ApiResponse<SuccessData> resp = this.setHostNameInternalWithHttpInfo(host, url2, message);
        return resp.getData();
    }

    public ApiResponse<SuccessData> setHostNameInternalWithHttpInfo(String host, String url2, String message) throws ApiException {
        Call call = this.setHostNameInternalValidateBeforeCall(host, url2, message, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setHostNameInternalAsync(String host, String url2, String message, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setHostNameInternalValidateBeforeCall(host, url2, message, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setSiteStandardFieldRestrictionsCall(String standardName, String fieldName, FieldValues valuesFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FieldValues localVarPostBody = valuesFile;
        String localVarPath = "/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}".replaceAll("\\{standardName\\}", this.apiClient.escapeString(standardName.toString())).replaceAll("\\{fieldName\\}", this.apiClient.escapeString(fieldName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setSiteStandardFieldRestrictionsValidateBeforeCall(String standardName, String fieldName, FieldValues valuesFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (standardName == null) {
            throw new ApiException("Missing the required parameter 'standardName' when calling setSiteStandardFieldRestrictions(Async)");
        }
        if (fieldName == null) {
            throw new ApiException("Missing the required parameter 'fieldName' when calling setSiteStandardFieldRestrictions(Async)");
        }
        if (valuesFile == null) {
            throw new ApiException("Missing the required parameter 'valuesFile' when calling setSiteStandardFieldRestrictions(Async)");
        }
        Call call = this.setSiteStandardFieldRestrictionsCall(standardName, fieldName, valuesFile, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData setSiteStandardFieldRestrictions(String standardName, String fieldName, FieldValues valuesFile) throws ApiException {
        ApiResponse<SuccessData> resp = this.setSiteStandardFieldRestrictionsWithHttpInfo(standardName, fieldName, valuesFile);
        return resp.getData();
    }

    public ApiResponse<SuccessData> setSiteStandardFieldRestrictionsWithHttpInfo(String standardName, String fieldName, FieldValues valuesFile) throws ApiException {
        Call call = this.setSiteStandardFieldRestrictionsValidateBeforeCall(standardName, fieldName, valuesFile, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setSiteStandardFieldRestrictionsAsync(String standardName, String fieldName, FieldValues valuesFile, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setSiteStandardFieldRestrictionsValidateBeforeCall(standardName, fieldName, valuesFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call testCentralizedConnectionProfileCall(String type, String name, String server, String agent, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofile/centralized/test/{type}/{name}/{server}/{agent}".replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{server\\}", this.apiClient.escapeString(server.toString())).replaceAll("\\{agent\\}", this.apiClient.escapeString(agent.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call testCentralizedConnectionProfileValidateBeforeCall(String type, String name, String server, String agent, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling testCentralizedConnectionProfile(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling testCentralizedConnectionProfile(Async)");
        }
        if (server == null) {
            throw new ApiException("Missing the required parameter 'server' when calling testCentralizedConnectionProfile(Async)");
        }
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling testCentralizedConnectionProfile(Async)");
        }
        Call call = this.testCentralizedConnectionProfileCall(type, name, server, agent, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData testCentralizedConnectionProfile(String type, String name, String server, String agent) throws ApiException {
        ApiResponse<SuccessData> resp = this.testCentralizedConnectionProfileWithHttpInfo(type, name, server, agent);
        return resp.getData();
    }

    public ApiResponse<SuccessData> testCentralizedConnectionProfileWithHttpInfo(String type, String name, String server, String agent) throws ApiException {
        Call call = this.testCentralizedConnectionProfileValidateBeforeCall(type, name, server, agent, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call testCentralizedConnectionProfileAsync(String type, String name, String server, String agent, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.testCentralizedConnectionProfileValidateBeforeCall(type, name, server, agent, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call testConnectionProfileCall(File definitionsFile, String ctm, String agent, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/connectionprofile/test";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (agent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("agent", agent));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call testConnectionProfileValidateBeforeCall(File definitionsFile, String ctm, String agent, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (definitionsFile == null) {
            throw new ApiException("Missing the required parameter 'definitionsFile' when calling testConnectionProfile(Async)");
        }
        Call call = this.testConnectionProfileCall(definitionsFile, ctm, agent, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData testConnectionProfile(File definitionsFile, String ctm, String agent) throws ApiException {
        ApiResponse<SuccessData> resp = this.testConnectionProfileWithHttpInfo(definitionsFile, ctm, agent);
        return resp.getData();
    }

    public ApiResponse<SuccessData> testConnectionProfileWithHttpInfo(File definitionsFile, String ctm, String agent) throws ApiException {
        Call call = this.testConnectionProfileValidateBeforeCall(definitionsFile, ctm, agent, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call testConnectionProfileAsync(File definitionsFile, String ctm, String agent, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.testConnectionProfileValidateBeforeCall(definitionsFile, ctm, agent, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transformFileCall(File definitionsFile, File deployDescriptorFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deploy/transform";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if (deployDescriptorFile != null) {
            localVarFormParams.put("deployDescriptorFile", deployDescriptorFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transformFileValidateBeforeCall(File definitionsFile, File deployDescriptorFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (definitionsFile == null) {
            throw new ApiException("Missing the required parameter 'definitionsFile' when calling transformFile(Async)");
        }
        if (deployDescriptorFile == null) {
            throw new ApiException("Missing the required parameter 'deployDescriptorFile' when calling transformFile(Async)");
        }
        Call call = this.transformFileCall(definitionsFile, deployDescriptorFile, progressListener, progressRequestListener);
        return call;
    }

    public String transformFile(File definitionsFile, File deployDescriptorFile) throws ApiException {
        ApiResponse<String> resp = this.transformFileWithHttpInfo(definitionsFile, deployDescriptorFile);
        return resp.getData();
    }

    public ApiResponse<String> transformFileWithHttpInfo(File definitionsFile, File deployDescriptorFile) throws ApiException {
        Call call = this.transformFileValidateBeforeCall(definitionsFile, deployDescriptorFile, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transformFileAsync(File definitionsFile, File deployDescriptorFile, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transformFileValidateBeforeCall(definitionsFile, deployDescriptorFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

