/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.ArchiveJobsList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ArchiveApi {
    private ApiClient apiClient;

    public ArchiveApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ArchiveApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getArchiveJobLogCall(String jobId, Long runNo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/archive/{jobId}/log".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (runNo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("runNo", runNo));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getArchiveJobLogValidateBeforeCall(String jobId, Long runNo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getArchiveJobLog(Async)");
        }
        if (runNo == null) {
            throw new ApiException("Missing the required parameter 'runNo' when calling getArchiveJobLog(Async)");
        }
        Call call = this.getArchiveJobLogCall(jobId, runNo, progressListener, progressRequestListener);
        return call;
    }

    public String getArchiveJobLog(String jobId, Long runNo) throws ApiException {
        ApiResponse<String> resp = this.getArchiveJobLogWithHttpInfo(jobId, runNo);
        return resp.getData();
    }

    public ApiResponse<String> getArchiveJobLogWithHttpInfo(String jobId, Long runNo) throws ApiException {
        Call call = this.getArchiveJobLogValidateBeforeCall(jobId, runNo, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getArchiveJobLogAsync(String jobId, Long runNo, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getArchiveJobLogValidateBeforeCall(jobId, runNo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getArchiveJobOutputCall(String jobId, Long runNo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/archive/{jobId}/output".replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (runNo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("runNo", runNo));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getArchiveJobOutputValidateBeforeCall(String jobId, Long runNo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getArchiveJobOutput(Async)");
        }
        if (runNo == null) {
            throw new ApiException("Missing the required parameter 'runNo' when calling getArchiveJobOutput(Async)");
        }
        Call call = this.getArchiveJobOutputCall(jobId, runNo, progressListener, progressRequestListener);
        return call;
    }

    public String getArchiveJobOutput(String jobId, Long runNo) throws ApiException {
        ApiResponse<String> resp = this.getArchiveJobOutputWithHttpInfo(jobId, runNo);
        return resp.getData();
    }

    public ApiResponse<String> getArchiveJobOutputWithHttpInfo(String jobId, Long runNo) throws ApiException {
        Call call = this.getArchiveJobOutputValidateBeforeCall(jobId, runNo, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getArchiveJobOutputAsync(String jobId, Long runNo, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getArchiveJobOutputValidateBeforeCall(jobId, runNo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchJobsCall(Integer limit, String jobname, String jobid, String ctm, String server, String folder, String fromTime, String toTime, String logContains, String outputContains, String application, String subApplication, String library, String memName, String memLibrary, String host, String hostGroup, String runAs, String orderId, String status, String orderDateFrom, String orderDateTo, Long numberOfRuns, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/archive/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (jobname != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobname", jobname));
        }
        if (jobid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("jobid", jobid));
        }
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (folder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder", folder));
        }
        if (fromTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fromTime", fromTime));
        }
        if (toTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("toTime", toTime));
        }
        if (logContains != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("logContains", logContains));
        }
        if (outputContains != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("outputContains", outputContains));
        }
        if (application != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("application", application));
        }
        if (subApplication != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("subApplication", subApplication));
        }
        if (library != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("library", library));
        }
        if (memName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("memName", memName));
        }
        if (memLibrary != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("memLibrary", memLibrary));
        }
        if (host != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("host", host));
        }
        if (hostGroup != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("hostGroup", hostGroup));
        }
        if (runAs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("runAs", runAs));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderId", orderId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (orderDateFrom != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderDateFrom", orderDateFrom));
        }
        if (orderDateTo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderDateTo", orderDateTo));
        }
        if (numberOfRuns != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("numberOfRuns", numberOfRuns));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchJobsValidateBeforeCall(Integer limit, String jobname, String jobid, String ctm, String server, String folder, String fromTime, String toTime, String logContains, String outputContains, String application, String subApplication, String library, String memName, String memLibrary, String host, String hostGroup, String runAs, String orderId, String status, String orderDateFrom, String orderDateTo, Long numberOfRuns, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.searchJobsCall(limit, jobname, jobid, ctm, server, folder, fromTime, toTime, logContains, outputContains, application, subApplication, library, memName, memLibrary, host, hostGroup, runAs, orderId, status, orderDateFrom, orderDateTo, numberOfRuns, progressListener, progressRequestListener);
        return call;
    }

    public ArchiveJobsList searchJobs(Integer limit, String jobname, String jobid, String ctm, String server, String folder, String fromTime, String toTime, String logContains, String outputContains, String application, String subApplication, String library, String memName, String memLibrary, String host, String hostGroup, String runAs, String orderId, String status, String orderDateFrom, String orderDateTo, Long numberOfRuns) throws ApiException {
        ApiResponse<ArchiveJobsList> resp = this.searchJobsWithHttpInfo(limit, jobname, jobid, ctm, server, folder, fromTime, toTime, logContains, outputContains, application, subApplication, library, memName, memLibrary, host, hostGroup, runAs, orderId, status, orderDateFrom, orderDateTo, numberOfRuns);
        return resp.getData();
    }

    public ApiResponse<ArchiveJobsList> searchJobsWithHttpInfo(Integer limit, String jobname, String jobid, String ctm, String server, String folder, String fromTime, String toTime, String logContains, String outputContains, String application, String subApplication, String library, String memName, String memLibrary, String host, String hostGroup, String runAs, String orderId, String status, String orderDateFrom, String orderDateTo, Long numberOfRuns) throws ApiException {
        Call call = this.searchJobsValidateBeforeCall(limit, jobname, jobid, ctm, server, folder, fromTime, toTime, logContains, outputContains, application, subApplication, library, memName, memLibrary, host, hostGroup, runAs, orderId, status, orderDateFrom, orderDateTo, numberOfRuns, null, null);
        Type localVarReturnType = new TypeToken<ArchiveJobsList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchJobsAsync(Integer limit, String jobname, String jobid, String ctm, String server, String folder, String fromTime, String toTime, String logContains, String outputContains, String application, String subApplication, String library, String memName, String memLibrary, String host, String hostGroup, String runAs, String orderId, String status, String orderDateFrom, String orderDateTo, Long numberOfRuns, final ApiCallback<ArchiveJobsList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchJobsValidateBeforeCall(limit, jobname, jobid, ctm, server, folder, fromTime, toTime, logContains, outputContains, application, subApplication, library, memName, memLibrary, host, hostGroup, runAs, orderId, status, orderDateFrom, orderDateTo, numberOfRuns, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArchiveJobsList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

