/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import java.net.Proxy;

public final class RequestLine {
    private RequestLine() {
    }

    static String get(Request request, Proxy.Type proxyType) {
        StringBuilder result2 = new StringBuilder();
        result2.append(request.method());
        result2.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request, proxyType)) {
            result2.append(request.httpUrl());
        } else {
            result2.append(RequestLine.requestPath(request.httpUrl()));
        }
        result2.append(" HTTP/1.1");
        return result2.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(HttpUrl url2) {
        String path = url2.encodedPath();
        String query = url2.encodedQuery();
        return query != null ? path + '?' + query : path;
    }
}

