/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVWriter;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.MappingUtils;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class StatefulBeanToCsv<T> {
    private int lineNumber = 0;
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final String lineEnd;
    private boolean headerWritten = false;
    private MappingStrategy<T> mappingStrategy;
    private final Writer writer;
    private CSVWriter csvwriter;
    private boolean throwExceptions;
    private List<CsvException> capturedExceptions = new ArrayList<CsvException>();
    private static final String INTROSPECTION_ERROR = "There was an error while manipulating the bean to be written.";

    private StatefulBeanToCsv() {
        throw new IllegalStateException("This class may never be instantiated with the nullary constructor.");
    }

    public StatefulBeanToCsv(char escapechar, String lineEnd, MappingStrategy<T> mappingStrategy, char quotechar, char separator, boolean throwExceptions, Writer writer) {
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
        this.mappingStrategy = mappingStrategy;
        this.quotechar = quotechar;
        this.separator = separator;
        this.throwExceptions = throwExceptions;
        this.writer = writer;
    }

    private void beforeFirstWrite(T bean) {
        if (this.mappingStrategy == null) {
            this.mappingStrategy = MappingUtils.determineMappingStrategy(bean.getClass());
        }
        this.csvwriter = new CSVWriter(this.writer, this.separator, this.quotechar, this.escapechar, this.lineEnd);
        String[] header = this.mappingStrategy.generateHeader();
        if (header.length > 0) {
            this.csvwriter.writeNext(header);
        }
        this.headerWritten = true;
    }

    public void write(T bean) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        if (bean != null) {
            ++this.lineNumber;
            if (!this.headerWritten) {
                this.beforeFirstWrite(bean);
            }
            ArrayList<String> contents = new ArrayList<String>();
            int numColumns = this.mappingStrategy.findMaxFieldIndex();
            if (this.mappingStrategy.isAnnotationDriven()) {
                for (int i = 0; i <= numColumns; ++i) {
                    BeanField beanField = this.mappingStrategy.findField(i);
                    try {
                        String s2 = beanField != null ? beanField.write(bean) : "";
                        contents.add(StringUtils.defaultString(s2));
                        continue;
                    }
                    catch (CsvDataTypeMismatchException e) {
                        e.setLineNumber(this.lineNumber);
                        if (this.throwExceptions) {
                            throw e;
                        }
                        this.capturedExceptions.add(e);
                        continue;
                    }
                    catch (CsvRequiredFieldEmptyException e) {
                        e.setLineNumber(this.lineNumber);
                        if (this.throwExceptions) {
                            throw e;
                        }
                        this.capturedExceptions.add(e);
                    }
                }
            } else {
                for (int i = 0; i <= numColumns; ++i) {
                    try {
                        PropertyDescriptor desc = this.mappingStrategy.findDescriptor(i);
                        Object o = desc != null ? desc.getReadMethod().invoke(bean, (Object[])null) : null;
                        contents.add(ObjectUtils.toString(o, ""));
                        continue;
                    }
                    catch (IntrospectionException e) {
                        CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean, null, INTROSPECTION_ERROR);
                        csve.initCause(e);
                        throw csve;
                    }
                    catch (IllegalAccessException e) {
                        CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean, null, INTROSPECTION_ERROR);
                        csve.initCause(e);
                        throw csve;
                    }
                    catch (InvocationTargetException e) {
                        CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(bean, null, INTROSPECTION_ERROR);
                        csve.initCause(e);
                        throw csve;
                    }
                }
            }
            this.csvwriter.writeNext(contents.toArray(new String[contents.size()]));
        }
    }

    public void write(List<T> beans) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        if (CollectionUtils.isNotEmpty(beans)) {
            for (T bean : beans) {
                this.write(bean);
            }
        }
    }

    public boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    public List<CsvException> getCapturedExceptions() {
        List<CsvException> intermediate = this.capturedExceptions;
        this.capturedExceptions = new ArrayList<CsvException>();
        return intermediate;
    }
}

