/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldDate;
import com.opencsv.bean.BeanFieldPrimitiveTypes;
import com.opencsv.bean.CsvBind;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvCustomBindByName;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    protected String[] header;
    protected Map<String, Integer> indexLookup = new HashMap<String, Integer>();
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Map<String, BeanField> fieldMap = null;
    protected final List<Field> requiredFields = new ArrayList<Field>();
    protected List<Field> copyOfRequiredFields;
    protected Class<? extends T> type;
    protected boolean annotationDriven;
    private static final String CANNOT_INSTANTIATE = "There was a problem instantiating the custom converter ";
    private static final String TYPE_NOT_SET = "The type has not been set in the MappingStrategy.";

    @Override
    public void captureHeader(CSVReader reader) throws IOException, CsvRequiredFieldEmptyException {
        if (this.type == null) {
            throw new IllegalStateException(TYPE_NOT_SET);
        }
        this.header = reader.readNext();
        ArrayList<String> requiredKeys = new ArrayList<String>();
        for (Map.Entry<String, BeanField> entrySet : this.fieldMap.entrySet()) {
            BeanField beanField = entrySet.getValue();
            if (!beanField.isRequired()) continue;
            requiredKeys.add(entrySet.getKey().toUpperCase());
        }
        if (requiredKeys.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.header.length && !requiredKeys.isEmpty(); ++i) {
            requiredKeys.remove(this.header[i].toUpperCase());
        }
        if (!requiredKeys.isEmpty()) {
            StrBuilder builder = new StrBuilder(128);
            String missingRequiredFields = builder.appendWithSeparators(requiredKeys, ",").toString();
            throw new CsvRequiredFieldEmptyException(this.type, this.fieldMap.get(requiredKeys.get(0)).getField(), String.format("Header is missing required fields [%s]", missingRequiredFields));
        }
    }

    @Override
    public void registerBeginningOfRecordForReading() {
        this.copyOfRequiredFields = new ArrayList<Field>(this.requiredFields);
    }

    @Override
    public void registerEndOfRecordForReading() throws CsvRequiredFieldEmptyException {
        if (!this.copyOfRequiredFields.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following required fields were not present for one record of the input:");
            for (Field f2 : this.copyOfRequiredFields) {
                sb.append(' ');
                sb.append(f2.getName());
            }
            throw new CsvRequiredFieldEmptyException(this.type, sb.toString());
        }
    }

    @Override
    public String[] generateHeader() {
        if (this.header == null) {
            if (this.fieldMap == null) {
                this.loadFields(this.type);
            }
            TreeSet<String> set = new TreeSet<String>(this.fieldMap.keySet());
            this.header = set.toArray(new String[this.fieldMap.size()]);
        }
        return ArrayUtils.clone(this.header);
    }

    protected void createIndexLookup(String[] values2) {
        if (this.indexLookup.isEmpty()) {
            for (int i = 0; i < values2.length; ++i) {
                this.indexLookup.put(values2[i], i);
            }
        }
    }

    protected void resetIndexMap() {
        this.indexLookup.clear();
    }

    @Override
    public Integer getColumnIndex(String name) {
        if (null == this.header) {
            throw new IllegalStateException("The header row hasn't been read yet.");
        }
        this.createIndexLookup(this.header);
        return this.indexLookup.get(name);
    }

    @Override
    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        BeanField beanField = null;
        if (StringUtils.isNotBlank(columnName)) {
            beanField = this.fieldMap.get(columnName.toUpperCase().trim());
            if (CollectionUtils.isNotEmpty(this.copyOfRequiredFields) && beanField != null) {
                this.copyOfRequiredFields.remove(beanField.getField());
            }
        }
        if (beanField != null) {
            return this.findDescriptor(beanField.getField().getName());
        }
        if (StringUtils.isNotBlank(columnName)) {
            return this.findDescriptor(columnName);
        }
        return null;
    }

    @Override
    public BeanField findField(int col) throws CsvBadConverterException {
        BeanField beanField = null;
        String columnName = this.getColumnName(col);
        if (StringUtils.isNotBlank(columnName)) {
            beanField = this.fieldMap.get(columnName.toUpperCase().trim());
            if (CollectionUtils.isNotEmpty(this.copyOfRequiredFields) && beanField != null) {
                this.copyOfRequiredFields.remove(beanField.getField());
            }
        }
        return beanField;
    }

    @Override
    public int findMaxFieldIndex() {
        return this.header == null ? -1 : this.header.length - 1;
    }

    public String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name) throws IntrospectionException {
        if (null == this.descriptorMap) {
            this.descriptorMap = this.loadDescriptorMap();
        }
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map2 = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor2 : descriptors = this.loadDescriptors(this.getType())) {
            map2.put(descriptor2.getName().toUpperCase(), descriptor2);
        }
        return map2;
    }

    protected BeanField instantiateCustomConverter(Class<? extends AbstractBeanField> converter) throws CsvBadConverterException {
        try {
            return converter.newInstance();
        }
        catch (IllegalAccessException oldEx) {
            CsvBadConverterException newEx = new CsvBadConverterException(converter, CANNOT_INSTANTIATE + converter.getCanonicalName());
            newEx.initCause(oldEx);
            throw newEx;
        }
        catch (InstantiationException oldEx) {
            CsvBadConverterException newEx = new CsvBadConverterException(converter, CANNOT_INSTANTIATE + converter.getCanonicalName());
            newEx.initCause(oldEx);
            throw newEx;
        }
    }

    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap<String, BeanField>();
        this.requiredFields.clear();
        for (Field field : this.loadFields(this.getType())) {
            boolean required;
            String columnName;
            Annotation annotation;
            if (field.isAnnotationPresent(CsvCustomBindByName.class)) {
                annotation = field.getAnnotation(CsvCustomBindByName.class);
                columnName = annotation.column().toUpperCase().trim();
                if (StringUtils.isEmpty(columnName)) {
                    columnName = field.getName().toUpperCase();
                }
                Class<? extends AbstractBeanField> converter = field.getAnnotation(CsvCustomBindByName.class).converter();
                BeanField bean = this.instantiateCustomConverter(converter);
                bean.setField(field);
                required = annotation.required();
                bean.setRequired(required);
                this.fieldMap.put(columnName, bean);
            } else if (field.isAnnotationPresent(CsvBindByName.class)) {
                annotation = field.getAnnotation(CsvBindByName.class);
                required = annotation.required();
                columnName = annotation.column().toUpperCase().trim();
                String locale = annotation.locale();
                if (field.isAnnotationPresent(CsvDate.class)) {
                    String formatString = field.getAnnotation(CsvDate.class).value();
                    if (StringUtils.isEmpty(columnName)) {
                        this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldDate(field, required, formatString, locale));
                    } else {
                        this.fieldMap.put(columnName, new BeanFieldDate(field, required, formatString, locale));
                    }
                } else if (StringUtils.isEmpty(columnName)) {
                    this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldPrimitiveTypes(field, required, locale));
                } else {
                    this.fieldMap.put(columnName, new BeanFieldPrimitiveTypes(field, required, locale));
                }
            } else {
                required = field.getAnnotation(CsvBind.class).required();
                this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldPrimitiveTypes(field, required, null));
            }
            if (!required) continue;
            this.requiredFields.add(field);
        }
    }

    private PropertyDescriptor[] loadDescriptors(Class<? extends T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> fields2 = new ArrayList<Field>();
        for (Field field : FieldUtils.getAllFields(cls)) {
            if (!field.isAnnotationPresent(CsvBind.class) && !field.isAnnotationPresent(CsvBindByName.class) && !field.isAnnotationPresent(CsvCustomBindByName.class)) continue;
            fields2.add(field);
        }
        this.annotationDriven = !fields2.isEmpty();
        return fields2;
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException, IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException(TYPE_NOT_SET);
        }
        return this.type.newInstance();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        this.type = type;
        this.loadFieldMap();
    }

    @Override
    public boolean isAnnotationDriven() {
        return this.annotationDriven;
    }
}

