/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.MappingUtils;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.Reader;

public class CsvToBeanBuilder<T> {
    private MappingStrategy<T> mappingStrategy = null;
    private final Reader reader;
    private CsvToBeanFilter filter = null;
    private boolean throwExceptions = true;
    private CSVReaderNullFieldIndicator nullFieldIndicator = null;
    private boolean keepCR;
    private Integer skipLines = null;
    private Boolean verifyReader = null;
    private Character separator = null;
    private Character quoteChar = null;
    private Character escapeChar = null;
    private Boolean strictQuotes = null;
    private Boolean ignoreLeadingWhiteSpace = null;
    private Boolean ignoreQuotations = null;
    private Class<? extends T> type = null;
    private Integer multilineLimit = null;

    private CsvToBeanBuilder() {
        this.reader = null;
        throw new IllegalStateException("The nullary constructor may never be used in CsvToBeanBuilder.");
    }

    public CsvToBeanBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("The Reader must always be non-null.");
        }
        this.reader = reader;
    }

    public CsvToBean build() throws IllegalStateException {
        if (this.mappingStrategy == null && this.type == null) {
            throw new IllegalStateException("Either a mapping strategy or the type of the bean to be populated must be specified.");
        }
        CsvToBean<T> bean = new CsvToBean<T>();
        CSVParser parser = this.buildParser();
        bean.setCsvReader(this.buildReader(parser));
        bean.setThrowExceptions(this.throwExceptions);
        if (this.filter != null) {
            bean.setFilter(this.filter);
        }
        if (this.mappingStrategy == null) {
            this.mappingStrategy = MappingUtils.determineMappingStrategy(this.type);
        }
        bean.setMappingStrategy(this.mappingStrategy);
        return bean;
    }

    private CSVParser buildParser() {
        CSVParserBuilder csvpb = new CSVParserBuilder();
        if (this.nullFieldIndicator != null) {
            csvpb.withFieldAsNull(this.nullFieldIndicator);
        }
        if (this.separator != null) {
            csvpb.withSeparator(this.separator.charValue());
        }
        if (this.quoteChar != null) {
            csvpb.withQuoteChar(this.quoteChar.charValue());
        }
        if (this.escapeChar != null) {
            csvpb.withEscapeChar(this.escapeChar.charValue());
        }
        if (this.strictQuotes != null) {
            csvpb.withStrictQuotes(this.strictQuotes);
        }
        if (this.ignoreLeadingWhiteSpace != null) {
            csvpb.withIgnoreLeadingWhiteSpace(this.ignoreLeadingWhiteSpace);
        }
        if (this.ignoreQuotations != null) {
            csvpb.withIgnoreQuotations(this.ignoreQuotations);
        }
        return csvpb.build();
    }

    private CSVReader buildReader(CSVParser parser) {
        CSVReaderBuilder csvrb = new CSVReaderBuilder(this.reader);
        csvrb.withCSVParser(parser);
        csvrb.withKeepCarriageReturn(this.keepCR);
        if (this.verifyReader != null) {
            csvrb.withVerifyReader(this.verifyReader);
        }
        if (this.skipLines != null) {
            csvrb.withSkipLines(this.skipLines);
        }
        if (this.multilineLimit != null) {
            csvrb.withMultilineLimit(this.multilineLimit);
        }
        return csvrb.build();
    }

    public CsvToBeanBuilder withMappingStrategy(MappingStrategy<T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        return this;
    }

    public CsvToBeanBuilder withFilter(CsvToBeanFilter filter2) {
        this.filter = filter2;
        return this;
    }

    public CsvToBeanBuilder withThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
        return this;
    }

    public CsvToBeanBuilder withFieldAsNull(CSVReaderNullFieldIndicator indicator) {
        this.nullFieldIndicator = indicator;
        return this;
    }

    public CsvToBeanBuilder withKeepCarriageReturn(boolean keepCR) {
        this.keepCR = keepCR;
        return this;
    }

    public CsvToBeanBuilder withVerifyReader(boolean verifyReader) {
        this.verifyReader = verifyReader;
        return this;
    }

    public CsvToBeanBuilder withSkipLines(int skipLines) {
        this.skipLines = skipLines;
        return this;
    }

    public CsvToBeanBuilder withSeparator(char separator) {
        this.separator = Character.valueOf(separator);
        return this;
    }

    public CsvToBeanBuilder withQuoteChar(char quoteChar) {
        this.quoteChar = Character.valueOf(quoteChar);
        return this;
    }

    public CsvToBeanBuilder withEscapeChar(char escapeChar) {
        this.escapeChar = Character.valueOf(escapeChar);
        return this;
    }

    public CsvToBeanBuilder withStrictQuotes(boolean strictQuotes) {
        this.strictQuotes = strictQuotes;
        return this;
    }

    public CsvToBeanBuilder withIgnoreLeadingWhiteSpace(boolean ignoreLeadingWhiteSpace) {
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        return this;
    }

    public CsvToBeanBuilder withIgnoreQuotations(boolean ignoreQuotations) {
        this.ignoreQuotations = ignoreQuotations;
        return this;
    }

    public CsvToBeanBuilder withType(Class<? extends T> type) {
        this.type = type;
        return this;
    }

    public CsvToBeanBuilder withMultilineLimit(int multilineLimit) {
        this.multilineLimit = multilineLimit;
        return this;
    }
}

