/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.Field;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldPrimitiveTypes<T>
extends AbstractBeanField<T> {
    private final String locale;

    public BeanFieldPrimitiveTypes(Field field, boolean required, String locale) {
        super(field, required);
        this.locale = locale;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        Object o = null;
        if (StringUtils.isNotBlank(value)) {
            try {
                if (StringUtils.isEmpty(this.locale)) {
                    ConvertUtilsBean converter = new ConvertUtilsBean();
                    converter.register(true, false, 0);
                    o = converter.convert(value, this.field.getType());
                } else {
                    LocaleConvertUtilsBean lcub = new LocaleConvertUtilsBean();
                    lcub.setDefaultLocale(new Locale(this.locale));
                    o = lcub.convert(value, this.field.getType());
                }
            }
            catch (ConversionException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, this.field.getType(), "Conversion of " + value + " to " + this.field.getType().getCanonicalName() + " failed.");
                csve.initCause(e);
                throw csve;
            }
        }
        return o;
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String result2 = null;
        if (value != null) {
            try {
                if (StringUtils.isEmpty(this.locale)) {
                    ConvertUtilsBean converter = new ConvertUtilsBean();
                    result2 = converter.convert(value);
                } else {
                    LocaleConvertUtilsBean converter = new LocaleConvertUtilsBean();
                    converter.setDefaultLocale(new Locale(this.locale));
                    result2 = converter.convert(value);
                }
            }
            catch (ConversionException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException("The field must be primitive, boxed primitive, BigDecimal, BigInteger or String types only.");
                csve.initCause(e);
                throw csve;
            }
        }
        return result2;
    }
}

