/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class NaturalCubicSpline
extends ParametricCurve {
    private static double[][] pt = new double[0][];
    private static double[][] data = new double[0][];
    private static int ci = 0;
    private boolean closed = false;

    public NaturalCubicSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    protected void eval(double[] p) {
        int n = p.length - 1;
        double t = p[n];
        double t2 = t * t;
        double t3 = t2 * t;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            p[i] = data[j++][ci] + data[j++][ci] * t + data[j++][ci] * t2 + data[j++][ci] * t3;
        }
    }

    private static void precalc(int n, int dim, boolean closed) {
        --n;
        double[] a = data[4 * dim];
        double[] b = data[4 * dim + 1];
        double[] c = data[4 * dim + 2];
        int k = 0;
        if (closed) {
            double[] d = data[4 * dim + 3];
            for (int j = 0; j < dim; ++j) {
                int i;
                double e = 0.25;
                a[1] = 0.25;
                d[1] = 0.25;
                b[0] = e * 3.0 * (pt[1][j] - pt[n][j]);
                double h = 4.0;
                double f2 = 3.0 * (pt[0][j] - pt[n - 1][j]);
                double g = 1.0;
                for (i = 1; i < n; ++i) {
                    a[i + 1] = e = 1.0 / (4.0 - a[i]);
                    d[i + 1] = -e * d[i];
                    b[i] = e * (3.0 * (pt[i + 1][j] - pt[i - 1][j]) - b[i - 1]);
                    h -= g * d[i];
                    f2 -= g * b[i - 1];
                    g = -a[i] * g;
                }
                b[n] = f2 - (g + 1.0) * b[n - 1];
                c[n] = b[n] / (h -= (g + 1.0) * (a[n] + d[n]));
                c[n - 1] = b[n - 1] - (a[n] + d[n]) * c[n];
                for (i = n - 2; i >= 0; --i) {
                    c[i] = b[i] - a[i + 1] * c[i + 1] - d[i + 1] * c[n];
                }
                double[] w = data[k++];
                double[] x = data[k++];
                double[] y = data[k++];
                double[] z = data[k++];
                for (int i2 = 0; i2 < n; ++i2) {
                    w[i2] = pt[i2][j];
                    x[i2] = c[i2];
                    y[i2] = 3.0 * (pt[i2 + 1][j] - pt[i2][j]) - 2.0 * c[i2] - c[i2 + 1];
                    z[i2] = 2.0 * (pt[i2][j] - pt[i2 + 1][j]) + c[i2] + c[i2 + 1];
                }
                w[n] = pt[n][j];
                x[n] = c[n];
                y[n] = 3.0 * (pt[0][j] - pt[n][j]) - 2.0 * c[n] - c[0];
                z[n] = 2.0 * (pt[n][j] - pt[0][j]) + c[n] + c[0];
            }
        } else {
            for (int j = 0; j < dim; ++j) {
                int i;
                a[0] = 0.5;
                for (i = 1; i < n; ++i) {
                    a[i] = 1.0 / (4.0 - a[i - 1]);
                }
                a[n] = 1.0 / (2.0 - a[n - 1]);
                b[0] = a[0] * (3.0 * (pt[1][j] - pt[0][j]));
                for (i = 1; i < n; ++i) {
                    b[i] = a[i] * (3.0 * (pt[i + 1][j] - pt[i - 1][j]) - b[i - 1]);
                }
                b[n] = a[n] * (3.0 * (pt[n][j] - pt[n - 1][j]) - b[n - 1]);
                c[n] = b[n];
                for (i = n - 1; i >= 0; --i) {
                    c[i] = b[i] - a[i] * c[i + 1];
                }
                double[] w = data[k++];
                double[] x = data[k++];
                double[] y = data[k++];
                double[] z = data[k++];
                for (int i3 = 0; i3 < n; ++i3) {
                    w[i3] = pt[i3][j];
                    x[i3] = c[i3];
                    y[i3] = 3.0 * (pt[i3 + 1][j] - pt[i3][j]) - 2.0 * c[i3] - c[i3 + 1];
                    z[i3] = 2.0 * (pt[i3][j] - pt[i3 + 1][j]) + c[i3] + c[i3 + 1];
                }
                w[n] = pt[n][j];
                x[n] = 0.0;
                y[n] = 0.0;
                z[n] = 0.0;
            }
        }
    }

    public void setClosed(boolean b) {
        this.closed = b;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public int getSampleLimit() {
        return 1;
    }

    public void appendTo(MultiPath mp) {
        int i;
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int n = this.gi.getGroupSize();
        if (n < 2) {
            throw new IllegalArgumentException("Group iterator size < 2");
        }
        int dim = mp.getDimension();
        int x = 3 + 4 * dim + 1;
        if (data.length < x) {
            double[][] temp = new double[x][];
            for (i = 0; i < data.length; ++i) {
                temp[i] = data[i];
            }
            data = temp;
        }
        if (pt.length < n) {
            int m = 2 * n;
            pt = new double[m][];
            for (i = 0; i < data.length; ++i) {
                NaturalCubicSpline.data[i] = new double[m];
            }
        }
        this.gi.set(0, 0);
        for (int i2 = 0; i2 < n; ++i2) {
            NaturalCubicSpline.pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
        }
        NaturalCubicSpline.precalc(n, dim, this.closed);
        ci = 0;
        double[] p = new double[dim + 1];
        this.eval(p);
        if (this.connect) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        i = 0;
        while (i < n) {
            ci = i++;
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
        }
    }

    public void resetMemory() {
        if (pt.length > 0) {
            pt = new double[0][];
        }
        if (data.length > 0) {
            data = new double[0][];
        }
    }
}

