/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.io;

import com.bmc.ctmconvert.UtilsKt;
import com.bmc.ctmconvert.generated.json.models.base.BaseJsonObject;
import com.bmc.ctmconvert.generated.json.models.folder.RegularFolder;
import com.bmc.ctmconvert.generated.json.models.folder.SimpleFolder;
import com.bmc.ctmconvert.generated.json.models.if_schema.CompletionStatus;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfCompletionStatus;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Event;
import com.bmc.ctmconvert.io.IJsonWriter;
import com.bmc.ctmconvert.io.IPrinter;
import com.bmc.ctmconvert.models.HighLevelCtmEntity;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J<\u0010\u0012\u001a\u00020\u000b2\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\rH\u0016J(\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J4\u0010\u001b\u001a\u00020\u000b2\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u0018\u001a\u00020\rH\u0002J6\u0010\u001c\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u001f2\b\u0010!\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/bmc/ctmconvert/io/JsonWriterImpl;", "Lcom/bmc/ctmconvert/io/IJsonWriter;", "printer", "Lcom/bmc/ctmconvert/io/IPrinter;", "outputDirectory", "Ljava/nio/file/Path;", "<init>", "(Lcom/bmc/ctmconvert/io/IPrinter;Ljava/nio/file/Path;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "setJobOrSubFolder", "", "parentFolder", "Lcom/bmc/ctmconvert/generated/json/models/base/BaseJsonObject;", "jobOrSubFolder", "", "", "Lkotlinx/serialization/json/JsonElement;", "flushJobsToFile", "jobsToAddInNewFolder", "Ljava/util/HashMap;", "Lcom/bmc/ctmconvert/models/HighLevelCtmEntity;", "Lkotlin/collections/HashMap;", "folderName", "newFolder", "writeFolderToOutputDirectory", "folder", "writeJobsToFolder", "createNewFolderAndCopyMandatoryFields", "Lkotlinx/serialization/json/JsonObject;", "eventsToWaitFor", "", "eventToAdd", "endedNotOkInCondition", "splitLargeFolder"})
@SourceDebugExtension(value={"SMAP\nJsonWriterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonWriterImpl.kt\ncom/bmc/ctmconvert/io/JsonWriterImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n136#2,9:117\n216#2:126\n217#2:128\n145#2:129\n1#3:127\n1#3:132\n1863#4,2:130\n*S KotlinDebug\n*F\n+ 1 JsonWriterImpl.kt\ncom/bmc/ctmconvert/io/JsonWriterImpl\n*L\n60#1:117,9\n60#1:126\n60#1:128\n60#1:129\n60#1:127\n60#1:130,2\n*E\n"})
public final class JsonWriterImpl
implements IJsonWriter {
    @NotNull
    private final IPrinter printer;
    @NotNull
    private final Path outputDirectory;
    @NotNull
    private final ObjectMapper objectMapper;

    public JsonWriterImpl(@NotNull IPrinter printer, @NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter(printer, "printer");
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        this.printer = printer;
        this.outputDirectory = outputDirectory;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void setJobOrSubFolder(@NotNull BaseJsonObject parentFolder, @NotNull Map.Entry<String, ? extends JsonElement> jobOrSubFolder) {
        Intrinsics.checkNotNullParameter(parentFolder, "parentFolder");
        Intrinsics.checkNotNullParameter(jobOrSubFolder, "jobOrSubFolder");
        Map<String, Object> map2 = parentFolder.getAdditionalProperties();
        Intrinsics.checkNotNullExpressionValue(map2, "getAdditionalProperties(...)");
        Map<String, Object> map3 = map2;
        String string = jobOrSubFolder.getKey();
        ObjectNode objectNode = UtilsKt.convertToObjectNode(JsonElementKt.getJsonObject(jobOrSubFolder.getValue()));
        map3.put(string, objectNode);
    }

    @Override
    public void flushJobsToFile(@NotNull HashMap<String, HighLevelCtmEntity> jobsToAddInNewFolder, @NotNull String folderName, @NotNull BaseJsonObject newFolder) {
        Intrinsics.checkNotNullParameter(jobsToAddInNewFolder, "jobsToAddInNewFolder");
        Intrinsics.checkNotNullParameter(folderName, "folderName");
        Intrinsics.checkNotNullParameter(newFolder, "newFolder");
        this.writeJobsToFolder(jobsToAddInNewFolder, newFolder);
        jobsToAddInNewFolder.clear();
        this.writeFolderToOutputDirectory(newFolder, folderName, this.outputDirectory, this.printer);
    }

    @Override
    public void writeFolderToOutputDirectory(@NotNull BaseJsonObject folder, @NotNull String folderName, @NotNull Path outputDirectory, @NotNull IPrinter printer) {
        Path path;
        Intrinsics.checkNotNullParameter(folder, "folder");
        Intrinsics.checkNotNullParameter(folderName, "folderName");
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        Intrinsics.checkNotNullParameter(printer, "printer");
        printer.printToNewLine("Creating " + folderName + " folder...");
        Object folderDefinition = this.objectMapper.valueToTree(folder);
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        Intrinsics.checkNotNullExpressionValue(objectNode, "createObjectNode(...)");
        ObjectNode foldersList = objectNode;
        foldersList.put(folderName, (JsonNode)folderDefinition);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createDirectories(outputDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue(path2, "createDirectories(...)");
        Path it = path = path2.resolve(folderName + ".json");
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        String string = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(foldersList);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        PathsKt.writeText$default(it, string, null, new OpenOption[0], 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeJobsToFolder(HashMap<String, HighLevelCtmEntity> jobsToAddInNewFolder, BaseJsonObject newFolder) {
        void $this$forEach$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        ArrayNode jobsArray = new ObjectMapper().createArrayNode();
        Object $this$mapNotNull$iv = jobsToAddInNewFolder;
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            HighLevelCtmEntity it$iv$iv;
            element$iv$iv$iv = object2.next();
            Map.Entry element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if ((HighLevelCtmEntity)it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            void it;
            HighLevelCtmEntity jobOrSubFolderToAdd = (HighLevelCtmEntity)element$iv;
            boolean bl = false;
            String type = jobOrSubFolderToAdd.getType();
            if (Intrinsics.areEqual(type, "SubFolder")) {
                Intrinsics.checkNotNullExpressionValue(newFolder.getAdditionalProperties(), "getAdditionalProperties(...)");
                element$iv$iv$iv = jobOrSubFolderToAdd.getOriginalName();
                ObjectNode element$iv$iv = UtilsKt.convertToObjectNode(JsonElementKt.getJsonObject(jobOrSubFolderToAdd.getJsonElement()));
                object2.put(element$iv$iv$iv, element$iv$iv);
                continue;
            }
            if (!StringsKt.startsWith$default(type, "Job:", false, 2, null)) continue;
            element$iv$iv$iv = object2 = UtilsKt.convertToObjectNode(JsonElementKt.getJsonObject(jobOrSubFolderToAdd.getJsonElement()));
            ArrayNode arrayNode = jobsArray;
            boolean bl4 = false;
            it.put("Name", jobOrSubFolderToAdd.getOriginalName());
            arrayNode.add((JsonNode)object2);
        }
        Map<String, Object> map2 = newFolder.getAdditionalProperties();
        Intrinsics.checkNotNullExpressionValue(map2, "getAdditionalProperties(...)");
        Map<String, Object> map3 = map2;
        map3.put("Jobs", jobsArray);
    }

    @Override
    @NotNull
    public BaseJsonObject createNewFolderAndCopyMandatoryFields(@NotNull JsonObject parentFolder, @NotNull List<String> eventsToWaitFor, @NotNull List<String> eventToAdd, @Nullable String endedNotOkInCondition) {
        JsonNode jsonNode;
        RegularFolder regularFolder;
        Intrinsics.checkNotNullParameter(parentFolder, "parentFolder");
        Intrinsics.checkNotNullParameter(eventsToWaitFor, "eventsToWaitFor");
        Intrinsics.checkNotNullParameter(eventToAdd, "eventToAdd");
        if (UtilsKt.isSimpleFolder(parentFolder)) {
            SimpleFolder simpleFolder;
            SimpleFolder folder = simpleFolder = new SimpleFolder();
            boolean bl = false;
            folder.withType(SimpleFolder.Type.SIMPLE_FOLDER);
            UtilsKt.setOrderMethod(folder, parentFolder);
            UtilsKt.setControlMServer(folder, parentFolder);
            UtilsKt.setSiteStandard(folder, parentFolder);
            return simpleFolder;
        }
        RegularFolder folder = regularFolder = new RegularFolder();
        boolean bl = false;
        folder.withType(RegularFolder.Type.FOLDER);
        UtilsKt.setOrderMethod(folder, parentFolder);
        UtilsKt.setControlMServer(folder, parentFolder);
        UtilsKt.setDaysToKeepActiveIfNotOk(folder, parentFolder);
        UtilsKt.setAdjustEvent(folder, parentFolder);
        UtilsKt.setSiteStandard(folder, parentFolder);
        UtilsKt.setCreatedBy(folder, parentFolder);
        Map<String, Object> map2 = folder.getAdditionalProperties();
        Intrinsics.checkNotNullExpressionValue(map2, "getAdditionalProperties(...)");
        Map<String, Object> map3 = map2;
        Object object = "When";
        JsonElement jsonElement = (JsonElement)parentFolder.get((Object)"When");
        if (jsonElement != null) {
            JsonElement it = jsonElement;
            boolean bl2 = false;
            jsonNode = UtilsKt.getWhenScheduling(it);
        } else {
            jsonNode = null;
        }
        JsonNode jsonNode2 = jsonNode;
        map3.put((String)object, jsonNode2);
        folder.withEventsToWaitFor(UtilsKt.createWaitForEvents(eventsToWaitFor));
        folder.withEventsToAdd(UtilsKt.createAddEvents(eventToAdd));
        if (endedNotOkInCondition != null) {
            Map<String, Object> map4 = folder.getAdditionalProperties();
            Intrinsics.checkNotNullExpressionValue(map4, "getAdditionalProperties(...)");
            map3 = map4;
            Object it = object = new IfCompletionStatus().withCompletionStatus((Object)CompletionStatus.NOTOK).withType(IfCompletionStatus.Type.IF_COMPLETION_STATUS);
            boolean bl3 = false;
            Map<String, Object> map5 = ((IfCompletionStatus)it).getAdditionalProperties();
            Intrinsics.checkNotNullExpressionValue(map5, "getAdditionalProperties(...)");
            Map<String, Object> map6 = map5;
            String string = "Event:Add_0";
            Event event = new Event().withType(Event.Type.EVENT_ADD).withEvent(endedNotOkInCondition);
            map6.put(string, event);
            map3.put(endedNotOkInCondition, object);
        }
        return regularFolder;
    }
}

