/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.generated.json.models.notifications;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"Type", "Message", "Destination", "Urgency", "By", "Days", "Criteria", "Value"})
public class Notify {
    @JsonProperty(value="Type")
    private Type type;
    @JsonProperty(value="Message")
    private String message;
    @JsonProperty(value="Destination")
    private String destination;
    @JsonProperty(value="Urgency")
    private Urgency urgency = Urgency.fromValue("Regular");
    @JsonProperty(value="By")
    private String by;
    @JsonProperty(value="Days")
    private String days;
    @JsonProperty(value="Criteria")
    private Criteria criteria;
    @JsonProperty(value="Value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="Type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="Type")
    public void setType(Type type) {
        this.type = type;
    }

    public Notify withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="Message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="Message")
    public void setMessage(String message) {
        this.message = message;
    }

    public Notify withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="Destination")
    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="Destination")
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Notify withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    @JsonProperty(value="Urgency")
    public Urgency getUrgency() {
        return this.urgency;
    }

    @JsonProperty(value="Urgency")
    public void setUrgency(Urgency urgency) {
        this.urgency = urgency;
    }

    public Notify withUrgency(Urgency urgency) {
        this.urgency = urgency;
        return this;
    }

    @JsonProperty(value="By")
    public String getBy() {
        return this.by;
    }

    @JsonProperty(value="By")
    public void setBy(String by) {
        this.by = by;
    }

    public Notify withBy(String by) {
        this.by = by;
        return this;
    }

    @JsonProperty(value="Days")
    public String getDays() {
        return this.days;
    }

    @JsonProperty(value="Days")
    public void setDays(String days) {
        this.days = days;
    }

    public Notify withDays(String days) {
        this.days = days;
        return this;
    }

    @JsonProperty(value="Criteria")
    public Criteria getCriteria() {
        return this.criteria;
    }

    @JsonProperty(value="Criteria")
    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public Notify withCriteria(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    @JsonProperty(value="Value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="Value")
    public void setValue(String value) {
        this.value = value;
    }

    public Notify withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Notify withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Notify.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("destination");
        sb.append('=');
        sb.append(this.destination == null ? "<null>" : this.destination);
        sb.append(',');
        sb.append("urgency");
        sb.append('=');
        sb.append(this.urgency == null ? "<null>" : this.urgency);
        sb.append(',');
        sb.append("by");
        sb.append('=');
        sb.append(this.by == null ? "<null>" : this.by);
        sb.append(',');
        sb.append("days");
        sb.append('=');
        sb.append(this.days == null ? "<null>" : this.days);
        sb.append(',');
        sb.append("criteria");
        sb.append('=');
        sb.append(this.criteria == null ? "<null>" : this.criteria);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result2 = 1;
        result2 = result2 * 31 + (this.urgency == null ? 0 : this.urgency.hashCode());
        result2 = result2 * 31 + (this.criteria == null ? 0 : this.criteria.hashCode());
        result2 = result2 * 31 + (this.by == null ? 0 : this.by.hashCode());
        result2 = result2 * 31 + (this.destination == null ? 0 : this.destination.hashCode());
        result2 = result2 * 31 + (this.days == null ? 0 : this.days.hashCode());
        result2 = result2 * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
        result2 = result2 * 31 + (this.message == null ? 0 : this.message.hashCode());
        result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result2;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Notify)) {
            return false;
        }
        Notify rhs = (Notify)other;
        return (this.urgency == rhs.urgency || this.urgency != null && this.urgency.equals((Object)rhs.urgency)) && (this.criteria == rhs.criteria || this.criteria != null && this.criteria.equals((Object)rhs.criteria)) && (this.by == rhs.by || this.by != null && this.by.equals(rhs.by)) && (this.destination == rhs.destination || this.destination != null && this.destination.equals(rhs.destination)) && (this.days == rhs.days || this.days != null && this.days.equals(rhs.days)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }

    public static enum Urgency {
        REGULAR("Regular"),
        URGENT("Urgent"),
        VERY_URGENT("VeryUrgent");

        private final String value;
        private static final Map<String, Urgency> CONSTANTS;

        private Urgency(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Urgency fromValue(String value) {
            Urgency constant2 = CONSTANTS.get(value);
            if (constant2 == null) {
                throw new IllegalArgumentException(value);
            }
            return constant2;
        }

        static {
            CONSTANTS = new HashMap<String, Urgency>();
            for (Urgency c : Urgency.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Type {
        NOTIFY_NOT_OK("Notify:NotOK"),
        NOTIFY_OK("Notify:OK"),
        NOTIFY_DOES_NOT_START("Notify:DoesNotStart"),
        NOTIFY_EXECUTION_TIME("Notify:ExecutionTime"),
        NOTIFY_DOES_NOT_END("Notify:DoesNotEnd"),
        NOTIFY_RE_RUN("Notify:ReRun"),
        NOTIFY_LATE_CYCLIC_SUBMIT("Notify:LateCyclicSubmit");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant2 = CONSTANTS.get(value);
            if (constant2 == null) {
                throw new IllegalArgumentException(value);
            }
            return constant2;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Criteria {
        LESS_THAN("LessThan"),
        GREATER_THAN("GreaterThan"),
        LESS_THAN_AVERAGE("LessThanAverage"),
        GREATER_THAN_AVERAGE("GreaterThanAverage");

        private final String value;
        private static final Map<String, Criteria> CONSTANTS;

        private Criteria(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Criteria fromValue(String value) {
            Criteria constant2 = CONSTANTS.get(value);
            if (constant2 == null) {
                throw new IllegalArgumentException(value);
            }
            return constant2;
        }

        static {
            CONSTANTS = new HashMap<String, Criteria>();
            for (Criteria c : Criteria.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

