/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.excelUtils;

import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.excelUtils.BaseExcelReporterKt;
import com.bmc.ctmconvert.excelUtils.Colors;
import com.bmc.ctmconvert.excelUtils.ExcelFile;
import com.bmc.ctmconvert.qualifyUtils.JobsNotQualified;
import com.bmc.ctmconvert.qualifyUtils.MigrationResultStatus;
import com.bmc.ctmconvert.qualifyUtils.QualificationSummary;
import com.bmc.ctmconvert.qualifyUtils.SheetData;
import com.bmc.ctmconvert.qualifyUtils.TestStatus;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&J\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0004J\u001a\u0010\u001e\u001a\u00020\u0019*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0016\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0002J\u0016\u0010&\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0002J\"\u0010'\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\"2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000bJ/\u0010'\u001a\u00020\u0019*\u00020\"2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0*\"\u00020\f2\b\b\u0002\u0010+\u001a\u00020\u0005H\u0004\u00a2\u0006\u0002\u0010,J$\u0010'\u001a\u00020\u0019*\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010+\u001a\u00020\u0005H\u0004J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\fH\u0004J\u0018\u0010/\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\fH\u0002J\u0016\u00101\u001a\u00020\u00192\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0004J\f\u00103\u001a\u000204*\u000205H\u0002JI\u00106\u001a\b\u0012\u0004\u0012\u0002070\u000b\"\u000e\b\u0000\u00108*\b\u0012\u0004\u0012\u0002H809*\u00020\"2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H80*2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u0002040<H\u0004\u00a2\u0006\u0002\u0010=J\u0012\u0010>\u001a\b\u0012\u0004\u0012\u0002070\u000b*\u00020\"H\u0004J\u0012\u0010?\u001a\b\u0012\u0004\u0012\u0002070\u000b*\u00020\"H\u0004J\u001e\u0010@\u001a\u00020\"2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010A\u001a\u00020\fH\u0004J\u0010\u0010B\u001a\u00020\u00192\u0006\u0010C\u001a\u00020DH\u0002J\u001c\u0010E\u001a\u00020\u00192\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000bH\u0004J\"\u0010G\u001a\u00020\u00192\u0018\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0IH\u0004J&\u0010J\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\"2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010A\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006L"}, d2={"Lcom/bmc/ctmconvert/excelUtils/BaseExcelReporter;", "Lcom/bmc/ctmconvert/excelUtils/ExcelFile;", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "maxSheetRows", "", "<init>", "(Lcom/bmc/ctmconvert/CommonLogger;I)V", "getMaxSheetRows", "()I", "jobsNotQualifiedSheetColumns", "", "", "jobNotQualifiedCells", "qualification", "Lcom/bmc/ctmconvert/qualifyUtils/JobsNotQualified;", "isEmptySheet", "", "sheet", "Lcom/bmc/ctmconvert/qualifyUtils/SheetData;", "calculateSummaryResultStatus", "qualifications", "", "Lcom/bmc/ctmconvert/qualifyUtils/QualificationSummary;", "writeJobNotQualifiedCells", "", "row", "Lorg/apache/poi/xssf/usermodel/XSSFRow;", "writeSheets", "sheets", "tryToSetAutoSizeColumnFor", "Lorg/apache/poi/xssf/usermodel/XSSFSheet;", "header", "autoSizeColumns", "Lorg/apache/poi/ss/usermodel/Sheet;", "columnSize", "logEmptySheets", "emptySheets", "mergeSheets", "addRows", "rows", "data", "", "numberOfCellsPerRow", "(Lorg/apache/poi/ss/usermodel/Sheet;[Ljava/lang/String;I)V", "writeQualificationQuestionnaire", "fileName", "createNoteRow", "value", "writeJobsNotQualifiedSheet", "jobsNotQualified", "toXssfColor", "Lorg/apache/poi/xssf/usermodel/XSSFColor;", "Ljava/awt/Color;", "createColorFormattingRule", "Lorg/apache/poi/ss/usermodel/ConditionalFormattingRule;", "T", "", "values", "colorProvider", "Lkotlin/Function1;", "(Lorg/apache/poi/ss/usermodel/Sheet;[Ljava/lang/Enum;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "createSummaryColorFormattingRule", "createMigrationResultColorFormattingRule", "writeQualificationSummarySheet", "qualificationResultsTitle", "addLinkToSheet", "cell", "Lorg/apache/poi/ss/usermodel/Cell;", "writeParametersSheet", "parameters", "writeLibmemsymFilesSheet", "libMemSymPathAndUsages", "", "addQualificationResultsSection", "qualificationSummary", "Common"})
@SourceDebugExtension(value={"SMAP\nBaseExcelReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseExcelReporter.kt\ncom/bmc/ctmconvert/excelUtils/BaseExcelReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,293:1\n1971#2,14:294\n1863#2,2:308\n774#2:310\n865#2,2:311\n1485#2:313\n1510#2,3:314\n1513#2,3:324\n1557#2:327\n1628#2,3:328\n1863#2:331\n1864#2:333\n774#2:334\n865#2,2:335\n1863#2,2:337\n1557#2:339\n1628#2,3:340\n1368#2:343\n1454#2,5:344\n1557#2:349\n1628#2,2:350\n1863#2,2:352\n1630#2:354\n1557#2:355\n1628#2,3:356\n1863#2,2:359\n1062#2:369\n1863#2,2:370\n381#3,7:317\n1#4:332\n11165#5:361\n11500#5,3:362\n37#6,2:365\n37#6,2:367\n126#7:372\n153#7,3:373\n*S KotlinDebug\n*F\n+ 1 BaseExcelReporter.kt\ncom/bmc/ctmconvert/excelUtils/BaseExcelReporter\n*L\n37#1:294,14\n42#1:308,2\n46#1:310\n46#1:311,2\n47#1:313\n47#1:314,3\n47#1:324,3\n47#1:327\n47#1:328,3\n48#1:331\n48#1:333\n57#1:334\n57#1:335,2\n73#1:337,2\n81#1:339\n81#1:340,3\n94#1:343\n94#1:344,5\n100#1:349\n100#1:350,2\n102#1:352,2\n100#1:354\n127#1:355\n127#1:356,3\n145#1:359,2\n204#1:369\n217#1:370,2\n47#1:317,7\n160#1:361\n160#1:362,3\n175#1:365,2\n188#1:367,2\n265#1:372\n265#1:373,3\n*E\n"})
public abstract class BaseExcelReporter
extends ExcelFile {
    @NotNull
    private final CommonLogger logger;
    private final int maxSheetRows;

    public BaseExcelReporter(@NotNull CommonLogger logger, int maxSheetRows) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.logger = logger;
        this.maxSheetRows = maxSheetRows;
    }

    public int getMaxSheetRows() {
        return this.maxSheetRows;
    }

    @NotNull
    public abstract List<String> jobsNotQualifiedSheetColumns();

    @NotNull
    public List<String> jobNotQualifiedCells(@NotNull JobsNotQualified qualification) {
        Intrinsics.checkNotNullParameter(qualification, "qualification");
        String[] stringArray = new String[]{qualification.getParentFolderName(), qualification.getJobOrFolderName(), qualification.getWhatIsTheIssue()};
        return CollectionsKt.listOf(stringArray);
    }

    private final boolean isEmptySheet(SheetData sheet) {
        return sheet.getData().size() <= 1;
    }

    private final String calculateSummaryResultStatus(Collection<QualificationSummary> qualifications) {
        Object object;
        Object v0;
        Iterable $this$maxByOrNull$iv = qualifications;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                QualificationSummary it = (QualificationSummary)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getTestStatus().getRank();
                do {
                    Object e$iv = iterator$iv.next();
                    QualificationSummary it2 = (QualificationSummary)e$iv;
                    $i$a$-maxByOrNull-BaseExcelReporter$calculateSummaryResultStatus$1 = false;
                    int v$iv = it2.getTestStatus().getRank();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        if ((object = (QualificationSummary)v0) == null || (object = ((QualificationSummary)object).getTestStatus()) == null) {
            object = TestStatus.Pass;
        }
        return ((Enum)object).name();
    }

    private final void writeJobNotQualifiedCells(XSSFRow row, JobsNotQualified qualification) {
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)this.jobNotQualifiedCells(qualification));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IndexedValue<String> element$iv;
            IndexedValue<String> it = element$iv = iterator2.next();
            boolean bl = false;
            this.createReportCell(row, it);
        }
    }

    protected final void writeSheets(@NotNull List<SheetData> sheets) {
        Object object;
        Iterable $this$mapTo$iv$iv;
        List list$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(sheets, "sheets");
        Iterable $this$filter$iv = sheets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SheetData)element$iv$iv;
            boolean bl = false;
            if (!(!this.isEmptySheet((SheetData)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (SheetData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = ((SheetData)it).getSheetName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            list$iv$iv = (List)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.mergeSheets((List<SheetData>)it));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SheetData sheetData = (SheetData)element$iv;
            boolean bl = false;
            XSSFSheet sheet = this.getWorkbook().createSheet(sheetData.getSheetName());
            this.logger.info("sheet name is " + sheet.getSheetName());
            it = sheetData.getData();
            boolean bl3 = false;
            Pair pair = TuplesKt.to(CollectionsKt.first(it), CollectionsKt.drop((Iterable)it, 1));
            List header = (List)pair.component1();
            List data = pair.component2();
            Intrinsics.checkNotNull(sheet);
            this.createHeader(sheet, header);
            this.addRows(sheet, data);
            this.tryToSetAutoSizeColumnFor(sheet, header);
        }
        $this$forEach$iv = sheets;
        object = this;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SheetData)element$iv$iv;
            boolean bl = false;
            if (!this.isEmptySheet((SheetData)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        super.logEmptySheets((List)destination$iv$iv);
    }

    private final void tryToSetAutoSizeColumnFor(XSSFSheet $this$tryToSetAutoSizeColumnFor, List<String> header) {
        boolean isWindows;
        boolean bl = isWindows = !Intrinsics.areEqual(File.separator, "/");
        if (isWindows) {
            try {
                this.autoSizeColumns($this$tryToSetAutoSizeColumnFor, header.size());
            }
            catch (Exception e) {
                this.logger.error("Unable to set automatic column size", e);
            }
        }
    }

    private final void autoSizeColumns(Sheet sheet, int columnSize) {
        if (columnSize > 0) {
            Iterable $this$forEach$iv = RangesKt.until(0, columnSize);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                sheet.autoSizeColumn(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logEmptySheets(List<SheetData> emptySheets) {
        if (!((Collection)emptySheets).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = emptySheets;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SheetData sheetData = (SheetData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSheetName());
            }
            String it = CollectionsKt.joinToString$default(CollectionsKt.distinct((List)destination$iv$iv), ", ", null, null, 0, null, null, 62, null);
            boolean bl = false;
            this.logger.info("Empty sheets were excluded from report: " + it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SheetData mergeSheets(List<SheetData> sheets) {
        void $this$flatMapTo$iv$iv;
        SheetData firstSheet = CollectionsKt.first(sheets);
        String sheetName = firstSheet.getSheetName();
        List<String> headers = CollectionsKt.first(firstSheet.getData());
        Iterable $this$flatMap$iv = sheets;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SheetData it = (SheetData)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.drop((Iterable)it.getData(), 1);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List data = (List)destination$iv$iv;
        return new SheetData(sheetName, headers, data);
    }

    /*
     * WARNING - void declaration
     */
    public final void addRows(@NotNull Sheet sheet, @NotNull List<? extends List<String>> rows) {
        Intrinsics.checkNotNullParameter(sheet, "sheet");
        Intrinsics.checkNotNullParameter(rows, "rows");
        if (sheet.getLastRowNum() + rows.size() < this.getMaxSheetRows()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)rows);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void indexedData;
                Row row;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Row row2 = row = sheet.createRow(sheet.getLastRowNum() + 1);
                boolean bl2 = false;
                Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)indexedData.getValue());
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    IndexedValue<String> element$iv;
                    IndexedValue<String> it = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(row2);
                    this.createReportCell(row2, it);
                }
                collection.add(row);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        } else {
            CommonLogger.DefaultImpls.error$default(this.logger, "the number of rows (" + rows.size() + ") exceeds the max " + this.getMaxSheetRows() + ", current rows count is " + sheet.getLastRowNum(), null, 2, null);
        }
    }

    protected final void addRows(@NotNull Sheet $this$addRows, @NotNull String[] data, int numberOfCellsPerRow) {
        Intrinsics.checkNotNullParameter($this$addRows, "<this>");
        Intrinsics.checkNotNullParameter(data, "data");
        this.addRows($this$addRows, ArraysKt.toList(data), numberOfCellsPerRow);
    }

    public static /* synthetic */ void addRows$default(BaseExcelReporter baseExcelReporter, Sheet sheet, String[] stringArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addRows");
        }
        if ((n2 & 2) != 0) {
            n = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        baseExcelReporter.addRows(sheet, stringArray, n);
    }

    protected final void addRows(@NotNull Sheet $this$addRows, @NotNull List<String> data, int numberOfCellsPerRow) {
        Intrinsics.checkNotNullParameter($this$addRows, "<this>");
        Intrinsics.checkNotNullParameter(data, "data");
        this.addRows($this$addRows, CollectionsKt.chunked((Iterable)data, numberOfCellsPerRow));
    }

    public static /* synthetic */ void addRows$default(BaseExcelReporter baseExcelReporter, Sheet sheet, List list, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addRows");
        }
        if ((n2 & 2) != 0) {
            n = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        baseExcelReporter.addRows(sheet, list, n);
    }

    /*
     * WARNING - void declaration
     */
    protected final void writeQualificationQuestionnaire(@NotNull String fileName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        InputStream inputStream = BaseExcelReporter.class.getResourceAsStream("/" + fileName);
        Intrinsics.checkNotNull(inputStream);
        InputStream inputStream2 = inputStream;
        String[] stringArray = Charsets.UTF_8;
        List<String> questionnaireLines = TextStreamsKt.readLines(new InputStreamReader(inputStream2, (Charset)stringArray));
        stringArray = new String[]{questionnaireLines.get(0), "Yes", "No"};
        List<String> headers = CollectionsKt.listOf(stringArray);
        List data = CollectionsKt.drop((Iterable)questionnaireLines, 1);
        XSSFSheet sheet = this.getWorkbook().createSheet("Manual Qualification");
        Intrinsics.checkNotNull(sheet);
        this.createHeader(sheet, (Collection<String>)headers);
        this.createNoteRow(sheet, "Note: The BMC presales team and customer must complete this questionnaire together.");
        Iterable $this$map$iv = CollectionsKt.withIndex(data);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int rowNum = it.getIndex() + 2;
            String value = (String)it.getValue();
            XSSFRow xSSFRow = sheet.createRow(rowNum);
            Intrinsics.checkNotNullExpressionValue(xSSFRow, "createRow(...)");
            collection.add(this.createReportCell((Row)xSSFRow, 0, value));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void createNoteRow(XSSFSheet sheet, String value) {
        XSSFCell xSSFCell;
        XSSFCell it = xSSFCell = sheet.createRow(1).createCell(0);
        boolean bl = false;
        it.setCellValue(value);
        XSSFCell cell = xSSFCell;
        Intrinsics.checkNotNull(cell);
        this.setSubTitleCellStyle(cell);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 2));
    }

    protected final void writeJobsNotQualifiedSheet(@NotNull List<JobsNotQualified> jobsNotQualified) {
        Intrinsics.checkNotNullParameter(jobsNotQualified, "jobsNotQualified");
        XSSFSheet sheet = this.getWorkbook().createSheet("Folder and Job issues");
        Intrinsics.checkNotNull(sheet);
        this.createHeader(sheet, (Collection<String>)this.jobsNotQualifiedSheetColumns());
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)jobsNotQualified);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IndexedValue element$iv;
            IndexedValue it = element$iv = iterator2.next();
            boolean bl = false;
            int rowNum = it.getIndex() + 1;
            JobsNotQualified qualification = (JobsNotQualified)it.getValue();
            XSSFRow row = sheet.createRow(rowNum);
            Intrinsics.checkNotNull(row);
            this.writeJobNotQualifiedCells(row, qualification);
        }
    }

    private final XSSFColor toXssfColor(Color $this$toXssfColor) {
        byte[] byArray = new byte[]{(byte)$this$toXssfColor.getRed(), (byte)$this$toXssfColor.getGreen(), (byte)$this$toXssfColor.getBlue()};
        return new XSSFColor(byArray, this.getWorkbook().getStylesSource().getIndexedColors());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T extends Enum<T>> List<ConditionalFormattingRule> createColorFormattingRule(@NotNull Sheet $this$createColorFormattingRule, @NotNull T[] values2, @NotNull Function1<? super T, ? extends XSSFColor> colorProvider) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$createColorFormattingRule, "<this>");
        Intrinsics.checkNotNullParameter(values2, "values");
        Intrinsics.checkNotNullParameter(colorProvider, "colorProvider");
        T[] $this$map$iv = values2;
        boolean $i$f$map = false;
        T[] TArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConditionalFormattingRule rule = $this$createColorFormattingRule.getSheetConditionalFormatting().createConditionalFormattingRule((byte)3, "\"" + it.name() + "\"");
            PatternFormatting formatting = rule.createPatternFormatting();
            formatting.setFillBackgroundColor(colorProvider.invoke(it));
            formatting.setFillPattern((short)1);
            CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[]{new CellRangeAddress(0, $this$createColorFormattingRule.getLastRowNum(), 1, 1)};
            $this$createColorFormattingRule.getSheetConditionalFormatting().addConditionalFormatting(cellRangeAddressArray, rule);
            collection.add(rule);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final List<ConditionalFormattingRule> createSummaryColorFormattingRule(@NotNull Sheet $this$createSummaryColorFormattingRule) {
        Intrinsics.checkNotNullParameter($this$createSummaryColorFormattingRule, "<this>");
        Collection $this$toTypedArray$iv = TestStatus.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.createColorFormattingRule($this$createSummaryColorFormattingRule, thisCollection$iv.toArray(new TestStatus[0]), arg_0 -> BaseExcelReporter.createSummaryColorFormattingRule$lambda$19(this, arg_0));
    }

    @NotNull
    protected final List<ConditionalFormattingRule> createMigrationResultColorFormattingRule(@NotNull Sheet $this$createMigrationResultColorFormattingRule) {
        Intrinsics.checkNotNullParameter($this$createMigrationResultColorFormattingRule, "<this>");
        Collection $this$toTypedArray$iv = MigrationResultStatus.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.createColorFormattingRule($this$createMigrationResultColorFormattingRule, thisCollection$iv.toArray(new MigrationResultStatus[0]), arg_0 -> BaseExcelReporter.createMigrationResultColorFormattingRule$lambda$20(this, arg_0));
    }

    @NotNull
    protected final Sheet writeQualificationSummarySheet(@NotNull Collection<QualificationSummary> qualifications, @NotNull String qualificationResultsTitle) {
        Intrinsics.checkNotNullParameter(qualifications, "qualifications");
        Intrinsics.checkNotNullParameter(qualificationResultsTitle, "qualificationResultsTitle");
        Iterable $this$sortedByDescending$iv = qualifications;
        boolean $i$f$sortedByDescending = false;
        List sortedQualifications = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                QualificationSummary it = (QualificationSummary)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRank());
                it = (QualificationSummary)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getRank());
            }
        });
        XSSFSheet sheet = this.getWorkbook().createSheet("Qualification Summary");
        String[] stringArray = new String[]{"Qualification tests description", "Test Status", "Number of entities found", "Test result message", "Possible ways to address Incompatibilities or Warnings"};
        List<String> columns2 = CollectionsKt.listOf(stringArray);
        Intrinsics.checkNotNull(sheet);
        this.createHeader(sheet, (Collection<String>)columns2);
        Iterable $this$forEach$iv = CollectionsKt.withIndex(sortedQualifications);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Cell cell;
            IndexedValue element$iv;
            IndexedValue it = element$iv = iterator2.next();
            boolean bl = false;
            QualificationSummary qualification = (QualificationSummary)it.getValue();
            XSSFRow row = sheet.createRow(it.getIndex() + 1);
            boolean bl2 = false;
            Intrinsics.checkNotNull(row);
            this.createReportCell((Row)row, 0, qualification.getQualificationTestDescription());
            this.createReportCell((Row)row, 1, qualification.getTestStatus().name());
            this.createReportCell((Row)row, 2, qualification.getNumberOfInstancesFound());
            Cell cell2 = cell = this.createReportCell((Row)row, 3, qualification.getWhatIsTheIssue());
            boolean bl3 = false;
            this.addLinkToSheet(cell2);
            cell2 = cell = this.createReportCell((Row)row, 4, qualification.getRecommendation());
            boolean bl4 = false;
            this.addLinkToSheet(cell2);
        }
        this.addQualificationResultsSection(sheet, sortedQualifications, qualificationResultsTitle);
        return sheet;
    }

    private final void addLinkToSheet(Cell cell) {
        MatchGroup linkedSheet;
        Regex regex = new Regex("(see|use) the (?<sheet>.*) sheet", RegexOption.IGNORE_CASE);
        String string = cell.getStringCellValue();
        Intrinsics.checkNotNullExpressionValue(string, "getStringCellValue(...)");
        MatchResult sheetNameResult = Regex.find$default(regex, string, 0, 2, null);
        if (sheetNameResult != null && (linkedSheet = RegexExtensionsJDK8Kt.get(sheetNameResult.getGroups(), "sheet")) != null) {
            XSSFHyperlink link = new XSSFCreationHelper(this.getWorkbook()).createHyperlink(HyperlinkType.DOCUMENT);
            link.setAddress("'" + linkedSheet.getValue() + "'!A1");
            cell.setHyperlink(link);
            cell.getRichStringCellValue().applyFont(linkedSheet.getRange().getFirst(), linkedSheet.getRange().getLast() + 7, this.getBlueFont());
        }
    }

    protected final void writeParametersSheet(@NotNull List<? extends List<String>> parameters) {
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        String[] stringArray = new String[]{"Parameter Name", "Value"};
        this.writeSheets(CollectionsKt.listOf(new SheetData("Parameters", CollectionsKt.listOf(stringArray), parameters)));
    }

    /*
     * WARNING - void declaration
     */
    protected final void writeLibmemsymFilesSheet(@NotNull Map<String, ? extends List<String>> libMemSymPathAndUsages) {
        Intrinsics.checkNotNullParameter(libMemSymPathAndUsages, "libMemSymPathAndUsages");
        if (!libMemSymPathAndUsages.isEmpty()) {
            void $this$mapTo$iv$iv;
            Map<String, ? extends List<String>> $this$map$iv = libMemSymPathAndUsages;
            boolean $i$f$map = false;
            Map<String, ? extends List<String>> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{it.getKey(), String.valueOf(CollectionsKt.distinct((Iterable)it.getValue()).size())};
                collection.add(CollectionsKt.listOf(stringArray));
            }
            List libmemsymList = CollectionsKt.toList((List)destination$iv$iv);
            String[] stringArray = new String[]{"File Name", "Number of Entities That Use It"};
            this.writeSheets(CollectionsKt.listOf(new SheetData("Libmemsym Files", CollectionsKt.listOf(stringArray), libmemsymList)));
        }
    }

    private final void addQualificationResultsSection(Sheet sheet, Collection<QualificationSummary> qualificationSummary, String qualificationResultsTitle) {
        block0: {
            Cell qualificationCell;
            String[] stringArray = new String[]{"", "", qualificationResultsTitle, this.calculateSummaryResultStatus(qualificationSummary)};
            this.addRows(sheet, stringArray, 2);
            Cell cell = qualificationCell = BaseExcelReporterKt.findCellWithText(sheet, qualificationResultsTitle);
            if (cell == null) break block0;
            cell.setCellStyle(this.getBoldCellStyle());
        }
    }

    private static final XSSFColor createSummaryColorFormattingRule$lambda$19(BaseExcelReporter this$0, TestStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return this$0.toXssfColor(switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
            case 1 -> Colors.INSTANCE.getLightGreen();
            case 2 -> Colors.INSTANCE.getLightRed();
            case 3 -> Colors.INSTANCE.getLightRed();
            case 4 -> Colors.INSTANCE.getLightYellow();
            case 5 -> Colors.INSTANCE.getLightOrange();
            case 6 -> Colors.INSTANCE.getLightRed();
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private static final XSSFColor createMigrationResultColorFormattingRule$lambda$20(BaseExcelReporter this$0, MigrationResultStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return this$0.toXssfColor(switch (WhenMappings.$EnumSwitchMapping$1[it.ordinal()]) {
            case 1 -> Colors.INSTANCE.getLightGreen();
            case 2 -> Colors.INSTANCE.getLightYellow();
            case 3 -> Colors.INSTANCE.getLightRed();
            case 4 -> Colors.INSTANCE.getLightRed();
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TestStatus.values().length];
            try {
                nArray[TestStatus.Pass.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.Incompatibility found.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.Manual actions.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.Automatic adjustment with warning.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.Not Qualified.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MigrationResultStatus.values().length];
            try {
                nArray[MigrationResultStatus.Pass.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MigrationResultStatus.Manual actions.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MigrationResultStatus.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MigrationResultStatus.Aborted.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

