/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.databaseCommon;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Table;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u0013\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011\u00a2\u0006\u0002\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/bmc/ctmconvert/databaseCommon/MngAliases;", "Lorg/jetbrains/exposed/sql/Table;", "<init>", "()V", "srv_alias", "Lorg/jetbrains/exposed/sql/Column;", "", "getSrv_alias", "()Lorg/jetbrains/exposed/sql/Column;", "hostname", "getHostname", "last_updated", "getLast_updated", "convertLastUpdateStringToDate", "Ljava/time/LocalDateTime;", "lastUpdatedValue", "lastUpdatedFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "()Ljava/time/format/DateTimeFormatter;", "Common"})
public final class MngAliases
extends Table {
    @NotNull
    public static final MngAliases INSTANCE = new MngAliases();
    @NotNull
    private static final Column<String> srv_alias = Table.varchar$default(INSTANCE, "SRV_ALIAS", 50, null, 4, null);
    @NotNull
    private static final Column<String> hostname = Table.varchar$default(INSTANCE, "HOSTNAME", 255, null, 4, null);
    @NotNull
    private static final Column<String> last_updated = Table.varchar$default(INSTANCE, "LAST_UPDATED", 17, null, 4, null);

    private MngAliases() {
        super("MNG_ALIASES");
    }

    @NotNull
    public final Column<String> getSrv_alias() {
        return srv_alias;
    }

    @NotNull
    public final Column<String> getHostname() {
        return hostname;
    }

    @NotNull
    public final Column<String> getLast_updated() {
        return last_updated;
    }

    @NotNull
    public final LocalDateTime convertLastUpdateStringToDate(@NotNull String lastUpdatedValue) {
        Intrinsics.checkNotNullParameter(lastUpdatedValue, "lastUpdatedValue");
        LocalDateTime localDateTime = LocalDateTime.parse(lastUpdatedValue, this.lastUpdatedFormatter());
        Intrinsics.checkNotNullExpressionValue(localDateTime, "parse(...)");
        return localDateTime;
    }

    public final DateTimeFormatter lastUpdatedFormatter() {
        return DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    }
}

