/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.io.ConsolePrinter;
import com.bmc.ctmconvert.io.JsonReaderImpl;
import com.bmc.ctmconvert.io.JsonWriterImpl;
import com.bmc.ctmconvert.modes.CountJobsMode;
import com.bmc.ctmconvert.modes.LogicalSplitMode;
import com.bmc.ctmconvert.modes.TechnicalSplitMode;
import java.io.File;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="splitLargeFolder", version={"1.0"}, mixinStandardHelpOptions=true, description={"Split large folders to smaller ones."})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0002R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001e\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/bmc/ctmconvert/MainArguments;", "Ljava/util/concurrent/Callable;", "", "<init>", "()V", "inputFile", "Ljava/io/File;", "getInputFile", "()Ljava/io/File;", "setInputFile", "(Ljava/io/File;)V", "outputDirectory", "", "getOutputDirectory", "()Ljava/lang/String;", "setOutputDirectory", "(Ljava/lang/String;)V", "maxJobsInFolder", "getMaxJobsInFolder", "()I", "setMaxJobsInFolder", "(I)V", "minJobsInFolder", "getMinJobsInFolder", "setMinJobsInFolder", "clearOutput", "", "getClearOutput", "()Z", "setClearOutput", "(Z)V", "splitMode", "getSplitMode", "setSplitMode", "call", "()Ljava/lang/Integer;", "extractArgumentsFromCliParameters", "Lcom/bmc/ctmconvert/Arguments;", "splitLargeFolder"})
public final class MainArguments
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"The large folder json file."})
    public File inputFile;
    @CommandLine.Option(names={"-o", "--outputDirectory"}, description={"The output directory where to save the splitter folders in."}, defaultValue="output")
    @NotNull
    private String outputDirectory = "ouput";
    @CommandLine.Option(names={"-max", "--maxJobsInFolder"}, description={"The maximum number of jobs in each folder."})
    private int maxJobsInFolder = 500;
    @CommandLine.Option(names={"-min", "--minJobsInFolder"}, description={"The minimum number of jobs in each folder."})
    private int minJobsInFolder = 100;
    @CommandLine.Option(names={"-co", "--clearOutput"}, description={"Clear output directory before writing to it."})
    private boolean clearOutput = true;
    @CommandLine.Option(names={"-mode"}, required=false, description={"Split mode."}, defaultValue="logical")
    @NotNull
    private String splitMode = "logical";

    @NotNull
    public final File getInputFile() {
        File file = this.inputFile;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException("inputFile");
        return null;
    }

    public final void setInputFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.inputFile = file;
    }

    @NotNull
    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.outputDirectory = string;
    }

    public final int getMaxJobsInFolder() {
        return this.maxJobsInFolder;
    }

    public final void setMaxJobsInFolder(int n) {
        this.maxJobsInFolder = n;
    }

    public final int getMinJobsInFolder() {
        return this.minJobsInFolder;
    }

    public final void setMinJobsInFolder(int n) {
        this.minJobsInFolder = n;
    }

    public final boolean getClearOutput() {
        return this.clearOutput;
    }

    public final void setClearOutput(boolean bl) {
        this.clearOutput = bl;
    }

    @NotNull
    public final String getSplitMode() {
        return this.splitMode;
    }

    public final void setSplitMode(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.splitMode = string;
    }

    @Override
    @NotNull
    public Integer call() {
        Arguments arguments2 = this.extractArgumentsFromCliParameters();
        ConsolePrinter printer = new ConsolePrinter(null, 1, null);
        JsonWriterImpl jobsWriter = new JsonWriterImpl(printer, arguments2.getOutputDirectory());
        JsonReaderImpl jsonReader = new JsonReaderImpl();
        String string = this.splitMode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "technical": {
                new TechnicalSplitMode(arguments2, printer, jobsWriter, jsonReader).run();
                break;
            }
            case "logical": {
                new LogicalSplitMode(arguments2, printer, jobsWriter, jsonReader).run();
                break;
            }
            case "count": {
                new CountJobsMode(arguments2, jsonReader).run();
            }
        }
        return 0;
    }

    private final Arguments extractArgumentsFromCliParameters() {
        Path path = this.getInputFile().toPath();
        Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
        Path path2 = Path.of(this.outputDirectory, new String[0]).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(path2, "toAbsolutePath(...)");
        return new Arguments(path, path2, this.minJobsInFolder, this.maxJobsInFolder, this.clearOutput);
    }
}

