/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.DataZipperKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u001c\u0010\b\u001a\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000b\u001a\u00020\tJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\n\u001a\u00020\tH\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\n\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bmc/ctmconvert/DataZipper;", "", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "zipFileName", "", "<init>", "(Lcom/bmc/ctmconvert/CommonLogger;Ljava/lang/String;)V", "zip", "Ljava/nio/file/Path;", "basePath", "outputFolderPath", "outputFolderPaths", "", "fileNames", "findFoldersInOutputPaths", "Ljava/io/File;", "findFoldersInBasePath", "findFolders", "folderToZip", "compress", "", "zipFile", "Ljava/util/zip/ZipOutputStream;", "zipFolders", "folders", "Common"})
@SourceDebugExtension(value={"SMAP\nDataZipper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataZipper.kt\ncom/bmc/ctmconvert/DataZipper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1368#2:88\n1454#2,5:89\n1557#2:94\n1628#2,3:95\n1663#2,8:98\n1557#2:106\n1628#2,3:107\n1863#2,2:110\n*S KotlinDebug\n*F\n+ 1 DataZipper.kt\ncom/bmc/ctmconvert/DataZipper\n*L\n39#1:88\n39#1:89,5\n73#1:94\n73#1:95,3\n73#1:98,8\n75#1:106\n75#1:107,3\n78#1:110,2\n*E\n"})
public final class DataZipper {
    @NotNull
    private final CommonLogger logger;
    @NotNull
    private final String zipFileName;

    public DataZipper(@NotNull CommonLogger logger, @NotNull String zipFileName) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(zipFileName, "zipFileName");
        this.logger = logger;
        this.zipFileName = zipFileName;
    }

    public /* synthetic */ DataZipper(CommonLogger commonLogger, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = DataZipperKt.zipFileName$default(null, 1, null);
        }
        this(commonLogger, string);
    }

    @Nullable
    public final Path zip(@NotNull Path basePath, @NotNull Path outputFolderPath) {
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(outputFolderPath, "outputFolderPath");
        return this.zip(basePath, CollectionsKt.listOf(outputFolderPath));
    }

    @Nullable
    public final Path zip(@NotNull Path basePath, @NotNull List<? extends Path> outputFolderPaths) {
        Path path;
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(outputFolderPaths, "outputFolderPaths");
        try {
            List folders = CollectionsKt.plus((Collection)this.findFoldersInBasePath(basePath), (Iterable)this.findFoldersInOutputPaths(outputFolderPaths));
            path = this.zipFolders(folders, basePath);
        }
        catch (Exception e) {
            this.logger.error("Unable to zip files", e);
            path = null;
        }
        return path;
    }

    @NotNull
    public final Object zip(@NotNull List<String> fileNames, @NotNull Path outputFolderPath) {
        Object object;
        Intrinsics.checkNotNullParameter(fileNames, "fileNames");
        Intrinsics.checkNotNullParameter(outputFolderPath, "outputFolderPath");
        try {
            object = this.zipFolders(this.findFolders(outputFolderPath, fileNames), outputFolderPath);
        }
        catch (Exception e) {
            this.logger.error("Unable to zip files", e);
            object = Unit.INSTANCE;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> findFoldersInOutputPaths(List<? extends Path> outputFolderPaths) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = outputFolderPaths;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Path path = it.toAbsolutePath().getParent();
            Intrinsics.checkNotNullExpressionValue(path, "getParent(...)");
            Iterable list$iv$iv = this.findFolders(path, CollectionsKt.listOf(((Object)it.getFileName()).toString()));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<File> findFoldersInBasePath(Path basePath) {
        String[] stringArray = new String[]{"report", "logs"};
        List<String> folderToZip = CollectionsKt.listOf(stringArray);
        return this.findFolders(basePath, folderToZip);
    }

    private final List<File> findFolders(Path basePath, List<String> folderToZip) {
        return SequencesKt.toList(SequencesKt.filter(FilesKt.walk$default(new File(((Object)basePath.toAbsolutePath()).toString()), null, 1, null), arg_0 -> DataZipper.findFolders$lambda$1(folderToZip, arg_0)));
    }

    private final void compress(Path basePath, ZipOutputStream zipFile) {
        Path dirName = basePath.getFileName();
        Set visitedFiles = new LinkedHashSet();
        Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(basePath, (Set<Path>)visitedFiles, this, dirName, zipFile){
            final /* synthetic */ Path $basePath;
            final /* synthetic */ Set<Path> $visitedFiles;
            final /* synthetic */ DataZipper this$0;
            final /* synthetic */ Path $dirName;
            final /* synthetic */ ZipOutputStream $zipFile;
            {
                this.$basePath = $basePath;
                this.$visitedFiles = $visitedFiles;
                this.this$0 = $receiver;
                this.$dirName = $dirName;
                this.$zipFile = $zipFile;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Intrinsics.checkNotNullParameter(file, "file");
                Intrinsics.checkNotNullParameter(attributes, "attributes");
                Path targetFile = this.$basePath.relativize(file);
                Intrinsics.checkNotNull(targetFile);
                if (DataZipper.access$compress$notLogLockFile(targetFile) && !this.$visitedFiles.contains(targetFile)) {
                    DataZipper.access$getLogger$p(this.this$0).info("adding " + this.$dirName + "/" + targetFile);
                    this.$zipFile.putNextEntry(new ZipEntry(this.$dirName + "/" + targetFile));
                    byte[] byArray = Files.readAllBytes(file);
                    Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
                    this.$zipFile.write(byArray);
                    this.$zipFile.closeEntry();
                    this.$visitedFiles.add(targetFile);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Path zipFolders(List<? extends File> folders, Path basePath) {
        Collection<Path> collection;
        Iterable $this$distinctBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Path zipFile = basePath.resolve(this.zipFileName);
        Intrinsics.checkNotNull(zipFile);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue(Files.createFile(zipFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createFile(...)");
        Iterable $this$map$iv = folders;
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.toPath());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        Iterable<Path> set$iv = new HashSet<Path>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Path it = (Path)e$iv;
            boolean bl = false;
            Path key$iv = it.getFileName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List uniqueFolders = list$iv;
        $this$distinctBy$iv = uniqueFolders;
        String string = this.zipFileName;
        object = this.logger;
        $i$f$map = false;
        set$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path bl = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getFileName());
        }
        collection = (List)destination$iv$iv;
        object.info("creating " + string + " from " + (List)collection + " directories");
        Closeable closeable = new ZipOutputStream(new FileOutputStream(new File(((Object)zipFile.toAbsolutePath()).toString())));
        Throwable throwable = null;
        try {
            ZipOutputStream zipStream = (ZipOutputStream)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = uniqueFolders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull(it);
                this.compress(it, zipStream);
            }
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return zipFile;
    }

    private static final boolean findFolders$lambda$1(List $folderToZip, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $folderToZip.contains(it.getName());
    }

    private static final boolean compress$notLogLockFile(Path $this$compress_u24notLogLockFile) {
        return !StringsKt.endsWith$default(PathsKt.getName($this$compress_u24notLogLockFile), ".lck", false, 2, null);
    }

    public static final /* synthetic */ boolean access$compress$notLogLockFile(Path $receiver) {
        return DataZipper.compress$notLogLockFile($receiver);
    }

    public static final /* synthetic */ CommonLogger access$getLogger$p(DataZipper $this) {
        return $this.logger;
    }
}

