/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.CommonLogger;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0015\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J \u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/bmc/ctmconvert/CommonLoggerImpl;", "Lcom/bmc/ctmconvert/CommonLogger;", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "logger$delegate", "Lkotlin/Lazy;", "prefix", "", "getPrefix", "()Ljava/lang/String;", "setPrefix", "(Ljava/lang/String;)V", "getLogDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "()Ljava/nio/file/Path;", "error", "", "msg", "thrown", "", "warning", "Ljava/lang/Exception;", "Lkotlin/Exception;", "info", "Common"})
@SourceDebugExtension(value={"SMAP\nCommonLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonLogger.kt\ncom/bmc/ctmconvert/CommonLoggerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class CommonLoggerImpl
implements CommonLogger {
    @NotNull
    public static final CommonLoggerImpl INSTANCE = new CommonLoggerImpl();
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(CommonLoggerImpl::logger_delegate$lambda$0);
    @NotNull
    private static String prefix = "";

    private CommonLoggerImpl() {
    }

    @NotNull
    public final Logger getLogger() {
        Lazy lazy = logger$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (Logger)t;
    }

    @NotNull
    public final String getPrefix() {
        return prefix;
    }

    public final void setPrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        prefix = string;
    }

    private final String prefix() {
        return ((CharSequence)prefix).length() == 0 ? "" : "[" + prefix + "] ";
    }

    private final Path getLogDirectory() {
        Path path;
        Path it = path = Paths.get("logs", new String[0]);
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue(Files.createDirectories(it, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(...)");
        return path;
    }

    @Override
    public void error(@NotNull String msg, @Nullable Throwable thrown) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.getLogger().log(Level.SEVERE, this.prefix() + msg, thrown);
    }

    @Override
    public void warning(@NotNull String msg, @Nullable Exception thrown) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.getLogger().log(Level.WARNING, this.prefix() + msg, thrown);
    }

    @Override
    public void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.getLogger().log(Level.INFO, this.prefix() + msg);
    }

    private static final Logger logger_delegate$lambda$0() {
        LogManager logManager = LogManager.getLogManager();
        InputStream inputStream = CommonLoggerImpl.class.getResourceAsStream("/logging.properties");
        Intrinsics.checkNotNull(inputStream);
        logManager.readConfiguration(inputStream);
        Logger logger = Logger.getGlobal();
        logger.setLevel(Level.FINEST);
        String timeStamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MM-dd-yyyy.HH-mm-ss"));
        Path logDirectory = INSTANCE.getLogDirectory();
        Path path = logDirectory.resolve("log" + timeStamp + ".log");
        Intrinsics.checkNotNullExpressionValue(path, "resolve(...)");
        FileHandler handler = new FileHandler(((Object)path.toAbsolutePath()).toString());
        handler.setFormatter(new SimpleFormatter());
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        return logger;
    }
}

