/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import com.bmc.ctmconvert.applications.ApplicationsDefs;
import com.bmc.ctmconvert.applications.ApplicationsEntitiy;
import com.bmc.ctmconvert.applications.ApplicationsJob;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.sap.SAPGlobals;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SAPJob
extends ApplicationsJob {
    private RulesDataSet SAPRules = null;
    private String DEFAULT_ACCOUNT = null;
    private String DEFAULT_TARGET_SERVER = null;
    private boolean START_CONDITION = false;
    private boolean INCLUDE_PERIODIC = false;
    private boolean INCLUDE_PLANNED_START_DATETIME = false;
    private String jobMode = null;
    private String jobCountSettings = null;
    private String jobCount = "";
    private String calendar = "";

    public SAPJob(ApplicationsEntitiy data, SchedEntity.TYPE type, ApplicationsDefs sourceDefinitions) {
        super(data, type, sourceDefinitions);
        this.init();
    }

    public SAPJob(ApplicationsEntitiy data, SchedEntity.TYPE type, SchedEntity parent, ApplicationsDefs sourceDefinitions) {
        super(data, type, parent, sourceDefinitions);
        this.init();
    }

    SAPJob(SchedEntity.TYPE type, String jobMode, String jobCount, boolean startCondition) {
        super(type);
        this.jobMode = jobMode;
        this.START_CONDITION = startCondition;
        this.jobCountSettings = "Specific_Job";
        this.jobCount = jobCount;
    }

    void setStartCondition(boolean startCondition) {
        this.START_CONDITION = startCondition;
    }

    public void addAutoEdits(String key, String value) {
        if (this.autoedits == null) {
            this.autoedits = new LinkedHashMap();
        }
        this.autoedits.put(key, value);
    }

    private void init() {
        Boolean isWorkDayMode;
        if (this.entityType == SchedEntity.TYPE.SMART_TABLE) {
            this.properties.setProperty("TABLE_USERDAILY", "SYSTEM");
        }
        this.SAPRules = RuleManager.instance().getCurrentRules();
        this.DEFAULT_ACCOUNT = this.SAPRules.getStringRule("SAP rules", new String[]{"DEFAULT_ACCOUNT"});
        this.DEFAULT_TARGET_SERVER = this.SAPRules.getStringRule("SAP rules", new String[]{"DEFAULT_TARGET_SERVER"});
        this.START_CONDITION = this.SAPRules.getBooleanRule("SAP rules", new String[]{"START_CONDITION"});
        this.INCLUDE_PERIODIC = this.SAPRules.getBooleanRule("SAP rules", new String[]{"INCLUDE_PERIODIC"});
        this.INCLUDE_PLANNED_START_DATETIME = this.SAPRules.getBooleanRule("SAP rules", new String[]{"INCLUDE_PLANNED_START_DATETIME"});
        this.jobMode = this.SAPRules.getStringRule("SAP rules", new String[]{"JOB_MODE"});
        this.jobCountSettings = this.SAPRules.getStringRule("SAP rules", new String[]{"JOB_COUNT_SETTING"});
        this.jobCount = this.getEntityValueByName("Variables", "JOBCOUNT");
        this.calendar = this.getEntityValueByName("Scheduling", "CALENDARID");
        String pStartDate = this.getEntityValueByName("Scheduling", "SDLSTRTDT");
        String pStartTime = this.getEntityValueByName("Scheduling", "SDLSTRTTM");
        String pLastDate = this.getEntityValueByName("Scheduling", "LASTSTRTDT");
        String pLastTime = this.getEntityValueByName("Scheduling", "LASTSTRTTM");
        if (this.INCLUDE_PLANNED_START_DATETIME) {
            boolean hasEndTime;
            boolean hasStartDate = pStartDate != null && !pStartDate.isEmpty() && pStartDate.length() >= 10;
            boolean hasEndDate = pLastDate != null && !pLastDate.isEmpty() && pLastDate.length() >= 10;
            boolean hasStartTime = pStartTime != null && !pStartTime.isEmpty();
            boolean bl = hasEndTime = pLastTime != null && !pLastTime.isEmpty();
            if (hasStartDate) {
                this.properties.put("ACTIVE_FROM", this.convertDateString(pStartDate));
            }
            if (hasStartTime) {
                this.properties.put("TIMEFROM", this.convertTimeString(pStartTime));
            }
            if (hasEndDate) {
                this.properties.put("ACTIVE_TILL", this.convertDateString(pLastDate));
            }
            if (hasEndTime) {
                this.properties.put("TIMETO", this.convertTimeString(pLastTime));
            }
        }
        if ((isWorkDayMode = Boolean.valueOf(this.calendar != null && !this.calendar.isEmpty() && pLastDate != null && !pLastDate.isEmpty() && (pLastTime == null || pLastTime.isEmpty()))).booleanValue()) {
            this.setWorkDayCalendarScheduling(this.calendar);
        } else {
            if (this.calendar != null && !this.calendar.isEmpty()) {
                Reporter.addMessage((List)this.messages, (String)"WRN13007", (String)this.getJobId(), (String[])new String[0]);
            }
            if (this.INCLUDE_PERIODIC) {
                String periodicEnabled = this.getEntityValueByName("Cyclic", "PERIODIC");
                String periodicMinutes = this.getEntityValueByName("Cyclic", "PRDMINS");
                String periodicHours = this.getEntityValueByName("Cyclic", "PRDHOURS");
                String periodicDays = this.getEntityValueByName("Cyclic", "PRDDAYS");
                String periodicWeeks = this.getEntityValueByName("Cyclic", "PRDWEEKS");
                String periodicMonths = this.getEntityValueByName("Cyclic", "PRDMONTHS");
                if (periodicEnabled != null && periodicEnabled.equalsIgnoreCase("X")) {
                    Integer interval = 0;
                    if (periodicMinutes != null && GlobalFunctions.isNumber((String)periodicMinutes)) {
                        interval = interval + Integer.parseInt(periodicMinutes);
                    }
                    if (periodicHours != null && GlobalFunctions.isNumber((String)periodicHours)) {
                        interval = interval + Integer.parseInt(periodicHours) * 60;
                    }
                    if (periodicDays != null && GlobalFunctions.isNumber((String)periodicDays)) {
                        interval = interval + Integer.parseInt(periodicDays) * 1440;
                    }
                    if (periodicWeeks != null && GlobalFunctions.isNumber((String)periodicWeeks)) {
                        interval = interval + Integer.parseInt(periodicWeeks) * 10080;
                    }
                    if (periodicMonths != null && GlobalFunctions.isNumber((String)periodicMonths)) {
                        interval = interval + Integer.parseInt(periodicMonths) * 43200;
                    }
                    if (interval > 64800) {
                        Reporter.addMessage((List)this.messages, (String)"WRN13001", (String)this.getJobId(), (String[])new String[]{interval.toString(), "64800", periodicMinutes, periodicHours, periodicDays, periodicWeeks, periodicMonths});
                        interval = 64800;
                    }
                    if (interval > 0) {
                        this.properties.put("CYCLIC", "1");
                        this.properties.put("CYCLIC_TYPE", "Interval");
                        this.properties.put("IND_CYCLIC", "START");
                        this.properties.put("INTERVAL", interval.toString());
                        this.properties.put("MAXWAIT", "99");
                    }
                }
            }
        }
    }

    String convertDateString(String inputString) {
        String result = inputString.substring(6, 10) + inputString.substring(3, 5) + inputString.substring(0, 2);
        return result;
    }

    String convertTimeString(String SAPTimeFormatString) {
        Object CTMTimeFormatString = SAPTimeFormatString;
        if (SAPTimeFormatString != null && !SAPTimeFormatString.isEmpty()) {
            try {
                String validSAPTimeFormatPattern = "([01][0-9]|2[0-3]):[0-5][0-9]:[0-9]{2}";
                boolean isValidSAPTimeFormat = SAPTimeFormatString.matches(validSAPTimeFormatPattern);
                if (isValidSAPTimeFormat) {
                    CTMTimeFormatString = SAPTimeFormatString.substring(0, 2) + SAPTimeFormatString.substring(3, 5);
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                ExceptionHandler.writeToExceptionFile((Exception)iobe);
                return SAPTimeFormatString;
            }
        }
        return CTMTimeFormatString;
    }

    private void setWorkDayCalendarScheduling(String calendar) {
        String periodicEnabled = this.getEntityValueByName("Cyclic", "PERIODIC");
        String periodicMinutes = this.getEntityValueByName("Cyclic", "PRDMINS");
        String periodicDays = this.getEntityValueByName("Cyclic", "PRDDAYS");
        String periodicMonths = this.getEntityValueByName("Cyclic", "PRDMONTHS");
        String pStartDate = this.getEntityValueByName("Scheduling", "SDLSTRTDT");
        this.setOptionalAttribute("DAYSCAL", calendar);
        String countingFrom = "D";
        if (Integer.parseInt(periodicMinutes) == 2) {
            countingFrom = "L";
        } else if (Integer.parseInt(periodicMinutes) == 1) {
            countingFrom = "D";
        } else {
            Reporter.addMessage((List)this.messages, (String)"WRN13004", (String)this.getJobId(), (String[])new String[]{periodicMinutes});
        }
        this.setOptionalAttribute("DAYS", String.format("%s%d", countingFrom, Integer.parseInt(periodicDays)));
        if (periodicEnabled != null && periodicEnabled.equalsIgnoreCase("X")) {
            int monthsPeriod = Integer.parseInt(periodicMonths);
            if (monthsPeriod > 12 || 12 % monthsPeriod != 0) {
                Reporter.addMessage((List)this.messages, (String)"WRN13005", (String)this.getJobId(), (String[])new String[]{"PRDMONTHS", periodicMonths});
            } else if (!pStartDate.matches("\\d{2}.\\d{2}.\\d{4}")) {
                Reporter.addMessage((List)this.messages, (String)"WRN13006", (String)this.getJobId(), (String[])new String[]{"SDLSTRTDT", pStartDate});
            } else {
                int initialMonth = Integer.parseInt(pStartDate.split("\\.")[1]);
                String[] months = GlobalFunctions.getMonthsArray();
                for (int i = 0; i < 12 / monthsPeriod; ++i) {
                    this.setOptionalAttribute(months[(initialMonth - 1 + i * monthsPeriod) % 12], "1");
                }
            }
        }
    }

    protected ApplicationsJob getApplicationsJob(ApplicationsEntitiy child) {
        SAPJob job = null;
        if (child.getEntityName().isEmpty()) {
            return job;
        }
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        filterDetails.put("Jobname", child.getEntityName());
        if (this.rules.getFilterHandler().isFilter(filterDetails)) {
            job = new SAPJob(child, SchedEntity.TYPE.JOB, (SchedEntity)this, this.sourceDefinitions);
        }
        return job;
    }

    public String originalProductID() {
        return "SAP";
    }

    public String getJobId() {
        if (this.type().equals((Object)SchedEntity.TYPE.JOB)) {
            return String.format("%s#%s", this.getOriginalJobName(), this.jobCount);
        }
        return this.getOriginalJobName();
    }

    public String getAttr(String attrName) {
        if (attrName.equals("OWNER")) {
            String sapR3Account = this.DEFAULT_ACCOUNT;
            if (this.entityType == SchedEntity.TYPE.JOB && this.autoedits != null && ((sapR3Account = (String)this.autoedits.get("%%SAPR3-ACCOUNT")) == null || sapR3Account.isEmpty())) {
                sapR3Account = this.DEFAULT_ACCOUNT;
            }
            return sapR3Account;
        }
        if (attrName.equals("MEMNAME")) {
            return this.properties.getProperty("JOBNAME");
        }
        if (attrName.equals("MEMLIB")) {
            return "Not in use for SAP jobs";
        }
        return this.properties.getProperty(attrName);
    }

    public List<Properties> getInConds() {
        List sourceInConds;
        ArrayList superInConds = super.getOutConds();
        if (this.START_CONDITION && (sourceInConds = this.sourceDefinitions.getJobInconds((SchedEntity)this)) != null) {
            if (superInConds == null) {
                superInConds = new ArrayList();
            }
            superInConds.addAll(sourceInConds);
        }
        return superInConds;
    }

    public List<Properties> getOutConds() {
        List sourceOutConds;
        ArrayList superOutConds = super.getOutConds();
        if (this.START_CONDITION && (sourceOutConds = this.sourceDefinitions.getJobOutconds((SchedEntity)this)) != null) {
            if (superOutConds == null) {
                superOutConds = new ArrayList();
            }
            superOutConds.addAll(sourceOutConds);
        }
        return superOutConds;
    }

    public List<Properties> getOnStmt() {
        List outConds;
        ArrayList<Properties> superOnStmts = super.getOnStmt();
        if (this.START_CONDITION && (outConds = this.sourceDefinitions.getJobOutconds((SchedEntity)this)) != null) {
            if (superOnStmts == null) {
                superOnStmts = new ArrayList<Properties>();
            }
            for (Properties outCond : outConds) {
                Properties tmpStatement = new Properties();
                tmpStatement.setProperty("CODE", String.format("NOTOK", new Object[0]));
                tmpStatement.setProperty("STMT", "*");
                tmpStatement.setProperty("ACTION", "DOCOND");
                tmpStatement.setProperty("NAME", outCond.get("NAME").toString());
                tmpStatement.setProperty("ODATE", outCond.get("ODATE").toString());
                tmpStatement.setProperty("SIGN", outCond.get("SIGN").toString());
                superOnStmts.add(tmpStatement);
            }
        }
        return superOnStmts;
    }

    public LinkedHashMap<String, String> getAutoedits() {
        String sapR3EventId;
        String targetServer;
        String sapR3Account;
        LinkedHashMap<String, String> sapAutoEdits = super.getAutoedits();
        if (this.entityType != SchedEntity.TYPE.JOB) {
            return sapAutoEdits;
        }
        if (sapAutoEdits == null) {
            sapAutoEdits = new LinkedHashMap<String, String>();
        }
        if (StringUtils.isEmpty((CharSequence)(sapR3Account = (String)sapAutoEdits.get("%%SAPR3-ACCOUNT")))) {
            sapR3Account = this.DEFAULT_ACCOUNT;
            sapAutoEdits.put("%%SAPR3-ACCOUNT", sapR3Account);
        }
        if (sapR3Account != null) {
            this.properties.setProperty("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", sapR3Account));
        }
        if (StringUtils.isEmpty((CharSequence)(targetServer = (String)sapAutoEdits.get("%%SAPR3-TARGET_SERVER")))) {
            sapAutoEdits.put("%%SAPR3-TARGET_SERVER", this.DEFAULT_TARGET_SERVER);
        }
        sapAutoEdits.put("%%SAPR3-JOB_MODE", this.jobMode);
        if (this.jobMode.equalsIgnoreCase("RUN_COPY")) {
            sapAutoEdits.put("%%SAPR3-JOB_COUNT", this.jobCountSettings);
            sapAutoEdits.put("%%SAPR3-JOBCOUNT", this.jobCountSettings);
            if (this.jobCount != null && this.jobCountSettings.equals("Specific_Job")) {
                sapAutoEdits.put("%%SAPR3-JOBCOUNT", this.jobCount);
            }
            sapAutoEdits.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("%%SAPR3-STEP-"));
        }
        String submitASAP = "X";
        if (this.START_CONDITION && StringUtils.isNotEmpty((CharSequence)(sapR3EventId = (String)sapAutoEdits.get("%%SAPR3-EVENT_ID"))) && !sapR3EventId.equalsIgnoreCase("SAP_END_OF_JOB")) {
            submitASAP = "E";
        }
        if (!submitASAP.equals("E")) {
            sapAutoEdits.remove("%%SAPR3-EVENT_ID");
            sapAutoEdits.remove("%%SAPR3-EVENT_PARAM");
        }
        sapAutoEdits.put("%%SAPR3-SUBMIT_ASAP", submitASAP);
        sapAutoEdits.values().removeAll(Collections.singleton("CTM_VALUE_NOT_EXTRACTED"));
        return sapAutoEdits;
    }

    public List<Properties> getTags() {
        if (this.entityType == SchedEntity.TYPE.JOB) {
            return null;
        }
        return super.getTags();
    }

    protected String resolveCompetitorFieldForFieldEditor(String fieldName) {
        String res = "";
        if (fieldName.equals(SAPGlobals.RULE_COMPETITOR_VALUE_SAP_JOB_NAME)) {
            res = super.getEntityValueByName("Variables", "JOBNAME");
        } else if (fieldName.equals(SAPGlobals.RULE_COMPETITOR_VALUE_TARGET_SERVER)) {
            res = super.getEntityValueByName("Variables", "EXECSERVER");
        }
        return res;
    }
}

