/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import com.bmc.ctmconvert.applications.ApplicationsHierarchyTree;
import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Params;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SAPAssessmentReport
extends AbstractAssessmentReport {
    private static final String JOBS_NODE_NAME = "Jobs";
    private static final String CALENDARS_NODE_NAME = "Calendars";
    private static final String JOB_NAME_DEFINITION = "JOBNAME";
    private static final String JOBCOUNT_DEFINITION = "JOBCOUNT";
    private static final String STEP_DEFINITION = "STEP";
    private static final String JOBS_DESCRIPTION_XML = "Jobs";
    private static final String CALENDARS_DESCRIPTION_XML = "Calendars";
    private static final String NUMBER_OF_ELEMENTS_XML = "#NUMBER_OF_ELEMENTS#";
    private static final String KEY_VALUE_SEPARETOR = "\t\t: ";
    private static final String SECTION_SEPARETOR = "------------------------------------------------------------------------------ \n";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private ArrayList<String> descriptionTypeLookNodes;
    private LinkedHashMap<String, String> descriptionMap_NodeName_NodeDesc;
    private LinkedHashMap<Key, SAPJob> descriptionMap_JobName_SAPJob;
    private LinkedHashMap<String, SAPCalendar> descriptionMap_calendarName_SAPCalendar;

    public SAPAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.descriptionTypeLookNodes = new ArrayList();
        this.descriptionMap_JobName_SAPJob = new LinkedHashMap();
        this.descriptionMap_calendarName_SAPCalendar = new LinkedHashMap();
        this.descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        this.getDataFromFiles();
    }

    private void getDataFromFiles() {
        ArrayList fileList = ApplicationsHierarchyTree.getDataFilesList();
        for (File SAPXmlFile : fileList) {
            this.getDataFromFile(SAPXmlFile);
        }
    }

    private void getDataFromFile(File SAPXmlFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(SAPXmlFile);
            NodeList Jobslist = doc.getElementsByTagName("JobData");
            NodeList Calendarslist = doc.getElementsByTagName("Calendar");
            this.getjobsData(Jobslist);
            this.getCalendarData(Calendarslist);
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private void getCalendarData(NodeList calendarslist) {
        for (int i = 0; i < calendarslist.getLength(); ++i) {
            Element calendarElement = (Element)calendarslist.item(i);
            SAPCalendar calendar = new SAPCalendar(this, calendarElement);
            String calendarName = calendar.calndarName();
            this.descriptionMap_calendarName_SAPCalendar.put(calendarName, calendar);
        }
    }

    private void getjobsData(NodeList jobslist) {
        for (int i = 0; i < jobslist.getLength(); ++i) {
            Element jobElement = (Element)jobslist.item(i);
            SAPJob job = new SAPJob(jobElement);
            String jobCount = job.getJobDefinitionByName(JOBCOUNT_DEFINITION);
            String jobName = job.getJobDefinitionByName(JOB_NAME_DEFINITION);
            this.descriptionMap_JobName_SAPJob.put(new Key(this, jobName, jobCount), job);
        }
    }

    private ArrayList<Element> getElementsByTagNameFromNodeList(NodeList Nodelist, String tagname) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int j = 0; j < Nodelist.getLength(); ++j) {
            Element element = (Element)Nodelist.item(j);
            NodeList tagslist = element.getElementsByTagName(tagname);
            for (int i = 0; i < tagslist.getLength(); ++i) {
                Element newElement = (Element)tagslist.item(i);
                list.add(newElement);
            }
        }
        return list;
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        String jobsNodeName = "Jobs(" + this.descriptionMap_JobName_SAPJob.size() + ")";
        String calendarsNodeName = "Calendars(" + this.descriptionMap_calendarName_SAPCalendar.size() + ")";
        DefaultMutableTreeNode jobsNode = new DefaultMutableTreeNode(jobsNodeName);
        DefaultMutableTreeNode calendarsNode = new DefaultMutableTreeNode(calendarsNodeName);
        this.descriptionTypeLookNodes.add(jobsNodeName);
        this.descriptionTypeLookNodes.add(calendarsNodeName);
        String jobsNodeDescription = this.descriptionMap_NodeName_NodeDesc.get("Jobs").replaceAll(NUMBER_OF_ELEMENTS_XML, Integer.toString(this.descriptionMap_JobName_SAPJob.size()));
        String calendarsNodeDescription = this.descriptionMap_NodeName_NodeDesc.get("Calendars").replaceAll(NUMBER_OF_ELEMENTS_XML, Integer.toString(this.descriptionMap_calendarName_SAPCalendar.size()));
        this.descriptionMap_NodeName_NodeDesc.put("Jobs", jobsNodeDescription);
        this.descriptionMap_NodeName_NodeDesc.put("Calendars", calendarsNodeDescription);
        this.descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), "Summary:\n\n" + jobsNodeDescription + "\n" + calendarsNodeDescription);
        jobsNode = this.addJobsToNode(jobsNode);
        calendarsNode = this.addCalendarsToNode(calendarsNode);
        mainTreeNodes.add(jobsNode);
        mainTreeNodes.add(calendarsNode);
        return mainTreeNodes;
    }

    private DefaultMutableTreeNode addCalendarsToNode(DefaultMutableTreeNode calendarsNode) {
        for (String name : this.descriptionMap_calendarName_SAPCalendar.keySet()) {
            DefaultMutableTreeNode calendarNode = new DefaultMutableTreeNode(name);
            calendarsNode.add(calendarNode);
        }
        return calendarsNode;
    }

    private DefaultMutableTreeNode addJobsToNode(DefaultMutableTreeNode jobsNode) {
        for (Key key : this.descriptionMap_JobName_SAPJob.keySet()) {
            DefaultMutableTreeNode jobNode = new DefaultMutableTreeNode(key.jobName + "(" + key.jobCount + ")");
            SAPJob Job = this.descriptionMap_JobName_SAPJob.get(key);
            LinkedHashMap<String, Step> stepHash = Job.getSteps();
            for (String step : stepHash.keySet()) {
                DefaultMutableTreeNode stepNode = new DefaultMutableTreeNode(step);
                jobNode.add(stepNode);
            }
            jobsNode.add(jobNode);
        }
        return jobsNode;
    }

    protected String getJobInfo(String messageID) {
        int NODE_TYPE_INDEX;
        if (messageID.isEmpty()) {
            return null;
        }
        String[] nodePath = messageID.split(";");
        if (nodePath[NODE_TYPE_INDEX = 1].startsWith("Jobs")) {
            return this.getJobNodeInfo(nodePath);
        }
        if (nodePath[NODE_TYPE_INDEX].startsWith("Calendars")) {
            return this.getCalendarNodeInfo(nodePath);
        }
        return "";
    }

    private String getCalendarNodeInfo(String[] nodePath) {
        StringBuilder ret = new StringBuilder();
        String calendarName = nodePath[nodePath.length - 1];
        SAPCalendar cal = this.descriptionMap_calendarName_SAPCalendar.get(calendarName);
        ret.append(cal.toString());
        return ret.toString();
    }

    private String getJobNodeInfo(String[] nodePath) {
        String nodeName;
        StringBuilder ret = new StringBuilder();
        String stepNumber = null;
        if (nodePath[nodePath.length - 1].matches("\\d+")) {
            nodeName = nodePath[nodePath.length - 2];
            stepNumber = nodePath[nodePath.length - 1];
        } else {
            nodeName = nodePath[nodePath.length - 1];
        }
        String jobName = nodeName.replaceAll("\\(\\d+\\)", "");
        String jobCount = nodeName.replaceFirst(".*\\(", "").replaceAll("\\)", "");
        Key key = new Key(this, jobName, jobCount);
        SAPJob job = this.descriptionMap_JobName_SAPJob.get(key);
        if (stepNumber == null) {
            ret.append(job == null ? "" : job.toString());
        } else {
            Step step = job.getStep(stepNumber);
            ret.append(step.toString());
        }
        return ret.toString();
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        return this.descriptionTypeLookNodes;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        return this.descriptionMap_NodeName_NodeDesc;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return null;
    }

    private class SAPCalendar {
        private String calendarName;
        private LinkedHashMap<String, YearCalendar> map_yearName_yearCalendar = new LinkedHashMap();

        public SAPCalendar(SAPAssessmentReport sAPAssessmentReport, Element calendarElement) {
            this.calendarName = calendarElement.getAttribute("NAME");
            NodeList yearlist = calendarElement.getElementsByTagName("Year");
            for (int i = 0; i < yearlist.getLength(); ++i) {
                Element yearElement = (Element)yearlist.item(i);
                YearCalendar yearCalendar = sAPAssessmentReport.new YearCalendar(yearElement);
                String yearName = yearCalendar.getName();
                this.map_yearName_yearCalendar.put(yearName, yearCalendar);
            }
        }

        public String calndarName() {
            return this.calendarName;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            for (String yearName : this.map_yearName_yearCalendar.keySet()) {
                YearCalendar year = this.map_yearName_yearCalendar.get(yearName);
                str.append(yearName + "\n");
                str.append(SAPAssessmentReport.SECTION_SEPARETOR);
                str.append(year.toString());
                str.append("\n");
            }
            return str.toString();
        }
    }

    private class SAPJob {
        private LinkedHashMap<String, String> general_data;
        private LinkedHashMap<String, String> cyclic_data;
        private LinkedHashMap<String, String> scheduling_data;
        private LinkedHashMap<String, Step> stepMAP_stepName_Step;
        private ArrayList<Element> VariablesfieldList;
        private ArrayList<Element> CyclicfieldList;
        private ArrayList<Element> SchedulingfieldList;

        public SAPJob(Element jobElement) {
            NodeList Variableslist = jobElement.getElementsByTagName("Variables");
            NodeList Cycliclist = jobElement.getElementsByTagName("Cyclic");
            NodeList Schedulinglist = jobElement.getElementsByTagName("Scheduling");
            this.VariablesfieldList = SAPAssessmentReport.this.getElementsByTagNameFromNodeList(Variableslist, "Field");
            this.CyclicfieldList = SAPAssessmentReport.this.getElementsByTagNameFromNodeList(Cycliclist, "Field");
            this.SchedulingfieldList = SAPAssessmentReport.this.getElementsByTagNameFromNodeList(Schedulinglist, "Field");
            this.general_data = new LinkedHashMap();
            this.cyclic_data = new LinkedHashMap();
            this.scheduling_data = new LinkedHashMap();
            this.stepMAP_stepName_Step = new LinkedHashMap();
            this.getStepsData();
            this.getCyclicData();
            this.getSchedulingData();
        }

        private void getSchedulingData() {
            for (Element field : this.SchedulingfieldList) {
                String name = field.getAttributes().getNamedItem("NAME").getNodeValue();
                String value = field.getAttributes().getNamedItem("VALUE").getNodeValue();
                this.scheduling_data.put(name, value);
            }
        }

        private void getCyclicData() {
            for (Element field : this.CyclicfieldList) {
                String name = field.getAttributes().getNamedItem("NAME").getNodeValue();
                String value = field.getAttributes().getNamedItem("VALUE").getNodeValue();
                this.cyclic_data.put(name, value);
            }
        }

        private String getJobDefinitionByName(String name) {
            for (Element field : this.VariablesfieldList) {
                String attrkey = field.getAttributes().getNamedItem("NAME").getNodeValue();
                String attrValue = field.getAttributes().getNamedItem("VALUE").getNodeValue();
                if (!attrkey.equals(name)) continue;
                return attrValue;
            }
            return null;
        }

        private void getStepsData() {
            for (Element field : this.VariablesfieldList) {
                String AutoEditValue = field.getAttributes().getNamedItem("AUTOEDIT").getNodeValue();
                String name = field.getAttributes().getNamedItem("NAME").getNodeValue();
                String value = field.getAttributes().getNamedItem("VALUE").getNodeValue();
                if (AutoEditValue.contains(SAPAssessmentReport.STEP_DEFINITION)) {
                    Pattern stepPat = Pattern.compile("STEP-S\\d+");
                    Pattern number = Pattern.compile("\\d+");
                    Matcher m = stepPat.matcher(AutoEditValue);
                    if (!m.find()) continue;
                    m = number.matcher(m.group());
                    m.find();
                    String stepNumber = m.group();
                    if (!this.stepMAP_stepName_Step.containsKey(stepNumber)) {
                        this.stepMAP_stepName_Step.put(stepNumber, new Step());
                    }
                    Step step = this.stepMAP_stepName_Step.get(stepNumber);
                    step.put(name, value);
                    continue;
                }
                this.general_data.put(name, value);
            }
        }

        private Step getStep(String stepNumber) {
            return this.stepMAP_stepName_Step.get(stepNumber);
        }

        private LinkedHashMap<String, Step> getSteps() {
            return this.stepMAP_stepName_Step;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            String sep = SAPAssessmentReport.KEY_VALUE_SEPARETOR;
            str.append("General\n");
            str.append(SAPAssessmentReport.SECTION_SEPARETOR);
            for (String name : this.general_data.keySet()) {
                if (name.length() > 10) {
                    str.append(name + "\t: " + this.general_data.get(name)).append("\n");
                    continue;
                }
                if (name.equals("")) continue;
                str.append(name + sep + this.general_data.get(name)).append("\n");
            }
            str.append("\nCyclic\n");
            str.append(SAPAssessmentReport.SECTION_SEPARETOR);
            for (String name : this.cyclic_data.keySet()) {
                str.append(name + sep + this.cyclic_data.get(name));
                str.append("\n");
            }
            str.append("\nScheduling\n");
            str.append(SAPAssessmentReport.SECTION_SEPARETOR);
            for (String name : this.scheduling_data.keySet()) {
                str.append(name + sep + this.scheduling_data.get(name));
                str.append("\n");
            }
            return str.toString();
        }
    }

    public class Key {
        public String jobName;
        public String jobCount;

        public Key(SAPAssessmentReport this$0, String jobName, String jobCount) {
            this.jobName = jobName;
            this.jobCount = jobCount;
        }

        public int hashCode() {
            return this.jobName.hashCode() ^ this.jobCount.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.jobName.equals(other.jobName)) {
                return false;
            }
            return this.jobCount.equals(other.jobCount);
        }
    }

    private class Step
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1L;

        private Step() {
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            for (String key : this.keySet()) {
                ret.append(key + SAPAssessmentReport.KEY_VALUE_SEPARETOR + (String)this.get(key) + "\n");
            }
            return ret.toString();
        }
    }

    private class YearCalendar
    extends LinkedHashMap<String, String> {
        private String yearname;
        private static final long serialVersionUID = 1L;

        public YearCalendar(Element yearElement) {
            this.yearname = yearElement.getAttribute("Number");
            NodeList monthList = yearElement.getElementsByTagName("Month");
            for (int i = 0; i < monthList.getLength(); ++i) {
                Element monthElement = (Element)monthList.item(i);
                String monthNumber = monthElement.getAttribute("Number");
                String Days = monthElement.getAttribute("Days");
                this.put(monthNumber, Days);
            }
        }

        public String getName() {
            return this.yearname;
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            for (String key : this.keySet()) {
                ret.append(key + SAPAssessmentReport.KEY_VALUE_SEPARETOR + (String)this.get(key) + "\n");
            }
            return ret.toString();
        }
    }
}

