/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.validation;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class ValidationProperties {
    public static String valueDefaultAll = "(Default: All)";
    private static final String defaultValidationPropertiesFileName = "Validation.properties";
    private String m_conversionPath = "";
    private String m_ValidationPropertiesFileName = "";
    Properties m_Validation_Properties = new Properties();

    public ValidationProperties(String validationPropertiesFileName) {
        this.m_conversionPath = ConversionEntitiesService.getCurrentConversionDirectory();
        this.m_ValidationPropertiesFileName = this.m_conversionPath + Globs.DIRSEP + defaultValidationPropertiesFileName;
        if (validationPropertiesFileName != null) {
            this.m_ValidationPropertiesFileName = validationPropertiesFileName;
        }
        if (GlobalFunctions.isFileExist((String)this.m_ValidationPropertiesFileName)) {
            try {
                this.loadValidationProperties();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadValidationProperties() throws IOException {
        FileInputStream inputStream = new FileInputStream(this.m_ValidationPropertiesFileName);
        this.m_Validation_Properties.load(inputStream);
        inputStream.close();
    }

    public void saveValidationProperties() {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.m_ValidationPropertiesFileName);
            this.m_Validation_Properties.store(outputStream, null);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public String getCtmName() {
        return this.m_Validation_Properties.getProperty("CtmName");
    }

    public void setCtmName(String ctmName) {
        this.m_Validation_Properties.setProperty("CtmName", ctmName);
    }

    public String getCtmForecast() {
        return this.m_Validation_Properties.getProperty("CtmForecast");
    }

    public void setCtmForecast(String ctmForecast) {
        this.m_Validation_Properties.setProperty("CtmForecast", ctmForecast);
    }

    public String getFirstDayOfWeek() {
        return this.m_Validation_Properties.getProperty("FirstDayOfWeek");
    }

    public void setFirstDayOfWeek(String firstDayOfWeek) {
        this.m_Validation_Properties.setProperty("FirstDayOfWeek", firstDayOfWeek);
    }

    public void setFilterProperties(String tableName, String jobName, String application, String memlib, Date fromDate, Date toDate) {
        this.m_Validation_Properties.setProperty("FilterTableName", tableName);
        this.m_Validation_Properties.setProperty("FilterJobName", jobName);
        this.m_Validation_Properties.setProperty("FilterApplication", application);
        this.m_Validation_Properties.setProperty("FilterMemlib", memlib);
        this.m_Validation_Properties.setProperty("FilterFromDate", GlobalFunctions.getDateStringFromDate((Date)fromDate, (String)"yyyyMMdd"));
        this.m_Validation_Properties.setProperty("FilterToDate", GlobalFunctions.getDateStringFromDate((Date)toDate, (String)"yyyyMMdd"));
    }

    public String getFilterTableName() {
        return this.m_Validation_Properties.getProperty("FilterTableName");
    }

    public String getFilterJobName() {
        return this.m_Validation_Properties.getProperty("FilterJobName");
    }

    public String getFilterApplication() {
        return this.m_Validation_Properties.getProperty("FilterApplication");
    }

    public String getFilterMemlib() {
        return this.m_Validation_Properties.getProperty("FilterMemlib");
    }

    public Date getFilterFromDate() {
        return GlobalFunctions.getDateByFormat((String)this.m_Validation_Properties.getProperty("FilterFromDate"), (String)"yyyyMMdd");
    }

    public Date getFilterToDate() {
        return GlobalFunctions.getDateByFormat((String)this.m_Validation_Properties.getProperty("FilterToDate"), (String)"yyyyMMdd");
    }

    public void setCalendarFile(String calendarFile) {
        this.m_Validation_Properties.setProperty("CalendarFile", calendarFile);
    }

    public String getCalendarFile() {
        return this.m_Validation_Properties.getProperty("CalendarFile");
    }

    public void setVendorForecast(String vendorForecast) {
        this.m_Validation_Properties.setProperty("VendorForecast", vendorForecast);
    }

    public String getVendorForecast() {
        return this.m_Validation_Properties.getProperty("VendorForecast");
    }

    private String buildJobValidationSettingKeyName(String table, String job) {
        return "JobValidationSetting|" + table + "|" + job;
    }

    public void setJobValidationSetting(String table, String job, String validationSetting) {
        String key = this.buildJobValidationSettingKeyName(table, job);
        if (validationSetting == null) {
            this.m_Validation_Properties.remove(key);
        } else {
            this.m_Validation_Properties.setProperty(key, validationSetting);
        }
    }

    public String getJobValidationSetting(String table, String job) {
        String key = this.buildJobValidationSettingKeyName(table, job);
        return this.m_Validation_Properties.getProperty(key);
    }

    public void setLastFocusCellDate(Date cellDate) {
        this.m_Validation_Properties.setProperty("LastFocusCellDate", GlobalFunctions.getDateStringFromDate((Date)cellDate, (String)"yyyyMMdd"));
    }

    public Date getLastFocusCellDate() {
        return GlobalFunctions.getDateByFormat((String)this.m_Validation_Properties.getProperty("LastFocusCellDate"), (String)"yyyyMMdd");
    }

    public void setLastFocusCellType(String entityType) {
        this.m_Validation_Properties.setProperty("LastFocusCellType", entityType);
    }

    public String getLastFocusCellType() {
        return this.m_Validation_Properties.getProperty("LastFocusCellType");
    }

    public void setLastFocusTable(String table) {
        this.m_Validation_Properties.setProperty("LastFocusTable", table);
    }

    public String getLastFocusTable() {
        return this.m_Validation_Properties.getProperty("LastFocusTable");
    }

    public void setLastFocusJob(String job) {
        this.m_Validation_Properties.setProperty("LastFocusJob", job);
    }

    public String getLastFocusJob() {
        return this.m_Validation_Properties.getProperty("LastFocusJob");
    }

    public String getForecastOutputFile() {
        return this.m_Validation_Properties.getProperty("forecastOutputFile");
    }

    public void setForecastOutputFile(String forecastOutputFile) {
        this.m_Validation_Properties.setProperty("forecastOutputFile", forecastOutputFile);
    }

    public String getForecastWarningsFile() {
        return this.m_Validation_Properties.getProperty("forecastWarningsFile");
    }

    public void setForecastWarningsFile(String forecastWarningsFile) {
        this.m_Validation_Properties.setProperty("forecastWarningsFile", forecastWarningsFile);
    }
}

