/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseCheckBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseCopyableLabel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseImagePanel;
import com.bmc.ctmconvert.base.BaseLinkLabel;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePasswordField;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextContainer;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ClipboardManager;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.flow.EmDetailsExtractor;
import com.bmc.ctmconvert.gui.flow.FlowGlobalFunction;
import com.bmc.ctmconvert.gui.flow.FlowManager;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import com.bmc.ctmconvert.utils.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;

public class LoadToEmPanel
extends FlowPanel
implements ActionListener {
    private static LoadToEmPanel instance;
    private static String conversionName;
    private BaseContentPanel oldContent;
    private final BaseCheckBox startEM;
    private BaseField userNameField;
    private final BaseTextField userName;
    private BaseField passwordField;
    private final BasePasswordField password;
    private BaseField machineNameField;
    private final BaseTextField machineName;
    private final BaseTextField port;
    private BaseCheckBox loadCalendars;
    private final String filesPath;

    public static LoadToEmPanel instance() {
        if (instance == null || !Params.instance().getConversionName().equals(conversionName)) {
            conversionName = Params.instance().getConversionName();
            instance = new LoadToEmPanel();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private boolean isEmExist() {
        EmDetailsExtractor extractor = new EmDetailsExtractor();
        return extractor.isEmExist();
    }

    private boolean isLoadableToEm() {
        return SettingsBooleanKeys.isOnPremise() && this.isEmExist();
    }

    private LoadToEmPanel() {
        boolean isDollarUniverseHdpConversion;
        boolean hasCalendarFile = !FlowGlobalFunction.getCalendarsFileFullPath().isEmpty();
        boolean isLoadableToEm = this.isLoadableToEm();
        BaseFooterPanel footer = this.getManualLoadInstructionsPanel(isLoadableToEm);
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("TITLE_LOAD_TO_CONTROLM")), footer);
        this.setImagePanel(new BaseImagePanel(this.getClass().getResource(FlowGlobals.SIDE_IMAGE_7_PATH)));
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.BACK, ButtonFactory.ButtonType.NEXT, ButtonFactory.ButtonType.QUIT}));
        String draftDirectory = this.filesPath = ConversionEntitiesService.getCurrentConversionDirectory();
        BaseSection conversionResultSection = new BaseSection(TextManager.instance().get("SECTION_CONVERSION_RESULT"));
        conversionResultSection.addField(new BaseField((BaseComponent)new BaseCopyableLabel(""), TextManager.instance().get("FIELD_LOAD_CONVERSION_RESULTS_FOLDER")));
        conversionResultSection.addField(this.createCopyToClipboardButton(draftDirectory));
        conversionResultSection.addField(new BaseField((BaseComponent)new BaseCopyableLabel(Params.instance().getConversionName()), TextManager.instance().get("FIELD_LOAD_CONVERSION_NAME")));
        conversionResultSection.addField(new BaseField((BaseComponent)this.createRulesSetTitleLabel(), TextManager.instance().get("FIELD_LOAD_RULES_NAME")));
        this.baseContentPanel.addSection(conversionResultSection);
        BaseSection startEMSection = new BaseSection(TextManager.instance().get("SECTION_CONTROL_M_DETAILS"));
        this.startEM = new BaseCheckBox(TextManager.instance().get("FIELD_START_EM"));
        this.startEM.setSelected(isLoadableToEm);
        this.startEM.addActionListener(e -> {
            this.userNameField.setEnabled(this.startEM.isSelected());
            this.passwordField.setEnabled(this.startEM.isSelected());
            this.machineNameField.setEnabled(this.startEM.isSelected());
            if (SettingsBooleanKeys.isXmlCalendarFileEnabled()) {
                this.loadCalendars.setEnabled(hasCalendarFile && this.startEM.isSelected());
            }
        });
        startEMSection.addField(new BaseField((BaseComponent)this.startEM));
        this.userName = new BaseTextField();
        this.userNameField = new BaseField((BaseComponent)this.userName, TextManager.instance().get("FIELD_LOAD_USER_NAME") + " ", 17);
        startEMSection.addField(this.userNameField);
        this.password = new BasePasswordField();
        this.passwordField = new BaseField((BaseComponent)this.password, TextManager.instance().get("FIELD_LOAD_PASSWORD") + " ", 17);
        startEMSection.addField(this.passwordField);
        String guiServerName = SettingsTable.instance().getProperty(SettingsStringKeys.GUI_SERVER_NAME, Params.instance().getHostname());
        this.machineName = new BaseTextField(guiServerName);
        this.machineNameField = new BaseField((BaseComponent)this.machineName, TextManager.instance().get("FIELD_LOAD_MACHINE_NAME") + " ", 17);
        startEMSection.addField(this.machineNameField);
        this.port = new BaseTextField("18080");
        BaseField portField = new BaseField((BaseComponent)this.port, TextManager.instance().get("FIELD_LOAD_PORT_NUMBER") + " ", 17);
        startEMSection.addField(portField);
        if (SettingsBooleanKeys.isXmlCalendarFileEnabled()) {
            this.loadCalendars = new BaseCheckBox(TextManager.instance().get("FIELD_LOAD_CALENDARS"));
            this.loadCalendars.setSelected(hasCalendarFile);
            this.loadCalendars.setEnabled(hasCalendarFile);
            BaseField loadCalendarsField = new BaseField((BaseComponent)this.loadCalendars, 17);
            startEMSection.addField(loadCalendarsField);
        }
        this.baseContentPanel.addSection(startEMSection);
        if (Params.instance().isZOS()) {
            BaseSection zosPostActions = new BaseSection("Setting Control-M data in Mainframe");
            BaseTextContainer zosPostActionsInstruction = new BaseTextContainer(this.getZosInstructions());
            BaseField zosPostActionsInstructionField = new BaseField((BaseComponent)zosPostActionsInstruction);
            zosPostActionsInstructionField.setFillAllArea(true);
            zosPostActions.addField(zosPostActionsInstructionField);
            this.baseContentPanel.addSection(zosPostActions);
        }
        BaseFooterPanel instructionFooter = null;
        if (isLoadableToEm) {
            ArrayList<BaseButton> componentList = new ArrayList<BaseButton>();
            BaseButton showAutomticLoad = new BaseButton(TextManager.instance().get("FIELD_LOAD_SHOW_AUTOMATIC_LOADING"));
            showAutomticLoad.setMnemonic(82);
            showAutomticLoad.addActionListener((ActionListener)this);
            componentList.add(showAutomticLoad);
            instructionFooter = new BaseFooterPanel(componentList);
        }
        BaseContentPanel instructionContent = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("TITLE_LOAD_TO_CONTROLM")), instructionFooter);
        BaseSection instructionConversionResultSection = new BaseSection(TextManager.instance().get("SECTION_CONVERSION_RESULT"));
        instructionConversionResultSection.addField(new BaseField((BaseComponent)new BaseCopyableLabel(""), TextManager.instance().get("FIELD_LOAD_CONVERSION_RESULTS_FOLDER")));
        instructionConversionResultSection.addField(this.createCopyToClipboardButton(draftDirectory));
        instructionConversionResultSection.addField(new BaseField((BaseComponent)new BaseCopyableLabel(Params.instance().getDatasourceName()), TextManager.instance().get("FIELD_LOAD_PROJECT_NAME")));
        instructionConversionResultSection.addField(new BaseField((BaseComponent)new BaseCopyableLabel(Params.instance().getConversionName()), TextManager.instance().get("FIELD_LOAD_CONVERSION_NAME")));
        instructionConversionResultSection.addField(new BaseField((BaseComponent)new BaseCopyableLabel(""), TextManager.instance().get("FIELD_LOAD_RULES_NAME")));
        instructionContent.addSection(instructionConversionResultSection);
        BaseSection loadDrafts = new BaseSection(TextManager.instance().get("SECTION_LOAD_DRAFTS"));
        BaseTextContainer loadDraftsInstruction = new BaseTextContainer(this.getLoadDraftInstructions(draftDirectory));
        BaseField loadDraftsInstructionField = new BaseField((BaseComponent)loadDraftsInstruction);
        loadDraftsInstructionField.setFillAllArea(true);
        loadDrafts.addField(loadDraftsInstructionField);
        instructionContent.addSection(loadDrafts);
        if (hasCalendarFile) {
            BaseSection loadCalendarsSection = new BaseSection("Loading Calendar Definitions");
            BaseTextContainer loadCalendarsInstruction = new BaseTextContainer(this.getLoadCalendarsInstruction());
            BaseField loadCalendarsInstructionField = new BaseField((BaseComponent)loadCalendarsInstruction);
            loadCalendarsInstructionField.setFillAllArea(true);
            loadCalendarsSection.addField(loadCalendarsInstructionField);
            instructionContent.addSection(loadCalendarsSection);
        }
        if (isDollarUniverseHdpConversion = this.isDollarUniverseHdpConversion()) {
            BaseSection loadHDP = new BaseSection("Dollar Universe HDP jobs handling");
            String scriptDir = ConversionEntitiesService.getCurrentConversionDirectory() + "HDP";
            String hdpInstructions = this.getHdpInstructions(scriptDir);
            BaseTextContainer loadHDPInstruction = new BaseTextContainer(hdpInstructions);
            BaseField loadHDPInstructionField = new BaseField((BaseComponent)loadHDPInstruction);
            loadHDPInstructionField.setFillAllArea(true);
            loadHDP.addField(loadHDPInstructionField);
            instructionContent.addSection(loadHDP);
        }
        BaseSection postConversionSection = new BaseSection(TextManager.instance().get("POST_CONVERSION_ACTIONS"));
        String postConversionInstructions = this.getPostConversionInstructions();
        BaseField postConversionField = new BaseField((BaseComponent)new BaseTextContainer(postConversionInstructions));
        postConversionField.setFillAllArea(true);
        postConversionSection.addField(postConversionField);
        instructionContent.addSection(postConversionSection);
        if (Params.instance().isZOS()) {
            BaseSection zosPostActions = new BaseSection("Setting Control-M data in Mainframe");
            BaseTextContainer zosPostActionsInstruction = new BaseTextContainer(this.getZosInstructions());
            BaseField zosPostActionsInstructionField = new BaseField((BaseComponent)zosPostActionsInstruction);
            zosPostActionsInstructionField.setFillAllArea(true);
            zosPostActions.addField(zosPostActionsInstructionField);
            instructionContent.addSection(zosPostActions);
        }
        instructionContent.buildContentPanel();
        this.oldContent = instructionContent;
        this.baseContentPanel.buildContentPanel();
        if (isLoadableToEm) {
            this.setContentPanel(this.baseContentPanel);
        } else {
            this.setContentPanel(instructionContent);
        }
        this.setValid(true);
    }

    private BaseFooterPanel getManualLoadInstructionsPanel(boolean isLoadableToEm) {
        BaseFooterPanel footer = null;
        if (isLoadableToEm) {
            ArrayList<BaseButton> componentList = new ArrayList<BaseButton>();
            BaseButton showInstruction = new BaseButton(TextManager.instance().get("FIELD_LOAD_SHOW_INSTRUCTION"));
            showInstruction.setMnemonic(83);
            showInstruction.addActionListener((ActionListener)this);
            componentList.add(showInstruction);
            footer = new BaseFooterPanel(componentList);
        }
        return footer;
    }

    private String getZosInstructions() {
        return String.format(TextManager.instance().get("FIELD_LOAD_ZOS_POST_ACTIONS_FORMAT"), this.fixPathSeparator(this.handleZOSPostActions()));
    }

    private String fixPathSeparator(String path) {
        return path.replace("\\\\", "\\");
    }

    private String getLoadDraftInstructions(String draftDirectory) {
        Optional<String> draftName = this.getDraftName(draftDirectory);
        String loadDraftsInstructionFormat = draftName.isEmpty() ? TextManager.instance().get("FIELD_LOAD_MULTIPLE_DRAFTS_INSTRUCTION_FORMAT") : TextManager.instance().get("FIELD_LOAD_DRAFTS_INSTRUCTION_FORMAT");
        return this.addInstructionsIfThereIsDuplicatedJobNameOrResource(String.format(loadDraftsInstructionFormat, this.fixPathSeparator(draftDirectory)));
    }

    private String addInstructionsIfThereIsDuplicatedJobNameOrResource(String instruction) {
        return this.addInstructionsIfThereIsDuplicatedResourceName(this.addInstructionsIfThereIsDuplicatedJobName(instruction));
    }

    private String addInstructionsIfThereIsDuplicatedJobName(String instructions) {
        if (Params.instance().isThereDuplicatedJobNames()) {
            instructions = (String)instructions + "\nNote: There is duplicated job names in the result data, in order to upload the data successfully you need to enable the 'allowDuplicateJobNames' flag.";
        }
        return instructions;
    }

    private String addInstructionsIfThereIsDuplicatedResourceName(String instructions) {
        if (Params.instance().isThereDuplicatedResourceNames()) {
            instructions = (String)instructions + "\nNote: There is duplicated resource names under the same Job/Folder in the result data, in order to upload the data successfully you need to enable the 'allowDuplicateResourceNames' flag.";
        }
        return instructions;
    }

    private String getPostConversionInstructions() {
        return String.format(TextManager.instance().get("LOAD_TO_EM_POST_CONVERSION_INSTRUCTIONS"), this.fixPathSeparator(ConversionEntitiesService.getCurrentConversionDirectory()) + "POST_CONVERSION_SCRIPTS\\");
    }

    private String getLoadCalendarsInstruction() {
        Object[] calendarsFiles = this.getCalendars();
        Object loadCalendarsInstructions = TextManager.instance().get("FIELD_LOAD_CALENDARS_INSTRUCTION_FORMAT");
        if (SettingsBooleanKeys.isXmlCalendarFileEnabled()) {
            loadCalendarsInstructions = "Loading the XML calendar file:\\nExecute the following command: \\nemdef defcal -u <Control-M user> -p <Control-M password> -s <GUI Server Name> -src \"%s\".\\n" + (String)loadCalendarsInstructions;
        }
        return String.format((String)loadCalendarsInstructions, calendarsFiles);
    }

    private Object[] getCalendars() {
        Object[] objectArray;
        block8: {
            Stream<Path> files = Files.list(Paths.get(this.filesPath, new String[0]));
            try {
                String calendarFileNamePattern = "(?i).*calendars\\.(xml|json)";
                Comparator xmlFilesShouldBeFirst = (left, right) -> {
                    if (left.getFileName().toString().toLowerCase().endsWith("xml")) {
                        return -1;
                    }
                    return 0;
                };
                objectArray = files.filter(f -> f.getFileName().toString().matches(calendarFileNamePattern)).sorted(xmlFilesShouldBeFirst).toArray();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new Object[0];
                }
            }
            files.close();
        }
        return objectArray;
    }

    private boolean isDollarUniverseHdpConversion() {
        File muDependenciesFile = new File(Params.instance().getDatasourcePath() + "MuDependencies.txt");
        return muDependenciesFile.exists();
    }

    private String getHdpInstructions(String path) {
        return String.format("1. Copy the content of the HDP folder to a Control-M Server Machine from the following location: \n   %s\".\n2. Define the host groups that appear in the conversion action report in Control-M/Server. \n3. Create a shout destination with the name specified in the conversion settings, which points to the script copied in step 1.\nFor more information see Post Conversion Steps: Dollar Universe HDP jobs in the On-line Help.", this.fixPathSeparator(path));
    }

    private BaseField createCopyToClipboardButton(String draftDirectory) {
        Pair<String, String> pathAndFileName = this.getCopyLink(draftDirectory);
        BaseButton copyToClipboard = ButtonFactory.createEnterSensitiveButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.COPY_DRAFT_XML_TO_CLIPBOARD, e -> ClipboardManager.instance().setClipboardContents((String)pathAndFileName.getValue()));
        String textLink = "<html><font color='blue'>" + TextManager.instance().get("FIELD_LOAD_OPEN_CONVERSION_RESULT_FOLDER") + "</font></html>";
        BaseLinkLabel baseLinkLabel = new BaseLinkLabel((String)pathAndFileName.getKey(), textLink);
        return new BaseField((BaseComponent)new BaseComponentWrapper((Component)copyToClipboard), (BaseComponent)baseLinkLabel);
    }

    private Pair<String, String> getCopyLink(String draftDirectory) {
        String linkDraftDirectory = draftDirectory.replace('\\', '/');
        String linkToControlMDataResultsDirectory = "file:///" + linkDraftDirectory;
        String linkToDraftXml = linkToControlMDataResultsDirectory + this.getDraftName(draftDirectory).orElse("");
        return new Pair((Object)linkToControlMDataResultsDirectory, (Object)linkToDraftXml);
    }

    private Optional<String> getDraftName(String draftDirectory) {
        Optional<String> optional;
        block8: {
            String draftFileName = GlobalFunctions.getDraftFileName();
            Stream<Path> files = Files.walk(Paths.get(draftDirectory, new String[0]), new FileVisitOption[0]);
            try {
                optional = files.map(f -> f.getFileName().toString()).filter(name -> name.equals(draftFileName)).findAny();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Optional.empty();
                }
            }
            files.close();
        }
        return optional;
    }

    private BaseCopyableLabel createRulesSetTitleLabel() {
        BaseCopyableLabel rulesSetTitle = new BaseCopyableLabel(RuleManager.instance().getCurrentRulesTitle());
        if (!Params.instance().isNewConversion()) {
            rulesSetTitle.setText(RuleManager.getRuleSetTitle((File)new File(ConversionEntitiesService.getCurrentConversionRulesFile())));
        }
        return rulesSetTitle;
    }

    private void swapInstructions() {
        BaseContentPanel tmp = this.baseContentPanel;
        this.setContentPanel(this.oldContent);
        this.oldContent = tmp;
    }

    private String handleZOSPostActions() {
        if (Params.instance().getVendorName().equalsIgnoreCase("JOBTRAC")) {
            String postActionsRawFileStr = Globs.JOBTRAC_POST_ACTIONS_FULLPATH;
            String postActionsNewFileStr = this.filesPath + Globs.DIRSEP + "JobTrac_Post_Actions.txt";
            try {
                File postActionsRawFile = new File(postActionsRawFileStr);
                File postActionsFile = new File(postActionsNewFileStr);
                GlobalFunctions.copy((File)postActionsRawFile, (File)postActionsFile);
                HashMap<String, Object> strToReplaceWithHM = new HashMap<String, Object>();
                strToReplaceWithHM.put("<Conversion project directory>/", this.filesPath + Globs.DIRSEP);
                strToReplaceWithHM.put("<convertsion project name>", Params.instance().getDatasourceName());
                Object oldtext = "";
                try (BufferedReader reader = new BufferedReader(new FileReader(postActionsFile));){
                    Object line = "";
                    while ((line = reader.readLine()) != null) {
                        oldtext = (String)oldtext + (String)line + "\r\n";
                    }
                }
                Object newtext = oldtext;
                for (String strToReplace : strToReplaceWithHM.keySet()) {
                    String replaceWithValue = (String)strToReplaceWithHM.get(strToReplace);
                    replaceWithValue = replaceWithValue.replace(Globs.DIRSEP, Globs.DIRSEP + Globs.DIRSEP);
                    newtext = ((String)newtext).replace(strToReplace, replaceWithValue);
                }
                try (FileWriter writer = new FileWriter(postActionsFile);){
                    writer.write((String)newtext);
                }
                return postActionsNewFileStr;
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
                return postActionsRawFileStr;
            }
        }
        return "";
    }

    @Override
    public boolean performNextOperation() {
        EmDetailsExtractor checker = new EmDetailsExtractor();
        if (this.startEM.isSelected()) {
            FlowManager.instance().isLoadToEMExecuted(true);
            SettingsTable.instance().setProperty(SettingsStringKeys.GUI_SERVER_NAME, this.machineName.getText());
            return FlowGlobalFunction.loadToEM(checker.getEmPath(), Optional.ofNullable(this.loadCalendars).map(BaseCheckBox::isSelected).orElse(false), this.userName.getText(), this.password.getText(), this.machineName.getText(), this.port.getText());
        }
        FlowManager.instance().isLoadToEMExecuted(false);
        return true;
    }

    @Override
    public boolean performPrevOperation() {
        return true;
    }

    @Override
    public boolean updateData() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.swapInstructions();
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return FlowGlobals.FlowPanels.LOAD_TO_EM;
    }

    @Override
    public String getHelpTitle() {
        return "LOAD_TO_EM_PANEL";
    }

    static {
        conversionName = "";
    }
}

