/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseImagePanel;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BaseTextContainer;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class LicensePanel
extends FlowPanel {
    private static LicensePanel instance;
    private BaseTextContainer licenceContainer;

    public static LicensePanel instance() {
        if (instance == null) {
            instance = new LicensePanel();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private LicensePanel() {
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("TITLE_LICENSE_PANEL"), TextManager.instance().get("SUB_TITLE_LICENSE_PANEL")));
        this.setImagePanel(new BaseImagePanel(((Object)((Object)this)).getClass().getResource(FlowGlobals.SIDE_IMAGE_1_PATH)));
        BaseNavigationPanel navigationPanel = new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.AGREE});
        this.setNavigationPanel(navigationPanel);
        JPanel licence = new JPanel(new BorderLayout());
        licence.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.licenceContainer = new BaseTextContainer(new Dimension(570, 386));
        this.licenceContainer.setEditable(false);
        this.licenceContainer.setText(this.getLicenceText());
        licence.add(this.licenceContainer.getComponent(), "Center");
        this.baseContentPanel.setContentPanel((Component)licence);
        this.setContentPanel(this.baseContentPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLicenseAgreementSigned() {
        File file = new File(Globs.LICENSE_AGREEMENT_HISTORY_FILE);
        Scanner scanner = null;
        boolean toRet = false;
        if (file.exists()) {
            try {
                scanner = new Scanner(file);
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    if (!line.equalsIgnoreCase(TextManager.instance().get("LICENSE_SIGNED"))) continue;
                    toRet = true;
                }
            }
            catch (FileNotFoundException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            finally {
                scanner.close();
            }
        }
        return toRet;
    }

    private String getLicenceText() {
        File file = new File(Globs.DATA_DIR + Globs.DIRSEP + "licence.txt");
        StringBuilder sb = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return sb.toString();
    }

    private void saveLicenseAgreementToFile() {
        File file = new File(Globs.LICENSE_AGREEMENT_HISTORY_FILE);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(TextManager.instance().get("LICENSE_SIGNED"));
            bw.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    @Override
    public boolean performNextOperation() {
        this.saveLicenseAgreementToFile();
        return true;
    }

    @Override
    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_AGREE"))) {
            this.navigationPanel.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
        } else {
            super.navegationActionPerformed(e);
        }
    }

    @Override
    public boolean performPrevOperation() {
        return true;
    }

    @Override
    public boolean updateData() {
        return true;
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return FlowGlobals.FlowPanels.LICENSE_AGREEMENT;
    }

    @Override
    public String getHelpTitle() {
        return "License Agreement";
    }
}

