/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.common.DescriptionManager;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.flow.FlowManager;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public abstract class FlowPanel
extends BasePanel
implements NavegationListener {
    public ProcessAlertsManager alerts = ProcessAlertsManager.instance();

    public abstract boolean performNextOperation();

    public abstract boolean performPrevOperation();

    public abstract boolean updateData();

    public abstract String getHelpTitle();

    public abstract FlowGlobals.FlowPanels getPanelType();

    public FlowPanel() {
        this.addNavegationListener(FlowManager.instance());
    }

    public void setContentPanel(BaseContentPanel baseContentPanel) {
        baseContentPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(9, 0, 0, 9), FlowGlobals.customLowerBorder));
        super.setContentPanel(baseContentPanel);
    }

    public boolean eligibleForNext() {
        return true;
    }

    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        boolean toContinue = true;
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"))) {
            toContinue = this.performNextOperation();
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_BACK_STR"))) {
            toContinue = this.performPrevOperation();
        } else if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"))) {
            DescriptionManager.instance().showDescriptionDialog(this.getHelpTitle());
            toContinue = false;
        }
        if (toContinue) {
            this.fireNavegationEvent(actionCommand);
        }
    }
}

