/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseImagePanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.flow.AssessmentReportsManager;
import com.bmc.ctmconvert.gui.flowpanels.DataImportDialog;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DataImportResult
extends FlowPanel {
    private static DataImportResult instance;
    private static String projectName;
    private static boolean loadAssessmentAborted;
    private JPanel importResultPanel;
    private JPanel assessmentReportContainer;
    private JPanel importStatusPanel;
    private JLabel importStatusLabel;
    private JTextArea importStatusTextArea;
    private BaseButton loadData;
    private BaseButton reloadData;
    private BaseButton detach;
    private BaseFooterPanel footerPanel;
    private FlowGlobals.COMPLETION_MODE dataImportEndedStatus;

    public static DataImportResult instance() {
        if (instance == null || !ConversionEntitiesService.getCurrentProjectName().equals(projectName) || Params.instance().isValidationProject() || loadAssessmentAborted) {
            projectName = ConversionEntitiesService.getCurrentProjectName();
            instance = new DataImportResult();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public static void destroy(String project) {
        if (project.equals(projectName)) {
            instance = null;
        }
    }

    private DataImportResult() {
        ActionListener loadDataListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataImportResult.this.loadData(false);
            }
        };
        ArrayList<BaseButton> componentList = new ArrayList<BaseButton>();
        this.loadData = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.LOAD_DATA, (ActionListener)loadDataListener);
        componentList.add(this.loadData);
        this.reloadData = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.RELOAD_DATA, (ActionListener)loadDataListener);
        componentList.add(this.reloadData);
        ArrayList<BaseButton> fromEndComponentList = new ArrayList<BaseButton>();
        this.detach = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.DETACH, (ActionListener)new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssessmentReportsManager.instance().viewAssessmentReportWindow();
            }
        });
        fromEndComponentList.add(this.detach);
        this.footerPanel = new BaseFooterPanel("", componentList, fromEndComponentList);
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel(String.format(TextManager.instance().get("DATA_IMPORT_TITLE_FORMAT"), ConversionEntitiesService.getCurrentProjectName())), this.footerPanel);
        this.setImagePanel(new BaseImagePanel(((Object)((Object)this)).getClass().getResource(FlowGlobals.SIDE_IMAGE_3_PATH)));
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.BACK, ButtonFactory.ButtonType.NEXT, ButtonFactory.ButtonType.QUIT}));
        this.importResultPanel = new JPanel();
        this.importResultPanel.setLayout(new BorderLayout());
        this.assessmentReportContainer = new JPanel();
        this.assessmentReportContainer.setLayout(new BorderLayout());
        this.importResultPanel.add((Component)this.assessmentReportContainer, "Center");
        this.importStatusPanel = new JPanel();
        this.importStatusPanel.setLayout(new BorderLayout());
        this.importStatusPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.importStatusLabel = new JLabel();
        this.importStatusLabel.setFont(FlowGlobals.FONT_STYLE_BOLD_TITLE);
        this.importStatusLabel.setForeground(FlowGlobals.ConversionBlue);
        this.importStatusPanel.add((Component)this.importStatusLabel, "North");
        this.importStatusTextArea = new JTextArea();
        this.importStatusTextArea.setForeground(FlowGlobals.ConversionBlue);
        this.importStatusTextArea.setBackground(FlowGlobals.ConversionWhite);
        this.importStatusTextArea.setEditable(false);
        this.importStatusTextArea.setLineWrap(true);
        this.importStatusTextArea.setWrapStyleWord(true);
        this.importStatusTextArea.setBorder(BorderFactory.createEmptyBorder(10, 50, 0, 0));
        this.importStatusPanel.add((Component)this.importStatusTextArea, "Center");
        this.importResultPanel.add((Component)this.importStatusPanel, "North");
        this.baseContentPanel.setContentPanel((Component)this.importResultPanel);
        this.baseContentPanel.setScrollable(false);
        this.setContentPanel(this.baseContentPanel);
        this.loadData(Params.instance().isImportComplete());
    }

    private void loadData(final boolean load) {
        Thread loadDataThread = new Thread(){

            @Override
            public void run() {
                DataImportResult.this.reloadData.setEnabled(false);
                ProcessAlertsManager.instance().init();
                loadAssessmentAborted = false;
                boolean isDemo = ConversionEntitiesService.getCurrentProjectDetails().getProperty("WRITABLE").equals("N");
                DataImportResult.this.setButtonsState(Params.instance().isImportComplete());
                if (load || DataImportDialog.viewDataImportDialog()) {
                    boolean importComplete = Params.instance().isImportComplete();
                    DataImportResult.this.dataImportEndedStatus = DataImportDialog.getEndedStatus();
                    if (DataImportResult.this.dataImportEndedStatus == null) {
                        DataImportResult.this.dataImportEndedStatus = FlowGlobals.COMPLETION_MODE.SUCCESS;
                    }
                    DataImportResult.this.setButtonsState(importComplete);
                    if (importComplete) {
                        if (Params.instance().isValidationProject()) {
                            DataImportResult.this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
                        } else {
                            DataImportResult.this.assessmentReportContainer.removeAll();
                            BaseContentPanel report = AssessmentReportsManager.instance().getEmbeddedAssessmentReport();
                            if (report != null) {
                                DataImportResult.this.assessmentReportContainer.add(report.getComponent(), "Center");
                                DataImportResult.this.assessmentReportContainer.validate();
                                DataImportResult.this.assessmentReportContainer.repaint();
                            } else if (AssessmentReportsManager.instance().isReportAborted()) {
                                DataImportResult.this.setImportResultPanel(FlowGlobals.COMPLETION_MODE.ABORTED);
                            } else {
                                DataImportResult.this.setImportResultPanel(FlowGlobals.COMPLETION_MODE.FAILURE);
                                DataImportResult.this.setValid(false);
                            }
                            DataImportResult.this.reloadData.setEnabled(!isDemo);
                        }
                    } else {
                        DataImportResult.this.setImportResultPanel(DataImportResult.this.dataImportEndedStatus);
                    }
                } else {
                    DataImportResult.this.reloadData.setEnabled(true);
                }
            }
        };
        loadDataThread.start();
    }

    private void setImportResultPanel(FlowGlobals.COMPLETION_MODE status) {
        this.importStatusTextArea.setText(ProcessAlertsManager.instance().getMessages());
        this.importStatusPanel.setVisible(true);
        switch (status) {
            case ABORTED: {
                this.importStatusLabel.setIcon(BaseMessageDialog.getImageIconByType((BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE));
                this.importStatusLabel.setText(TextManager.instance().get("CAPTURE_DATA_IMPORT_ABORTED"));
                loadAssessmentAborted = true;
                break;
            }
            case FAILURE: {
                this.importStatusLabel.setIcon(BaseMessageDialog.getImageIconByType((BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE));
                this.importStatusLabel.setText(TextManager.instance().get("CAPTURE_DATA_IMPORT_FAILED"));
                break;
            }
        }
    }

    private void setButtonsState(boolean importComplete) {
        this.loadData.setVisible(!importComplete);
        this.reloadData.setVisible(importComplete);
        this.detach.setEnabled(importComplete);
        this.assessmentReportContainer.setVisible(importComplete);
        this.importStatusPanel.setVisible(!importComplete && this.dataImportEndedStatus != FlowGlobals.COMPLETION_MODE.SUCCESS);
        this.footerPanel.setMessage(importComplete ? TextManager.instance().get("DATA_IMPORT_RELOAD_DESCRIPTION") : "");
        this.setValid(importComplete);
    }

    @Override
    public boolean performNextOperation() {
        this.assessmentReportContainer.removeAll();
        this.assessmentReportContainer.validate();
        this.assessmentReportContainer.repaint();
        return Params.instance().isImportComplete();
    }

    @Override
    public boolean performPrevOperation() {
        return true;
    }

    @Override
    public boolean updateData() {
        if (Params.instance().isValidationProject()) {
            this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_BACK_STR"));
        } else {
            this.loadData(Params.instance().isImportComplete());
        }
        return true;
    }

    @Override
    public String getHelpTitle() {
        return "EVALUATE_DATA";
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return Params.instance().isValidationProject() ? FlowGlobals.FlowPanels.CONVERSION_RESULT : FlowGlobals.FlowPanels.DATA_IMPORT_RESULTS;
    }
}

