/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseButtonGroup;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseImagePanel;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextArea;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.list.BaseDetailedList;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.flowpanels.ConversionResultsPanel;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ConversionsPanel
extends FlowPanel {
    private static ConversionsPanel instance;
    private static String datasourceName;
    private BaseDetailedList myConversionsList;
    private BaseRadioButton rerunConversion;
    private BaseRadioButton existingConversion;
    private BaseTextField name;
    private BaseField nameField;
    private BaseTextArea description;
    private BaseField descriptionField;
    private BaseSection section;
    private String conversionsPath;
    private MouseListener listListener;

    public static ConversionsPanel instance() {
        if (instance == null || !Params.instance().getDatasourceName().equals(datasourceName)) {
            instance = new ConversionsPanel();
        } else {
            instance.updateData();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private ConversionsPanel() {
        datasourceName = Params.instance().getDatasourceName();
        this.listListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ConversionsPanel.this.navigationPanel.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
                }
            }
        };
        this.conversionsPath = ConversionEntitiesService.getCurrentProjectConversionsDirectory();
        ActionListener radioClickListner = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean action = e.getActionCommand().equals(TextManager.instance().get("CAPTURE_DATA_FIELD_RERUN_CONVERSION"));
                ConversionsPanel.this.myConversionsList.setEnabled(!action);
                ConversionsPanel.this.nameField.setEnabled(action);
                ConversionsPanel.this.descriptionField.setEnabled(action);
                if (ConversionsPanel.this.myConversionsList.isEnabled() && !ConversionsPanel.this.myConversionsList.isValid()) {
                    ConversionsPanel.this.myConversionsList.setSelectedIndex(Integer.valueOf(0));
                }
                ConversionsPanel.this.section.setValid(ConversionsPanel.this.section.isValid());
            }
        };
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel(String.format(TextManager.instance().get("CONVERSIONS_PANEL_TITLE_FORMAT"), ConversionEntitiesService.getCurrentProjectName())));
        this.setImagePanel(new BaseImagePanel(((Object)((Object)this)).getClass().getResource(FlowGlobals.SIDE_IMAGE_4_PATH)));
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.BACK, ButtonFactory.ButtonType.NEXT, ButtonFactory.ButtonType.QUIT}));
        this.section = new BaseSection(){

            public boolean isValid() {
                boolean toRet = false;
                toRet = ConversionsPanel.this.rerunConversion.isValid() ? ConversionsPanel.this.name.isValid() : ConversionsPanel.this.myConversionsList.isValid();
                return toRet;
            }
        };
        BaseButtonGroup buttonsGroup = new BaseButtonGroup();
        this.rerunConversion = new BaseRadioButton(TextManager.instance().get("CAPTURE_DATA_FIELD_RERUN_CONVERSION"));
        this.rerunConversion.addActionListener(radioClickListner);
        this.rerunConversion.setActionCommand(TextManager.instance().get("CAPTURE_DATA_FIELD_RERUN_CONVERSION"));
        this.rerunConversion.setSelected(true);
        buttonsGroup.add(this.rerunConversion);
        BaseField rerunConversionField = new BaseField((BaseComponent)this.rerunConversion);
        rerunConversionField.fillFieldSize(true);
        this.section.addField(rerunConversionField);
        this.name = new BaseTextField(GlobalFunctions.getUniqueFileOrFoldertName((String)Params.instance().getDatasourceName(), (String)this.conversionsPath), new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.CONVERSION_NAME));
        this.nameField = new BaseField((BaseComponent)this.name, TextManager.instance().get("CONVERSION_PANEL_FIELD_CONVERSION_NAME"), true, 17);
        this.section.addField(this.nameField);
        this.description = new BaseTextArea();
        this.descriptionField = new BaseField((BaseComponent)this.description, TextManager.instance().get("CONVERSION_PANEL_FIELD_CONVERSION_DESCRIPTION"), 17);
        this.section.addField(this.descriptionField);
        this.section.addField(new BaseField(null));
        this.existingConversion = new BaseRadioButton(TextManager.instance().get("FIELD_LOAD_EXISTING_CONVERSION"));
        this.existingConversion.addActionListener(radioClickListner);
        this.existingConversion.setActionCommand(TextManager.instance().get("FIELD_LOAD_EXISTING_CONVERSION"));
        buttonsGroup.add(this.existingConversion);
        BaseField existingConversionField = new BaseField((BaseComponent)this.existingConversion);
        existingConversionField.fillFieldSize(true);
        this.section.addField(existingConversionField);
        List conversions = ConversionEntitiesService.getCurrentProjectConversionsDetails();
        LinkedHashMap<String, String> detailsTitles = new LinkedHashMap<String, String>();
        detailsTitles.put("VENDOR_FULL_NAME", TextManager.instance().get("LIST_DETAILS_TITLE_VENDOR"));
        detailsTitles.put("RULES_NAME", TextManager.instance().get("LIST_DETAILS_TITLE_RULESET_NAME"));
        detailsTitles.put("CREATION_DATE", TextManager.instance().get("LIST_DETAILS_TITLE_DATE_CREATED"));
        detailsTitles.put("DESCRIPTION", TextManager.instance().get("LIST_DETAILS_TITLE_DESCRIPTION"));
        Properties settings = new Properties();
        settings.setProperty("SORT_BY", "NAME");
        settings.put("DETAILS_TITLES", detailsTitles);
        this.myConversionsList = new BaseDetailedList(conversions, settings, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.VENDORS_LIST));
        this.myConversionsList.setValidityComponent(null);
        this.myConversionsList.setBorder(null);
        this.myConversionsList.addMouseListener(this.listListener);
        this.myConversionsList.setDeleteAction((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String conversionName = e.getActionCommand();
                GlobalFunctions.deleteDir((File)new File(ConversionEntitiesService.getConversionDirectory((String)ConversionEntitiesService.getCurrentProjectName(), (String)conversionName)));
                ConversionResultsPanel.destroy(conversionName);
                ConversionEntitiesService.unregisterConversion((String)ConversionEntitiesService.getCurrentProjectName(), (String)conversionName);
                if (ConversionsPanel.this.myConversionsList.getData().isEmpty()) {
                    ConversionsPanel.this.existingConversion.setEnabled(false);
                    ConversionsPanel.this.rerunConversion.doClick();
                }
            }
        });
        if (conversions.isEmpty()) {
            this.existingConversion.setEnabled(false);
        }
        BaseContentPanel contentHeader = new BaseContentPanel();
        contentHeader.setDisableSpacer(true);
        contentHeader.setBorder(null);
        contentHeader.addSection(this.section);
        contentHeader.buildContentPanel();
        contentHeader.setScrollable(false);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        content.add(contentHeader.getComponent(), "North");
        ((JPanel)this.myConversionsList.getComponent()).setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 10));
        content.add(this.myConversionsList.getComponent(), "Center");
        this.baseContentPanel.setContentPanel((Component)content);
        this.myConversionsList.addValidityListener((ValidityListener)this.section);
        contentHeader.addValidityListener((ValidityListener)this);
        this.setContentPanel(this.baseContentPanel);
        this.rerunConversion.doClick();
    }

    @Override
    public boolean performNextOperation() {
        ConversionResultsPanel.destroy();
        if (this.rerunConversion.isValid()) {
            Params.instance().setIsNewConversion(true);
            Params.instance().setConversionName(this.name.getText());
            Params.instance().setConversionDescription(this.description.getText());
        } else {
            Params.instance().setIsNewConversion(false);
            Properties selected = this.myConversionsList.getSelectedItemProperties();
            Params.instance().setConversionName(selected.getProperty("NAME"));
            Params.instance().setConversionDescription(selected.getProperty("DESCRIPTION"));
        }
        return true;
    }

    @Override
    public boolean performPrevOperation() {
        return true;
    }

    @Override
    public boolean updateData() {
        List conversions;
        this.name.setText(GlobalFunctions.getUniqueFileOrFoldertName((String)ConversionEntitiesService.getCurrentProjectName(), (String)this.conversionsPath));
        if (!Params.instance().isNewConversion()) {
            this.description.setText("");
        }
        this.existingConversion.setEnabled(!(conversions = ConversionEntitiesService.getCurrentProjectConversionsDetails()).isEmpty());
        if (conversions.isEmpty()) {
            this.rerunConversion.doClick();
        }
        this.myConversionsList.setData(conversions);
        this.myConversionsList.addMouseListener(this.listListener);
        if (this.rerunConversion.isValid()) {
            this.rerunConversion.doClick();
        } else {
            this.existingConversion.doClick();
        }
        return true;
    }

    @Override
    public String getHelpTitle() {
        return "CONVERSION_PANEL";
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return FlowGlobals.FlowPanels.CONVERSIONS;
    }

    static {
        datasourceName = "";
    }
}

