/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flow;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseFrame;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.base.ObserverFrame;
import com.bmc.ctmconvert.common.CompareVersionToS3;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ExternalCommand;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.WhichAppRunning;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.gui.flow.AssessmentReportsManager;
import com.bmc.ctmconvert.gui.flow.ConversionReportManager;
import com.bmc.ctmconvert.gui.flowpanels.AboutWindow;
import com.bmc.ctmconvert.gui.flowpanels.ConversionResultsPanel;
import com.bmc.ctmconvert.gui.flowpanels.ConversionSettingPanel;
import com.bmc.ctmconvert.gui.flowpanels.ConversionsPanel;
import com.bmc.ctmconvert.gui.flowpanels.DataImportResult;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.gui.flowpanels.LicensePanel;
import com.bmc.ctmconvert.gui.flowpanels.LoadToEmPanel;
import com.bmc.ctmconvert.gui.flowpanels.ProjectsPanel;
import com.bmc.ctmconvert.gui.flowpanels.SummaryPanel;
import com.bmc.ctmconvert.gui.flowpanels.WelcomeWindow;
import com.bmc.ctmconvert.services.settings.Feature;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class FlowManager
implements NavegationListener {
    private static FlowManager instance;
    private BaseFrame mainFrame;
    private Deque<FlowPanel> flowStack;
    private FlowPanel currFlowPanel;
    private boolean isLoadToEMExecuted;
    private boolean isImportPerformed;
    private boolean isConversionPerformed;
    private boolean isConversionSettingPerformed;

    private FlowManager() {
        try {
            ConversionLogger.InitLogging();
            TextManager.initiateInstance();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return;
        }
        this.flowStack = new ArrayDeque<FlowPanel>();
    }

    public static FlowManager instance() {
        if (instance == null) {
            instance = new FlowManager();
        }
        return instance;
    }

    private void checkForNewVersion(final boolean automatic) {
        Thread compareVersion = new Thread(this){

            @Override
            public void start() {
                CompareVersionToS3 compareVer = new CompareVersionToS3(automatic);
                compareVer.compareToLatestVersion("https://control-m-conversion.s3.eu-central-1.amazonaws.com/ConversionToolVersionContent/VersionsContent.txt", Globs.TEMP_DIR + "/VersionsContent.txt");
            }
        };
        if (!automatic || SettingsTable.instance().getProperty((Feature)SettingsBooleanKeys.COMPARE_TO_LAST_VERSION_THROUGH_FTP)) {
            compareVersion.start();
        }
    }

    public Component getMainFrame() {
        return this.mainFrame.getComponent();
    }

    public void start() {
        this.setRunningApp();
        this.setConversionLookAndFeel();
        this.mainFrame = new BaseFrame(TextManager.instance().get("CONVERSION_TOOL_TITLE"), true);
        ObserverFrame.instance().setCurrentFrame((Frame)this.mainFrame.getComponent());
        this.mainFrame.addNavegationListener((NavegationListener)this);
        this.currFlowPanel = LicensePanel.instance();
        this.navigate(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
        this.checkForNewVersion(true);
        this.mainFrame.setVisible(true);
    }

    private void setRunningApp() {
        WhichAppRunning whichAppRunning = new WhichAppRunning();
        try {
            whichAppRunning.setCurrentApp("Conversion");
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private void navigate(String actionCommand) {
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_QUIT_STR")) || actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_FINISH_STR")) || actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.closeOperation();
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_BACK_STR"))) {
            this.currFlowPanel = this.flowStack.pop();
            this.currFlowPanel.updateData();
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"))) {
            this.flowStack.push(this.currFlowPanel);
            switch (this.currFlowPanel.getPanelType()) {
                case LICENSE_AGREEMENT: {
                    if (LicensePanel.isLicenseAgreementSigned()) {
                        this.currFlowPanel = ProjectsPanel.instance();
                        break;
                    }
                    WelcomeWindow.instance();
                    break;
                }
                case PROJECTS: {
                    this.currFlowPanel = DataImportResult.instance();
                    break;
                }
                case DATA_IMPORT_RESULTS: {
                    this.currFlowPanel = ConversionsPanel.instance();
                    break;
                }
                case CONVERSIONS: {
                    this.currFlowPanel = ConversionSettingPanel.instance();
                    break;
                }
                case CONVERSION_SETTING: {
                    this.currFlowPanel = ConversionResultsPanel.instance();
                    break;
                }
                case CONVERSION_RESULT: {
                    this.currFlowPanel = LoadToEmPanel.instance();
                    break;
                }
                case LOAD_TO_EM: {
                    this.currFlowPanel = new SummaryPanel();
                    break;
                }
                default: {
                    this.currFlowPanel = LicensePanel.instance();
                }
            }
        }
        if (this.currFlowPanel.eligibleForNext()) {
            this.mainFrame.setContent((BaseComponent)this.currFlowPanel);
        } else {
            this.currFlowPanel.navegationActionPerformed(new ConversionEvent(TextManager.instance().get("MAIN_NAVIGATION_BACK_STR"), true));
        }
    }

    private void setConversionLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        UIManager.put("ToolTip.background", new ColorUIResource(255, 247, 200));
        UIManager.put("TableHeader.cellBorder", null);
        UIManager.put("Panel.background", FlowGlobals.ConversionWhite);
        UIManager.put("Menu.background", FlowGlobals.ConversionWhite);
        UIManager.put("Menu.foreground", FlowGlobals.ConversionBlack);
        UIManager.put("Menu.selectionBackground", FlowGlobals.ConversionMenuSelectionRollover);
        UIManager.put("Menu.selectionForeground", FlowGlobals.ConversionBlack);
        UIManager.put("PopupMenu.background", FlowGlobals.ConversionGray);
        UIManager.put("PopupMenu.border", BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(9609895)));
        UIManager.put("MenuItem.background", FlowGlobals.ConversionWhite);
        UIManager.put("MenuItem.foreground", FlowGlobals.ConversionBlack);
        UIManager.put("MenuItem.selectionBackground", FlowGlobals.ConversionMenuSelectionRollover);
        UIManager.put("MenuItem.selectionForeground", FlowGlobals.ConversionBlack);
        UIManager.put("CheckBoxMenuItem.background", FlowGlobals.ConversionWhite);
        UIManager.put("CheckBoxMenuItem.foreground", FlowGlobals.ConversionBlack);
        UIManager.put("CheckBoxMenuItem.selectionBackground", FlowGlobals.ConversionMenuSelectionRollover);
        UIManager.put("CheckBoxMenuItem.selectionForeground", FlowGlobals.ConversionBlack);
        UIManager.put("ComboBox.selectionBackground", FlowGlobals.ConversionMenuSelectionRollover);
        UIManager.put("ComboBox.disabledBackground", FlowGlobals.fieldReadOnlyBackground);
        UIManager.put("ComboBox.background", FlowGlobals.fieldDefaultBackground);
        UIManager.put("ComboBox.border", FlowGlobals.fieldDefaultBorder);
        UIManager.put("ScrollBar.background", FlowGlobals.ConversionGray);
        UIManager.put("ScrollBar.darkShadow", FlowGlobals.ConversionUpperOuterBorderColor);
        UIManager.put("ScrollBar.thumbDarkShadow", FlowGlobals.ConversionUpperOuterBorderColor);
        UIManager.put("ScrollBar.thumbShadow", FlowGlobals.ConversionUpperInnerBorderColor);
        UIManager.put("ScrollPane.background", FlowGlobals.ConversionWhite);
        UIManager.put("ScrollPane.border", BorderFactory.createEmptyBorder());
        UIManager.put("ScrollPane.viewportBorder", BorderFactory.createEmptyBorder());
        UIManager.put("Table.scrollPaneBorder", BorderFactory.createEmptyBorder());
        UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createEmptyBorder());
        UIManager.put("Table.rendererUseUIBorder", false);
        UIManager.put("TableHeader.background", FlowGlobals.ConversionLightBlue);
        UIManager.put("TableHeader.foreground", FlowGlobals.ConversionWhite);
        UIManager.put("TableHeader.cellBorder", BorderFactory.createEmptyBorder());
        UIManager.put("ToolTip.border", BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(85133)), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        UIManager.put("ToolTip.background", FlowGlobals.fieldReadOnlyBackground);
        UIManager.put("TabbedPane.selected", FlowGlobals.ConversionWhite);
    }

    public boolean wasProcessExecuted(FlowGlobals.FlowPanels type) {
        if (type.equals((Object)FlowGlobals.FlowPanels.DATA_IMPORT)) {
            return this.isImportPerformed;
        }
        if (type.equals((Object)FlowGlobals.FlowPanels.CONVERSION_SETTING)) {
            return this.isConversionSettingPerformed;
        }
        if (type.equals((Object)FlowGlobals.FlowPanels.CONVERSION_RESULT)) {
            return this.isConversionPerformed;
        }
        if (type.equals((Object)FlowGlobals.FlowPanels.LOAD_TO_EM)) {
            return this.isLoadToEMExecuted;
        }
        for (Object panel : this.flowStack.toArray()) {
            if (!((FlowPanel)((Object)panel)).getPanelType().equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    public void isLoadToEMExecuted(boolean b) {
        this.isLoadToEMExecuted = b;
    }

    public void isImportPerformed(boolean b) {
        this.isImportPerformed = b;
    }

    public void isConversionPerformed(boolean b) {
        this.isConversionPerformed = b;
    }

    public void isConversionSettingPerformed(boolean b) {
        this.isConversionSettingPerformed = b;
    }

    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"))) {
            if (this.currFlowPanel != null) {
                this.currFlowPanel.navegationActionPerformed(e);
            }
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_ABOUT"))) {
            AboutWindow.instance();
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CHECK_FOR_NEW_VERSION"))) {
            this.setBusyWait(true);
            this.checkForNewVersion(false);
            this.setBusyWait(false);
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_VERIFICATION_STR"))) {
            this.openVerificationTool();
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_WELCOME"))) {
            WelcomeWindow.instance();
        } else {
            this.navigate(actionCommand);
        }
    }

    private void openVerificationTool() {
        ExternalCommand extCmd = new ExternalCommand.Builder(new String[]{"VerificationTool\\verification.bat"}).workingDirectory(Globs.HOME_DIR).redirectErrToOut(true).waitFor(false).isScript(true).build();
        extCmd.start();
    }

    private void closeOperation() {
        AssessmentReportsManager.instance().closeOperation();
        ConversionReportManager.instance().closeOperation();
        if (Params.instance().isCaptureCleanupNeeded()) {
            for (File toDelete : Params.instance().getToCleanup()) {
                toDelete.delete();
            }
        }
        this.mainFrame.dispose();
        SettingsTable.instance().saveSettings();
    }

    public void setBusyWait(boolean wait) {
        this.getMainFrame().setCursor(Cursor.getPredefinedCursor(wait ? 3 : 0));
    }
}

